using System;
using System.IO;
using System.Windows.Forms;
using MyDebug;
using System.Collections;


namespace MPRStat
{
    public enum PlayerFlags : ushort
    {
        SwapSide = 1,
        GCCut = 2,
        GCBlip = 4,
        Gears = 8,
        Shifter = 16,
        Reserved1 = 32,
        Brake = 64,
        Throttle = 128,
        Reserved2 = 256,
        Clutch = 512,
        Mouse = 1024,
        KbNoHelp = 2048,
        KbStabilised = 4096,
        CustomView = 8192
    }

    enum frameEvent
    {
        BEGINNING = 0x00,
        STARTFINISHLINE = 0x27,
        SPLIT = 0x26,
        PITSTOP = 0x60,
        SERVERJOIN = 0x14,
        SERVERLEAVE = 0x3F,
        RACEJOIN = 0x04,
        LEAVEPITS = 0x05,
        SPECTATE = 0x11,
        JUMPTOPITS = 0x12,
        LOCALDRIVERCHANGE = 0x06,
        DRIVERCHANGEREQUEST = 0x47,
        END = 0x01,
}
    enum pen
    {
        PENALTY_NONE,		// 0		
        PENALTY_DT,			// 1
        PENALTY_DT_VALID,	// 2
        PENALTY_SG,			// 3
        PENALTY_SG_VALID,	// 4
        PENALTY_30,			// 5
        PENALTY_45,			// 6
        PENALTY_NUM
    }
    enum penr
    {
        PENR_UNKNOWN,		// 0 - unknown or cleared penalty
        PENR_ADMIN,			// 1 - penalty given by admin
        PENR_WRONG_WAY,		// 2 - wrong way driving
        PENR_FALSE_START,	// 3 - starting before green light
        PENR_SPEEDING,		// 4 - speeding in pit lane
        PENR_STOP_SHORT,	// 5 - stop-go pit stop too short
        PENR_STOP_LATE,		// 6 - compulsory stop is too late
        PENR_NUM
    };

    enum PIT_work
    {
        PSE_NOTHING = 0,		// bit 0 (1)
        PSE_STOP = 2,			// bit 1 (2)
        PSE_FR_DAM = 4,			// bit 2 (4)
        PSE_FR_WHL = 8,			// etc...
        PSE_LE_FR_DAM = 16,
        PSE_LE_FR_WHL = 32,
        PSE_RI_FR_DAM = 64,
        PSE_RI_FR_WHL = 128,
        PSE_RE_DAM = 256,
        PSE_RE_WHL = 512,
        PSE_LE_RE_DAM = 1024,
        PSE_LE_RE_WHL = 2048,
        PSE_RI_RE_DAM = 4096,
        PSE_RI_RE_WHL = 8192,
        PSE_BODY_MINOR = 16384,
        PSE_BODY_MAJOR = 32768,
        PSE_SETUP = 65536,
        PSE_REFUEL = 131072,
    };

    enum confirm
    {
        CONF_MENTIONED = 1,
        CONF_CONFIRMED = 2,
        CONF_PENALTY_DT = 4,
        CONF_PENALTY_SG = 8,
        CONF_PENALTY_30 = 16,
        CONF_PENALTY_45 = 32,
        CONF_DID_NOT_PIT = 64
    }
    public class resultInfo{
        public string nickNameWc;
        public string nickName;
        public string plate;
	    public string CName;
	    public string userName;
	    public int laps;
	    public int plyFlags;
	    public int confFlags;
	    public int numPitStop;
	    public int penaltySecs;
	    public int totTime;
	    public int PBrace;
        public int zero;
	    public int startPos;
	    public int HMass;
        public int HRest;
        public int UCID;
        public int PLID;
        public int driverID;
        public string HSkin;
        public string CSkin;
        public bool finished;
    }
    public class mprHeader
    {
        public string header;
        public int gameVersion;
        public int gameRevision;
        public int MPRVersion;
        public int immediateStart;
        public int reserved10;
        public int reserved11;
        public int rules;
        public int flags;
        public int laps;
        public int skill;
        public int wind;
        public int numPlayers;
        public string lfsVersion;
        public string shortTrackName;
        public int startTime;
        public string trackName;
        public int config;
        public int reversed;
        public int weather;
        public int numFinished;
        public int zero;
        public System.Collections.ArrayList results = new System.Collections.ArrayList();
        public System.Collections.ArrayList chat = new System.Collections.ArrayList();
    }
    public class rJoinInfo
    {
        public int UCID;
        public int PLID;
        public int driverID;
        public string nickName;
        public string plate;
        public string unknown;
        public string unknown2;
        public string HSkin;
        public string unknown3;
        public string LCName;
        public string CSkin;
        public string userName;
    }

    public class Reader
    {
        static bool firstGetFrame = true;
        static int lastTStamp = 0;
        static int nbTStamp = 0;
        static int tStamp;
        static int totTStamp = 0;
        static Queue buffers = new Queue(20);
        static bool initCar = false;
        static System.Collections.ArrayList shortCarNames = new System.Collections.ArrayList();
        static System.Collections.ArrayList longCarNames = new System.Collections.ArrayList();




        public static int pakGetByte(byte[] pak, int first)
        {
            return (int)pak[first];
        }
        public static string pakGetString(byte[] pak, int first, int len)
        {
            return CodePage.GetString(pak, first, len);
        }
        public static int pakGetWord(byte[] pak, int first)
        {
            return (int)System.BitConverter.ToUInt16(pak, first);
        }
        public static int pakGetShort(byte[] pak, int first)
        {
            return (int)System.BitConverter.ToInt16(pak, first);
        }
        public static long pakGetUnsigned(byte[] pak, int first)
        {
            return (long)System.BitConverter.ToUInt32(pak, first);
        }
        public static int pakGetInt(byte[] pak, int first)
        {
            return (int)System.BitConverter.ToInt32(pak, first);
        }
        public static float pakGetFloat(byte[] pak, int first)
        {
            return (float)System.BitConverter.ToSingle(pak, first);
        }
        public static bool findPattern(Stream fp, byte[] pattern )
        {
            byte[] buffer = new byte[pattern.Length];


            fp.Read(buffer, 0, pattern.Length);
            while( true ){
                bool flag_find = true;
                byte [] car = new byte[1];
                for (int i = 0; i < pattern.Length; i++)
                {
                    if( buffer[i] != pattern[i] ){
                        flag_find = false;
                        break;
                    }
                }
                if (flag_find == true)
                    return true;
                for (int i = 0; i < pattern.Length-1; i++)
                    buffer[i] = buffer[i+1];
                    try
                    {
                        fp.Read(car, 0, 1);
                    }
                    catch
                    {
                        return false;
                    }
                buffer[pattern.Length-1] = car[0];
            }
        }
        public static string bufferToHexa( byte[] buffer,int buffLen )
        {
            string retString = "";
            string sep = "";
            for (int i = 0; i < buffLen; i++)
            {
                retString = retString + sep + string.Format("0x{0:X2}", buffer[i]);
                sep = ", ";
            }
            return retString;
        }
        public static void funcInitCar()
        {
            if (!initCar)
            {
                #region Car Names Tables
                shortCarNames.Add("UF1"); longCarNames.Add("UF 1000");
                shortCarNames.Add("XFG"); longCarNames.Add("XF GTI");
                shortCarNames.Add("XRG"); longCarNames.Add("XR GT");
                shortCarNames.Add("XRT"); longCarNames.Add("XR GT TURBO");
                shortCarNames.Add("RB4"); longCarNames.Add("RB4 GT");
                shortCarNames.Add("FXO"); longCarNames.Add("FXO TURBO");
                shortCarNames.Add("LX4"); longCarNames.Add("LX4");
                shortCarNames.Add("LX6"); longCarNames.Add("LX6");
                shortCarNames.Add("RAC"); longCarNames.Add("RA");
                shortCarNames.Add("FZ5"); longCarNames.Add("FZ50");
                shortCarNames.Add("MRT"); longCarNames.Add("MRT5");
                shortCarNames.Add("XFR"); longCarNames.Add("XF GTR");
                shortCarNames.Add("UFR"); longCarNames.Add("UF GTR");
                shortCarNames.Add("FOX"); longCarNames.Add("FORMULA XR");
                shortCarNames.Add("FO8"); longCarNames.Add("FORMULA V8");
                shortCarNames.Add("FXR"); longCarNames.Add("FXO GTR");
                shortCarNames.Add("XRR"); longCarNames.Add("XR GTR");
                shortCarNames.Add("FZR"); longCarNames.Add("FZ50 GTR");
                shortCarNames.Add("BF1"); longCarNames.Add("BMW SAUBER");
                shortCarNames.Add("FBM"); longCarNames.Add("BMW FB02");
                #endregion
                initCar = true;
            }

        }
        public static string longToShortCarName( string LCName ){
            funcInitCar();
            for (int i = 0; i < longCarNames.Count; i++)
            {
                if ((string)longCarNames[i] == LCName)
                    return (string)shortCarNames[i];
            }
            return "";
        }
        public static mprHeader readHeader(Stream fp)
        {
            mprHeader mprResult;
            System.Collections.ArrayList rJoin ;

            byte[] buffer = new byte[3000];

            mprResult = new mprHeader();
            rJoin = new System.Collections.ArrayList();
            firstGetFrame = true;

            lastTStamp = 0;
            nbTStamp = 0;
            tStamp =0;
            totTStamp = 0;


            fp.Read( buffer,0,80 );

            mprResult.header = pakGetString(buffer,0,6);
            mprResult.gameVersion = pakGetByte(buffer,6);
            mprResult.gameVersion = pakGetByte(buffer,7);
            mprResult.MPRVersion = pakGetByte( buffer,8);
            mprResult.immediateStart = pakGetByte(buffer,9);
            mprResult.reserved10 = pakGetByte(buffer,10);
            mprResult.reserved11 = pakGetByte(buffer,11);
            mprResult.rules = pakGetInt(buffer,12);
            mprResult.flags = pakGetInt(buffer,16);
            mprResult.laps = pakGetByte(buffer,20);
            mprResult.skill = pakGetByte(buffer,21);
            mprResult.wind = pakGetByte(buffer,22);
            mprResult.numPlayers = pakGetByte(buffer,23);
            mprResult.lfsVersion = pakGetString(buffer,24,8);
            mprResult.shortTrackName = pakGetString(buffer,32,4);
            mprResult.startTime = pakGetInt(buffer,36);
            mprResult.trackName = pakGetString(buffer,40,32);
            mprResult.config = pakGetByte(buffer,72);
            mprResult.reversed = pakGetByte(buffer,73);
            mprResult.weather = pakGetByte(buffer,74);
            mprResult.numFinished = pakGetByte(buffer,75);
            mprResult.zero = pakGetInt(buffer,76);

            for (int i = 0; i < mprResult.numFinished; i++)
            {
                resultInfo ri = new resultInfo();
                fp.Read(buffer, 0, 80);
                ri.nickNameWc = pakGetString(buffer, 0, 24);
                ri.nickName = "";
                ri.plate = pakGetString(buffer, 24, 8);
                ri.CName = pakGetString(buffer, 32, 4);
                ri.userName = pakGetString(buffer, 36, 24);
                ri.laps = pakGetShort(buffer, 60);
                ri.plyFlags = pakGetShort(buffer, 62);
                ri.confFlags = pakGetShort(buffer, 64);
                ri.numPitStop = pakGetByte(buffer, 65);
                ri.penaltySecs = pakGetByte(buffer, 66);
                ri.totTime = pakGetInt(buffer, 68);
                ri.PBrace = pakGetInt(buffer, 72);
                ri.zero = pakGetByte(buffer, 76);
                ri.startPos = pakGetByte(buffer, 77);
                ri.HMass = pakGetByte(buffer, 78);
                ri.HRest = pakGetByte(buffer, 79);
                ri.finished = true;
                mprResult.results.Add(ri);
//                debug.WriteLine(ri.nickNameWc + " : " + ri.startPos + "<BR>");

            }
            fp.Seek(3920, SeekOrigin.Begin);
            bool flag_first = true;
// Read all joined players
            int header;
            while (true)
            {
                fp.Read(buffer, 0, 2);
                header = pakGetShort(buffer,0);
                if (flag_first && header != 0x0444)
                {
                    fp.Seek(265, SeekOrigin.Current);
                    fp.Read(buffer, 0, 2);
                    header = pakGetShort(buffer, 0);
                }
                if (header != 0x0444)
                {
//                    debug.WriteLine(bufferToHexa(buffer, 2) + "<BR>");
                    if (flag_first == false)
                    {
                        int skip = 55; // 55 or 51
                        fp.Read(buffer ,0, skip);
//                        debug.WriteLine(bufferToHexa(buffer, skip) + "<BR>");
                        fp.Read(buffer, 0, 2);
                        header = pakGetShort(buffer, 0);
                        if (header != 0x0444)
                        {
                            break;
                        }
                    }
                    else
                    {
                        break;
                    }
                }
                flag_first = false;
// Read all joined players
                fp.Read(buffer, 0, 280);
                rJoinInfo rj = new rJoinInfo();
              
                rj.nickName = pakGetString(buffer,5 - 2,24);
                rj.plate = pakGetString(buffer, 29 - 2, 8);
                rj.UCID = pakGetByte(buffer, 37 - 2);
                rj.unknown = pakGetString(buffer, 38 - 2, 4);
                rj.PLID = pakGetByte(buffer, 42 - 2);
                rj.unknown2 = pakGetString(buffer, 43 - 2, 10);
                rj.HSkin = pakGetString(buffer, 53 - 2, 16);
                rj.unknown3 = pakGetString(buffer, 69 - 2, 13);
                rj.LCName = pakGetString(buffer, 82 - 2, 32);
                rj.CSkin = pakGetString(buffer, 114 - 2, 16);
                rJoin.Add( rj );
//                debug.WriteLine(bufferToHexa(buffer, 280) + "<BR>");
/*
                debug.WriteLine(string.Format( "{0} UCID : Ox{1:X2} PLID :0x{2:X2} <BR>",
                                                rj.nickName,
                                                rj.UCID,
                                                rj.PLID
                                       )
                );
*/
            }
// Recup des initial connections
            while (true)
            {
                if (header != 0x143C && header != 0x073C)
		            break;
                fp.Read(buffer, 0, 59);
                int driverID = pakGetByte(buffer,0 );
                string nickName = pakGetString( buffer,3,24);
                string plate = pakGetString( buffer,27,8 );
                string userName = pakGetString( buffer,35,24);
                fp.Read(buffer, 0, 2);
                header = pakGetShort(buffer,0);
                for (int i = 0; i < rJoin.Count; i++)
                {
                    rJoinInfo rj = (rJoinInfo)rJoin[i];
//                    debug.WriteLine(rj.nickName + ":" + nickName + "<BR>");
                    if (rj.nickName == nickName)
                    {
                        rj.userName = userName;
                        rj.driverID = driverID;
                    }
                }
   	        }
            int nbmp = mprResult.results.Count;
            for( int i = 0; i < rJoin.Count; i++ ){
                rJoinInfo rj = (rJoinInfo) rJoin[i];
                bool flagFind = false;
                for( int j = 0; j < nbmp;j++ ){
                    resultInfo mp = (resultInfo) mprResult.results[j];
                    if( mp.userName == rj.userName ){
                        flagFind = true;
                        mp.PLID = rj.PLID;
                        mp.UCID = rj.UCID;
                        mp.nickName = rj.nickName;
                        mp.driverID = rj.driverID;
                        break;
                    }
                }
                if (!flagFind)
                {
                    resultInfo newmp = new resultInfo();
                    newmp.CName = "";
                    newmp.confFlags = -1;
                    newmp.CSkin = rj.CSkin;
                    newmp.driverID = rj.driverID;
                    newmp.HMass = 0;
                    newmp.HRest = 0;
                    newmp.HSkin = rj.HSkin;
                    newmp.laps = 0;
                    newmp.nickName = rj.nickName;
                    newmp.nickNameWc = exportstats.lfsStripColor(rj.nickName);
                    newmp.numPitStop = 0;
                    newmp.PBrace = 0;
                    newmp.penaltySecs = 0;
                    newmp.plate = rj.plate;
                    newmp.PLID = rj.PLID;
                    newmp.plyFlags = 0;
                    newmp.startPos = 0;
                    newmp.totTime = 0;
                    newmp.UCID = rj.UCID;
                    newmp.userName = rj.userName;
                    newmp.zero = 0;
                    newmp.finished = false;
                    newmp.CName = longToShortCarName(rj.LCName);
                    mprResult.results.Add(newmp);
                }
            }

            return mprResult;

        }

        public static byte[] getFrame( Stream fp ){


            byte[] buffer = new byte[3000];

            if (firstGetFrame)
            {
                byte[] pattern = new byte[3];
                pattern[0] = 0x00;
                pattern[1] = 0x48;
                pattern[2] = 0x13;
                if (!Reader.findPattern(fp, pattern))
                {
                    MessageBox.Show("Mpr non lisible");
                    return null;
                }
                fp.Read(buffer, 0, 75); // ??
                firstGetFrame = false;
            }
            if( buffers.Count != 0 )
                return (byte[])buffers.Dequeue();

            try {
                fp.Read(buffer, 0, 2);
            }
            catch{
                return null;
            }
            tStamp = Reader.pakGetShort( buffer,0 );
            if( tStamp < lastTStamp )
                nbTStamp++;
            lastTStamp = tStamp;
            totTStamp = nbTStamp * 65536 + tStamp;
            fp.Read(buffer, 0, 1);
            int TFMarker = Reader.pakGetByte(buffer, 0);
            if (TFMarker == 0xFF)
                return null;
            int packetSize=0;
            int UCID;
            switch (TFMarker)
            {
                case 0xFE:
                    packetSize = 72;
                    fp.Seek(-3, SeekOrigin.Current);
                    fp.Read(buffer, 0, packetSize);
//                        debug.WriteLine( Reader.bufferToHexa( buffer,packetSize) + "<BR>");
                    return buffer;
                    break;
                case 0xFD:
                    fp.Read(buffer, 0, 3);
                    UCID = Reader.pakGetByte(buffer, 0);
                    packetSize = Reader.pakGetShort(buffer, 1);
                    fp.Seek(-6, SeekOrigin.Current);
                    fp.Read(buffer, 0, packetSize + 6);
//                    debug.WriteLine( Reader.bufferToHexa( buffer,packetSize+6) + "<BR>");
                    return buffer;
                    break;
                case 0xFC:
                    fp.Read(buffer, 0, 3);
                    UCID = Reader.pakGetByte(buffer, 0);
                    packetSize = Reader.pakGetShort(buffer, 1);
                    fp.Seek(-6, SeekOrigin.Current);
                    fp.Read(buffer, 0, packetSize + 6);
//                    debug.WriteLine("---->" + Reader.bufferToHexa(buffer, packetSize + 6) + "<BR>");
                    int idxStart = 6;
                    int currIdx = 0;
                    while (true)
                    {
                        int subLength = Reader.pakGetByte(buffer, idxStart);
                        currIdx = 0;
                        byte[] buff = new byte[300];
                        buff[currIdx++] = buffer[0];
                        buff[currIdx++] = buffer[1];
                        buff[currIdx++] = buffer[2];
                        buff[currIdx++] = buffer[3];
                        int tot = subLength + 1;
                        buff[currIdx++] = (byte)(tot % 256);
                        buff[currIdx++] = (byte)(tot / 256 );
                        for( int i = 0; i <= subLength+6;i++ )
                            buff[currIdx++] = buffer[idxStart+i];
                        idxStart = idxStart + subLength + 1;
//                        debug.WriteLine( "==>" + Reader.bufferToHexa(buff, subLength + 6 + 1) + "<BR>");
//                        debug.WriteLine(idxStart.ToString() + "<BR>");
//                        debug.WriteLine(packetSize.ToString() + "<BR>");
                        buffers.Enqueue(buff);
                        if (idxStart >= (packetSize + 6))
                            break;
                    }
                    return (byte[])buffers.Dequeue();
            }

            return buffer;
        }
    }

    public class STARTFINISHLINE
    {
        /// <summary>
        /// Short Track Name.
        /// </summary>
        public readonly int PLID;
        public readonly int UCID;
        public readonly int lap;
        public readonly long lapTime;


        public STARTFINISHLINE(byte[] packet)
        {

            UCID = Reader.pakGetByte(packet, 3);
            PLID = Reader.pakGetByte(packet, 8);
            lap = Reader.pakGetShort(packet, 9);
            lapTime = Reader.pakGetShort(packet, 11) * 10;
        }
    }
    public class SPLIT
    {
        /// <summary>
        /// Short Track Name.
        /// </summary>
        public readonly int PLID;
        public readonly int UCID;
        public readonly int split;
        public readonly long splitTime;


        public SPLIT(byte[] packet)
        {
            UCID = Reader.pakGetByte(packet, 3);
            PLID = Reader.pakGetByte(packet, 8);
            split = Reader.pakGetByte(packet, 9) - 2;
            splitTime = Reader.pakGetShort(packet, 11) * 10;
        }
    }
    public class SERVERLEAVE
    {
        /// <summary>
        /// Short Track Name.
        /// </summary>
        public readonly int DriverID;


        public SERVERLEAVE(byte[] packet)
        {
            DriverID = Reader.pakGetByte(packet, 8);
        }
    }
    public class CHAT
    {
        /// <summary>
        /// Short Track Name.
        /// </summary>
        public readonly int UCID;
        public readonly string mess;


        public CHAT(byte[] packet)
        {
            int size = Reader.pakGetShort(packet, 4);
            UCID = Reader.pakGetByte(packet, 3);
            mess = Reader.pakGetString(packet, 10, size);
        }
    }


}