using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MPRStat;
using MyDebug;

namespace MPRStat
{
    public partial class Form1 : Form
    {
        public static string getShortVersion(int level)
        {
            string[] FullNameSplit = System.Reflection.Assembly.GetExecutingAssembly().FullName.Split(',');
            string[] version = FullNameSplit[1].Trim().Split('=');
            string[] id = version[1].Split('.');
            string retVal = id[0];
            for (int i = 1; i < level; i++)
                retVal += "." + id[i];
            return retVal;
        }

        public Form1()
        {
            InitializeComponent();
            version.Text = "Version : " + getShortVersion(3);
            debug.openDebug("deb.html",true );

        }

        private void button1_Click(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "mpr files (*.mpr)|*.mpr|All files (*.*)|*.*";
            openFileDialog1.FileName = fileName.Text;
            openFileDialog1.RestoreDirectory = true;
            if( openFileDialog1.ShowDialog() == DialogResult.OK ){
                fileName.Text = openFileDialog1.FileName;
            }
        }

        private void startParse_Click(object sender, EventArgs e)
        {
            MPRParse mprstat;
            try
            {
                if( this.fileName.Text != "" )
                    mprstat = new MPRParse("MPRStat.cfg",this.fileName.Text,"debug.htm" );
            }
            catch (Exception ex)
            {
                string msg = "The following error occurred:" + "\n"
                                + ex.Message + "\n"
                                + ex.Source + "\n"
                                + ex.StackTrace + "\n"
                                + ex.TargetSite + "\n";
                MessageBox.Show(msg);
            }

        }
    }
}