##########################################################
# GUI (Graphical User Interface) Version 1.0.4 by Tim NL #
##########################################################
# Change date 24-3-2009 Rebuild from v5.716 to v5.829
#
# Copy script in ./bin/includes folder and
# make the following changes in your LFSLapper.lpr
# to install this GUI in LFSLapper V5.829
#
##########################################
#Add to Event triggered when lapper start#
##########################################
#Event OnLapperStart()
#	OnLapperStart_Gui();
#EndEvent
########################
#Add to Command actions#
########################
#	SWITCH( $command )
#		CASE "!gui":
#			IF( UserInGroup( "admin",$userName ) == 1 )
#			THEN
#			  MA_gui(0,0);
#			ELSE
#			  privMsg( "You are not an Admin!");
#			ENDIF
#			BREAK;
###########################
#Add to Overriding options#
###########################
#include( "./includes/Gui_V104.lpr");
#
###########################################################
#If want to use the Drift Option see part at end of Script#
###########################################################

Sub OnLapperStart_Gui()
	GlobalVar $GUI_origL ;
	GlobalVar $GUI_origT ;
	GlobalVar $GUI_Lap ;
	GlobalVar $GUI_qual ;
	GlobalVar $GUI_wind ;
	GlobalVar $GUI_weather ;
	GlobalVar $GUI_mustpit ;
	GlobalVar $GUI_fcv ;
	GlobalVar $GUI_drift ;
	GlobalVar $GUI_midrace ;
	GlobalVar $GUI_start ;
	 $GUI_origL = "40" ;
	 $GUI_origT = "60" ;
	 $GUI_Lap = 5 ;
	 $GUI_qual = 10 ;
	 $GUI_wind = 0 ;
	 $GUI_weather = 1 ;
	 $GUI_mustpit = "no" ;
	 $GUI_fcv = "no" ;
	 $GUI_drift = "no" ;
	 $GUI_midrace = "yes" ;	
	 $GUI_start = "finish" ;

	GlobalVar $GUI_col_bl1 ;
	 $GUI_col_bl1 = 16 ;
	GlobalVar $GUI_col_bl2 ;
	 $GUI_col_bl2 = 32 ;
	GlobalVar $GUI_col_bl_rev ;
	 $GUI_col_bl_rev = 32 ;
	GlobalVar $GUI_col_so1 ;
	 $GUI_col_so1 = 32 ;
	GlobalVar $GUI_col_so2 ;
	 $GUI_col_so2 = 32 ;
	GlobalVar $GUI_col_so3 ;
	 $GUI_col_so3 = 32 ;
	GlobalVar $GUI_col_so4 ;
	 $GUI_col_so4 = 32 ;
	GlobalVar $GUI_col_so5 ;
	 $GUI_col_so5 = 32 ;
	GlobalVar $GUI_col_so6 ;
	 $GUI_col_so6 = 32 ;
	GlobalVar $GUI_col_so_rev ;
	 $GUI_col_so_rev = 32 ;
	GlobalVar $GUI_col_fe1 ;
	 $GUI_col_fe1 = 32 ;
	GlobalVar $GUI_col_fe2 ;
	 $GUI_col_fe2 = 32 ;
	GlobalVar $GUI_col_fe3 ;
	 $GUI_col_fe3 = 32 ;
	GlobalVar $GUI_col_fe4 ;
	 $GUI_col_fe4 = 32 ;
	GlobalVar $GUI_col_fe5 ;
	 $GUI_col_fe5 = 32 ;
	GlobalVar $GUI_col_fe6 ;
	 $GUI_col_fe6 = 32 ;
	GlobalVar $GUI_col_fe_rev ;
	 $GUI_col_fe_rev = 32 ;
	GlobalVar $GUI_col_ky1 ;
	 $GUI_col_ky1 = 32 ;
	GlobalVar $GUI_col_ky2 ;
	 $GUI_col_ky2 = 32 ;
	GlobalVar $GUI_col_ky3 ;
	 $GUI_col_ky3 = 32 ;
	GlobalVar $GUI_col_ky_rev ;
	 $GUI_col_ky_rev = 32 ;
	GlobalVar $GUI_col_we1 ;
	 $GUI_col_we1 = 32 ;
	GlobalVar $GUI_col_we_rev ;
	 $GUI_col_we_rev = 32 ;
	GlobalVar $GUI_col_as1 ;
	 $GUI_col_as1 = 32 ;
	GlobalVar $GUI_col_as2 ;
	 $GUI_col_as2 = 32 ;
	GlobalVar $GUI_col_as3 ;
	 $GUI_col_as3 = 32 ;
	GlobalVar $GUI_col_as4 ;
	 $GUI_col_as4 = 32 ;
	GlobalVar $GUI_col_as5 ;
	 $GUI_col_as5 = 32 ;
	GlobalVar $GUI_col_as6 ;
	 $GUI_col_as6 = 32 ;
	GlobalVar $GUI_col_as7 ;
	 $GUI_col_as7 = 32 ;
	GlobalVar $GUI_col_as_rev ;
	 $GUI_col_as_rev = 32 ;

	GlobalVar $GUI_col_bl0 ;
	 $GUI_col_bl0 = 16 ;
	GlobalVar $GUI_col_so0 ;
	 $GUI_col_so0 = 32 ;
	GlobalVar $GUI_col_fe0 ;
	 $GUI_col_fe0 = 32 ;
	GlobalVar $GUI_col_ky0 ;
	 $GUI_col_ky0 = 32 ;
	GlobalVar $GUI_col_we0 ;
	 $GUI_col_we0 = 32 ;
	GlobalVar $GUI_col_as0 ;
	 $GUI_col_as0 = 32 ;

	GlobalVar $GUI_col_mustpit_yes ;
	 $GUI_col_mustpit_yes = 16 ;
	GlobalVar $GUI_col_mustpit_no ;
	 $GUI_col_mustpit_no = 32 ;

	GlobalVar $GUI_col_fcv_yes ;
	 $GUI_col_fcv_yes = 16 ;
	GlobalVar $GUI_col_fcv_no ;
	 $GUI_col_fcv_no = 32 ;

	GlobalVar $GUI_col_midrace_yes ;
	 $GUI_col_midrace_yes = 16 ;
	GlobalVar $GUI_col_midrace_no ;
	 $GUI_col_midrace_no = 32 ;

	GlobalVar $GUI_col_wind_0 ;
	 $GUI_col_wind_0 = 16 ;
	GlobalVar $GUI_col_wind_1 ;
	 $GUI_col_wind_1 = 32 ;
	GlobalVar $GUI_col_wind_2 ;
	 $GUI_col_wind_2 = 32 ;

	GlobalVar $GUI_col_start_0 ;
	 $GUI_col_start_0 = 32 ;
	GlobalVar $GUI_col_start_1 ;
	 $GUI_col_start_1 = 32 ;
	GlobalVar $GUI_col_start_2 ;
	 $GUI_col_start_2 = 32 ;
	GlobalVar $GUI_col_start_3 ;
	 $GUI_col_start_3 = 32 ;

	GlobalVar $GUI_col_weather_1 ;
	 $GUI_col_weather_1 = 32 ;
	GlobalVar $GUI_col_weather_2 ;
	 $GUI_col_weather_2 = 32 ;
	GlobalVar $GUI_col_weather_3 ;
	 $GUI_col_weather_3 = 32 ;

	GlobalVar $GUI_col_drift_yes ;
	 $GUI_col_drift_yes = 16 ;
	GlobalVar $GUI_col_drift_no ;
	 $GUI_col_drift_no = 32 ;
	GlobalVar $Angle_drift ;
	 $Angle_drift = 0 ;	 

 	GlobalVar $GUI_current_car ;
	 $GUI_current_car = "FBM" ;
 	GlobalVar $GUI_current_track ;
	 $GUI_current_track = "BL1" ;
 	GlobalVar $GUI_track_label ;
         $GUI_track_label = "bl" ;
 	GlobalVar $GUI_track_rev ;
         $GUI_track_rev = "" ;

	cmdLFS( "/vote yes" );
	cmdLFS( "/laps " . $GUI_Lap );
	cmdLFS( "/qual " . $GUI_qual );
	cmdLFS( "/wind " . $GUI_wind );
	cmdLFS( "/weather " . $GUI_weather );
	cmdLFS( "/mustpit " . $GUI_mustpit );
	cmdLFS( "/midrace " . $GUI_midrace );
	cmdLFS( "/fcv " . $GUI_fcv );
	cmdLFS( "/start " . $GUI_start );
	cmdLFS( "/cars " . $GUI_current_car );
	#cmdLFS( "/end" );
	#cmdLFS( "/track " . $GUI_current_track . $GUI_track_rev );
EndSub


Sub MA_gui( $KeyFlags,$id )
	$HostName = getLapperVar( "HostName" );
	
	openPrivButton( "gui_border",$GUI_origL-1,$GUI_origT-1,77,88,5,-1,16," " );
	openPrivButton( "gui_main",$GUI_origL,$GUI_origT,75,86,5,-1,32," " );
	openPrivButton( "gui_banner",$GUI_origL,$GUI_origT,75,6,5,-1,32,"GUI (Graphical User Interface)  " . $HostName );
	openPrivButton( "gui_ver",$GUI_origL+3,$GUI_origT+81,12,3,3,-1,0,"^0GUI Version 1.0.4 by Tim NL" );

	openPrivButton( "laps_box",$GUI_origL+3,$GUI_origT+8,18,10,4,-1,32," " );
	openPrivButton( "laps",$GUI_origL+4,$GUI_origT+9,8,4,4,-1,32,"Laps" );
	openPrivButton( "lapsvar",$GUI_origL+12,$GUI_origT+9,8,4,4,-1,16," " . $GUI_Lap  );
	openPrivButton( "lap-5",$GUI_origL+4,$GUI_origT+13,4,4,4,-1,16,"-5",MA_lap_M5 );
	openPrivButton( "lap-1",$GUI_origL+8,$GUI_origT+13,4,4,4,-1,16,"-1",MA_lap_M1 );
	openPrivButton( "lap+1",$GUI_origL+12,$GUI_origT+13,4,4,4,-1,16,"+1",MA_lap_P1 );
	openPrivButton( "lap+5",$GUI_origL+16,$GUI_origT+13,4,4,4,-1,16,"+5",MA_lap_P5 );

	openPrivButton( "qual_box",$GUI_origL+24,$GUI_origT+8,18,10,4,-1,32," " );
	openPrivButton( "qual",$GUI_origL+25,$GUI_origT+9,8,4,4,-1,32,"Qual" );
	openPrivButton( "qualvar",$GUI_origL+33,$GUI_origT+9,8,4,4,-1,16," " . $GUI_qual  );
	openPrivButton( "qual-5",$GUI_origL+25,$GUI_origT+13,4,4,4,-1,16,"-5",MA_qual_M5 );
	openPrivButton( "qual-1",$GUI_origL+29,$GUI_origT+13,4,4,4,-1,16,"-1",MA_qual_M1 );
	openPrivButton( "qual+1",$GUI_origL+33,$GUI_origT+13,4,4,4,-1,16,"+1",MA_qual_P1 );
	openPrivButton( "qual+5",$GUI_origL+37,$GUI_origT+13,4,4,4,-1,16,"+5",MA_qual_P5 );

	openPrivButton( "current_box",$GUI_origL+45,$GUI_origT+8,28,10,4,-1,32," " );
	openPrivButton( "track",$GUI_origL+46,$GUI_origT+9,6,4,4,-1,96,"Track: " );
	openPrivButton( "car",$GUI_origL+46,$GUI_origT+13,6,4,4,-1,96,"Car's: " );
	openPrivButton( "current_track",$GUI_origL+52,$GUI_origT+9,20,4,4,-1,16, . $GUI_current_track,MA_select_track );
	openPrivButton( "current_car",$GUI_origL+52,$GUI_origT+13,20,4,4,-1,16, . $GUI_current_car,MA_select_track );

	openPrivButton( "mid_box",$GUI_origL+3,$GUI_origT+22,35,6,4,-1,32," " );
	openPrivButton( "mid",$GUI_origL+4,$GUI_origT+23,16,4,4,-1,32,"Join Midrace" );
	  IF( $GUI_midrace == "yes" )
	  THEN
		  $GUI_col_midrace_yes = 16;
		  $GUI_col_midrace_no = 32;
	  ELSE
		  $GUI_col_midrace_yes = 32;
		  $GUI_col_midrace_no = 16;
	  ENDIF
	openPrivButton( "mid_yes",$GUI_origL+21,$GUI_origT+23,8,4,4,-1,$GUI_col_midrace_yes,"Yes",MA_midyes );
	openPrivButton( "mid_no",$GUI_origL+29,$GUI_origT+23,8,4,4,-1,$GUI_col_midrace_no,"No",MA_midno );

	openPrivButton( "mustpit_box",$GUI_origL+3,$GUI_origT+30,35,6,4,-1,32," " );
	openPrivButton( "mustpit",$GUI_origL+4,$GUI_origT+31,16,4,4,-1,32,"Must Pit" );
	  IF( $GUI_mustpit == "yes" )
	  THEN
		  $GUI_col_mustpit_yes = 16;
		  $GUI_col_mustpit_no = 32;
	  ELSE
		  $GUI_col_mustpit_yes = 32;
		  $GUI_col_mustpit_no = 16;
	  ENDIF
	openPrivButton( "pit_yes",$GUI_origL+21,$GUI_origT+31,8,4,4,-1,$GUI_col_mustpit_yes,"Yes",MA_pit_yes );
	openPrivButton( "pit_no",$GUI_origL+29,$GUI_origT+31,8,4,4,-1,$GUI_col_mustpit_no,"No",MA_pit_no );

	openPrivButton( "fcv_box",$GUI_origL+3,$GUI_origT+38,35,6,4,-1,32," " );
	openPrivButton( "fcv",$GUI_origL+4,$GUI_origT+39,16,4,4,-1,32,"Force Cockpit View" );
	  IF( $GUI_fcv == "yes" )
	  THEN
		  $GUI_col_fcv_yes = 16;
		  $GUI_col_fcv_no = 32;
	  ELSE
		  $GUI_col_fcv_yes = 32;
		  $GUI_col_fcv_no = 16;
	  ENDIF
	openPrivButton( "fcv_yes",$GUI_origL+21,$GUI_origT+39,8,4,4,-1,$GUI_col_fcv_yes,"Yes",MA_fcv_yes );
	openPrivButton( "fcv_no",$GUI_origL+29,$GUI_origT+39,8,4,4,-1,$GUI_col_fcv_no,"No",MA_fcv_no );

	openPrivButton( "wind_box",$GUI_origL+3,$GUI_origT+46,43,6,4,-1,32," " );
	openPrivButton( "wind",$GUI_origL+4,$GUI_origT+47,16,4,4,-1,32,"Wind" );
	  IF( $GUI_wind == 0 )
	  THEN
		  $GUI_col_wind_0 = 16;
		  $GUI_col_wind_1 = 32;
		  $GUI_col_wind_2 = 32;
	  ELSE
	  	IF( $GUI_wind == 1 )
	    THEN
			  $GUI_col_wind_0 = 32;
			  $GUI_col_wind_1 = 16;
			  $GUI_col_wind_2 = 32;
	    ELSE
			  $GUI_col_wind_0 = 32;
			  $GUI_col_wind_1 = 32;
			  $GUI_col_wind_2 = 16;
	    ENDIF
	  ENDIF 
	openPrivButton( "wind_0",$GUI_origL+21,$GUI_origT+47,8,4,4,-1,$GUI_col_wind_0,"Off",MA_wind_0 );
	openPrivButton( "wind_1",$GUI_origL+29,$GUI_origT+47,8,4,4,-1,$GUI_col_wind_1,"Low",MA_wind_1 );
	openPrivButton( "wind_2",$GUI_origL+37,$GUI_origT+47,8,4,4,-1,$GUI_col_wind_2,"High",MA_wind_2 );

	openPrivButton( "weather_box",$GUI_origL+3,$GUI_origT+54,69,6,4,-1,32," " );
	openPrivButton( "weather",$GUI_origL+4,$GUI_origT+55,16,4,4,-1,32,"Weather" );
	  IF( $GUI_weather == 1 )
	  THEN
		  $GUI_col_weather_0 = 16;
		  $GUI_col_weather_1 = 32;
		  $GUI_col_weather_2 = 32;
	  ELSE
	  	IF( $GUI_weather == 2 )
	    THEN
			  $GUI_col_weather_0 = 32;
			  $GUI_col_weather_1 = 16;
			  $GUI_col_weather_2 = 32;
	    ELSE
			  $GUI_col_weather_0 = 32;
			  $GUI_col_weather_1 = 32;
			  $GUI_col_weather_2 = 16;
	    ENDIF
	  ENDIF 
	openPrivButton( "weather_0",$GUI_origL+21,$GUI_origT+55,12,4,4,-1,$GUI_col_weather_0,"Clear Day",MA_weather_0 );
	openPrivButton( "weather_1",$GUI_origL+33,$GUI_origT+55,12,4,4,-1,$GUI_col_weather_1,"Cloudy Afternoon",MA_weather_1 );
	openPrivButton( "weather_2",$GUI_origL+45,$GUI_origT+55,12,4,4,-1,$GUI_col_weather_2,"Cloudy sunset",MA_weather_2 );
	openPrivButton( "weather_end",$GUI_origL+57,$GUI_origT+55,14,4,4,-1,16,"END Race to set",end_race );

	openPrivButton( "start_box",$GUI_origL+3,$GUI_origT+62,51,6,4,-1,32," " );
	openPrivButton( "start",$GUI_origL+4,$GUI_origT+63,16,4,4,-1,32,"Start Grid" );
	  IF( $GUI_start == "fixed" )
	  THEN
		  $GUI_col_start_0 = 16;
		  $GUI_col_start_1 = 32;
		  $GUI_col_start_2 = 32;
		  $GUI_col_start_3 = 32;
	  ELSE
	   	IF( $GUI_start == "finish" )
	    THEN
		  	$GUI_col_start_0 = 32;
		 	  $GUI_col_start_1 = 16;
		 	  $GUI_col_start_2 = 32;
		  	$GUI_col_start_3 = 32;
	    ELSE
	      IF( $GUI_start == "reverse" )
	      THEN
		     	$GUI_col_start_0 = 32;
		     	$GUI_col_start_1 = 32;
		     	$GUI_col_start_2 = 16;
		     	$GUI_col_start_3 = 32;
		 	  ELSE
		     	$GUI_col_start_0 = 32;
		     	$GUI_col_start_1 = 32;
		     	$GUI_col_start_2 = 32;
		     	$GUI_col_start_3 = 16;
			  ENDIF
	    ENDIF
	  ENDIF 
	openPrivButton( "start_0",$GUI_origL+21,$GUI_origT+63,8,4,4,-1,$GUI_col_start_0,"Fixed",MA_start_0 );
	openPrivButton( "start_1",$GUI_origL+29,$GUI_origT+63,8,4,4,-1,$GUI_col_start_1,"Finish",MA_start_1 );
	openPrivButton( "start_2",$GUI_origL+37,$GUI_origT+63,8,4,4,-1,$GUI_col_start_2,"Reverse",MA_start_2 );
	openPrivButton( "start_3",$GUI_origL+45,$GUI_origT+63,8,4,4,-1,$GUI_col_start_3,"Random",MA_start_3 );

	openPrivButton( "drift_box",$GUI_origL+3,$GUI_origT+70,35,6,4,-1,32," " );
	openPrivButton( "drift",$GUI_origL+4,$GUI_origT+71,16,4,4,-1,32,"Drift Option" );
	  IF( $GUI_drift == "yes" )
	  THEN
		  $GUI_col_drift_yes = 16;
		  $GUI_col_drift_no = 32;
	  ELSE
		  $GUI_col_drift_yes = 32;
		  $GUI_col_drift_no = 16;
	  ENDIF
	openPrivButton( "drift_yes",$GUI_origL+21,$GUI_origT+71,8,4,4,-1,$GUI_col_drift_yes,"Yes",MA_drift_yes );
	openPrivButton( "drift_no",$GUI_origL+29,$GUI_origT+71,8,4,4,-1,$GUI_col_drift_no,"No",MA_drift_no );

  openPrivButton( "close_box",$GUI_origL+106,$GUI_origT+79,12,6,4,-1,32," ",MA_close_gui );
  openPrivButton( "close_gui",$GUI_origL+107,$GUI_origT+80,10,4,4,-1,16,"Close",MA_close_gui );
	MA_select_track();
EndSub

Sub MA_close_gui( $KeyFlags,$id )
  closePrivButton("gui_border&gui_main&gui_banner&gui_ver&close_box&close_gui");
  closePrivButton("drift_box&drift&drift_yes&drift_no");
  closePrivButton("current_box&current_track&current_car&track&car");
  closePrivButton("start_box&start&start_0&start_1&start_2&start_3");
  closePrivButton("wind_box&wind&wind_0&wind_1&wind_2");
  closePrivButton("weather_end&weather_box&weather&weather_0&weather_1&weather_2");
  closePrivButton("fcv_box&fcv&fcv_yes&fcv_no");
  closePrivButton("mid_box&mid&mid_yes&mid_no");
  closePrivButton("mustpit_box&mustpit&pit_yes&pit_no");
  closePrivButton("laps_box&laps&lapsvar&lap-5&lap-1&lap+1&lap+5");
  closePrivButton("qual_box&qual&qualvar&qual-5&qual-1&qual+1&qual+5");
  closePrivButton("select_track_box_w&select_track_box_b&select_track_top_txt&select_track_bl&select_track_so&select_track_fe&select_track_ky&select_track_we&select_track_as&set_track&cancel_track&select_cancel_box_b&cancel_box_b&set_track_box_b");
  closePrivButton("select_track_bl1&select_track_bl2&select_track_bl_rev");
  closePrivButton("select_track_so1&select_track_so2&select_track_so3&select_track_so4&select_track_so5&select_track_so6&select_track_so_rev");
  closePrivButton("select_track_fe1&select_track_fe2&select_track_fe3&select_track_fe4&select_track_fe5&select_track_fe6&select_track_fe_rev");
  closePrivButton("select_track_ky1&select_track_ky2&select_track_ky3&select_track_ky_rev");
  closePrivButton("select_track_we1&select_track_we_rev");
  closePrivButton("select_track_as1&select_track_as2&select_track_as3&select_track_as4&select_track_as5&select_track_as6&select_track_as7&select_track_as_rev");
  closePrivButton("select_car_box_w&select_car_box_b&select_car_top_txt&select_car_all");
  closePrivButton("select_car_gtr&select_car_fxr&select_car_xrr&select_car_fzr");
  closePrivButton("select_car_fwd&select_car_ufr&select_car_xfr");  
  closePrivButton("select_car_mrt&select_car_fbm&select_car_fox&select_car_fo8&select_car_bf1");
  closePrivButton("select_car_tbo&select_car_rb4&select_car_fxo&select_car_xrt");
  closePrivButton("select_car_rwd&select_car_lx4&select_car_lx6&select_car_rac&select_car_fz5");   
  closePrivButton("select_car_xfg_xrg&select_car_xfg&select_car_xrg&select_car_uf1&select_car_vws");
  closePrivButton("select_car_fill1&select_car_fill2&select_car_fill3");
EndSub

Sub MA_drift_yes( $KeyFlags,$id )
  $GUI_drift="yes";
  closePrivButton("drift_yes&drift_no");
  openPrivButton( "drift_yes",$GUI_origL+21,$GUI_origT+71,8,4,4,-1,16,"Yes",MA_drift_yes );
  openPrivButton( "drift_no",$GUI_origL+29,$GUI_origT+71,8,4,4,-1,32,"No",MA_drift_no );
EndSub

Sub MA_drift_no( $KeyFlags,$id )
  $GUI_drift="no";
  closePrivButton("drf0&drf1&drf2");
  closePrivButton("drift_yes&drift_no");
  openPrivButton( "drift_yes",$GUI_origL+21,$GUI_origT+71,8,4,4,-1,32,"Yes",MA_drift_yes );
  openPrivButton( "drift_no",$GUI_origL+29,$GUI_origT+71,8,4,4,-1,16,"No",MA_drift_no );
EndSub

Sub end_race( $KeyFlags,$id )
  cmdLFS( "/end");
EndSub

#########################
# Select Track          #
#########################

Sub MA_select_track()

	  IF(  $GUI_track_label == "bl" )
	  THEN
		  $GUI_col_bl0 = 16; $GUI_col_so0 = 32; $GUI_col_fe0 = 32; $GUI_col_ky0 = 32; $GUI_col_we0 = 32; $GUI_col_as0 = 32;
	  ELSE
	   	IF(  $GUI_track_label == "so" )
	    THEN
		  	$GUI_col_bl0 = 32; $GUI_col_so0 = 16; $GUI_col_fe0 = 32; $GUI_col_ky0 = 32; $GUI_col_we0 = 32; $GUI_col_as0 = 32;
	    ELSE
	      IF(  $GUI_track_label == "fe" )
	      THEN
		  		$GUI_col_bl0 = 32; $GUI_col_so0 = 32; $GUI_col_fe0 = 16; $GUI_col_ky0 = 32; $GUI_col_we0 = 32; $GUI_col_as0 = 32;
		 	  ELSE
	        IF(  $GUI_track_label == "ky" )
	        THEN
		  			$GUI_col_bl0 = 32; $GUI_col_so0 = 32; $GUI_col_fe0 = 32; $GUI_col_ky0 = 16; $GUI_col_we0 = 32; $GUI_col_as0 = 32;
		 		  ELSE
	        	IF(  $GUI_track_label == "we" )
	         	THEN
		  				$GUI_col_bl0 = 32; $GUI_col_so0 = 32; $GUI_col_fe0 = 32; $GUI_col_ky0 = 32; $GUI_col_we0 = 16; $GUI_col_as0 = 32;
		 			  ELSE
		  				$GUI_col_bl0 = 32; $GUI_col_so0 = 32; $GUI_col_fe0 = 32; $GUI_col_ky0 = 32; $GUI_col_we0 = 32; $GUI_col_as0 = 16;
					  ENDIF
				  ENDIF
			  ENDIF
	    ENDIF
	  ENDIF

  openPrivButton( "select_track_box_w",$GUI_origL+76,$GUI_origT-1,44,38,4,-1,16," " );
  openPrivButton( "select_track_box_b",$GUI_origL+77,$GUI_origT,42,36,4,-1,32," " );
  openPrivButton( "select_track_top_txt",$GUI_origL+77,$GUI_origT,42,6,5,-1,32,"Select Track" );
  openPrivButton( "select_track_bl",$GUI_origL+78,$GUI_origT+7,4,4,4,-1,$GUI_col_bl0,"BL" );
  openPrivButton( "select_track_bl1",$GUI_origL+82,$GUI_origT+7,4,4,4,-1,$GUI_col_bl1,"1",select_bl1 );
  openPrivButton( "select_track_bl2",$GUI_origL+86,$GUI_origT+7,4,4,4,-1,$GUI_col_bl2,"2",select_bl2 );
  openPrivButton( "select_track_bl_rev",$GUI_origL+110,$GUI_origT+7,8,4,4,-1,$GUI_col_bl_rev,"Reverse",MA_select_rev );
  openPrivButton( "select_track_so",$GUI_origL+78,$GUI_origT+11,4,4,4,-1,$GUI_col_so0,"SO" );
  openPrivButton( "select_track_so1",$GUI_origL+82,$GUI_origT+11,4,4,4,-1,$GUI_col_so1,"1",select_so1 );
  openPrivButton( "select_track_so2",$GUI_origL+86,$GUI_origT+11,4,4,4,-1,$GUI_col_so2,"2",select_so2 );
  openPrivButton( "select_track_so3",$GUI_origL+90,$GUI_origT+11,4,4,4,-1,$GUI_col_so3,"3",select_so3 );
  openPrivButton( "select_track_so4",$GUI_origL+94,$GUI_origT+11,4,4,4,-1,$GUI_col_so4,"4",select_so4 );
  openPrivButton( "select_track_so5",$GUI_origL+98,$GUI_origT+11,4,4,4,-1,$GUI_col_so5,"5",select_so5 );
  openPrivButton( "select_track_so6",$GUI_origL+102,$GUI_origT+11,4,4,4,-1,$GUI_col_so6,"6",select_so6 );
  openPrivButton( "select_track_so_rev",$GUI_origL+110,$GUI_origT+11,8,4,4,-1,$GUI_col_so_rev,"Reverse",MA_select_rev );
  openPrivButton( "select_track_fe",$GUI_origL+78,$GUI_origT+15,4,4,4,-1,$GUI_col_fe0,"FE" );
  openPrivButton( "select_track_fe1",$GUI_origL+82,$GUI_origT+15,4,4,4,-1,$GUI_col_fe1,"1",select_fe1 );
  openPrivButton( "select_track_fe2",$GUI_origL+86,$GUI_origT+15,4,4,4,-1,$GUI_col_fe2,"2",select_fe2 );
  openPrivButton( "select_track_fe3",$GUI_origL+90,$GUI_origT+15,4,4,4,-1,$GUI_col_fe3,"3",select_fe3 );
  openPrivButton( "select_track_fe4",$GUI_origL+94,$GUI_origT+15,4,4,4,-1,$GUI_col_fe4,"4",select_fe4 );
  openPrivButton( "select_track_fe5",$GUI_origL+98,$GUI_origT+15,4,4,4,-1,$GUI_col_fe5,"5",select_fe5 );
  openPrivButton( "select_track_fe6",$GUI_origL+102,$GUI_origT+15,4,4,4,-1,$GUI_col_fe6,"6",select_fe6 );
  openPrivButton( "select_track_fe_rev",$GUI_origL+110,$GUI_origT+15,8,4,4,-1,$GUI_col_fe_rev,"Reverse",MA_select_rev );
  openPrivButton( "select_track_ky",$GUI_origL+78,$GUI_origT+19,4,4,4,-1,$GUI_col_ky0,"KY" );
  openPrivButton( "select_track_ky1",$GUI_origL+82,$GUI_origT+19,4,4,4,-1,$GUI_col_ky1,"1",select_ky1 );
  openPrivButton( "select_track_ky2",$GUI_origL+86,$GUI_origT+19,4,4,4,-1,$GUI_col_ky2,"2",select_ky2 );
  openPrivButton( "select_track_ky3",$GUI_origL+90,$GUI_origT+19,4,4,4,-1,$GUI_col_ky3,"3",select_ky3 );
  openPrivButton( "select_track_ky_rev",$GUI_origL+110,$GUI_origT+19,8,4,4,-1,$GUI_col_ky_rev,"Reverse",MA_select_rev );
  openPrivButton( "select_track_we",$GUI_origL+78,$GUI_origT+23,4,4,4,-1,$GUI_col_we0,"WE" );
  openPrivButton( "select_track_we1",$GUI_origL+82,$GUI_origT+23,4,4,4,-1,$GUI_col_we1,"1",select_we1 );
  openPrivButton( "select_track_we_rev",$GUI_origL+110,$GUI_origT+23,8,4,4,-1,$GUI_col_we_rev,"Reverse",MA_select_rev );
  openPrivButton( "select_track_as",$GUI_origL+78,$GUI_origT+27,4,4,4,-1,$GUI_col_as0,"AS" );
  openPrivButton( "select_track_as1",$GUI_origL+82,$GUI_origT+27,4,4,4,-1,$GUI_col_as1,"1",select_as1 );
  openPrivButton( "select_track_as2",$GUI_origL+86,$GUI_origT+27,4,4,4,-1,$GUI_col_as2,"2",select_as2 );
  openPrivButton( "select_track_as3",$GUI_origL+90,$GUI_origT+27,4,4,4,-1,$GUI_col_as3,"3",select_as3 );
  openPrivButton( "select_track_as4",$GUI_origL+94,$GUI_origT+27,4,4,4,-1,$GUI_col_as4,"4",select_as4 );
  openPrivButton( "select_track_as5",$GUI_origL+98,$GUI_origT+27,4,4,4,-1,$GUI_col_as5,"5",select_as5 );
  openPrivButton( "select_track_as6",$GUI_origL+102,$GUI_origT+27,4,4,4,-1,$GUI_col_as6,"6",select_as6 );
  openPrivButton( "select_track_as7",$GUI_origL+106,$GUI_origT+27,4,4,4,-1,$GUI_col_as7,"7",select_as7 );
  openPrivButton( "select_track_as_rev",$GUI_origL+110,$GUI_origT+27,8,4,4,-1,$GUI_col_as_rev,"Reverse",MA_select_rev );

 MA_select_car(0,0);
EndSub

Sub select_bl1( $KeyFlags,$id )
  $GUI_current_track="BL1"; $GUI_track_label="bl";
  $GUI_col_bl1=16; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_bl2( $KeyFlags,$id )
  $GUI_current_track="BL2"; $GUI_track_label="bl";
  $GUI_col_bl1=32; $GUI_col_bl2=16;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_so1( $KeyFlags,$id )
  $GUI_current_track="SO1"; $GUI_track_label="so";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=16; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_so2( $KeyFlags,$id )
  $GUI_current_track="SO2"; $GUI_track_label="so"; 
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=16; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_so3( $KeyFlags,$id )
  $GUI_current_track="SO3"; $GUI_track_label="so";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=16; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_so4( $KeyFlags,$id )
  $GUI_current_track="SO4"; $GUI_track_label="so";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=16; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_so5( $KeyFlags,$id )
  $GUI_current_track="SO5"; $GUI_track_label="so";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=16; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_so6( $KeyFlags,$id )
  $GUI_current_track="SO6"; $GUI_track_label="so";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=16;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_fe1( $KeyFlags,$id )
  $GUI_current_track="FE1"; $GUI_track_label="fe";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=16; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_fe2( $KeyFlags,$id )
  $GUI_current_track="FE2"; $GUI_track_label="fe";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=16; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_fe3( $KeyFlags,$id )
  $GUI_current_track="FE3"; $GUI_track_label="fe";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=16; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_fe4( $KeyFlags,$id )
  $GUI_current_track="FE4"; $GUI_track_label="fe";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=16; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_fe5( $KeyFlags,$id )
  $GUI_current_track="FE5"; $GUI_track_label="fe";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=16; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_fe6( $KeyFlags,$id )
  $GUI_current_track="FE6"; $GUI_track_label="fe";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=16;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_ky1( $KeyFlags,$id )
  $GUI_current_track="KY1"; $GUI_track_label="ky";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=16; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_ky2( $KeyFlags,$id )
  $GUI_current_track="KY2"; $GUI_track_label="ky";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=16; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_ky3( $KeyFlags,$id )
  $GUI_current_track="KY3"; $GUI_track_label="ky";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=16;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_we1( $KeyFlags,$id )
  $GUI_current_track="WE1"; $GUI_track_label="we";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=16;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_as1( $KeyFlags,$id )
  $GUI_current_track="AS1"; $GUI_track_label="as";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=16; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_as2( $KeyFlags,$id )
  $GUI_current_track="AS2"; $GUI_track_label="as";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=16; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_as3( $KeyFlags,$id )
  $GUI_current_track="AS3"; $GUI_track_label="as";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=16; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_as4( $KeyFlags,$id )
  $GUI_current_track="AS4"; $GUI_track_label="as";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=16; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_as5( $KeyFlags,$id )
  $GUI_current_track="AS5"; $GUI_track_label="as";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=16; $GUI_col_as6=32; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_as6( $KeyFlags,$id )
  $GUI_current_track="AS6"; $GUI_track_label="as";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=16; $GUI_col_as7=32;
  MA_select_track();
EndSub

Sub select_as7( $KeyFlags,$id )
  $GUI_current_track="AS7"; $GUI_track_label="as";
  $GUI_col_bl1=32; $GUI_col_bl2=32;
  $GUI_col_so1=32; $GUI_col_so2=32; $GUI_col_so3=32; $GUI_col_so4=32; $GUI_col_so5=32; $GUI_col_so6=32;
  $GUI_col_fe1=32; $GUI_col_fe2=32; $GUI_col_fe3=32; $GUI_col_fe4=32; $GUI_col_fe5=32; $GUI_col_fe6=32;
  $GUI_col_ky1=32; $GUI_col_ky2=32; $GUI_col_ky3=32;
  $GUI_col_we1=32;
  $GUI_col_as1=32; $GUI_col_as2=32; $GUI_col_as3=32; $GUI_col_as4=32; $GUI_col_as5=32; $GUI_col_as6=32; $GUI_col_as7=16;
  MA_select_track();
EndSub
 
Sub MA_select_rev( $KeyFlags,$id )
	IF(  $GUI_track_rev == "R" )
	THEN
  	  $GUI_track_rev = "" ;
          $GUI_col_bl_rev = 32; $GUI_col_so_rev = 32; $GUI_col_fe_rev = 32; $GUI_col_ky_rev = 32; $GUI_col_we_rev = 32; $GUI_col_as_rev = 32;
	ELSE
  	  $GUI_track_rev = "R" ;

	  IF(  $GUI_track_label == "bl" )
	  THEN
		  $GUI_col_bl_rev = 16; $GUI_col_so_rev = 32; $GUI_col_fe_rev = 32; $GUI_col_ky_rev = 32; $GUI_col_we_rev = 32; $GUI_col_as_rev = 32;
	  ELSE
	   	IF(  $GUI_track_label == "so" )
	    THEN
		  	$GUI_col_bl_rev = 32; $GUI_col_so_rev = 16; $GUI_col_fe_rev = 32; $GUI_col_ky_rev = 32; $GUI_col_we_rev = 32; $GUI_col_as_rev = 32;
	    ELSE
	      IF(  $GUI_track_label == "fe" )
	      THEN
		  		$GUI_col_bl_rev = 32; $GUI_col_so_rev = 32; $GUI_col_fe_rev = 16; $GUI_col_ky_rev = 32; $GUI_col_we_rev = 32; $GUI_col_as_rev = 32;
		 	  ELSE
	        IF(  $GUI_track_label == "ky" )
	        THEN
		  			$GUI_col_bl_rev = 32; $GUI_col_so_rev = 32; $GUI_col_fe_rev = 32; $GUI_col_ky_rev = 16; $GUI_col_we_rev = 32; $GUI_col_as_rev = 32;
		 		  ELSE
	        	IF(  $GUI_track_label == "we" )
	         	THEN
		  				$GUI_col_bl_rev = 32; $GUI_col_so_rev = 32; $GUI_col_fe_rev = 32; $GUI_col_ky_rev = 32; $GUI_col_we_rev = 16; $GUI_col_as_rev = 32;
		 			  ELSE
		  				$GUI_col_bl_rev = 32; $GUI_col_so_rev = 32; $GUI_col_fe_rev = 32; $GUI_col_ky_rev = 32; $GUI_col_we_rev = 32; $GUI_col_as_rev = 16;
					  ENDIF
				  ENDIF
			  ENDIF
	    ENDIF
	  ENDIF
	ENDIF

  MA_select_track();
EndSub

Sub MA_end_race( $KeyFlags,$id )
  openPrivButton( "end_box",$GUI_origL+45,$GUI_origT+22,28,10,4,-1,32," " );
  openPrivButton( "end",$GUI_origL+46,$GUI_origT+23,26,4,4,-1,32,"Race END before the Track Changed" );
  openPrivButton( "end_yes",$GUI_origL+46,$GUI_origT+27,13,4,4,-1,16,"Change Track Now",MA_end_track );
  openPrivButton( "end_no",$GUI_origL+60,$GUI_origT+27,12,4,4,-1,16,"Cancel",MA_end_no );
EndSub

Sub MA_end_no( $KeyFlags,$id )
  closePrivButton("end_box&end&end_yes&end_no");
EndSub

Sub MA_end_track( $KeyFlags,$id )
  cmdLFS("/end");
  closePrivButton("end_box&end&end_yes&end_no");
  closePrivButton("end2_box&end2&end2_yes");
  openPrivButton( "current_track",$GUI_origL+52,$GUI_origT+9,20,4,4,-1,16, . $GUI_current_track,MA_select_track );
  openGlobalButton ("test",$GUI_origL+45,$GUI_origT+32,28,6,4,6,16,"^7Track will be changed in (%cpt%) second(s)");
	DelayedCommand( 5, change_track );
EndSub

Sub change_track()
	cmdLFS( "/track " . $GUI_current_track . $GUI_track_rev );
EndSub

#########################
# Select Car            #
#########################

Sub MA_select_car( $KeyFlags,$id )
  openPrivButton( "select_car_box_w",$GUI_origL+76,$GUI_origT+37,44,50,4,-1,16," " );
  openPrivButton( "select_car_box_b",$GUI_origL+77,$GUI_origT+38,42,36,4,-1,32," " );
  openPrivButton( "select_car_top_txt",$GUI_origL+77,$GUI_origT+38,42,6,5,-1,32,"Select Car's" );
  openPrivButton( "select_car_fwd",$GUI_origL+78,$GUI_origT+45,8,4,4,-1,16,"FWD",MA_select_fwd );
  openPrivButton( "select_car_ufr",$GUI_origL+86,$GUI_origT+45,8,4,4,-1,16,"UFR",MA_select_ufr );
  openPrivButton( "select_car_xfr",$GUI_origL+94,$GUI_origT+45,8,4,4,-1,16,"XFR",MA_select_xfr );
  openPrivButton( "select_car_fill1",$GUI_origL+102,$GUI_origT+45,8,4,4,-1,16," " );
  openPrivButton( "select_car_all",$GUI_origL+110,$GUI_origT+45,8,4,4,-1,16,"ALL",MA_select_all );
  openPrivButton( "select_car_gtr",$GUI_origL+78,$GUI_origT+49,8,4,4,-1,16,"GTR",MA_select_gtr );
  openPrivButton( "select_car_fxr",$GUI_origL+86,$GUI_origT+49,8,4,4,-1,16,"FXR",MA_select_fxr );
  openPrivButton( "select_car_xrr",$GUI_origL+94,$GUI_origT+49,8,4,4,-1,16,"XRR",MA_select_xrr );
  openPrivButton( "select_car_fzr",$GUI_origL+102,$GUI_origT+49,8,4,4,-1,16,"FZR",MA_select_fzr );
  openPrivButton( "select_car_fill2",$GUI_origL+110,$GUI_origT+49,8,4,4,-1,16," " );
  openPrivButton( "select_car_tbo",$GUI_origL+78,$GUI_origT+53,8,4,4,-1,16,"TBO",MA_select_tbo );
  openPrivButton( "select_car_rb4",$GUI_origL+86,$GUI_origT+53,8,4,4,-1,16,"RB4",MA_select_rb4 );
  openPrivButton( "select_car_fxo",$GUI_origL+94,$GUI_origT+53,8,4,4,-1,16,"FXO",MA_select_fxo );
  openPrivButton( "select_car_xrt",$GUI_origL+102,$GUI_origT+53,8,4,4,-1,16,"XRT",MA_select_xrt );
  openPrivButton( "select_car_fill3",$GUI_origL+110,$GUI_origT+53,8,4,4,-1,16," " );      
  openPrivButton( "select_car_mrt",$GUI_origL+78,$GUI_origT+57,8,4,4,-1,16,"MRT",MA_select_mrt );
  openPrivButton( "select_car_fbm",$GUI_origL+86,$GUI_origT+57,8,4,4,-1,16,"FBM",MA_select_fbm );
  openPrivButton( "select_car_fox",$GUI_origL+94,$GUI_origT+57,8,4,4,-1,16,"FOX",MA_select_fox );
  openPrivButton( "select_car_fo8",$GUI_origL+102,$GUI_origT+57,8,4,4,-1,16,"FO8",MA_select_fo8 );
  openPrivButton( "select_car_bf1",$GUI_origL+110,$GUI_origT+57,8,4,4,-1,16,"BF1",MA_select_bf1 );
  openPrivButton( "select_car_rwd",$GUI_origL+78,$GUI_origT+61,8,4,4,-1,16,"RWD",MA_select_rwd );
  openPrivButton( "select_car_lx4",$GUI_origL+86,$GUI_origT+61,8,4,4,-1,16,"LX4",MA_select_lx4 );
  openPrivButton( "select_car_lx6",$GUI_origL+94,$GUI_origT+61,8,4,4,-1,16,"LX6",MA_select_lx6 );
  openPrivButton( "select_car_rac",$GUI_origL+102,$GUI_origT+61,8,4,4,-1,16,"RAC",MA_select_rac );
  openPrivButton( "select_car_fz5",$GUI_origL+110,$GUI_origT+61,8,4,4,-1,16,"FZ5",MA_select_fz5 );  
  openPrivButton( "select_car_xfg_xrg",$GUI_origL+78,$GUI_origT+65,8,4,4,-1,16,"XFG+XRG",MA_select_xfg_xrg );
  openPrivButton( "select_car_xfg",$GUI_origL+86,$GUI_origT+65,8,4,4,-1,16,"XFG",MA_select_xfg );
  openPrivButton( "select_car_xrg",$GUI_origL+94,$GUI_origT+65,8,4,4,-1,16,"XRG",MA_select_xrg );
  openPrivButton( "select_car_uf1",$GUI_origL+102,$GUI_origT+65,8,4,4,-1,16,"UF1",MA_select_uf1 );
  openPrivButton( "select_car_vws",$GUI_origL+110,$GUI_origT+65,8,4,4,-1,16,"VWS",MA_select_vws );

  openPrivButton( "set_track_box_b",$GUI_origL+78,$GUI_origT+79,14,6,4,-1,32," " );
  openPrivButton( "set_track",$GUI_origL+79,$GUI_origT+80,12,4,4,-1,16,"SET TRACK",MA_end_race );  
  openPrivButton( "select_cancel_box_b",$GUI_origL+77,$GUI_origT+74,42,12,4,-1,32," " );       
EndSub

Sub MA_select_vws( $KeyFlags,$id )
  $GUI_current_car="VWS";
  set_car(0,0);
EndSub

Sub MA_select_gtr( $KeyFlags,$id )
  $GUI_current_car="GTR";
  set_car(0,0);
EndSub

Sub MA_select_fxr( $KeyFlags,$id )
  $GUI_current_car="FXR";
  set_car(0,0);
EndSub

Sub MA_select_xrr( $KeyFlags,$id )
  $GUI_current_car="XRR";
  set_car(0,0);
EndSub

Sub MA_select_fzr( $KeyFlags,$id )
  $GUI_current_car="FZR";
  set_car(0,0);
EndSub

Sub MA_select_fwd( $KeyFlags,$id )
  $GUI_current_car="UFR+XFR";
  set_car(0,0);
EndSub

Sub MA_select_ufr( $KeyFlags,$id )
  $GUI_current_car="UFR";
  set_car(0,0);
EndSub

Sub MA_select_xfr( $KeyFlags,$id )
  $GUI_current_car="XFR";
  set_car(0,0);
EndSub

Sub MA_select_tbo( $KeyFlags,$id )
  $GUI_current_car="TBO";
  set_car(0,0);
EndSub

Sub MA_select_rb4( $KeyFlags,$id )
  $GUI_current_car="RB4";
  set_car(0,0);
EndSub

Sub MA_select_fxo( $KeyFlags,$id )
  $GUI_current_car="FXO";
  set_car(0,0);
EndSub

Sub MA_select_xrt( $KeyFlags,$id )
  $GUI_current_car="XRT";
  set_car(0,0);
EndSub

Sub MA_select_mrt( $KeyFlags,$id )
  $GUI_current_car="MRT";
  set_car(0,0);
EndSub

Sub MA_select_fbm( $KeyFlags,$id )
  $GUI_current_car="FBM";
  set_car(0,0);
EndSub

Sub MA_select_fox( $KeyFlags,$id )
  $GUI_current_car="FOX";
  set_car(0,0);
EndSub

Sub MA_select_fo8( $KeyFlags,$id )
  $GUI_current_car="FO8";
  set_car(0,0);
EndSub

Sub MA_select_bf1( $KeyFlags,$id )
  $GUI_current_car="BF1";
  set_car(0,0);
EndSub

Sub MA_select_xfg_xrg( $KeyFlags,$id )
  $GUI_current_car="XFG+XRG";
  set_car(0,0);
EndSub

Sub MA_select_xfg( $KeyFlags,$id )
  $GUI_current_car="XFG";
  set_car(0,0);
EndSub

Sub MA_select_xrg( $KeyFlags,$id )
  $GUI_current_car="XRG";
  set_car(0,0);
EndSub

Sub MA_select_uf1( $KeyFlags,$id )
  $GUI_current_car="UF1";
  set_car(0,0);
EndSub

Sub MA_select_rwd( $KeyFlags,$id )
  $GUI_current_car="LX4+LX6+RAC+FZ5";
  set_car(0,0);
EndSub

Sub MA_select_lx4( $KeyFlags,$id )
  $GUI_current_car="LX4";
  set_car(0,0);
EndSub

Sub MA_select_lx6( $KeyFlags,$id )
  $GUI_current_car="LX6";
  set_car(0,0);
EndSub

Sub MA_select_rac( $KeyFlags,$id )
  $GUI_current_car="RAC";
  set_car(0,0);
EndSub

Sub MA_select_fz5( $KeyFlags,$id )
  $GUI_current_car="FZ5";
  set_car(0,0);
EndSub

Sub MA_select_all( $KeyFlags,$id )
  $GUI_current_car="ALL";
  set_car(0,0);
EndSub

Sub set_car( $KeyFlags,$id )
  cmdLFS( "/cars " . $GUI_current_car );
  openPrivButton( "current_car",$GUI_origL+52,$GUI_origT+13,20,4,4,-1,16, . $GUI_current_car,MA_select_track );
EndSub

#########################
# set weather           #
#########################

Sub MA_weather_0( $KeyFlags,$id )
  $GUI_weather=1;
  closePrivButton("weather_0&weather_1&weather_2");
  openPrivButton( "weather_0",$GUI_origL+21,$GUI_origT+55,12,4,4,-1,16,"Clear Day",MA_weather_0 );
  openPrivButton( "weather_1",$GUI_origL+33,$GUI_origT+55,12,4,4,-1,32,"Cloudy Afternoon",MA_weather_1 );
  openPrivButton( "weather_2",$GUI_origL+45,$GUI_origT+55,12,4,4,-1,32,"Cloudy sunset",MA_weather_2 );
  cmdLFS( "/weather " . $GUI_weather );
EndSub

Sub MA_weather_1( $KeyFlags,$id )
  $GUI_weather=2;
  closePrivButton("weather_0&weather_1&weather_2");
  openPrivButton( "weather_0",$GUI_origL+21,$GUI_origT+55,12,4,4,-1,32,"Clear Day",MA_weather_0 );
  openPrivButton( "weather_1",$GUI_origL+33,$GUI_origT+55,12,4,4,-1,16,"Cloudy Afternoon",MA_weather_1 );
  openPrivButton( "weather_2",$GUI_origL+45,$GUI_origT+55,12,4,4,-1,32,"Cloudy sunset",MA_weather_2 );
  cmdLFS( "/weather " . $GUI_weather );
EndSub

Sub MA_weather_2( $KeyFlags,$id )
  $GUI_weather=3;
  closePrivButton("weather_0&weather_1&weather_2");
  openPrivButton( "weather_0",$GUI_origL+21,$GUI_origT+55,12,4,4,-1,32,"Clear Day",MA_weather_0 );
  openPrivButton( "weather_1",$GUI_origL+33,$GUI_origT+55,12,4,4,-1,32,"Cloudy Afternoon",MA_weather_1 );
  openPrivButton( "weather_2",$GUI_origL+45,$GUI_origT+55,12,4,4,-1,16,"Cloudy sunset",MA_weather_2 );
  cmdLFS( "/weather " . $GUI_weather );
EndSub

Sub MA_start_0( $KeyFlags,$id )
  $GUI_start = "fixed";
  closePrivButton("start_0&start_1&start_2&start_3");
  openPrivButton( "start_0",$GUI_origL+21,$GUI_origT+63,8,4,4,-1,16,"Fixed",MA_start_0 );
  openPrivButton( "start_1",$GUI_origL+29,$GUI_origT+63,8,4,4,-1,32,"Finish",MA_start_1 );
  openPrivButton( "start_2",$GUI_origL+37,$GUI_origT+63,8,4,4,-1,32,"Reverse",MA_start_2 );
  openPrivButton( "start_3",$GUI_origL+45,$GUI_origT+63,8,4,4,-1,32,"Random",MA_start_3 );
  cmdLFS( "/start " . $GUI_start );
EndSub

Sub MA_start_1( $KeyFlags,$id )
  $GUI_start = "finish";
  closePrivButton("start_0&start_1&start_2&start_3");
  openPrivButton( "start_0",$GUI_origL+21,$GUI_origT+63,8,4,4,-1,32,"Fixed",MA_start_0 );
  openPrivButton( "start_1",$GUI_origL+29,$GUI_origT+63,8,4,4,-1,16,"Finish",MA_start_1 );
  openPrivButton( "start_2",$GUI_origL+37,$GUI_origT+63,8,4,4,-1,32,"Reverse",MA_start_2 );
  openPrivButton( "start_3",$GUI_origL+45,$GUI_origT+63,8,4,4,-1,32,"Random",MA_start_3 );
  cmdLFS( "/start " . $GUI_start );
EndSub

Sub MA_start_2( $KeyFlags,$id )
  $GUI_start = "reverse";
  closePrivButton("start_0&start_1&start_2&start_3");
  openPrivButton( "start_0",$GUI_origL+21,$GUI_origT+63,8,4,4,-1,32,"Fixed",MA_start_0 );
  openPrivButton( "start_1",$GUI_origL+29,$GUI_origT+63,8,4,4,-1,32,"Finish",MA_start_1 );
  openPrivButton( "start_2",$GUI_origL+37,$GUI_origT+63,8,4,4,-1,16,"Reverse",MA_start_2 );
  openPrivButton( "start_3",$GUI_origL+45,$GUI_origT+63,8,4,4,-1,32,"Random",MA_start_3 );
  cmdLFS( "/start " . $GUI_start );
EndSub

Sub MA_start_3( $KeyFlags,$id )
  $GUI_start = "random";
  closePrivButton("start_0&start_1&start_2&start_3");
  openPrivButton( "start_0",$GUI_origL+21,$GUI_origT+63,8,4,4,-1,32,"Fixed",MA_start_0 );
  openPrivButton( "start_1",$GUI_origL+29,$GUI_origT+63,8,4,4,-1,32,"Finish",MA_start_1 );
  openPrivButton( "start_2",$GUI_origL+37,$GUI_origT+63,8,4,4,-1,32,"Reverse",MA_start_2 );
  openPrivButton( "start_3",$GUI_origL+45,$GUI_origT+63,8,4,4,-1,16,"Random",MA_start_3 );
  cmdLFS( "/start " . $GUI_start );
EndSub

Sub MA_wind_0( $KeyFlags,$id )
  $GUI_wind=0;
  closePrivButton("wind_0&wind_1&wind_2");
  openPrivButton( "wind_0",$GUI_origL+21,$GUI_origT+47,8,4,4,-1,16,"Off",MA_wind_0 );
  openPrivButton( "wind_1",$GUI_origL+29,$GUI_origT+47,8,4,4,-1,32,"Low",MA_wind_1 );
  openPrivButton( "wind_2",$GUI_origL+37,$GUI_origT+47,8,4,4,-1,32,"High",MA_wind_2 );
  cmdLFS( "/wind " . $GUI_wind );
EndSub

Sub MA_wind_1( $KeyFlags,$id )
  $GUI_wind=1;
  closePrivButton("wind_0&wind_1&wind_2");
  openPrivButton( "wind_0",$GUI_origL+21,$GUI_origT+47,8,4,4,-1,32,"Off",MA_wind_0 );
  openPrivButton( "wind_1",$GUI_origL+29,$GUI_origT+47,8,4,4,-1,16,"Low",MA_wind_1 );
  openPrivButton( "wind_2",$GUI_origL+37,$GUI_origT+47,8,4,4,-1,32,"High",MA_wind_2 );
  cmdLFS( "/wind " . $GUI_wind );
EndSub

Sub MA_wind_2( $KeyFlags,$id )
  $GUI_wind=2;
  closePrivButton("wind_0&wind_1&wind_2");
  openPrivButton( "wind_0",$GUI_origL+21,$GUI_origT+47,8,4,4,-1,32,"Off",MA_wind_0 );
  openPrivButton( "wind_1",$GUI_origL+29,$GUI_origT+47,8,4,4,-1,32,"Low",MA_wind_1 );
  openPrivButton( "wind_2",$GUI_origL+37,$GUI_origT+47,8,4,4,-1,16,"High",MA_wind_2 );
  cmdLFS( "/wind " . $GUI_wind );
EndSub

Sub MA_fcv_yes( $KeyFlags,$id )
  $GUI_fcv="yes";
  closePrivButton("fcv_yes&fcv_no");
  openPrivButton( "fcv_yes",$GUI_origL+21,$GUI_origT+39,8,4,4,-1,16,"Yes",MA_fcv_yes );
  openPrivButton( "fcv_no",$GUI_origL+29,$GUI_origT+39,8,4,4,-1,32,"No",MA_fcv_no );
  cmdLFS( "/fcv " . $GUI_fcv );
EndSub

Sub MA_fcv_no( $KeyFlags,$id )
  $GUI_fcv="no";
  closePrivButton("fcv_yes&fcv_no");
  openPrivButton( "fcv_yes",$GUI_origL+21,$GUI_origT+39,8,4,4,-1,32,"Yes",MA_fcv_yes );
  openPrivButton( "fcv_no",$GUI_origL+29,$GUI_origT+39,8,4,4,-1,16,"No",MA_fcv_no );
  cmdLFS( "/fcv " . $GUI_fcv );
EndSub

Sub MA_midyes( $KeyFlags,$id )
  $GUI_midrace="yes";
  closePrivButton("mid_yes&mid_no");
  openPrivButton( "mid_yes",$GUI_origL+20,$GUI_origT+23,8,4,4,-1,16,"Yes",MA_midyes );
  openPrivButton( "mid_no",$GUI_origL+28,$GUI_origT+23,8,4,4,-1,32,"No",MA_midno );
  cmdLFS( "/midrace " . $GUI_midrace );
EndSub

Sub MA_midno( $KeyFlags,$id )
  $GUI_midrace="no";
  closePrivButton("mid_yes&mid_no");
  openPrivButton( "mid_yes",$GUI_origL+20,$GUI_origT+23,8,4,4,-1,32,"Yes",MA_midyes );
  openPrivButton( "mid_no",$GUI_origL+28,$GUI_origT+23,8,4,4,-1,16,"No",MA_midno );
  cmdLFS( "/midrace " . $GUI_midrace );
EndSub

Sub MA_qual_P1( $KeyFlags,$id )
  $GUI_qual=$GUI_qual+1;
  openPrivButton( "qualvar",$GUI_origL+33,$GUI_origT+9,8,4,4,-1,16," " . $GUI_qual );
  cmdLFS( "/qual " . $GUI_qual );
EndSub

Sub MA_qual_M1( $KeyFlags,$id )
  $GUI_qual=$GUI_qual-1;
  openPrivButton( "qualvar",$GUI_origL+33,$GUI_origT+9,8,4,4,-1,16," " . $GUI_qual );
  IF ( $GUI_qual <= 0 )
    THEN
    $GUI_qual=0;
   openPrivButton( "qualvar",$GUI_origL+33,$GUI_origT+9,8,4,4,-1,16,"Off" );
  ENDIF
  cmdLFS( "/qual " . $GUI_qual );
EndSub

Sub MA_qual_P5( $KeyFlags,$id )
  $GUI_qual=$GUI_qual+5;
  openPrivButton( "qualvar",$GUI_origL+33,$GUI_origT+9,8,4,4,-1,16," " . $GUI_qual );
  cmdLFS( "/qual " . $GUI_qual );
EndSub

Sub MA_qual_M5( $KeyFlags,$id )
  $GUI_qual=$GUI_qual-5;
  openPrivButton( "qualvar",$GUI_origL+33,$GUI_origT+9,8,4,4,-1,16," " . $GUI_qual );
  IF ( $GUI_qual <= 0 )
    THEN
    $GUI_qual=0;
   openPrivButton( "qualvar",$GUI_origL+33,$GUI_origT+9,8,4,4,-1,16,"Off" );
  ENDIF
  cmdLFS( "/qual " . $GUI_qual );
EndSub
	
Sub MA_lap_P1( $KeyFlags,$id )
  $GUI_Lap=$GUI_Lap+1;
  openPrivButton( "lapsvar",$GUI_origL+12,$GUI_origT+9,8,4,4,-1,16," " . $GUI_Lap );
  cmdLFS( "/laps " . $GUI_Lap );
EndSub

Sub MA_lap_M1( $KeyFlags,$id )
  $GUI_Lap=$GUI_Lap-1;
  openPrivButton( "lapsvar",$GUI_origL+12,$GUI_origT+9,8,4,4,-1,16," " . $GUI_Lap );
  IF ( $GUI_Lap <= 0 )
    THEN
    $GUI_Lap=0;
    openPrivButton( "lapsvar",$GUI_origL+12,$GUI_origT+9,8,4,4,-1,16,"Practice" );
  ENDIF
  cmdLFS( "/laps " . $GUI_Lap );
EndSub

Sub MA_lap_P5( $KeyFlags,$id )
  $GUI_Lap=$GUI_Lap+5;
  openPrivButton( "lapsvar",$GUI_origL+12,$GUI_origT+9,8,4,4,-1,16," " . $GUI_Lap );
  cmdLFS( "/laps " . $GUI_Lap );
EndSub

Sub MA_lap_M5( $KeyFlags,$id )
  $GUI_Lap=$GUI_Lap-5;
  openPrivButton( "lapsvar",$GUI_origL+12,$GUI_origT+9,8,4,4,-1,16," " . $GUI_Lap );
  IF ( $GUI_Lap <= 0 )
    THEN
    $GUI_Lap=0;
    openPrivButton( "lapsvar",$GUI_origL+12,$GUI_origT+9,8,4,4,-1,16,"Practice" );
  ENDIF
  cmdLFS( "/laps " . $GUI_Lap );
EndSub

Sub MA_pit_yes( $KeyFlags,$id )
  $GUI_mustpit="yes";
  closePrivButton("pit_yes&pit_no");
  openPrivButton( "pit_yes",$GUI_origL+21,$GUI_origT+31,8,4,4,-1,16,"Yes",MA_pit_yes );
  openPrivButton( "pit_no",$GUI_origL+29,$GUI_origT+31,8,4,4,-1,32,"No",MA_pit_no );
  cmdLFS( "/mustpit " . $GUI_mustpit );
EndSub

Sub MA_pit_no( $KeyFlags,$id )
  $GUI_mustpit="no";
  closePrivButton("pit_yes&pit_no");
  openPrivButton( "pit_yes",$GUI_origL+21,$GUI_origT+31,8,4,4,-1,32,"Yes",MA_pit_yes );
  openPrivButton( "pit_no",$GUI_origL+29,$GUI_origT+31,8,4,4,-1,16,"No",MA_pit_no );
  cmdLFS( "/mustpit " . $GUI_mustpit );
EndSub


/*
#Copy and past this part in your in your LFSLapper.lpr to use the Drift Option in GUI

##################
#Drifting options#
##################
# This is the filepath for a file containing the collected data.
# This file will be created if it doesnt exist yet.
# You must ensure read/write access to this path.
#-------------------------------------------------------------------

$DriftDatabase = "./DriftPB";

# Actions to do on new personal best drift lap.

Event OnDriftPB()  # Player event
	IF( $GUI_drift == "yes" )
	THEN
	cmdLFS( "/msg " . GetCurrentPlayerVar("Nickname") . "^3 made new PB: ^7" . GetCurrentPlayerVar("DriftScore") . " ^3pts!" );
	ENDIF
EndEvent

# Actions to do to when total lap drift score is higher or equal to MinimumDriftScore.

Event OnDriftLap() # Player event
	IF( $GUI_drift == "yes" )
	THEN
		cmdLFS("/msg " . GetCurrentPlayerVar("Nickname") . " ^3drifted to ^7" . GetCurrentPlayerVar("DriftScore") . " ^3pts" );
	ENDIF
EndEvent

# Message to get on end of each drift.
# Possible variables to use:

Event OnDriftScore() # Player event

$AngleVelocity = GetCurrentPlayerVar( "AngleVelocity" );

	IF( $GUI_drift == "yes" )
	THEN
		openPrivButton( "drf0",99,1,22,10,4,-1,16," " );
		IF( $AngleVelocity < 0 )
		THEN
			$Angle_drift=($AngleVelocity)*(-1);
			openPrivButton( "drf1",100,2,20,4,4,-1,32,"Score: ^7" . GetCurrentPlayerVar("DriftScore") . " ^3" . GetCurrentPlayerVar("LastDriftScore") );
			openPrivButton( "drf2",100,6,20,4,4,-1,32,"Drift Angle:  ^7" . $Angle_drift . "^2>" );
		ELSE
			openPrivButton( "drf1",100,2,20,4,4,-1,32,"Score: ^7" . GetCurrentPlayerVar("DriftScore") . " ^3" . GetCurrentPlayerVar("LastDriftScore") );
			openPrivButton( "drf2",100,6,20,4,4,-1,32,"Drift Angle: ^2<^7" . $AngleVelocity . " " );
		ENDIF
	ENDIF
EndEvent

$GoodDriftScore = 4000; # Value to be reached to execute action on good drift score

Event OnGoodDrift() # Player event
	IF( $GUI_drift == "yes" )
	THEN
		privMsg(  GetCurrentPlayerVar("Nickname") . " ^3made excellent drift: ^7" . GetCurrentPlayerVar("LastDriftScore") ." ^3pts" );
	ENDIF
EndEvent

#$MinimumDriftSpeed = 50; # Minimum speed in km/h to maintain. Driving below that speed will reset score
#$MinimumDriftAngle = 15; # Minimum angel to maintain. When angle is below value, score is reset
#$MaximumDriftAngle = 100; # Maximum angel to maintain. When angle is above value, score is reset

*/