<?php
/*
** @package		PHPInSim.
** @since		2009-03-10 23:50 EST.
** @author		Mark 'Dygear' Tomlin.
** @license		MIT License (http://opensource.org/licenses/mit-license.php).
** @copyright	Copyright (C) 2009, Mark 'Dygear' Tomlin.
** @version		0.3.1
*/

include_once('./config.php');
$InSim = new InSim($AdminPass, $Address, $Port, $PreFixChar);

class InSim {
	private $skIn;
	private $skOt;
	private $time;
	function __construct($AdminPass = '', $Address = '127.0.0.1', $Port = 29999, $PreFixChar = '!') {
		// Get Includes
		include_once('defines.php');
		require_once('packets.php');
		// Create Socket Connections;
		# Socket In;
		if ($this->skIn = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP)) {
			echo('Listen socket created!' . PHP_EOL);
			if (socket_bind($this->skIn, $Address, $Port + 1))
				echo('Binded to listen socket!' . PHP_EOL);
			else
				die('Could not bind to listen socket, address or port!' . PHP_EOL);
		}
		else
			die('Could not create listen socket!' . PHP_EOL);
		# Socket Out;
		if ($this->skOt = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP)) {
			echo('Send socket created!' . PHP_EOL);
			if (socket_connect($this->skOt, $Address, $Port))
				echo('Conneceted to send socket!' . PHP_EOL);
			else
				die('Could not connect to send socket, address or port!' . PHP_EOL);
		}
		else
			die('Could not create send socket!');
		// Create env;
		$this->packets = new packets();
		// Connect To InSim;
		$this->send(pack('CCCxSSxCSa16a16', 44, 1, 1, $Port + 1, 4 | 8, 36, 0, $AdminPass, 'phpInSim'));
		$this->main();
	}
	function send($packet) {
		return socket_write($this->skOt, $packet, strlen($packet));
	}
	function main() {
		while (TRUE) {
			// Keep Alive;
			if (time() > $this->time) {
				$this->send(pack('CCCC', 4, 3, 0, 0));
				$this->time = time() + 30;
			}
			// Get Packet;
			if ($data = $this->recv()) {
				print_r($this->packets->read($data));
			}
		}
	}
	function recv() {
		return socket_read($this->skIn, 256, PHP_BINARY_READ);
	}
	function __destruct() {
		$this->send(pack('CCCC', 4, 3, 0, 2));
	}
}

?>