﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Threading;

using Commands.Properties;

namespace Commands
{
    public partial class MainForm : Form
    {
        Socket socket;

        public MainForm()
        {
            InitializeComponent();
            hostTextBox.Text = Settings.Default.Host;
            portTextBox.Text = Settings.Default.Port.ToString();
            passTextBox.Text = Settings.Default.Pass;
            commandTextBox.Text = Settings.Default.Command;
            ActiveControl = connectButton;
        }

        byte[] CreateIsi()
        {
            byte[] isi = new byte[44];

            //byte	Size;		// 44
            isi[0] = 44;
            //byte	Type;		// ISP_ISI
            isi[1] = 1;
            //byte	ReqI;		// If non-zero LFS will send an IS_VER packet
            //byte	Zero;		// 0

            //word	UDPPort;	// Port for UDP replies from LFS (0 to 65535)
            //word	Flags;		// Bit flags for options (see below)

            //byte	Sp0;		// 0
            //byte	Prefix;		// Special host message prefix character
            //word	Interval;	// Time in ms between NLP or MCI (0 = none)

            //char	Admin[16];	// Admin password (if set in LFS)
            ASCIIEncoding.ASCII.GetBytes(passTextBox.Text, 0, passTextBox.Text.Length, isi, 12);
            //char	IName[16];	// A short name for your program
            ASCIIEncoding.ASCII.GetBytes("Commands", 0, "Commands".Length, isi, 28);

            return isi;
        }

        bool CheckConfig()
        {
            IPAddress ip;
            ushort port;
            return IPAddress.TryParse(hostTextBox.Text, out ip) && ushort.TryParse(portTextBox.Text, out port);
        }

        void connectButton_Click(object sender, EventArgs e)
        {
            if (socket == null || !socket.Connected)
            {
                if (!CheckConfig())
                {
                    MessageBox.Show("Invalid host or port.", "InSim Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }

                try
                {
                    socket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
                    socket.Connect(Settings.Default.Host, ushort.Parse(Settings.Default.Port));
                    socket.Send(CreateIsi());
                    ToggleButtons();
                    commandTextBox.Focus();
                }
                catch (SocketException)
                {
                    MessageBox.Show("LFS probably not running, or not listening on correct port.", "Insim Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        void disconnectButton_Click(object sender, EventArgs e)
        {
            if (socket != null)
            {
                socket.Close();
                ToggleButtons();
            }
        }

        byte[] CreateMst()
        {
            byte[] mst = new byte[68];

            //byte	Size;		// 68
            mst[0] = 68;
            //byte	Type;		// ISP_MST
            mst[1] = 13;
            //byte	ReqI;		// 0
            mst[2] = 0;
            //byte	Zero;
            mst[3] = 0;

            //char	Msg[64];	// last byte must be zero
            ASCIIEncoding.ASCII.GetBytes(commandTextBox.Text, 0, commandTextBox.Text.Length, mst, 4);

            return mst;
        }

        void sendButton_Click(object sender, EventArgs e)
        {
            if (socket != null)
            {
                socket.Send(CreateMst());
            }
        }

        void ToggleButtons()
        {
            connectButton.Enabled = !connectButton.Enabled;
            disconnectButton.Enabled = !disconnectButton.Enabled;
            sendButton.Enabled = !sendButton.Enabled;
            hostTextBox.Enabled = !hostTextBox.Enabled;
            portTextBox.Enabled = !portTextBox.Enabled;
            passTextBox.Enabled = !passTextBox.Enabled;
        }

        void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            Settings.Default.Host = hostTextBox.Text;
            Settings.Default.Port = portTextBox.Text;
            Settings.Default.Pass = passTextBox.Text;
            Settings.Default.Command = commandTextBox.Text;
            Settings.Default.Save();
        }
    }
}
