[ vertex shader ]

uniform vec4 light_pos;
uniform vec3 cam_pos;
varying vec3 light_coord, eye_coord;

//
varying vec4  v_diffuse, v_ambient;

void main()
{
 gl_Position = ftransform();

 gl_TexCoord[ 0 ] = gl_MultiTexCoord0;

 mat3 tbn = mat3( gl_MultiTexCoord2.xyz, gl_MultiTexCoord1.xyz, gl_Normal.xyz );

// light_coord = light_pos * tbn;

 if( light_pos.w == 0.0 )
  light_coord = light_pos.xyz * tbn;
 else
  light_coord = normalize( light_pos.xyz - gl_Vertex.xyz ) * tbn;


 eye_coord   = ( cam_pos - gl_Vertex.xyz ) * tbn;

// material
 v_diffuse = gl_FrontMaterial.diffuse * gl_LightSource[ 0 ].diffuse;
 v_ambient = gl_FrontMaterial.ambient * ( gl_LightSource[ 0 ].ambient + gl_LightModel.ambient );
// 



#if defined(DRAW_SHADOWED)
 calc_shadow_coord( gl_ModelViewMatrix * gl_Vertex )
#endif 
}

[ fragment shader ]

#define SHADOW_DIFFUSE 0.2
#define ANTI_LIGHT_DIFFUSE 0.2


varying vec3 light_coord, eye_coord;

uniform sampler2D base_tex;
uniform sampler2D bump_tex;
uniform sampler2D glos_tex;

varying vec4  v_diffuse, v_ambient;

const vec3 m_one = vec3( -1.0, -1.0, -1.0 );
const vec3 two   = vec3( 2.0,  2.0,  2.0 );


void main()
{
 vec3  viewV = normalize( eye_coord );

 vec2 plx = vec2(2,-1) * 0.03; // 
	vec2 plx_coord = gl_TexCoord[ 0 ].xy;

//viewV.y = 0.0;

 float height; 
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.25 * ( height * plx.x + plx.y ) * viewV.yx; 
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.25 * ( height * plx.x + plx.y ) * viewV.yx;
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.25 * ( height * plx.x + plx.y ) * viewV.yx;
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.25 * ( height * plx.x + plx.y ) * viewV.yx;

/* height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.125 * ( height * plx.x + plx.y ) * viewV.yx; 
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.125 * ( height * plx.x + plx.y ) * viewV.yx;
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.125 * ( height * plx.x + plx.y ) * viewV.yx;
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.125 * ( height * plx.x + plx.y ) * viewV.yx;
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.125 * ( height * plx.x + plx.y ) * viewV.yx; 
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.125 * ( height * plx.x + plx.y ) * viewV.yx;
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.125 * ( height * plx.x + plx.y ) * viewV.yx;
 height = texture2D( bump_tex, plx_coord ).a;
 plx_coord += 0.125 * ( height * plx.x + plx.y ) * viewV.yx; */

 vec3 base = texture2D( base_tex, plx_coord ).rgb;
// vec3 bump = texture2D( bump_tex, plx_coord ).rbg;

// vec3 bump = texture2D( bump_tex, plx_coord ).rgb; // volt

 vec3 bump = texture2D( bump_tex, plx_coord ).rgb;

 vec3 glos = texture2D( glos_tex, plx_coord ).rgb;
  
 bump  = normalize( bump * two + m_one );


//bump = vec3(0,0,1);
 vec3  lVect = normalize( light_coord );

// VOLT vec3  diffuse = ( v_diffuse * clamp( dot( lVect, bump ), 0.0, 1.0 ) ).xyz;
/////////////////////////////////////////
/////////////////////////////////////////
 float Bdot = max( -1.0, min( dot( lVect, bump ), 1.0 ) );
 
  vec3  diffuse = vec3(0,0,0);
  vec3  ambient = v_ambient;
  if( Bdot > 0.0 )
  {
   diffuse = ( v_diffuse * Bdot ).xyz;
   ambient += SHADOW_DIFFUSE * diffuse;
   diffuse *= ( 1.0 - SHADOW_DIFFUSE );
  }
  else
   ambient += ANTI_LIGHT_DIFFUSE * ( v_diffuse * -Bdot ).xyz;
/////////////////////////////////////////
/////////////////////////////////////////
 
 diffuse = max( diffuse, vec3( 0.0 ) );

// vec3  viewV = normalize( eye_coord );
 lVect = ( dot( lVect, bump ) * two * bump ) - lVect;
 
 vec3 specular = glos * ( gl_FrontMaterial.specular * gl_LightSource[ 0 ].specular * pow( clamp( dot( lVect, viewV ), 0.0, 1.0 ), gl_FrontMaterial.shininess ) ).xyz;

 specular = max( specular, vec3( 0.0 ) );

vec3 color     = ambient.xyz * base;
vec3 diff_spec = diffuse * base + specular;


//diff_spec = vec3(0,0,0);
//color = base * 0.2;

#if defined(DRAW_SHADOWED)
 add_shadow( color, diff_spec )
#else
 color += diff_spec;
#endif

// gl_FragColor.xyz = v_ambient.xyz * base + ( diffuse * base + specular );
 gl_FragColor.xyz = color;
 gl_FragColor.w = texture2D( base_tex, plx_coord ).a;
}
