﻿/*
 *  Copyright Alex McBride 2008.
 * 
 *  This file is part of LFSReplayParser.
 *
 *  LFSReplayParser is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  LFSReplayParser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with LFSReplayParser. If not, see <http://www.gnu.org/licenses/>.
 *  
 */

namespace LFSReplayParser.Replays
{
    /// <summary>
    /// The host weather types, depedent on track.
    /// </summary>
    public enum Weathers
    {
        /// <summary>
        /// Bright or clear weather.
        /// </summary>
        BrightClear = 0,

        /// <summary>
        /// Overcast weather.
        /// </summary>
        Overcast = 1,

        /// <summary>
        /// Cloudy, sunset or dusk weather.
        /// </summary>
        CloudySunsetDusk = 2
    }
}
