﻿/*
 *  Copyright Alex McBride 2008.
 * 
 *  This file is part of LFSReplayParser.
 *
 *  LFSReplayParser is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesse  General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  LFSReplayParser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with LFSReplayParser. If not, see <http://www.gnu.org/licenses/>.
 *  
 */

namespace LFSReplayParser.Replays
{
    /// <summary>
    /// The player results confirmation flags.
    /// </summary>
    [System.Flags]
    public enum ConfirmFlags
    {
        /// <summary>
        /// Player mentioned in race results.
        /// </summary>
        Mentioned = 1,

        /// <summary>
        /// Player confirmed in race results.
        /// </summary>
        Confirmed = 2,

        /// <summary>
        /// Player recieved a drive-through penalty (disqualified).
        /// </summary>
        DriveThrough = 4,

        /// <summary>
        /// Player recieved a stop and go penalty (disqualified).
        /// </summary>
        StopAndGo = 8,

        /// <summary>
        /// Player recieved a thirty second time penalty (time).
        /// </summary>
        ThirtySeconds = 16,

        /// <summary>
        /// Player recieved a forty-five second time penalty (time).
        /// </summary>
        FortyFiveSeconds = 32,

        /// <summary>
        /// Player did not pit on host with mandatory pit stop (disqualified).
        /// </summary>
        DidNotPit = 64,

        /// <summary>
        /// Player was disqualified.
        /// </summary>
        Disqualified = (DriveThrough | StopAndGo | DidNotPit),

        /// <summary>
        /// Player recieved time penalty.
        /// </summary>
        Time = (ThirtySeconds | FortyFiveSeconds)
    }
}
