﻿/*
 *  Copyright Alex McBride 2008.
 * 
 *  This file is part of LFSReplayParser.
 *
 *  LFSReplayParser is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  LFSReplayParser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with LFSReplayParser. If not, see <http://www.gnu.org/licenses/>.
 *  
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace LFSReplayParser.Extensions
{
    /// <summary>
    /// Extensions for the System.String class.
    /// </summary>
    internal static class StringExtensions
    {
        /// <summary>
        /// Replaces the formated string with the specified arguments.
        /// </summary>
        /// <param name="args">A System.Object to format.</param>
        public static string FormatWith(this string input, params object[] args)
        {
            return string.Format(input, args);
        }

        /// <summary>
        /// Indicates whether the string contains a null or empty value.
        /// </summary>
        public static bool IsNullOrEmpty(this string input)
        {
            return string.IsNullOrEmpty(input);
        }

        /// <summary>
        /// Remove colours codes from string.
        /// </summary>
        public static string StripColours(this string input)
        {
            return Regex.Replace(input, @"\^[0-9]", "");
        }
    }
}
