Attribute VB_Name = "LFS"
Option Explicit

'here are the constants, enums and types you and okInSimClient need for various events

'api to copy to/from byte arrays to user-defined types
Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)

'// ISS state flags
'state flags in the STAte packet and some in CamPosPack (lngStateFlags)
Public Const ISS_GAME = 1               '// in game (or MPR)
Public Const ISS_REPLAY = 2             '// in SPR
Public Const ISS_PAUSED = 4             '// paused
Public Const ISS_SHIFTU = 8             '// in SHIFT+U mode
Public Const ISS_SHIFTU_HIGH = 16       '// HIGH view
Public Const ISS_SHIFTU_FOLLOW = 32     '// following car
Public Const ISS_SHIFTU_NO_OPT = 64     '// buttons are hidden
Public Const ISS_SHOW_2D = 128          '// showing 2d display
Public Const ISS_FRONT_END = 256        '// in front end screen
Public Const ISS_MULTI = 512            '// multiplayer mode
Public Const ISS_MPSPEEDUP = 1024       '// multiplayer speedup option
Public Const ISS_WINDOWED = 2048        '// lfs is running in a window
Public Const ISS_SOUND_MUTE = 4096      '// sound is switched off
Public Const ISS_VIEW_OVERRIDE = 8192   '// override user view

'Pit work flags (curPitWorkFlags)
Public Const PSE_NOTHING = 1
Public Const PSE_STOP = 2
Public Const PSE_FR_DAM = 4
Public Const PSE_FR_WHL = 8
Public Const PSE_LE_FR_DAM = 16
Public Const PSE_LE_FR_WHL = 32
Public Const PSE_RI_FR_DAM = 64
Public Const PSE_RI_FR_WHL = 128
Public Const PSE_RE_DAM = 256
Public Const PSE_RE_WHL = 512
Public Const PSE_LE_RE_DAM = 1024
Public Const PSE_LE_RE_WHL = 2048
Public Const PSE_RI_RE_DAM = 4096
Public Const PSE_RI_RE_WHL = 8192
Public Const PSE_BODY_MINOR = 16384
Public Const PSE_BODY_MAJOR = 32768
Public Const PSE_SETUP = 65536
Public Const PSE_REFUEL = 131072

'player flags in the NewPLayer packet (lngPlayerFlags)
Public Const PIF_SWAPSIDE = 1
Public Const PIF_GC_CUT = 2
Public Const PIF_GC_BLIP = 4
Public Const PIF_AUTOGEARS = 8
Public Const PIF_SHIFTER = 16
Public Const PIF_RESERVED = 32
Public Const PIF_HELP_B = 64
Public Const PIF_AXIS_CLUTCH = 128
Public Const PIF_INPITS = 256
Public Const PIF_AUTOCLUTCH = 512
Public Const PIF_MOUSE = 1024
Public Const PIF_KB_NO_HELP = 2048
Public Const PIF_KB_STABILISED = 4096
Public Const PIF_CUSTOM_VIEW = 8192

'confirmation flags in the RESult/FINish packet (lngConfirmFlags)
Public Const MENTIONED = 1
Public Const CONFIRMED = 2
Public Const PENALTY_DT = 4
Public Const PENALTY_SG = 8
Public Const PENALTY_30 = 16
Public Const PENALTY_45 = 32
Public Const DID_NOT_PIT = 64
Public Const CONF_MENTIONED = 1
Public Const CONF_CONFIRMED = 2
Public Const CONF_PENALTY_DT = 4
Public Const CONF_PENALTY_SG = 8
Public Const CONF_PENALTY_30 = 16
Public Const CONF_PENALTY_45 = 32
Public Const CONF_DID_NOT_PIT = 64

Public Const CONF_DISQ = CONF_PENALTY_DT + CONF_PENALTY_SG + CONF_DID_NOT_PIT
Public Const CONF_TIME = CONF_PENALTY_30 + CONF_PENALTY_45

'Race Flags (lngRaceFlags)
Public Const HOSTF_CAN_VOTE = 1
Public Const HOSTF_CAN_SELECT = 2
Public Const HOSTF_MID_RACE = 32
Public Const HOSTF_MUST_PIT = 64
Public Const HOSTF_CAN_RESET = 128

'// Passengers byte
Public Const PASS_FRONT_FEMALE = 1
Public Const PASS_FRONT = 2
Public Const PASS_REARLEFT_FEMALE = 4
Public Const PASS_REARLEFT = 8
Public Const PASS_REARMID_FEMALE = 16
Public Const PASS_REARMID = 32
Public Const PASS_REARRIGHT_FEMALE = 64
Public Const PASS_REARRIGHT = 128

'race progress
Public Enum RaceProgress
    PROGRESS_NOT_RACING = 0
    PROGRESS_RACING = 1
    PROGRESS_QUALIFYING = 2
End Enum

'possible winds in state packet
Public Enum Winds
    WIND_NONE = 0
    WIND_LOW = 1
    WIND_HIGH = 2
End Enum

'states/options you can set in SetState, ISP_SFP packet
'(renamed from ISS_ to avoid VB6 naming conflict)
Public Enum SettableStates
    SST_SHIFTU_FOLLOW = 32      'following car
    SST_SHIFTU_NO_OPT = 64      'buttons are hidden
    SST_SHOW_2D = 128           'showing 2d display
    SST_MPSPEEDUP = 1024        'multiplayer speedup option
    SST_SOUND_MUTE = 4096       'sound is mute
End Enum

'modifiers for the SingleCHar packet/SendChar sub
Public Enum CtrlShift
    SCH_NONE = 0
    SCH_SHIFT = 1
    SCH_CTRL = 2
    SCH_CTRL_SHIFT = 3
End Enum

'vote action during VoteNotify and VoteAction
Public Enum VoteActions
    VOTE_NONE = 0       '// 0 - no vote
    VOTE_END = 1        '// 1 - end race
    VOTE_RESTART = 2    '// 2 - restart
    VOTE_QUALIFY = 3    '// 3 - qualify
    VOTE_NUM = 4
End Enum

'// View identifiers
'in game camera for STAte packet/SetCamera sub
Public Enum CameraViews
    VIEW_FOLLOW = 0     '// 0 - arcade
    VIEW_HELI = 1       '// 1 - helicopter
    VIEW_CAM = 2        '// 2 - tv camera
    VIEW_DRIVER = 3     '// 3 - cockpit
    VIEW_CUSTOM = 4     '// 4 - custom
    VIEW_MAX = 5
    VIEW_ANOTHER = 255  '// viewing another car
End Enum

Public Enum TyreCompounds
    TYRE_R1 = 0
    TYRE_R2 = 1
    TYRE_R3 = 2
    TYRE_R4 = 3
    TYRE_ROAD_SUPER = 4
    TYRE_ROAD_NORMAL = 5
    TYRE_HYBRID = 6
    TYRE_KNOBBLY = 7
    TYRE_NUM = 8
    NOT_CHANGED = 255
End Enum

'Pit lane facts
Public Enum PitLaneFacts
    PITLANE_EXIT = 0            'left pit lane
    PITLANE_ENTER = 1           'entered pit lane
    PITLANE_NO_PURPOSE = 2      'entered for no purpose
    PITLANE_DT = 3              'entered for drive-through
    PITLANE_SG = 4              'entered for stop-go
End Enum

'Penalty values (VALID means the penalty can now be cleared) (renamed to avoid naming conflict)
Public Enum PenaltyValue
    PEN_PENALTY_NONE = 0
    PEN_PENALTY_DT = 1
    PEN_PENALTY_DT_VALID = 2
    PEN_PENALTY_SG = 3
    PEN_PENALTY_SG_VALID = 4
    PEN_PENALTY_30 = 5
    PEN_PENALTY_45 = 6
    PEN_PENALTY_NUM = 7
End Enum

'// Penalty reasons
Public Enum PenaltyReason
    PENR_UNKNOWN = 0        '// 0 - unknown or cleared penalty
    PENR_ADMIN = 1          '// 1 - penalty given by admin
    PENR_WRONG_WAY = 2      '// 2 - wrong way driving
    PENR_FALSE_START = 3    '// 3 - starting before green light
    PENR_SPEEDING = 4       '// 4 - speeding in pit lane
    PENR_STOP_SHORT = 5     '// 5 - stop-go pit stop too short
    PENR_STOP_LATE = 6      '// 6 - compulsory stop is too late
    PENR_NUM = 7
End Enum

Public Enum RaceFlags
    FLG_BLUE = 1
    FLG_YELLOW = 2
    FLG_BOTH = 3
End Enum

'node and lap type during NLP packet/GetNLPInfo function
Public Type NodeLap
    lngNode As Long
    lngLap As Long
    bytPLID As Byte
End Type

'car info type during MCI packet/GetMCIInfo function
Public Type CompCar
    lngNode As Long
    lngLap As Long
    bytPLID As Byte
    lngX As Long
    lngY As Long
    lngZ As Long
    lngSpeed As Long
    lngDirection As Long
    lngHeading As Long
    intAngVel As Integer
End Type

'OutSim type
Public Type OutSimPacket
    bytTime(0 To 3) As Byte         'time in milliseconds (to check order)
    sngAVelocity0 As Single         'Angular Velocity, 3 floats
    sngAVelocity1 As Single
    sngAVelocity2 As Single
    sngHeading As Single            'Orientation, 3 floats, Heading, Pitch, Roll
    sngPitch As Single
    sngRoll As Single
    sngAccelerationX As Single      'Acceleration, 3 floats, X, Y, Z
    sngAccelerationY As Single
    sngAccelerationZ As Single
    sngVelocityX As Single          'Velocity, 3 floats X, Y, Z
    sngVelocityY As Single
    sngVelocityZ As Single
    lngPositionX As Long            'Position, 3 ints X, Y, Z (metres x 65536)
    lngPositionY As Long
    lngPositionZ As Long
    lngID As Long                   '(optional ID - if specified in cfg.txt)
End Type

'OutGauge type
Public Type OutGaugePacket
    bytTime(0 To 3) As Byte         'time in milliseconds (to check order)
    bytCar(0 To 3) As Byte          'Car name
    bytFlags(0 To 1) As Byte        'Combination of OG_FLAGS
    bytGear As Byte                 'Reverse:0, Neutral:1, First:2...
    bytSpareB As Byte               'SpareB
    sngSpeed As Single              'M/S
    sngRPM As Single                'RPM
    sngTurbo As Single              'BAR
    sngEngTemp As Single            'C
    sngFuel As Single               '0 to 1
    sngOilPress As Single           'BAR
    sngSpare1 As Single             'Spare1
    sngSpare2 As Single             'Spare2
    sngSpare3 As Single             'Spare3
    sngThrottle As Single           '0 to 1
    sngBrake As Single              '0 to 1
    sngClutch As Single             '0 to 1
    bytDisplay1(0 To 15) As Byte    'Usually Fuel
    bytDisplay2(0 To 15) As Byte    'Usually Settings
    lngID As Long                   '(optional ID - if specified in cfg.txt)
End Type
