VERSION 5.00
Begin VB.UserControl okSocket 
   AutoRedraw      =   -1  'True
   CanGetFocus     =   0   'False
   ClientHeight    =   240
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   240
   ClipBehavior    =   0  'None
   HitBehavior     =   0  'None
   InvisibleAtRuntime=   -1  'True
   Picture         =   "okSocket.ctx":0000
   ScaleHeight     =   16
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   16
   ToolboxBitmap   =   "okSocket.ctx":0087
End
Attribute VB_Name = "okSocket"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'okSocket - a Windows Socket 2 implementation by Kris Kolody (RayOK)
'
' some socket info and code from winsockvb.com (http://web.archive.org/web/*/http://www.winsockvb.com),
' CSocketMaster/Plus (planetsourcecode.com) and MSDN (http://msdn2.microsoft.com/en-us/library/ms740673.aspx)
' uses customized subclassing code from Paul Caton's self-subclassing class
'  (http://www.planet-source-code.com/vb/scripts/ShowCode.asp?txtCodeId=54117&lngWId=1)

'==================================================================================================
' ucSubclass - A template UserControl for control authors that require self-subclassing without ANY
'              external dependencies. IDE safe.
'
' Paul_Caton@hotmail.com
' Copyright free, use and abuse as you see fit.
'
' v1.0.0000 20040525 First cut.....................................................................
' v1.1.0000 20040602 Multi-subclassing version.....................................................
' v1.1.0001 20040604 Optimized the subclass code...................................................
' v1.1.0002 20040607 Substituted byte arrays for strings for the code buffers......................
' v1.1.0003 20040618 Re-patch when adding extra hWnds..............................................
' v1.1.0004 20040619 Optimized to death version....................................................
' v1.1.0005 20040620 Use allocated memory for code buffers, no need to re-patch....................
' v1.1.0006 20040628 Better protection in zIdx, improved comments..................................
' v1.1.0007 20040629 Fixed InIDE patching oops.....................................................
' v1.1.0008 20040910 Fixed bug in UserControl_Terminate, zSubclass_Proc procedure hidden...........

'==================================================================================================
'Subclasser declarations

Private Enum eMsgWhen
  MSG_AFTER = 1                                                                         'Message calls back after the original (previous) WndProc
  MSG_BEFORE = 2                                                                        'Message calls back before the original (previous) WndProc
  MSG_BEFORE_AND_AFTER = MSG_AFTER Or MSG_BEFORE                                        'Message calls back before and after the original (previous) WndProc
End Enum

Private Const ALL_MESSAGES           As Long = -1                                       'All messages added or deleted
Private Const GMEM_FIXED             As Long = 0                                        'Fixed memory GlobalAlloc flag
Private Const GWL_WNDPROC            As Long = -4                                       'Get/SetWindow offset to the WndProc procedure address
Private Const PATCH_04               As Long = 88                                       'Table B (before) address patch offset
Private Const PATCH_05               As Long = 93                                       'Table B (before) entry count patch offset
Private Const PATCH_08               As Long = 132                                      'Table A (after) address patch offset
Private Const PATCH_09               As Long = 137                                      'Table A (after) entry count patch offset

Private Type tSubData                                                                   'Subclass data type
  hWnd                               As Long                                            'Handle of the window being subclassed
  nAddrSub                           As Long                                            'The address of our new WndProc (allocated memory).
  nAddrOrig                          As Long                                            'The address of the pre-existing WndProc
  nMsgCntA                           As Long                                            'Msg after table entry count
  nMsgCntB                           As Long                                            'Msg before table entry count
  aMsgTblA()                         As Long                                            'Msg after table array
  aMsgTblB()                         As Long                                            'Msg Before table array
End Type

Private sc_aSubData()                As tSubData                                        'Subclass data array

Private Declare Sub RtlMoveMemory Lib "kernel32" (Destination As Any, Source As Any, ByVal Length As Long)
Private Declare Function GetModuleHandleA Lib "kernel32" (ByVal lpModuleName As String) As Long
Private Declare Function GetProcAddress Lib "kernel32" (ByVal hModule As Long, ByVal lpProcName As String) As Long
Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Private Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function SetWindowLongA Lib "user32" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
'==================================================================================================


' Winsock version, who needs 1.1?
Private Const WINSOCK_V2_2  As Long = &H202

' Length of fields within the WSADATA structure.
Private Const WSADESCRIPTION_LEN  As Long = 256
Private Const WSASYS_STATUS_LEN   As Long = 128

' To initialize Winsock.
Private Type WSADATA
   wVersion                               As Integer
   wHighVersion                           As Integer
   szDescription(WSADESCRIPTION_LEN + 1)  As Byte
   szSystemstatus(WSASYS_STATUS_LEN + 1)  As Byte
   iMaxSockets                            As Integer
   iMaxUpdDg                              As Integer
   lpVendorInfo                           As Long
End Type

Private Const SOCKET_ERROR        As Long = -1

' Internet addresses.
Private Const INADDR_ANY          As Long = &H0
Private Const INADDR_NONE         As Long = &HFFFFFFFF

' Maximum backlog when calling listen().
Private Const SOMAXCONN As Long = 5

' Messages send with WSAAsyncSelect().
Private Const FD_READ       As Long = &H1
Private Const FD_WRITE      As Long = &H2
Private Const FD_ACCEPT     As Long = &H8
Private Const FD_CONNECT    As Long = &H10
Private Const FD_CLOSE      As Long = &H20

' GetWinsockError constants.
Private Const WSABASEERR          As Long = 10000
Private Const WSAEINTR            As Long = WSABASEERR + 4
Private Const WSAEACCES           As Long = WSABASEERR + 13
Private Const WSAEFAULT           As Long = WSABASEERR + 14
Private Const WSAEINVAL           As Long = WSABASEERR + 22
Private Const WSAEMFILE           As Long = WSABASEERR + 24
Private Const WSAEWOULDBLOCK      As Long = WSABASEERR + 35
Private Const WSAEINPROGRESS      As Long = WSABASEERR + 36
Private Const WSAEALREADY         As Long = WSABASEERR + 37
Private Const WSAENOTSOCK         As Long = WSABASEERR + 38
Private Const WSAEDESTADDRREQ     As Long = WSABASEERR + 39
Private Const WSAEMSGSIZE         As Long = WSABASEERR + 40
Private Const WSAEPROTOTYPE       As Long = WSABASEERR + 41
Private Const WSAENOPROTOOPT      As Long = WSABASEERR + 42
Private Const WSAEPROTONOSUPPORT  As Long = WSABASEERR + 43
Private Const WSAESOCKTNOSUPPORT  As Long = WSABASEERR + 44
Private Const WSAEOPNOTSUPP       As Long = WSABASEERR + 45
Private Const WSAEPFNOSUPPORT     As Long = WSABASEERR + 46
Private Const WSAEAFNOSUPPORT     As Long = WSABASEERR + 47
Private Const WSAEADDRINUSE       As Long = WSABASEERR + 48
Private Const WSAEADDRNOTAVAIL    As Long = WSABASEERR + 49
Private Const WSAENETDOWN         As Long = WSABASEERR + 50
Private Const WSAENETUNREACH      As Long = WSABASEERR + 51
Private Const WSAENETRESET        As Long = WSABASEERR + 52
Private Const WSAECONNABORTED     As Long = WSABASEERR + 53
Private Const WSAECONNRESET       As Long = WSABASEERR + 54
Private Const WSAENOBUFS          As Long = WSABASEERR + 55
Private Const WSAEISCONN          As Long = WSABASEERR + 56
Private Const WSAENOTCONN         As Long = WSABASEERR + 57
Private Const WSAESHUTDOWN        As Long = WSABASEERR + 58
Private Const WSAETOOMANYREFS     As Long = WSABASEERR + 59
Private Const WSAETIMEDOUT        As Long = WSABASEERR + 60
Private Const WSAECONNREFUSED     As Long = WSABASEERR + 61
Private Const WSAENAMETOOLONG     As Long = WSABASEERR + 63
Private Const WSAEHOSTDOWN        As Long = WSABASEERR + 64
Private Const WSAEHOSTUNREACH     As Long = WSABASEERR + 65
Private Const WSAENOTEMPTY        As Long = WSABASEERR + 66
Private Const WSAEPROCLIM         As Long = WSABASEERR + 67
Private Const WSASYSNOTREADY      As Long = WSABASEERR + 91
Private Const WSAVERNOTSUPPORTED  As Long = WSABASEERR + 92
Private Const WSANOTINITIALISED   As Long = WSABASEERR + 93
Private Const WSAEDISCON          As Long = WSABASEERR + 101
Private Const WSATYPE_NOT_FOUND   As Long = WSABASEERR + 109
Private Const WSAHOST_NOT_FOUND   As Long = WSABASEERR + 1001
Private Const WSATRY_AGAIN        As Long = WSABASEERR + 1002
Private Const WSANO_RECOVERY      As Long = WSABASEERR + 1003
Private Const WSANO_DATA          As Long = WSABASEERR + 1004

' Basic IPv4 addressing structures.
Private Type in_addr
   s_addr   As Long
End Type

Private Type sockaddr_in
   sin_family        As Integer
   sin_port          As Integer
   sin_addr          As in_addr
   sin_zero(0 To 7)  As Byte
End Type

' Used with name resolution functions.
Private Type hostent
   h_name         As Long
   h_aliases      As Long
   h_addrtype     As Integer
   h_length       As Integer
   h_addr_list    As Long
End Type

' Used with socket().
Private Enum SocketTypes
   SOCK_STREAM = 1
   SOCK_DGRAM = 2
End Enum

' Used with socket().
Public Enum Protocols
   IPPROTO_TCP = 6
   IPPROTO_UDP = 17
End Enum

' Used with socket().
Private Enum AddressFamilies
   AF_INET = 2
End Enum

' DLL handling functions.
Private Declare Function WSAStartup Lib "ws2_32.dll" (ByVal wVersionRequested As Integer, ByRef lpWSAData As WSADATA) As Long
Private Declare Function WSACleanup Lib "ws2_32.dll" () As Long
Private Declare Function WSAGetLastError Lib "ws2_32.dll" () As Long

' Resolution functions.
Private Declare Function gethostbyname Lib "ws2_32.dll" (ByVal host_name As String) As Long
Private Declare Function gethostbyaddr Lib "ws2_32.dll" (haddr As Long, ByVal hnlen As Long, ByVal addrtype As Long) As Long

' Conversion functions.
Private Declare Function inet_addr Lib "ws2_32.dll" (ByVal cp As String) As Long
Private Declare Function inet_ntoa Lib "ws2_32.dll" (ByVal laddr As Long) As Long
Private Declare Function htons Lib "ws2_32.dll" (ByVal hostshort As Long) As Integer

' Socket functions.
Private Declare Function ws2_socket Lib "ws2_32.dll" Alias "socket" (ByVal af As AddressFamilies, ByVal stype As SocketTypes, ByVal lngProtocol As Long) As Long
Private Declare Function ws2_bind Lib "ws2_32.dll" Alias "bind" (ByVal s As Long, ByRef Name As sockaddr_in, ByVal namelen As Long) As Long
Private Declare Function ws2_listen Lib "ws2_32.dll" Alias "listen" (ByVal s As Long, ByVal backlog As Long) As Long
Private Declare Function ws2_accept Lib "ws2_32.dll" Alias "accept" (ByVal s As Long, ByRef addr As sockaddr_in, ByRef addrlen As Long) As Long
Private Declare Function ws2_connect Lib "ws2_32.dll" Alias "connect" (ByVal s As Long, ByRef Name As sockaddr_in, ByVal namelen As Long) As Long
Private Declare Function ws2_sendto Lib "ws2_32.dll" Alias "sendto" (ByVal s As Long, ByRef buf As Byte, ByVal datalen As Long, ByVal Flags As Long, ByRef toaddr As sockaddr_in, ByVal tolen As Long) As Long
Private Declare Function ws2_recv Lib "ws2_32.dll" Alias "recv" (ByVal s As Long, ByRef buf As Byte, ByVal datalen As Long, ByVal Flags As Long) As Long
Private Declare Function ws2_closesocket Lib "ws2_32.dll" Alias "closesocket" (ByVal s As Long) As Long

' I/O model functions.
Private Declare Function WSAAsyncSelect Lib "ws2_32.dll" (ByVal s As Long, ByVal hWnd As Long, ByVal wMsg As Long, ByVal lEvent As Long) As Long

' Other general Win32 APIs.
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (pDst As Any, pSrc As Any, ByVal ByteLen As Long)
Private Declare Function RegisterWindowMessage Lib "user32" Alias "RegisterWindowMessageA" (ByVal lpString As String) As Long


Private Type Connection
    sSocket As Long
    SocketAddress As sockaddr_in
    RecvRaised As Boolean
End Type
Private ConnList() As Connection

Private m_lngSocketMsg As Long
Private m_blnInitilized As Boolean

Public Event Connected(ByVal lngSocket As Long)
Public Event Accepted(ByVal lngSocket As Long, ByVal strAddr As String, ByVal intPort As Integer)
Public Event Received(ByVal lngSocket As Long, Data() As Byte, ByVal lngLength As Long)
Public Event DataSent(ByVal lngSocket As Long, ByVal lngTotal As Long)
Public Event ReadyToSend(ByVal lngSocket As Long)
Public Event Closed(ByVal lngSocket As Long)
Public Event Error(ByVal lngSocket As Long, ByVal strMsg As String)


'Subclass handler - MUST be the first Public routine in this file. That includes public properties also
Public Sub zSubclass_Proc(ByVal bBefore As Boolean, ByRef bHandled As Boolean, ByRef lReturn As Long, ByRef lng_hWnd As Long, ByRef uMsg As Long, ByRef wParam As Long, ByRef lParam As Long)
Attribute zSubclass_Proc.VB_MemberFlags = "40"
'Parameters:
  'bBefore  - Indicates whether the the message is being processed before or after the default handler - only really needed if a message is set to callback both before & after.
  'bHandled - Set this variable to True in a 'before' callback to prevent the message being subsequently processed by the default handler... and if set, an 'after' callback
  'lReturn  - Set this variable as per your intentions and requirements, see the MSDN documentation for each individual message value.
  'hWnd     - The window handle
  'uMsg     - The message number
  'wParam   - Message related data
  'lParam   - Message related data
'Notes:
  'If you really know what you're doing, it's possible to change the values of the
  'hWnd, uMsg, wParam and lParam parameters in a 'before' callback so that different
  'values get passed to the default handler.. and optionaly, the 'after' callback
  
    If uMsg = m_lngSocketMsg Then
        Select Case LoWord(lParam)
            Case FD_READ
                Call Recv(wParam)
            Case FD_WRITE
                RaiseEvent ReadyToSend(wParam)
            Case FD_ACCEPT
                Call SocketAccept(wParam)
            Case FD_CONNECT
                RaiseEvent Connected(wParam)
            Case FD_CLOSE
                Call CloseSocket(wParam)
        End Select
    End If
End Sub


Public Function Initilize() As Boolean
    Dim udtWinsockData As WSADATA
    
    Call WSACleanup
    
    If Not m_blnInitilized Then
        If WSAStartup(WINSOCK_V2_2, udtWinsockData) <> SOCKET_ERROR Then
            Randomize
            m_lngSocketMsg = RegisterWindowMessage("okSocket" & Rnd * 10000 & hWnd)
            m_blnInitilized = True
            
            ReDim ConnList(0)
        
            'subclass the window to get socket messages
            Call Subclass_Start(UserControl.hWnd)
            Call Subclass_AddMsg(UserControl.hWnd, m_lngSocketMsg, MSG_BEFORE)
        End If
    End If
    
    Initilize = m_blnInitilized
End Function

'The control is terminating - a good place to stop the subclasser
Private Sub UserControl_Terminate()
  On Error GoTo Catch
  
  Call Terminate
  
  'Stop all subclassing
  If m_blnInitilized Then Call Subclass_StopAll
Catch:
End Sub

Public Sub Terminate()
    Dim i As Long
  
    On Error Resume Next
    
    If m_blnInitilized Then 'close all sockets
        m_lngSocketMsg = 0
        m_blnInitilized = False
        
        For i = 1 To UBound(ConnList)
            Call CloseSocket(ConnList(i).sSocket)
        Next i
        
        ReDim ConnList(0)
                        Erase ConnList()
        
        Call WSACleanup
    End If
End Sub


'you can connect or listen
Public Function Connect(ByVal Protocol As Protocols, ByVal Port As Long, ByVal Host As String) As Long
    Dim lngSocket As Long, lngInetAddr As Long, udtAddress As sockaddr_in
    
    lngSocket = ws2_socket(AF_INET, IIf(Protocol = IPPROTO_TCP, SOCK_STREAM, SOCK_DGRAM), Protocol)
    
    If SocketSelect(lngSocket, FD_READ Or FD_WRITE Or FD_CONNECT Or FD_CLOSE) Then
        lngInetAddr = inet_addr(vbIPFromHostName(Host))
        If lngInetAddr = INADDR_NONE Then
            Call CloseSocket(lngSocket)
            RaiseEvent Error(lngSocket, "connect error: server not found")
        Else
            With udtAddress
                .sin_family = AF_INET
                .sin_addr.s_addr = lngInetAddr
                .sin_port = htons(Port)
            End With
            Call ConnAdd(lngSocket, udtAddress)
            
            Call ws2_connect(lngSocket, udtAddress, LenB(udtAddress))
            
            Connect = lngSocket
        End If
    End If
End Function

Public Function Listen(ByVal Protocol As Protocols, ByVal Port As Long, Optional ByVal IP As String = INADDR_ANY) As Long
    Dim lngSocket As Long, udtAddress As sockaddr_in
    
    lngSocket = ws2_socket(AF_INET, IIf(Protocol = IPPROTO_TCP, SOCK_STREAM, SOCK_DGRAM), Protocol)
    
    If SocketSelect(lngSocket, FD_READ Or FD_WRITE Or FD_ACCEPT Or FD_CLOSE) Then
        With udtAddress
            .sin_family = AF_INET
            .sin_addr.s_addr = inet_addr(IP)
            .sin_port = htons(Port)
        End With
        Call ConnAdd(lngSocket, udtAddress)
        
        If ws2_bind(lngSocket, udtAddress, LenB(udtAddress)) = 0 Then
            Call ws2_listen(lngSocket, SOMAXCONN)
            
            Listen = lngSocket
        Else
            'could not bind
            Call CloseSocket(lngSocket)
        End If
    End If
End Function

'while listening, called when someone is trying to connect
Private Sub SocketAccept(ByVal lngSocket As Long)
    Dim lngAcceptSocket As Long, udtAddress As sockaddr_in
    
    lngAcceptSocket = ws2_accept(lngSocket, udtAddress, LenB(udtAddress))
    If SocketSelect(lngAcceptSocket, FD_READ Or FD_WRITE Or FD_CLOSE) Then
        Call ConnAdd(lngAcceptSocket, udtAddress)
        
        RaiseEvent Accepted(lngAcceptSocket, vbInetNtoa(udtAddress.sin_addr.s_addr), udtAddress.sin_port)
    End If
End Sub

'used by connect, listen and accept to get messages from the given socket
Private Function SocketSelect(ByVal lngSocket As Long, ByVal Events As Long) As Boolean
    If lngSocket = SOCKET_ERROR Then
        RaiseEvent Error(lngSocket, "create socket error: " & GetWinsockError(WSAGetLastError))
    Else
        If WSAAsyncSelect(lngSocket, UserControl.hWnd, m_lngSocketMsg, Events) <> SOCKET_ERROR Then
            SocketSelect = True
        Else
            RaiseEvent Error(lngSocket, "wsaasyncselect error: " & GetWinsockError(WSAGetLastError))
            Call CloseSocket(lngSocket)
        End If
    End If
End Function

Private Sub Recv(ByVal lngSocket As Long)
    Dim intConn As Integer, bytRecvBuffer() As Byte, lngRecv As Long, lngError As Long
    Const BUFFER_SIZE As Long = 4096
    
    On Error GoTo RecvErr
    
    intConn = ConnFind(lngSocket)
    
    'receive all data into a buffer
    Do
        Erase bytRecvBuffer
        ReDim bytRecvBuffer(BUFFER_SIZE - 1)
        
        lngRecv = ws2_recv(lngSocket, bytRecvBuffer(0), BUFFER_SIZE, 0&)
        If lngRecv = SOCKET_ERROR Then
            lngError = WSAGetLastError
            If lngError <> WSAEWOULDBLOCK And lngError <> 0 Then
                RaiseEvent Error(lngSocket, "receive error: " & GetWinsockError(lngError))
                'Call CloseSocket(lngSocket)
            End If
        Else
            'raise if connection found
            If intConn > 0 Then
                'Debug.Print "|" & CStr(lngSocket) & "|recv: " & CStr(lngRecv) & " bytes"
                If lngRecv = 0 Then
                    If Not ConnList(intConn).RecvRaised Then
                        ConnList(intConn).RecvRaised = True
                        ReDim bytRecvBuffer(0)
                        RaiseEvent Received(lngSocket, bytRecvBuffer, lngRecv)
                    End If
                Else
                    If lngRecv < BUFFER_SIZE Then ReDim Preserve bytRecvBuffer(0 To lngRecv - 1)
                    RaiseEvent Received(lngSocket, bytRecvBuffer, lngRecv)
                End If
            Else
                Debug.Print "|" & CStr(lngSocket) & "|recv: connection not found"
            End If
        End If
    Loop Until lngRecv <= 0
    
    Exit Sub
RecvErr:
    Debug.Print Err.Number & ": " & Err.Description
    Call CloseSocket(lngSocket)
End Sub

Public Sub Send(ByVal lngSocket As Long, Data() As Byte, ByVal lngStart As Long)
    Dim intConn As Integer, lngSend As Long, bytSendBuffer() As Byte, lngSize As Long, lngError As Long
    
    'On Error GoTo SendErr
    
    intConn = ConnFind(lngSocket)
    If intConn = 0 Then
        'not found, error then close
        Debug.Print "|" & CStr(lngSocket) & "|send: connection not found"
        Call CloseSocket(lngSocket)
    Else
        'copy from data into buffer
        Do
            lngSize = (UBound(Data) + 1) - lngStart
            If lngSize > 8192 Then lngSize = 8192
        
            If lngSize <= 0 Then
                'Debug.Print "|" & CStr(lngSocket) & "|send: no more bytes to send"
                lngSend = 0
            Else
                Erase bytSendBuffer
                ReDim bytSendBuffer(lngSize - 1)
                Call CopyMemory(bytSendBuffer(0), Data(lngStart), lngSize)
            
                lngSend = ws2_sendto(lngSocket, bytSendBuffer(0), lngSize, 0, ConnList(intConn).SocketAddress, LenB(ConnList(intConn).SocketAddress))
                If lngSend = SOCKET_ERROR Then
                    'error, if not blocking close socket
                    lngError = WSAGetLastError
                    If lngError = WSAEWOULDBLOCK Then
                        RaiseEvent DataSent(lngSocket, -1)      'raise with -1
                    Else
                        RaiseEvent Error(lngSocket, "send error: " & GetWinsockError(lngError))
                        Call CloseSocket(lngSocket)
                    End If
                Else
                    'Debug.Print "|" & CStr(lngSocket) & "|send: " & CStr(lngSend) & " bytes"
                    lngStart = lngStart + lngSend
                    RaiseEvent DataSent(lngSocket, lngStart)
                End If
            End If
        Loop Until lngSend <= 0
    End If
    
    Exit Sub
SendErr:
    Debug.Print Err.Number & ": " & Err.Description
    Call CloseSocket(lngSocket)
End Sub

Public Sub CloseSocket(ByVal lngSocket As Long)
    Call ws2_closesocket(lngSocket)
    Call ConnRemove(ConnFind(lngSocket))
    
    RaiseEvent Closed(lngSocket)
End Sub


'- Connections List Code
'
Private Function ConnAdd(ByVal lngSocket As Long, Address As sockaddr_in) As Integer
On Error GoTo ConnAddErr
    Dim intNew As Integer
    
    intNew = UBound(ConnList) + 1
    
    ReDim Preserve ConnList(0 To intNew)
    ConnList(intNew).sSocket = lngSocket
    ConnList(intNew).SocketAddress = Address
    
    ConnAdd = intNew
    
    Exit Function
ConnAddErr:
    Debug.Print "ConnAdd() Error: " & Err.Number & ": " & Err.Description
End Function

Private Function ConnFind(ByVal lngSocket As Long) As Integer
    Dim i As Integer, intIndex As Integer

    For i = 1 To UBound(ConnList)
        If ConnList(i).sSocket = lngSocket Then
            intIndex = i
            Exit For
        End If
    Next
    
    ConnFind = intIndex
End Function

Private Sub ConnRemove(ByVal intIndex As Integer)
On Error GoTo ConnRemoveErr
    Dim lngUBound As Long, i As Long
    
    If intIndex > 0 Then
        lngUBound = UBound(ConnList)
        If lngUBound = 1 Then
            ReDim ConnList(0)
        ElseIf lngUBound >= 2 Then
            For i = intIndex + 1 To UBound(ConnList)
                ConnList(i - 1).sSocket = ConnList(i).sSocket
                ConnList(i - 1).SocketAddress = ConnList(i).SocketAddress
                ConnList(i - 1).RecvRaised = ConnList(i).RecvRaised
            Next
            ReDim Preserve ConnList(0 To UBound(ConnList) - 1)
        End If
    End If
    
    Exit Sub
ConnRemoveErr:
    Debug.Print "ConnRemove() Error: " & intIndex
End Sub


'------------ Helper Functions ------------
Private Function LoWord(lDWord As Long) As Integer
  If lDWord And &H8000& Then
    LoWord = lDWord Or &HFFFF0000
  Else
    LoWord = lDWord And &HFFFF&
  End If
End Function

'Winsock helper functions only
Private Function GetWinsockError(ByVal lngErrorCode As Long) As String
    Select Case lngErrorCode
        Case WSAEINTR: GetWinsockError = "interrupted function call"
        Case WSAEACCES: GetWinsockError = "permission denied"
        Case WSAEFAULT: GetWinsockError = "invalid address"
        Case WSAEINVAL: GetWinsockError = "invalid argument"
        Case WSAEMFILE: GetWinsockError = "too many files open"
        Case WSAEWOULDBLOCK: GetWinsockError = "function call would block"
        Case WSAEINPROGRESS: GetWinsockError = "blocking call already in progress"
        Case WSAEALREADY: GetWinsockError = "operation already in progress"
        Case WSAENOTSOCK: GetWinsockError = "not a valid socket descriptor"
        Case WSAEDESTADDRREQ: GetWinsockError = "destination address required"
        Case WSAEMSGSIZE: GetWinsockError = "message is too long"
        Case WSAEPROTOTYPE: GetWinsockError = "protocol wrong type for socket"
        Case WSAENOPROTOOPT: GetWinsockError = "bad protocol option"
        Case WSAEPROTONOSUPPORT: GetWinsockError = "protocol not supported"
        Case WSAESOCKTNOSUPPORT: GetWinsockError = "socket type not supported"
        Case WSAEOPNOTSUPP: GetWinsockError = "operation not supported"
        Case WSAEPFNOSUPPORT: GetWinsockError = "protocol family not supported"
        Case WSAEAFNOSUPPORT: GetWinsockError = "address family not supported by protocol"
        Case WSAEADDRINUSE: GetWinsockError = "address in use"
        Case WSAEADDRNOTAVAIL: GetWinsockError = "address is not available"
        Case WSAENETDOWN: GetWinsockError = "network is down"
        Case WSAENETUNREACH: GetWinsockError = "network is unreachable"
        Case WSAENETRESET: GetWinsockError = "network dropped connection on reset"
        Case WSAECONNABORTED: GetWinsockError = "software caused connection abort"
        Case WSAECONNRESET: GetWinsockError = "connection reset by peer"
        Case WSAENOBUFS: GetWinsockError = "no buffer space available"
        Case WSAEISCONN: GetWinsockError = "socket is already connected"
        Case WSAENOTCONN: GetWinsockError = "socket is not connected"
        Case WSAESHUTDOWN: GetWinsockError = "cannot send after shutdown"
        Case WSAETOOMANYREFS: GetWinsockError = "too many socket references"
        Case WSAETIMEDOUT: GetWinsockError = "request timed out"
        Case WSAECONNREFUSED: GetWinsockError = "connection refused"
        Case WSAENAMETOOLONG: GetWinsockError = "name is too long"
        Case WSAEHOSTDOWN: GetWinsockError = "host is down"
        Case WSAEHOSTUNREACH: GetWinsockError = "host is unreachable"
        Case WSAEPROCLIM: GetWinsockError = "too many processes"
        Case WSASYSNOTREADY: GetWinsockError = "network sub-system is unavailable"
        Case WSAVERNOTSUPPORTED: GetWinsockError = "requested version not supported"
        Case WSANOTINITIALISED: GetWinsockError = "winsock is not loaded - call WSAStartup"
        Case WSAEDISCON: GetWinsockError = "graceful shutdown in progress"
        Case WSATYPE_NOT_FOUND: GetWinsockError = "class type not found"
        Case WSAHOST_NOT_FOUND: GetWinsockError = "host not found"
        Case WSATRY_AGAIN: GetWinsockError = "non-authoritative host not found"
        Case WSANO_RECOVERY: GetWinsockError = "non-recoverable error"
        Case WSANO_DATA: GetWinsockError = "valid name - no data record of requested type"
        Case Else: GetWinsockError = "unknown error(" + CStr(lngErrorCode) & ")"
    End Select
End Function

' Convert a dotted IP address into a network byte integer.
Private Function vbInetAddr(ByVal strIPAddress As String) As Long
  vbInetAddr = inet_addr(strIPAddress)
End Function
' Return a dotted 4 octet address from a 32bit network byte integer.
Private Function vbInetNtoa(ByVal lngIPAddress As Long) As String
  Dim lpString As Long, strBuffer As String
  
  lpString = inet_ntoa(lngIPAddress)
  If (lpString) Then
    ' Prepare a buffer, copy the IP into it, then trim and return.
    strBuffer = String$(16, 0)
    Call CopyMemory(ByVal strBuffer, ByVal lpString, Len(strBuffer))
    vbInetNtoa = Mid$(strBuffer, 1, InStr(1, strBuffer, Chr$(0)) - 1)
  End If
End Function

Private Function vbHostNameFromIP(ByVal strIPAddress As String) As String
  Dim udtHost As hostent, lngIPAddress As Long, lngPointer As Long, strBuffer As String
  
  ' First, convert the string IP to a long IP.
  lngIPAddress = vbInetAddr(strIPAddress)
  
  If (lngIPAddress = INADDR_NONE) Then Exit Function
  
  ' Now call gethostbyaddr to retrieve the hostent structure.
  lngPointer = gethostbyaddr(lngIPAddress, 4, AF_INET)
  If (lngPointer) Then
    ' Copy the hostent structure out of the pointer.
    Call CopyMemory(udtHost, ByVal lngPointer, LenB(udtHost))
    
    ' Prepare a string buffer and copy the hostname into it from the hostent.h_name field.
    strBuffer = String$(1024, 0)
    Call CopyMemory(ByVal strBuffer, ByVal udtHost.h_name, Len(strBuffer))
    
    ' Trim the null characters off, and return the buffer.
    vbHostNameFromIP = Mid$(strBuffer, 1, InStr(1, strBuffer, Chr$(0)) - 1)
  End If
End Function

Private Function vbIPFromHostName(ByVal strHostName As String) As String
  Dim udtHost As hostent, lngIPAddress As Long, lngPointer As Long
  Dim bytIPAddress(0 To 3) As Byte, strBuffer As String, i As Long
   
  ' Firstly, check if the hostname is already an IP.
  lngIPAddress = vbInetAddr(strHostName)
  If (lngIPAddress <> INADDR_NONE) Then
    ' If it's already an IP, just return it.
    vbIPFromHostName = strHostName
    Exit Function
  End If
  
  ' It's not an IP, so we'll have to resolve it. Call gethostbyname().
  lngPointer = gethostbyname(strHostName)
  If (lngPointer) Then
    ' Copy the hostent structure to local memory.
    Call CopyMemory(udtHost, ByVal lngPointer, LenB(udtHost))
    
    ' h_addr_list contains a pointer to a long. So, firstly, copy out the pointer.
    Call CopyMemory(lngPointer, ByVal udtHost.h_addr_list, udtHost.h_length)
    
    ' Copy the IP address into a four byte array, so we can build a dotted IP string from it.
    Call CopyMemory(bytIPAddress(0), ByVal lngPointer, udtHost.h_length)
    
    ' Build and return the IP string.
    For i = 0 To 3
      strBuffer = strBuffer & CStr(bytIPAddress(i)) & "."
    Next i
    vbIPFromHostName = Mid$(strBuffer, 1, Len(strBuffer) - 1)
  End If
End Function



'======================================================================================================
'Subclass code - The programmer may call any of the following Subclass_??? routines

'Add a message to the table of those that will invoke a callback. You should Subclass_Start first and then add the messages
Private Sub Subclass_AddMsg(ByVal lng_hWnd As Long, ByVal uMsg As Long, Optional ByVal When As eMsgWhen = MSG_AFTER)
'Parameters:
  'lng_hWnd  - The handle of the window for which the uMsg is to be added to the callback table
  'uMsg      - The message number that will invoke a callback. NB Can also be ALL_MESSAGES, ie all messages will callback
  'When      - Whether the msg is to callback before, after or both with respect to the the default (previous) handler
  With sc_aSubData(zIdx(lng_hWnd))
    If When And eMsgWhen.MSG_BEFORE Then
      Call zAddMsg(uMsg, .aMsgTblB, .nMsgCntB, eMsgWhen.MSG_BEFORE, .nAddrSub)
    End If
    If When And eMsgWhen.MSG_AFTER Then
      Call zAddMsg(uMsg, .aMsgTblA, .nMsgCntA, eMsgWhen.MSG_AFTER, .nAddrSub)
    End If
  End With
End Sub

'Delete a message from the table of those that will invoke a callback.
Private Sub Subclass_DelMsg(ByVal lng_hWnd As Long, ByVal uMsg As Long, Optional ByVal When As eMsgWhen = MSG_AFTER)
'Parameters:
  'lng_hWnd  - The handle of the window for which the uMsg is to be removed from the callback table
  'uMsg      - The message number that will be removed from the callback table. NB Can also be ALL_MESSAGES, ie all messages will callback
  'When      - Whether the msg is to be removed from the before, after or both callback tables
  With sc_aSubData(zIdx(lng_hWnd))
    If When And eMsgWhen.MSG_BEFORE Then
      Call zDelMsg(uMsg, .aMsgTblB, .nMsgCntB, eMsgWhen.MSG_BEFORE, .nAddrSub)
    End If
    If When And eMsgWhen.MSG_AFTER Then
      Call zDelMsg(uMsg, .aMsgTblA, .nMsgCntA, eMsgWhen.MSG_AFTER, .nAddrSub)
    End If
  End With
End Sub

'Return whether we're running in the IDE.
Private Function Subclass_InIDE() As Boolean
  Debug.Assert zSetTrue(Subclass_InIDE)
End Function

'Start subclassing the passed window handle
Private Function Subclass_Start(ByVal lng_hWnd As Long) As Long
'Parameters:
  'lng_hWnd  - The handle of the window to be subclassed
'Returns;
  'The sc_aSubData() index
  Const CODE_LEN              As Long = 200                                             'Length of the machine code in bytes
  Const FUNC_CWP              As String = "CallWindowProcA"                             'We use CallWindowProc to call the original WndProc
  Const FUNC_EBM              As String = "EbMode"                                      'VBA's EbMode function allows the machine code thunk to know if the IDE has stopped or is on a breakpoint
  Const FUNC_SWL              As String = "SetWindowLongA"                              'SetWindowLongA allows the cSubclasser machine code thunk to unsubclass the subclasser itself if it detects via the EbMode function that the IDE has stopped
  Const MOD_USER              As String = "user32"                                      'Location of the SetWindowLongA & CallWindowProc functions
  Const MOD_VBA5              As String = "vba5"                                        'Location of the EbMode function if running VB5
  Const MOD_VBA6              As String = "vba6"                                        'Location of the EbMode function if running VB6
  Const PATCH_01              As Long = 18                                              'Code buffer offset to the location of the relative address to EbMode
  Const PATCH_02              As Long = 68                                              'Address of the previous WndProc
  Const PATCH_03              As Long = 78                                              'Relative address of SetWindowsLong
  Const PATCH_06              As Long = 116                                             'Address of the previous WndProc
  Const PATCH_07              As Long = 121                                             'Relative address of CallWindowProc
  Const PATCH_0A              As Long = 186                                             'Address of the owner object
  Static aBuf(1 To CODE_LEN)  As Byte                                                   'Static code buffer byte array
  Static pCWP                 As Long                                                   'Address of the CallWindowsProc
  Static pEbMode              As Long                                                   'Address of the EbMode IDE break/stop/running function
  Static pSWL                 As Long                                                   'Address of the SetWindowsLong function
  Dim i                       As Long                                                   'Loop index
  Dim j                       As Long                                                   'Loop index
  Dim nSubIdx                 As Long                                                   'Subclass data index
  Dim sHex                    As String                                                 'Hex code string
  
'If it's the first time through here..
  If aBuf(1) = 0 Then
  
'The hex pair machine code representation.
    sHex = "5589E583C4F85731C08945FC8945F8EB0EE80000000083F802742185C07424E830000000837DF800750AE838000000E84D00" & _
           "00005F8B45FCC9C21000E826000000EBF168000000006AFCFF7508E800000000EBE031D24ABF00000000B900000000E82D00" & _
           "0000C3FF7514FF7510FF750CFF75086800000000E8000000008945FCC331D2BF00000000B900000000E801000000C3E33209" & _
           "C978078B450CF2AF75278D4514508D4510508D450C508D4508508D45FC508D45F85052B800000000508B00FF90A4070000C3"

'Convert the string from hex pairs to bytes and store in the static machine code buffer
    i = 1
    Do While j < CODE_LEN
      j = j + 1
      aBuf(j) = Val("&H" & Mid$(sHex, i, 2))                                            'Convert a pair of hex characters to an eight-bit value and store in the static code buffer array
      i = i + 2
    Loop                                                                                'Next pair of hex characters
    
'Get API function addresses
    If Subclass_InIDE Then                                                              'If we're running in the VB IDE
      aBuf(16) = &H90                                                                   'Patch the code buffer to enable the IDE state code
      aBuf(17) = &H90                                                                   'Patch the code buffer to enable the IDE state code
      pEbMode = zAddrFunc(MOD_VBA6, FUNC_EBM)                                           'Get the address of EbMode in vba6.dll
      If pEbMode = 0 Then                                                               'Found?
        pEbMode = zAddrFunc(MOD_VBA5, FUNC_EBM)                                         'VB5 perhaps
      End If
    End If
    
    pCWP = zAddrFunc(MOD_USER, FUNC_CWP)                                                'Get the address of the CallWindowsProc function
    pSWL = zAddrFunc(MOD_USER, FUNC_SWL)                                                'Get the address of the SetWindowLongA function
    ReDim sc_aSubData(0 To 0) As tSubData                                               'Create the first sc_aSubData element
  Else
    nSubIdx = zIdx(lng_hWnd, True)
    If nSubIdx = -1 Then                                                                'If an sc_aSubData element isn't being re-cycled
      nSubIdx = UBound(sc_aSubData()) + 1                                               'Calculate the next element
      ReDim Preserve sc_aSubData(0 To nSubIdx) As tSubData                              'Create a new sc_aSubData element
    End If
    
    Subclass_Start = nSubIdx
  End If

  With sc_aSubData(nSubIdx)
    .hWnd = lng_hWnd                                                                    'Store the hWnd
    .nAddrSub = GlobalAlloc(GMEM_FIXED, CODE_LEN)                                       'Allocate memory for the machine code WndProc
    .nAddrOrig = SetWindowLongA(.hWnd, GWL_WNDPROC, .nAddrSub)                          'Set our WndProc in place
    Call RtlMoveMemory(ByVal .nAddrSub, aBuf(1), CODE_LEN)                              'Copy the machine code from the static byte array to the code array in sc_aSubData
    Call zPatchRel(.nAddrSub, PATCH_01, pEbMode)                                        'Patch the relative address to the VBA EbMode api function, whether we need to not.. hardly worth testing
    Call zPatchVal(.nAddrSub, PATCH_02, .nAddrOrig)                                     'Original WndProc address for CallWindowProc, call the original WndProc
    Call zPatchRel(.nAddrSub, PATCH_03, pSWL)                                           'Patch the relative address of the SetWindowLongA api function
    Call zPatchVal(.nAddrSub, PATCH_06, .nAddrOrig)                                     'Original WndProc address for SetWindowLongA, unsubclass on IDE stop
    Call zPatchRel(.nAddrSub, PATCH_07, pCWP)                                           'Patch the relative address of the CallWindowProc api function
    Call zPatchVal(.nAddrSub, PATCH_0A, ObjPtr(Me))                                     'Patch the address of this object instance into the static machine code buffer
  End With
End Function

'Stop all subclassing
Private Sub Subclass_StopAll()
  Dim i As Long
  
  i = UBound(sc_aSubData())                                                             'Get the upper bound of the subclass data array
  Do While i >= 0                                                                       'Iterate through each element
    With sc_aSubData(i)
      If .hWnd <> 0 Then                                                                'If not previously Subclass_Stop'd
        Call Subclass_Stop(.hWnd)                                                       'Subclass_Stop
      End If
    End With
    
    i = i - 1                                                                           'Next element
  Loop
End Sub

'Stop subclassing the passed window handle
Private Sub Subclass_Stop(ByVal lng_hWnd As Long)
'Parameters:
  'lng_hWnd  - The handle of the window to stop being subclassed
  With sc_aSubData(zIdx(lng_hWnd))
    Call SetWindowLongA(.hWnd, GWL_WNDPROC, .nAddrOrig)                                 'Restore the original WndProc
    Call zPatchVal(.nAddrSub, PATCH_05, 0)                                              'Patch the Table B entry count to ensure no further 'before' callbacks
    Call zPatchVal(.nAddrSub, PATCH_09, 0)                                              'Patch the Table A entry count to ensure no further 'after' callbacks
    Call GlobalFree(.nAddrSub)                                                          'Release the machine code memory
    .hWnd = 0                                                                           'Mark the sc_aSubData element as available for re-use
    .nMsgCntB = 0                                                                       'Clear the before table
    .nMsgCntA = 0                                                                       'Clear the after table
    Erase .aMsgTblB                                                                     'Erase the before table
    Erase .aMsgTblA                                                                     'Erase the after table
  End With
End Sub

'======================================================================================================
'These z??? routines are exclusively called by the Subclass_??? routines.

'Worker sub for Subclass_AddMsg
Private Sub zAddMsg(ByVal uMsg As Long, ByRef aMsgTbl() As Long, ByRef nMsgCnt As Long, ByVal When As eMsgWhen, ByVal nAddr As Long)
  Dim nEntry  As Long                                                                   'Message table entry index
  Dim nOff1   As Long                                                                   'Machine code buffer offset 1
  Dim nOff2   As Long                                                                   'Machine code buffer offset 2
  
  If uMsg = ALL_MESSAGES Then                                                           'If all messages
    nMsgCnt = ALL_MESSAGES                                                              'Indicates that all messages will callback
  Else                                                                                  'Else a specific message number
    Do While nEntry < nMsgCnt                                                           'For each existing entry. NB will skip if nMsgCnt = 0
      nEntry = nEntry + 1
      
      If aMsgTbl(nEntry) = 0 Then                                                       'This msg table slot is a deleted entry
        aMsgTbl(nEntry) = uMsg                                                          'Re-use this entry
        Exit Sub                                                                        'Bail
      ElseIf aMsgTbl(nEntry) = uMsg Then                                                'The msg is already in the table!
        Exit Sub                                                                        'Bail
      End If
    Loop                                                                                'Next entry

    nMsgCnt = nMsgCnt + 1                                                               'New slot required, bump the table entry count
    ReDim Preserve aMsgTbl(1 To nMsgCnt) As Long                                        'Bump the size of the table.
    aMsgTbl(nMsgCnt) = uMsg                                                             'Store the message number in the table
  End If

  If When = eMsgWhen.MSG_BEFORE Then                                                    'If before
    nOff1 = PATCH_04                                                                    'Offset to the Before table
    nOff2 = PATCH_05                                                                    'Offset to the Before table entry count
  Else                                                                                  'Else after
    nOff1 = PATCH_08                                                                    'Offset to the After table
    nOff2 = PATCH_09                                                                    'Offset to the After table entry count
  End If

  If uMsg <> ALL_MESSAGES Then
    Call zPatchVal(nAddr, nOff1, VarPtr(aMsgTbl(1)))                                    'Address of the msg table, has to be re-patched because Redim Preserve will move it in memory.
  End If
  Call zPatchVal(nAddr, nOff2, nMsgCnt)                                                 'Patch the appropriate table entry count
End Sub

'Return the memory address of the passed function in the passed dll
Private Function zAddrFunc(ByVal sDLL As String, ByVal sProc As String) As Long
  zAddrFunc = GetProcAddress(GetModuleHandleA(sDLL), sProc)
  Debug.Assert zAddrFunc                                                                'You may wish to comment out this line if you're using vb5 else the EbMode GetProcAddress will stop here everytime because we look for vba6.dll first
End Function

'Worker sub for Subclass_DelMsg
Private Sub zDelMsg(ByVal uMsg As Long, ByRef aMsgTbl() As Long, ByRef nMsgCnt As Long, ByVal When As eMsgWhen, ByVal nAddr As Long)
  Dim nEntry As Long
  
  If uMsg = ALL_MESSAGES Then                                                           'If deleting all messages
    nMsgCnt = 0                                                                         'Message count is now zero
    If When = eMsgWhen.MSG_BEFORE Then                                                  'If before
      nEntry = PATCH_05                                                                 'Patch the before table message count location
    Else                                                                                'Else after
      nEntry = PATCH_09                                                                 'Patch the after table message count location
    End If
    Call zPatchVal(nAddr, nEntry, 0)                                                    'Patch the table message count to zero
  Else                                                                                  'Else deleteting a specific message
    Do While nEntry < nMsgCnt                                                           'For each table entry
      nEntry = nEntry + 1
      If aMsgTbl(nEntry) = uMsg Then                                                    'If this entry is the message we wish to delete
        aMsgTbl(nEntry) = 0                                                             'Mark the table slot as available
        Exit Do                                                                         'Bail
      End If
    Loop                                                                                'Next entry
  End If
End Sub

'Get the sc_aSubData() array index of the passed hWnd
Private Function zIdx(ByVal lng_hWnd As Long, Optional ByVal bAdd As Boolean = False) As Long
'Get the upper bound of sc_aSubData() - If you get an error here, you're probably Subclass_AddMsg-ing before Subclass_Start
  zIdx = UBound(sc_aSubData)
  Do While zIdx >= 0                                                                    'Iterate through the existing sc_aSubData() elements
    With sc_aSubData(zIdx)
      If .hWnd = lng_hWnd Then                                                          'If the hWnd of this element is the one we're looking for
        If Not bAdd Then                                                                'If we're searching not adding
          Exit Function                                                                 'Found
        End If
      ElseIf .hWnd = 0 Then                                                             'If this an element marked for reuse.
        If bAdd Then                                                                    'If we're adding
          Exit Function                                                                 'Re-use it
        End If
      End If
    End With
    zIdx = zIdx - 1                                                                     'Decrement the index
  Loop
  
  If Not bAdd Then
    Debug.Assert False                                                                  'hWnd not found, programmer error
  End If

'If we exit here, we're returning -1, no freed elements were found
End Function

'Patch the machine code buffer at the indicated offset with the relative address to the target address.
Private Sub zPatchRel(ByVal nAddr As Long, ByVal nOffset As Long, ByVal nTargetAddr As Long)
  Call RtlMoveMemory(ByVal nAddr + nOffset, nTargetAddr - nAddr - nOffset - 4, 4)
End Sub

'Patch the machine code buffer at the indicated offset with the passed value
Private Sub zPatchVal(ByVal nAddr As Long, ByVal nOffset As Long, ByVal nValue As Long)
  Call RtlMoveMemory(ByVal nAddr + nOffset, nValue, 4)
End Sub

'Worker function for Subclass_InIDE
Private Function zSetTrue(ByRef bValue As Boolean) As Boolean
  zSetTrue = True
  bValue = True
End Function
