VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "okInSimClient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'objects needed to work
Private WithEvents InSimSocket As okSocket
Attribute InSimSocket.VB_VarHelpID = -1
Private WithEvents theTimer As Timer
Attribute theTimer.VB_VarHelpID = -1

'sockets
Private m_blnInitilized As Boolean
Private m_lngInSimClient As Long      'socket for the insim client, LFS
Private m_blnConnected As Boolean     'connected or not
Private m_bytTimer As Byte            'timer count

'connection info
Private m_strInSimIP As String
Private m_lngInSimSendPort As Long
Private m_strInSimPassword As String
Private m_lngInSimUDPPort As Long
Private m_strInSimPrefix As String
Private m_lngInSimFlags As Long
Private m_lngNodeSeconds As Long

'arrays to hold latest packet types
Private NLPInfo(0 To 31) As NodeLap
Private MCIInfo(0 To 7) As CompCar

'the second byte in all packets is one of these
Private Enum InSimPackets
    ISP_NONE = 0    '                : not used
    ISP_ISI = 1     'instruction     : InSim initialise
    ISP_VER = 2     'info            : Version info
    ISP_TINY = 3    'both ways       : multi purpose
    ISP_SMALL = 4   'both ways       : multi purpose
    ISP_STA = 5     'info            : State info
    ISP_SCH = 6     'instruction     : single character
    ISP_SFP = 7     'instruction     : state flags pack
    ISP_SCC = 8     'instruction     : set car camera
    ISP_CPP = 9     'both ways       : cam pos pack
    ISP_ISM = 10    'info            : start multiplayer
    ISP_MSO = 11    'info            : message out
    ISP_III = 12    'info            : hidden /i message
    ISP_MST = 13    'instruction     : type message or /command
    ISP_MTC = 14    'instruction     : message to a connection
    ISP_MOD = 15    'instruction     : set screen mode
    ISP_VTN = 16    'info            : vote notification
    ISP_RST = 17    'info            : new connection
    ISP_NCN = 18    'info            : new connection
    ISP_CNL = 19    'info            : Connection Left
    ISP_CPR = 20    'info            : Connection renamed
    ISP_NPL = 21    'info            : new player (joined race)
    ISP_PLP = 22    'info            : player pit (keeps slot in race)
    ISP_PLL = 23    'info            : player leave (spectate - loses slot)
    ISP_LAP = 24    'info            : lap Time
    ISP_SPX = 25    'info            : split x time
    ISP_PIT = 26    'info            : pit stop start
    ISP_PSF = 27    'info            : pit stop finish
    ISP_PLA = 28    'info            : pit lane enter / leave
    ISP_CCH = 29    'info            : camera Changed
    ISP_PEN = 30    'info            : Penalty given Or cleared
    ISP_TOC = 31    'info            : take over car
    ISP_FLG = 32    'info            : Flag (yellow Or blue)
    ISP_PFL = 33    'info            : player flags (help flags)
    ISP_FIN = 34    'info            : finished race
    ISP_RES = 35    'info            : result CONFIRMED
    ISP_REO = 36    'both ways       : reorder (info or instruction)
    ISP_NLP = 37    'info            : node and lap packet
    ISP_MCI = 38    'info            : multi car info
End Enum

'the fourth byte of IS_TINY packets is one of these
Private Enum TinyPackets
    TINY_NONE = 0   '                : see "maintaining the connection"
    TINY_VER = 1    'info request    : get version
    TINY_CLOSE = 2  'instruction     : Close InSim
    TINY_PING = 3   'ping request    : external progam requesting a reply
    TINY_REPLY = 4  'ping reply      : reply to a ping request
    TINY_VTC = 5    'info            : vote cancelled
    TINY_SCP = 6    'info request    : send camera pos
    TINY_SST = 7    'info request    : send state info
    TINY_GTH = 8    'info request    : get time in hundredths (i.e. SMALL_RTP)
    TINY_MPE = 9    'info            : multi player end
    TINY_ISM = 10   'info request    : get multiplayer info (i.e. ISP_ISM)
    TINY_REN = 11   'info            : race end (return to game setup screen)
    TINY_CLR = 12   'info            : all players cleared from race
    TINY_NCN = 13   'info            : get all connections
    TINY_NPL = 14   'info            : get all players
    TINY_RES = 15   'info            : get all results
    TINY_NLP = 16   'info request    : send an IS_NLP packet
    TINY_MCI = 17   'info request    : send an IS_MCI packet
    TINY_REO = 18   'info request    : send an IS_REO packet
    TINY_RST = 19   'info request    : send an IS_RST packet
End Enum

'the fourth byte of IS_SMALL packets is one of these
Private Enum SmallPackets
    SMALL_NONE = 0  '                : not used
    SMALL_SSP = 1   'instruction     : start sending positions
    SMALL_SSG = 2   'instruction     : start sending gauges
    SMALL_VTA = 3   'report          : vote Action
    SMALL_TMS = 4   'instruction     : time stop
    SMALL_STP = 5   'instruction     : Time step
    SMALL_RTP = 6   'info            : race time packet (reply to GTH)
    SMALL_NLI = 7   'instruction     : set node lap interval
End Enum

'events raised to update the UI n' stuff
Public Event Connected()
Public Event Disconnected()
Public Event Status(ByVal strMsg As String)

'event packets from InSim, base events
Public Event Version(ByVal strVersion As String, ByVal strProduct As String, ByVal lngInSimVer As Long)
Public Event StateChanged(ByVal sngReplaySpeed As Single, ByVal lngStateFlags As Long, ByVal bytInGameCam As CameraViews, _
    ByVal bytViewPlayer As Byte, ByVal bytNumPlayers As Byte, ByVal bytNumConns As Byte, _
    ByVal bytNumFinished As Byte, ByVal RaceInProg As RaceProgress, ByVal bytQualMins As Byte, _
    ByVal bytRaceLaps As Byte, ByVal strTrack As String, ByVal bytWeather As Byte, ByVal Wind As Winds)
Public Event MessageOut(ByVal bytUCID As Byte, bytPLID As Byte, ByVal blnUser As Boolean, ByVal bytStart As Byte, ByVal strMsg As String)
Public Event MessageInfo(ByVal bytUCID As Byte, bytPLID As Byte, ByVal strMsg As String)
Public Event MultiJoin(ByVal bytHost As Byte, ByVal strName As String)
Public Event MultiLeave()
Public Event VoteNotify(ByVal bytUCID As Byte, ByVal Action As VoteActions)
Public Event VoteAction(ByVal Action As VoteActions)
Public Event VoteCancel()

'race tracking events
Public Event RaceStart(ByVal bytRaceLaps As Byte, ByVal bytQualMins As Byte, ByVal bytNumPlayers As Byte, ByVal strTrack As String, ByVal bytWeather As Byte, _
    ByVal Wind As Winds, ByVal lngRaceFlags As Long, ByVal lngFinish As Long, ByVal lngSplit1 As Long, ByVal lngSplit2 As Long, ByVal lngSplit3 As Long)
Public Event RaceClear()
Public Event RaceReOrder(ByVal bytNumPlayers As Byte, PLIDs() As Byte)
Public Event RaceEnd()
Public Event ConnectionNew(ByVal bytUCID As Byte, ByVal strUName As String, ByVal strPName As String, ByVal bytAdmin As Byte, ByVal bytTotal As Byte)
Public Event ConnectionLeave(ByVal bytUCID As Byte, ByVal bytTotal As Byte)
Public Event ConnectionRename(ByVal bytUCID As Byte, ByVal strPName As String, ByVal strPlate As String)
Public Event PlayerNew(ByVal bytPLID As Byte, ByVal bytUCID As Byte, ByVal bytType As Byte, ByVal lngPlayerFlags As Long, ByVal strPName As String, _
    ByVal strPlate As String, ByVal strCName As String, ByVal strSName As String, ByVal RLTyre As TyreCompounds, _
    ByVal RRTyre As TyreCompounds, ByVal FLTyre As TyreCompounds, ByVal FRTyre As TyreCompounds, _
    ByVal bytHMass As Byte, ByVal HTRes As Byte, ByVal bytPass As Byte, ByVal bytPlyNum As Byte)
Public Event PlayerGarage(ByVal bytPLID As Byte)
Public Event PlayerLeave(ByVal bytPLID As Byte)
Public Event PlayerLap(ByVal bytPLID As Byte, ByVal sngSeconds As Single, ByVal lngLapsDone As Long, ByVal lngPlayerFlags As Long, _
    ByVal Penalty As PenaltyValue, ByVal bytNumStops As Byte)
Public Event PlayerSplit(ByVal bytPLID As Byte, ByVal sngSeconds As Single, ByVal bytSplit As Byte, ByVal Penalty As PenaltyValue, ByVal bytNumStops As Byte)
Public Event PlayerPitStop(ByVal bytPLID As Byte, ByVal lngLapsDone As Long, ByVal lngPlayerFlags As Long, ByVal Penalty As PenaltyValue, ByVal bytNumStops As Byte, _
    ByVal RLTyre As Byte, ByVal RRTyre As Byte, ByVal FLTyre As Byte, ByVal FRTyre As Byte, ByVal dblPitWorkFlags As Double)
Public Event PlayerPitStopFinished(ByVal bytPLID As Byte, ByVal sngSeconds As Single)
Public Event PlayerPitLane(ByVal bytPLID As Byte, ByVal Fact As PitLaneFacts)
Public Event PlayerCameraChange(ByVal bytPLID As Byte, ByVal bytCamera As Byte)
Public Event PlayerPenalty(ByVal bytPLID As Byte, ByVal OldPenalty As PenaltyValue, ByVal NewPenalty As PenaltyValue, ByVal Reason As PenaltyReason)
Public Event PlayerTakeOverCar(ByVal bytPLID As Byte, ByVal bytOldUCID As Byte, ByVal bytNewUCID As Byte)
Public Event PlayerRaceFlag(ByVal bytPLID As Byte, ByVal blnOn As Boolean, ByVal Flag As RaceFlags, ByVal bytCarBehind As Byte)
Public Event PlayerFlagChanged(ByVal bytPLID As Byte, ByVal lngFlags As Long)
Public Event PlayerFinished(ByVal bytPLID As Byte, ByVal sngTotalTime As Single, ByVal sngBestLap As Single, ByVal bytHours As Byte, _
    ByVal bytNumStops As Byte, ByVal bytConfirm As Byte, ByVal lngLapsDone As Long, ByVal lngFlags As Long)
Public Event PlayerResult(ByVal bytPLID As Byte, ByVal strUName As String, ByVal strPName As String, ByVal strPlate As String, _
    ByVal strCName As String, ByVal sngTotalTime As Single, ByVal sngBestLap As Single, ByVal bytHours As Byte, ByVal bytNumStops As Byte, _
    ByVal bytConfirm As Byte, ByVal lngLapsDone As Long, ByVal lngFlags As Long, ByVal bytResultNum As Byte, ByVal bytNumResults As Byte)

'NLP and MCI
Public Event NodeLap(ByVal bytNumPlayers As Byte)
Public Event MultiCarInfo(ByVal bytNumCompCar As Byte)

'camera and time events
Public Event CameraPosition(ByVal lngVecX As Long, ByVal lngVecY As Long, ByVal lngVecZ As Long, _
    ByVal lngHeading As Long, ByVal lngPitch As Long, ByVal lngRoll As Long, ByVal bytViewPlayer As Byte, ByVal bytInGameCam As CameraViews, _
    ByVal sngFOV As Single, ByVal lngTime As Long, ByVal lngStateFlags As Long)
Public Event RaceTime(ByVal dblTime As Double)

'pure receive data event
'Public Event DataReceived(Bytes() As Byte, ByVal lngLength As Long)

'initilize and terminate completely enable and disable InSim
'these 2 are only to be used by the program behind the scenes to check if the basics will work
Public Function Initilize(ByVal aSocket As okSocket, aTimer As Timer) As Boolean
    If Not m_blnInitilized Then
        Set InSimSocket = aSocket
        Set theTimer = aTimer
    
        m_blnInitilized = True
    End If

    Initilize = m_blnInitilized
End Function
Public Sub Terminate()
    If m_blnConnected Then Call Disconnect
    m_blnInitilized = False
End Sub

'a few properties
Public Property Get Connected() As Boolean
    Connected = m_blnConnected
End Property

Public Property Get IP() As String
    IP = m_strInSimIP
End Property

Public Property Get SendPort() As Long
    SendPort = m_lngInSimSendPort
End Property

Public Property Get Prefix() As String
    Prefix = m_strInSimPrefix
End Property

Public Property Get UDPPort() As Long
    UDPPort = m_lngInSimUDPPort
End Property

Public Property Get Flags() As Long
    Flags = m_lngInSimFlags
End Property

Public Property Get NodeLapInterval() As Long
    NodeLapInterval = m_lngNodeSeconds
End Property

'// INITIALISING InSim
'// ==================
'// To initialise the InSim system, type into LFS : /insim xxxxx
'// where xxxxx is the TCP and UDP port you want LFS to open.
'
'// OR start LFS with the command line option : LFS /insim=xxxxx
'// This will make LFS listen for packets on that TCP and UDP port.
'
'// TO START COMMUNICATION
'// ======================
Public Sub Connect(ByVal strIP As String, ByVal lngSendPort As Long, Optional ByVal strPassword As String, Optional strPrefix As String, _
    Optional lngUDPPort As Long, Optional blnNLP As Boolean = False, Optional blnMCI As Boolean = False, Optional lngInterval As Byte)
    
    Const ISF_NLP = 16 '// bit 4 : set to receive NLP packets
    Const ISF_MCI = 32 '// bit 5 : set to receive MCI packets
    
    If Not m_blnConnected Then
        m_strInSimIP = strIP
        m_lngInSimSendPort = lngSendPort
        m_strInSimPassword = strPassword
        m_strInSimPrefix = strPrefix
        m_lngInSimUDPPort = lngUDPPort
        m_lngInSimFlags = -blnNLP * ISF_NLP Or -blnMCI * ISF_MCI
        m_lngNodeSeconds = lngInterval
        
        m_lngInSimClient = InSimSocket.Connect(IPPROTO_TCP, m_lngInSimSendPort, m_strInSimIP)
        If m_lngInSimClient Then
            RaiseEvent Status("connecting to " & m_strInSimIP & ":" & CStr(m_lngInSimSendPort))
            m_bytTimer = 0
            theTimer.Interval = 1000
            theTimer.Enabled = True
        Else
            RaiseEvent Status("could not connect!?")
        End If
    Else
        RaiseEvent Status("already connected!?")
    End If
End Sub

'// TCP : Connect to LFS using a TCP connection, then send this packet :
'// UDP : No connection required, just send this packet to LFS :
'
'struct IS_ISI // InSim Init - packet to initialise the InSim system
'{
'    byte    Size;       // 44
'    byte    Type;       // ISP_ISI
'    byte    ReqI;       // If non-zero LFS will send an IS_VER packet
'    byte    Zero;       // 0
'
'    word    UDPPort;    // Port for UDP replies from LFS (0 to 65535)
'    word    Flags;      // Bit flags for options (see below)
'
'    byte    Sp0;        // 0
'    byte    Prefix;     // Special host message prefix character
'    word    Interval;   // Time in ms between NLP or MCI (0 = none)
'
'    char    Admin[16];  // Admin password (if set in LFS)
'    char    IName[16];  // A short name for your program
'};
Private Sub SendISI()
    Dim bytData(0 To 43) As Byte

    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_ISI
    bytData(2) = 1  'gimme version!
    
    Call LongToWordBytes(bytData, m_lngInSimUDPPort, 4)
    Call LongToWordBytes(bytData, m_lngInSimFlags, 6)
    
    Call StringToBytes(bytData, m_strInSimPrefix, 9, 1)
    Call LongToWordBytes(bytData, m_lngNodeSeconds, 10)
    
    Call StringToBytes(bytData, m_strInSimPassword, 12, 16)
    Call StringToBytes(bytData, App.Title, 28, 16)

    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub
'// NOTE 1) UDPPort field when you connect using UDP :
'// zero     : LFS sends all packets to the port of the incoming packet
'// non-zero : LFS sends all packets to the specified UDPPort
'
'// NOTE 2) UDPPort field when you connect using TCP :
'// zero     : LFS sends NLP / MCI packets using your TCP connection
'// non-zero : LFS sends NLP / MCI packets to the specified UDPPort
'
'// NOTE 3) Flags field (set the relevant bits to turn on the option) :
'
'// In most cases you should not set both ISF_NLP and ISF_MCI flags
'// because all IS_NLP information is included in the IS_MCI packet.
'
'// NOTE 4) Prefix field, if set when initialising InSim on a host :
'
'// Messages typed with this prefix will be sent to your InSim program
'// on the host (in IS_MSO) and not displayed on anyone's screen.

'// GENERAL PURPOSE PACKETS - IS_TINY (4 bytes) and IS_SMALL (8 bytes)
'// =======================
'// To avoid defining several packet structures that are exactly the same, and to avoid
'// wasting the ISP_ enumeration, IS_TINY is used at various times when no additional data
'// other than SubT is required.  IS_SMALL is used when an additional integer is needed.
'
'// IS_TINY - used for various requests, replies and reports
'struct IS_TINY // General purpose 4 byte packet
'{
'    byte Size;      // always 4
'    byte Type;      // always ISP_TINY
'    byte ReqI;      // 0 unless it is an info request or a reply to an info request
'    byte SubT;      // subtype, from TINY_ enumeration (e.g. TINY_RACE_END)
'};
Private Sub SendTiny(ByVal SubT As TinyPackets, Optional ByVal ReqI As Byte)
    Dim bytData(0 To 3) As Byte
    
    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_TINY
    bytData(2) = ReqI
    bytData(3) = SubT
    
    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub

'// IS_SMALL - used for various requests, replies and reports
'struct IS_SMALL // General purpose 8 byte packet
'{
'    byte Size;      // always 8
'    byte Type;      // always ISP_SMALL
'    byte ReqI;      // 0 unless it is an info request or a reply to an info request
'    byte SubT;      // subtype, from SMALL_ enumeration (e.g. SMALL_SSP)
'
'    unsigned UVal;  // value (e.g. for SMALL_SSP this would be the OutSim packet rate)
'};
Private Sub SendSmall(ByVal SubT As SmallPackets, Optional ByVal ReqI As Byte, Optional UVal As Double)
    Dim bytData(0 To 7) As Byte, lngTemp As Long
    
    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_SMALL
    bytData(2) = ReqI
    bytData(3) = SubT
            
    'basic way to convert a c++ unsigned (as double) to a byte array
    lngTemp = IIf(UVal > 2147483647, UVal - 4294967296#, UVal)
    Call CopyMemory(bytData(4), lngTemp, 4)
    
    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub

'// VERSION REQUEST
'// ===============
'// It is advisable to request version information as soon as you have connected, to
'// avoid problems when connecting to a host with a later or earlier version.  You will
'// be sent a version packet on connection if you set ReqI in the IS_ISI packet.
'
'// To request an InSimVersion packet at any time, send this IS_TINY :
'// ReqI : non-zero      (returned in the reply)
'// SubT : TINY_VER      (request an IS_VER)
Public Sub GetVersion()
    Call SendTiny(TINY_VER, 1)
End Sub

'// CLOSING InSim
'// =============
'// You can send this IS_TINY to close the InSim connection to your program :
'// ReqI : 0
'// SubT : TINY_CLOSE    (close this connection)
'
'// Another InSimInit packet is then required to start operating again.
'// You can shut down InSim completely and stop it listening at all by typing /insim=0
'// into LFS (or send a MsgTypePack to do the same thing).
Public Function Disconnect()
    m_bytTimer = 0
    theTimer.Enabled = False
    
    If m_blnConnected Then
        m_blnConnected = False
        
        Call SendTiny(TINY_CLOSE, 0)
        Call InSimSocket.CloseSocket(m_lngInSimClient)
    End If
End Function

'// MAINTAINING THE CONNECTION - IMPORTANT
'// ==========================
'// If InSim does not receive a packet for 70 seconds, it will close your connection.
'// To open it again you would need to send another InSimInit packet.
'
'// LFS will send a blank IS_TINY packet like this every 30 seconds :
'// ReqI : 0
'// SubT : TINY_NONE     (keep alive packet)
'
'// You should reply with a blank IS_TINY packet :
'// ReqI : 0
'// SubT : TINY_NONE     (has no effect other than resetting the timeout)
'
'// NOTE : If you want to request a reply from LFS to check the connection
'// at any time, you can send this IS_TINY :
'// ReqI : non-zero      (returned in the reply)
'// SubT : TINY_PING     (request a TINY_REPLY)
'
'// LFS will reply with this IS_TINY :
'// ReqI : non-zero      (as received in the request packet)
'// SubT : TINY_REPLY    (reply to ping)
Private Sub theTimer_Timer()
    m_bytTimer = m_bytTimer + 1
    If m_bytTimer >= 240 Then m_bytTimer = 1    'avoid overflow..
    
    If Not m_blnConnected Then
        'not connected yet. just wait for socket connected event. connect timeout is 30 seconds
        If m_bytTimer >= 30 Then
            RaiseEvent Status("connect attempt timed out after 30 seconds")
            theTimer.Enabled = False
            Call InSimSocket.CloseSocket(m_lngInSimClient)
        End If
    Else
        '30 seconds elapsed, check connection with TINY_PING
        If m_bytTimer Mod 30 = 0 Then
            Call SendTiny(TINY_PING, 2)
        End If

        '70 seconds elapsed, disconnect
        If m_bytTimer > 70 Then
            RaiseEvent Status("no response in 70 seconds.. InSim running?")
            Call Disconnect
        End If
    End If
End Sub

'// STATE REPORTING AND REQUESTS
'// ============================
'// To request a StatePack at any time, send this IS_TINY :
'// ReqI : non-zero      (returned in the reply)
'// SubT : TINY_SST      (Send STate)
Public Sub GetState()
    Call SendTiny(TINY_SST, 3)
End Sub

'// Setting states
'// These states can be set by a special packet :
'
'struct IS_SFP // State Flags Pack
'{
'    byte    Size;       // 8
'    byte    Type;       // ISP_SFP
'    byte    ReqI;       // 0
'    byte    Zero;
'
'    word    Flag;       // the state to set
'    byte    OffOn;      // 0 = off / 1 = on
'    byte    Sp3;        // spare
'};
Public Sub SetState(ByVal WhichState As SettableStates, ByVal TurnOn As Boolean)
    Dim bytData(0 To 7) As Byte
    
    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_SFP
    
    Call LongToWordBytes(bytData, WhichState, 4)
    bytData(6) = -TurnOn
    
    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub
'// Other states must be set by using keypresses or messages (see below)

'// SCREEN MODE
'// ===========
'// You can send this packet to LFS to set the screen mode :
'
'struct IS_MOD // MODe : send to LFS to change screen mode
'{
'    byte    Size;       // 20
'    byte    Type;       // ISP_MOD
'    byte    ReqI;       // 0
'    byte    Zero;
'
'    int     Bits16;     // set to choose 16-bit
'    int     RR;         // refresh rate - zero for default
'    int     Width;      // 0 means go to window
'    int     Height;     // 0 means go to window
'};
Public Sub SetScreenMode(Optional ByVal Bits16 As Boolean, Optional ByVal Refresh As Long, _
                         Optional ByVal Width As Long, Optional ByVal Height As Long)
    Dim bytData(0 To 19) As Byte
    
    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_MOD
    
    bytData(4) = -Bits16    'i guess
    Call CopyMemory(bytData(8), Refresh, 4)     'VB6 long to C++ int, same thing, just copy
    Call CopyMemory(bytData(12), Width, 4)
    Call CopyMemory(bytData(16), Height, 4)
    
    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub

'// The refresh rate actually selected by LFS will be the highest available rate
'// that is less than or equal to the specified refresh rate.  Refresh rate can
'// be specified as zero in which case the default refresh rate will be used.
'// If Width and Height are both zero, LFS will switch to windowed mode.
'
'// TEXT MESSAGES AND KEY PRESSES
'// ==============================
'// You can send 64-byte text messages to LFS as if the user had typed them in.
'// Messages that appear on LFS screen (up to 128 bytes) are reported to the
'// external program.  You can also send simulated keypresses to LFS.
'
'// NOTE : The /mso command - Typing "/mso MESSAGE" into LFS will send a MSO packet.
'
'// MESSAGES IN (TO LFS)
'// -----------
'
'struct IS_MST // MSg Type : 64 chars - send to LFS to type message or command
'{
'    byte    Size;       // 68
'    byte    Type;       // ISP_MST
'    byte    ReqI;       // 0
'    byte    Zero;
'
'    char    Msg[64];
'};
Public Sub SendMessage(ByVal strMsg As String)
    Dim bytData(0 To 67) As Byte
    
    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_MST
    
    Call StringToBytes(bytData, strMsg, 4, 64)
    
    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub

'struct IS_MTC // Message To Connection : 64 chars - send to a connection or a player
'{
'    byte    Size;       // 72
'    byte    Type;       // ISP_MTC
'    byte    ReqI;       // 0
'    byte    Zero;
'
'    byte    UCID;       // connection's unique id (0 = host)
'    byte    PLID;       // player's unique id (if zero, use UCID)
'    byte    Sp2;
'    byte    Sp3;
'
'    char    Msg[64];
'};
Public Sub SendPlayerMessage(ByVal strMsg As String, Optional ByVal bytPLID As Byte, Optional ByVal bytUCID As Byte)
    Dim bytData(0 To 71) As Byte
    
    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_MTC
    
    bytData(4) = bytUCID
    bytData(5) = bytPLID
    Call StringToBytes(bytData, strMsg, 8, 64)
    
    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub

'struct IS_SCH // Single CHaracter - send to simulate single character
'{
'    byte    Size;       // 8
'    byte    Type;       // ISP_SCH
'    byte    ReqI;       // 0
'    byte    Zero;
'
'    byte    CharB;      // key to press
'    byte    Flags;      // bit 0 : SHIFT / bit 1 : CTRL
'    byte    Spare2;
'    byte    Spare3;
'};
Public Sub SendChar(ByVal bytChar As Byte, Optional ByVal CtrlOrShift As CtrlShift = SCH_NONE)
    Dim bytData(0 To 7) As Byte
    
    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_SCH
    
    bytData(4) = bytChar
    bytData(5) = CtrlOrShift
    
    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub

'// MULTIPLAYER NOTIFICATION
'// ========================
'// To request an IS_ISM packet at any time, send this IS_TINY :
'// ReqI : non-zero      (returned in the reply)
'// SubT : TINY_ISM      (request an IS_ISM)
Public Sub GetMulti()
    Call SendTiny(TINY_ISM, 4)
End Sub
'// NOTE : If LFS is not in multiplayer mode, the host name in the ISM will be empty.

'// VOTE NOTIFY AND CANCEL
'// ======================
'// You can instruct LFS host to cancel a vote using an IS_TINY
'// ReqI : 0
'// SubT : TINY_VTC      (VoTe Cancel)
Public Sub CancelVote()
    Call SendTiny(TINY_VTC)
End Sub

'// RACE TRACKING
'// =============
'
'// To request an IS_RST packet at any time, send this IS_TINY :
'// ReqI : non-zero      (returned in the reply)
'// SubT : TINY_RST      (request an IS_RST)
Public Sub GetRaceStart()
    Call SendTiny(TINY_RST, 5)
End Sub

'// IS_REO : REOrder - this packet can be sent in either direction
'
'// LFS sends one at the start of every race or qualifying session, listing the start order
'// You can send one to LFS before a race start, to specify the starting order.
'// It may be a good idea to avoid conflict by using /start=fixed (LFS setting).
'// Alternatively, you can leave the LFS setting, but make sure you send your IS_REO
'// AFTER you receive the IS_VTA.  LFS does its default grid reordering at the same time
'// as it sends the IS_VTA (VoTe Action) and you can override this by sending an IS_REO.
'
'struct IS_REO // REOrder (when race restarts after qualifying)
'{
'    byte    Size;       // 36
'    byte    Type;       // ISP_REO
'    byte    ReqI;       // 0 unless this is a reply to an TINY_REO request
'    byte    NumP;       // number of players in race
'
'    byte    PLID[32];   // all PLIDs in new order
'};
Public Sub SendREO(bytPLID() As Byte, ByVal NumP As Byte, Optional ByVal ReqI As Byte)
    Dim bytData(0 To 35) As Byte, i As Byte
    
    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_REO
    bytData(2) = ReqI
    bytData(3) = NumP
    
    For i = 0 To 31
        If i <= UBound(bytPLID) Then
            bytData(i + 4) = bytPLID(i)
        Else
            Exit For
        End If
    Next
    
    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub

'// To request an IS_REO packet at any time, send this IS_TINY :
'// ReqI : non-zero      (returned in the reply)
'// SubT : TINY_REO      (request an IS_REO)
Public Sub GetREO()
    Call SendTiny(TINY_REO, 6)
End Sub

'// TRACKING PACKET REQUESTS
'// ========================
'// To request players, connections, results or a single NLP or MCI, send an IS_TINY
'// In each case, ReqI must be non-zero, and will be returned in the reply packet
'
'// SubT : TINT_NCN - request all connections
Public Sub GetConnections()
    Call SendTiny(TINY_NCN, 7)
End Sub
'// SubT : TINY_NPL - request all players
Public Sub GetPlayers()
    Call SendTiny(TINY_NPL, 8)
End Sub
'// SubT : TINY_RES - request all results
Public Sub GetResults()
    Call SendTiny(TINY_RES, 9)
End Sub
'// SubT : TINY_NLP - request a single IS_NLP
Public Sub GetNLP()
    Call SendTiny(TINY_NLP, 10)
End Sub
'// SubT : TINY_MCI - request a set of IS_MCI
Public Sub GetMCI()
    Call SendTiny(TINY_MCI, 11)
End Sub

'// CAR TRACKING PACKETS - car position info sent at constant intervals
'// ====================
'
'// IS_NLP - compact, all cars in one packet
'// IS_MCI - more detailed, 8 cars per packet
'
'// To receive IS_NLP or IS_MCI packets at a specified interval :
'// 1) Set the Interval field in the IS_ISI (InSimInit) packet
'// 2) Set one of the flags ISF_NLP or ISF_MCI in the IS_ISI packet
'
'// If ISF_NLP flag is set, the IS_NLP packet is sent...
'struct NodeLap // Car info in 4 bytes - there is an array of these in the NLP (below)
'{
'    word    NodeLapHi3;     // current path node (and high 3 bits of lap)
'    byte    LapLo8;         // current lap (low byte of lap - see below)
'    byte    UniqueId;       // player's unique id
'};
Friend Function GetNLPInfo() As NodeLap()
    GetNLPInfo = NLPInfo
End Function

'// If ISF_MCI flag is set, a set of IS_MCI packets is sent...
'struct CompCar // Car info in 28 bytes - there is an array of these in the MCI (below)
'{
'    word    Node;       // current path node
'    word    Lap;        // current lap
'    byte    UniqueId;   // player's unique id
'    byte    Sp1;
'    byte    Sp2;
'    byte    Sp3;
'    int     X;          // X map (65536 = 1 metre)
'    int     Y;          // Y map (65536 = 1 metre)
'    int     Z;          // Z alt (65536 = 1 metre)
'    word    Speed;      // speed (32768 = 100 m/s)
'    word    Direction;  // direction of car's motion : 0 = world y direction, 32768 = 180 deg
'    word    Heading;    // direction of forward axis : 0 = world y direction, 32768 = 180 deg
'    short   AngVel;     // signed, rate of change of heading : (16384 = 360 deg/s)
'};
Friend Function GetMCIInfo() As CompCar()
    GetMCIInfo = MCIInfo
End Function

'// You can change the rate of NLP or MCI after initialisation by sending this IS_SMALL :
'// ReqI : 0
'// SubT : SMALL_NLI     (Node Lap Interval)
'// UVal : interval      (0 means stop, otherwise interval in ms, 100 to 8000)
Public Sub SetNodeLapInterval(ByVal lngMillseconds As Long)
    If lngMillseconds > 0 And lngMillseconds < 100 Then lngMillseconds = 100
    If lngMillseconds > 8000 Then lngMillseconds = 8000
    
    m_lngNodeSeconds = lngMillseconds
    
    Call SendSmall(SMALL_NLI, 0, CDbl(lngMillseconds))
End Sub

'// CAR POSITION PACKETS (Initialising OutSim from InSim - See "OutSim" below)
'// ====================
'
'// To request Car Positions from the currently viewed car, send this IS_SMALL :
'// ReqI : 0
'// SubT : SMALL_SSP     (Start Sending Positions)
'// UVal : interval      (time between updates - zero means stop sending)
Public Sub GetOutSim(ByVal lngInterval As Long)
    Call SendSmall(SMALL_SSP, 0, CDbl(lngInterval))
End Sub
'
'// The SSP packet makes LFS start sending UDP packets if in game, using the OutSim
'// system as documented near the end of this text file.
'// You do not need to set any OutSim values in LFS cfg.txt as OutSim is automatically
'// initialised by the SSP packet.
'
'// The OutSim packets will be sent to the UDP port specified in the InSimInit packet.
'// NOTE : OutSim packets are not InSim packets and don't have a 4-byte header.

'// DASHBOARD PACKETS (Initialising OutGauge from InSim - See "OutGauge" below)
'// =================
'
'// To request Dashboard Packets from the currently viewed car, send this IS_SMALL :
'// ReqI : 0
'// SubT : SMALL_SSG     (Start Sending Gauges)
'// UVal : interval      (time between updates - zero means stop sending)
Public Sub GetOutGauge(ByVal lngInterval As Long)
    Call SendSmall(SMALL_SSG, 0, CDbl(lngInterval))
End Sub
'// The SSG packet makes LFS start sending UDP packets if in game, using the OutGauge
'// system as documented near the end of this text file.
'// You do not need to set any OutGauge values in LFS cfg.txt as OutSim is automatically
'// initialised by the SSG packet.
'
'// The OutGauge packets will be sent to the UDP port specified in the InSimInit packet.
'// NOTE : OutGauge packets are not InSim packets and don't have a 4-byte header.

'// CAMERA CONTROL
'// ==============
'
'// IN GAME camera control
'// ----------------------
'
'// You can set the viewed car and selected camera directly with a special packet.
'// These are the states normally set in-game by using the TAB and V keys.
'
'struct IS_SCC // Set Car Camera - Simplified camera packet (not SHIFT+U mode)
'{
'    byte    Size;       // 8
'    byte    Type;       // ISP_SCC
'    byte    ReqI;       // 0
'    byte    Zero;
'
'    byte    ViewPlayer; // Player Index of car to view (0 = pole...)
'    byte    InGameCam;  // InGameCam (as reported in StatePack)
'    byte    UniqueId;   // Overrides ViewPlayer if set
'    byte    Spare3;
'};
Public Sub SetCamera(Optional ByVal bytViewPlayer As Byte = 255, Optional ByVal bytCamera As CameraViews = 255, Optional bytUniqueID As Byte)
    Dim bytData(0 To 7) As Byte
    
    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_SCC
    
    bytData(4) = bytViewPlayer
    bytData(5) = bytCamera
    bytData(6) = bytUniqueID
    
    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub
'// Special case : set ViewPlayer or InGameCam to 255 to leave that option unchanged.
'// NOTE : if UniqueId is used, the ViewPlayer byte will be ignored

'// DIRECT camera control
'// ---------------------
'// A Camera Position Packet can be used for LFS to report a camera position and state,
'// and for the external program to set LFS camera position in game or SHIFT+U mode.
'
'// Type : "Vec" : 3 ints (X, Y, Z) - 65536 means 1 metre
'
'struct IS_CPP // Cam Pos Pack - Full camera packet (in car OR SHIFT+U mode)
'{
'    byte    Size;       // 32
'    byte    Type;       // ISP_CPP
'    byte    ReqI;       // instruction : 0 / or reply : ReqI as received in the TINY_SCP
'    byte    Zero;
'
'    Vec     Pos;        // Position vector
'    word    Heading;    // 0 points along Y axis
'    word    Pitch;      // 0 means looking at horizon
'    word    Roll;       // 0 means no roll
'    byte    ViewPlayer; // Player Index of car to view (0 = pole...)
'    byte    InGameCam;  // InGameCam (as reported in StatePack)
'    float   FOV;        // 4-byte float : FOV in radians
'    word    Time;       // Time to get there (0 means instant + reset)
'    word    Flags;      // ISS state flags (see below)
'};
Public Sub SetCameraPosition(ByVal ReqI As Byte, ByVal lngVecX As Long, ByVal lngVecY As Long, ByVal lngVecZ As Long, _
    ByVal lngHeading As Long, ByVal lngPitch As Long, ByVal lngRoll As Long, ByVal bytViewPlayer As Byte, _
    ByVal bytInGameCam As CameraViews, ByVal sngFOV As Single, ByVal lngTime As Long, ByVal lngFlags As Long)
    
    Dim bytData(0 To 31) As Byte
    
    bytData(0) = UBound(bytData) + 1
    bytData(1) = ISP_CPP
    bytData(2) = ReqI
    
    Call CopyMemory(bytData(4), lngVecX, 4)
    Call CopyMemory(bytData(8), lngVecY, 4)
    Call CopyMemory(bytData(12), lngVecZ, 4)
    Call LongToWordBytes(bytData, lngHeading, 16)
    Call LongToWordBytes(bytData, lngPitch, 18)
    Call LongToWordBytes(bytData, lngRoll, 20)
    bytData(22) = bytViewPlayer
    bytData(23) = bytInGameCam
    Call CopyMemory(bytData(24), sngFOV, 4)
    Call LongToWordBytes(bytData, lngTime, 28)
    Call LongToWordBytes(bytData, lngFlags, 30)
    
    Call InSimSocket.Send(m_lngInSimClient, bytData, 0)
End Sub
'// The ISS state flags that can be set are :
'// ISS_SHIFTU           - in SHIFT+U mode
'// ISS_SHIFTU_HIGH      - HIGH view
'// ISS_SHIFTU_FOLLOW    - following car
'// ISS_VIEW_OVERRIDE    - override user view
'
'// On receiving this packet, LFS will set up the camera to match the values in the packet,
'// including switching into or out of SHIFT+U mode depending on the ISS_SHIFTU flag.
'
'// If ISS_SHIFTU is not set, then ViewPlayer and InGameCam will be used.
'// If ISS_VIEW_OVERRIDE is set, the in-car view Heading Pitch and Roll will be taken
'// from the values in this packet.  Otherwise normal in-game control will be used.
'
'// Position vector (Vec Pos) - ignored for in-game (not SHIFT+U) cameras.
'// For SHIFT+U cameras, Pos can be either relative or absolute.
'
'// If ISS_SHIFTU_FOLLOW is set, that means it's a following camera, so the position
'// is relative to the selected car.  Otherwise, the position is an absolute camera
'// position, as used in normal SHIFT+U mode.

'// SMOOTH CAMERA POSITIONING
'// --------------------------
'// The "Time" value in the packet is used for camera smoothing.  A zero Time means instant
'// positioning.  Any other value (milliseconds) will cause the camera to move smoothly to
'// the requested position in that time.  This is most useful in SHIFT+U camera modes or
'// for smooth changes of internal view when using the ISS_VIEW_OVERRIDE flag.
'
'// NOTE : you can use frequently updated camera positions with a longer "Time" than your
'// updates.  For example, sending a camera position every 100 ms, with a Time value of
'// 1000 ms.  LFS will make a smooth motion from these "rough" inputs.
'
'// If the requested camera mode is different from the one LFS is already in, it cannot
'// move smoothly to the new position, so in this case the "Time" value is ignored.
'
'// GETTING A CAMERA PACKET
'// -----------------------
'
'// To GET a CamPosPack from LFS, send this IS_TINY :
'// ReqI : non-zero      (returned in the reply)
'// SubT : TINY_SCP      (Send Cam Pos)
Public Sub GetCameraPosition()
    Call SendTiny(TINY_SCP, 12)
End Sub
'// LFS will reply with a CamPosPack as described above.  You can store this packet
'// and later send back exactly the same packet to LFS and it will try to replicate
'// that camera position.

'// TIME CONTROL
'// ============
'// You can Stop or Start Time in LFS and while it is stopped you can make LFS move
'// in time steps in multiples of 100th of a second.  Warning : unlike pausing, this
'// is a "trick" to LFS and the program is unaware of time passing, so you must not
'// leave it stopped because LFS is unusable in that state.  You must never use this
'// packet in multiplayer mode.
'
'// Request the current time at any point with this IS_TINY :
'// ReqI : non-zero      (returned in the reply)
'// SubT : TINY_GTH      (Get Time in Hundredths)
Public Sub GetRaceTime()
    Call SendTiny(TINY_GTH, 13)
End Sub
'// The time will be sent back in this IS_SMALL :
'// ReqI : non-zero      (as received in the request packet)
'// SubT : SMALL_RTP     (Race Time Packet)
'// UVal : Time          (hundredths of a second since start of race or replay)

'// Stop and Start with this IS_SMALL :
'// ReqI : 0
'// SubT : SMALL_TMS     (TiMe Stop)
'// UVal : stop          (1 - stop / 0 - carry on)
Public Sub TimeStop(ByVal blnStopped As Boolean)
    Call SendSmall(SMALL_TMS, 0, CDbl(-blnStopped))
End Sub

'// When STOPPED, make time step updates with this IS_SMALL :
'// ReqI : 0
'// SubT : SMALL_STP     (STeP)
'// UVal : number        (number of hundredths of a second to update)
Public Sub TimeStep(ByVal lngHundreths As Long)
    Call SendSmall(SMALL_STP, 0, CDbl(lngHundreths))
End Sub


'- socket events
'
Private Sub InSimSocket_Error(ByVal lngSocket As Long, ByVal strMsg As String)
    If lngSocket <> m_lngInSimClient Then
        Debug.Print "InSimSocket_Error: unknown socket: " & lngSocket
    Else
        Debug.Print "InSimSocket_Error: " & strMsg
    End If
End Sub
Private Sub InSimSocket_Connected(ByVal lngSocket As Long)
    If lngSocket <> m_lngInSimClient Then
        Debug.Print "InSimSocket_Connected: unknown socket: " & lngSocket
    Else
        m_blnConnected = True
        m_bytTimer = 0
         
        RaiseEvent Status("connected")
        RaiseEvent Connected

        'get state and host info
        Call SendISI
        Call GetState
        Call GetMulti
    End If
End Sub
Private Sub InSimSocket_Received(ByVal lngSocket As Long, Data() As Byte, ByVal lngLength As Long)
    Dim i As Byte, bytInfo As Byte
                    
    If lngSocket <> m_lngInSimClient Then
        Debug.Print "InSimSocket_Received: unknown socket: " & lngSocket
    Else
        'RaiseEvent DataReceived(Data, lngLength)

        If Not m_blnConnected Then
            Debug.Print "InSimSocket_Received: not connected?"
        Else
            m_bytTimer = 0        'reset timeout
            
            Debug.Print "InSimSocket_Received - Size:" & Data(0) & "/" & lngLength & " Type:" & Data(1) & " ReqI:" & Data(2)
            
            'parse packet depending on ID
            Select Case Data(1)
                Case ISP_VER '// VERsion
                    Dim lngVersion As Long
                    
                    lngVersion = BytesWordToLong(Data, 18)
                    If lngVersion < 4 Then RaiseEvent Status("InSim version is less than 4. Get LFS S2 W17 or later!")
                    RaiseEvent Version(BytesToString(Data, 4, 8), BytesToString(Data, 12, 6), lngVersion)
                Case ISP_TINY
                    Select Case Data(3)
                        Case TINY_NONE: Call SendTiny(TINY_NONE) 'LFS pinging us, send acknowledgement
                        Case TINY_MPE: RaiseEvent MultiLeave
                        Case TINY_VTC: RaiseEvent VoteCancel
                        Case TINY_CLR: RaiseEvent RaceClear
                        Case TINY_REN: RaiseEvent RaceEnd
                    End Select
                Case ISP_SMALL
                    Select Case Data(3)
                        Case SMALL_VTA: RaiseEvent VoteAction(BytesUnsignedToDouble(Data, 4))
                        Case SMALL_RTP: RaiseEvent RaceTime(BytesUnsignedToDouble(Data, 4))
                    End Select
                Case ISP_STA '// STAte
                    RaiseEvent StateChanged(BytesFloatToSingle(Data, 4), BytesWordToLong(Data, 8), Data(10), Data(11), Data(12), _
                        Data(13), Data(14), Data(15), Data(16), Data(17), BytesToString(Data, 20, 6), Data(26), Data(27))
                Case ISP_CPP
                    RaiseEvent CameraPosition(BytesIntToLong(Data, 4), BytesIntToLong(Data, 8), BytesIntToLong(Data, 12), BytesWordToLong(Data, 16), BytesWordToLong(Data, 18), _
                        BytesWordToLong(Data, 20), Data(22), Data(23), BytesFloatToSingle(Data, 24), BytesWordToLong(Data, 28), BytesWordToLong(Data, 30))
                Case ISP_ISM '// InSim Multi
                    RaiseEvent MultiJoin(Data(4), BytesToString(Data, 8, 32))
                Case ISP_MSO '// MSg Out : system messages and user messages
                    RaiseEvent MessageOut(Data(4), Data(5), Data(6), Data(7), BytesToString(Data, 8, 128))
                Case ISP_III '// InsIm Info : 64 chars - /i message from user to host's InSim
                    RaiseEvent MessageInfo(Data(4), Data(5), BytesToString(Data, 8, 64))
                Case ISP_VTN '// VoTe Notify
                    RaiseEvent VoteNotify(Data(4), Data(5))
                Case ISP_RST '// Race STart
                    RaiseEvent RaceStart(Data(4), Data(5), Data(6), BytesToString(Data, 8, 6), Data(14), Data(15), BytesWordToLong(Data, 16), _
                        BytesWordToLong(Data, 18), BytesWordToLong(Data, 20), BytesWordToLong(Data, 22), BytesWordToLong(Data, 24))
                Case ISP_NCN '// New ConN
                    RaiseEvent ConnectionNew(Data(3), BytesToString(Data, 4, 24), BytesToString(Data, 28, 24), Data(52), Data(53))
                Case ISP_CNL '// ConN Leave
                    RaiseEvent ConnectionLeave(Data(3), Data(5))
                Case ISP_CPR '// Conn Player Rename
                    RaiseEvent ConnectionRename(Data(3), BytesToString(Data, 4, 24), BytesToString(Data, 28, 8))
                Case ISP_NPL '// New PLayer joining race (if PLID already exists, then leaving pits)
                    RaiseEvent PlayerNew(Data(3), Data(4), Data(5), BytesWordToLong(Data, 6), BytesToString(Data, 8, 24), BytesToString(Data, 32, 8), _
                        BytesToString(Data, 40, 4), BytesToString(Data, 44, 16), Data(60), Data(61), Data(62), Data(63), Data(64), Data(65), Data(67), Data(73))
                Case ISP_PLP '// PLayer Pits (go to settings - stays in player list)
                    RaiseEvent PlayerGarage(Data(3))
                Case ISP_PLL '// PLayer Leave race (spectate - removed from player list)
                    RaiseEvent PlayerLeave(Data(3))
                Case ISP_LAP '// LAP time
                    RaiseEvent PlayerLap(Data(3), BytesMSHTToSeconds(Data, 4), BytesWordToLong(Data, 8), BytesWordToLong(Data, 10), Data(13), Data(14))
                Case ISP_SPX '// SPlit X time
                    RaiseEvent PlayerSplit(Data(3), BytesMSHTToSeconds(Data, 4), Data(8), Data(9), Data(10))
                Case ISP_PIT '// PIT stop (stop at pit garage)
                    RaiseEvent PlayerPitStop(Data(3), BytesWordToLong(Data, 4), BytesWordToLong(Data, 6), Data(9), Data(10), _
                        Data(12), Data(13), Data(14), Data(15), BytesUnsignedToDouble(Data, 16))
                Case ISP_PSF '// Pit Stop Finished
                    RaiseEvent PlayerPitStopFinished(Data(3), BytesMSHTToSeconds(Data, 4))
                Case ISP_PLA '// Pit LAne
                    RaiseEvent PlayerPitLane(Data(3), Data(4))
                Case ISP_CCH '// Camera CHange
                    RaiseEvent PlayerCameraChange(Data(3), Data(4))
                Case ISP_PEN '// PENalty (given or cleared)
                    RaiseEvent PlayerPenalty(Data(3), Data(4), Data(5), Data(6))
                Case ISP_TOC '// Take Over Car
                    RaiseEvent PlayerTakeOverCar(Data(3), Data(4), Data(5))
                Case ISP_FLG '// FLaG (yellow or blue flag changed)
                    RaiseEvent PlayerRaceFlag(Data(3), Data(4), Data(5), Data(6))
                Case ISP_PFL '// Player FLags (help flags changed)
                    RaiseEvent PlayerFlagChanged(Data(3), BytesWordToLong(Data, 4))
                Case ISP_FIN '// FINished race notification (not a final result - use IS_RES)
                    RaiseEvent PlayerFinished(Data(3), BytesMSHTToSeconds(Data, 4), BytesMSHTToSeconds(Data, 8), Data(12), Data(13), Data(14), BytesWordToLong(Data, 16), BytesWordToLong(Data, 18))
                Case ISP_RES '// RESult (qualify or confirmed finish)
                    RaiseEvent PlayerResult(Data(3), BytesToString(Data, 4, 24), BytesToString(Data, 28, 24), BytesToString(Data, 52, 8), BytesToString(Data, 60, 4), _
                        BytesMSHTToSeconds(Data, 64), BytesMSHTToSeconds(Data, 68), Data(72), Data(73), Data(74), BytesWordToLong(Data, 76), BytesWordToLong(Data, 78), Data(80), Data(81))
                Case ISP_REO '// REOrder (when race restarts after qualifying)
                    Dim bytPLIDs(0 To 31) As Byte
                    
                    Call CopyMemory(bytPLIDs(0), Data(4), 32)
                    RaiseEvent RaceReOrder(Data(3), bytPLIDs)
                Case ISP_NLP '// Node and Lap Packet
                    For i = 0 To 31
                        bytInfo = 4 + (i * 4)
                
                        With NLPInfo(i)
                            .lngNode = BytesWordToLong(Data, bytInfo) And 8191
                            .lngLap = Data(bytInfo + 2) Or ((BytesWordToLong(Data, bytInfo) And 57344) \ 8192)
                            .bytPLID = Data(bytInfo + 3)
                        End With
                    Next i
                    
                    RaiseEvent NodeLap(Data(3))
                Case ISP_MCI '// Multi Car Info - if more than 8 in race then more than one of these is sent
                    For i = 0 To 7
                        bytInfo = 4 + (i * 28)
                
                        With MCIInfo(i)
                            .lngNode = BytesWordToLong(Data, bytInfo)
                            .lngLap = BytesWordToLong(Data, bytInfo + 2)
                            .bytPLID = Data(bytInfo + 4)
                            .lngX = BytesIntToLong(Data, bytInfo + 8)
                            .lngY = BytesIntToLong(Data, bytInfo + 12)
                            .lngZ = BytesIntToLong(Data, bytInfo + 16)
                            .lngSpeed = BytesWordToLong(Data, bytInfo + 20)
                            .lngDirection = BytesWordToLong(Data, bytInfo + 22)
                            .lngHeading = BytesWordToLong(Data, bytInfo + 24)
                            Call CopyMemory(.intAngVel, Data(bytInfo + 26), 2)    'C++ short to VB6 integer, both 2 byte signed, so just copy
                        End With
                    Next i
                    
                    RaiseEvent MultiCarInfo(Data(3))
                Case Else
                    RaiseEvent Status("Unknown packet!? First 10 chars: " & BytesToString(Data, 0, 10) & "...")
            End Select
        End If
    End If
End Sub
Private Sub InSimSocket_Closed(ByVal lngSocket As Long)
    If lngSocket <> m_lngInSimClient Then
        Debug.Print "InSimSocket_Connected: unknown socket: " & lngSocket
    Else
        m_blnConnected = True
        m_bytTimer = 0

        RaiseEvent Status("disconnected")
        RaiseEvent Disconnected
    End If
End Sub

'helper functions to convert InSim data one way or another
Private Sub StringToBytes(bytData() As Byte, ByVal strString As String, ByVal intStart As Integer, ByVal intLength As Integer)
    Dim i As Integer
    
    On Error GoTo StringToBytesErr
    
    For i = 1 To intLength
        bytData(intStart - 1 + i) = Asc(Mid$(strString, i, 1))
    Next
    
StringToBytesErr:
    'silent error, for now
End Sub

Private Sub LongToWordBytes(bytData() As Byte, ByVal lngWord As Long, ByVal intStart As Integer)
    bytData(intStart) = lngWord Mod 256
    bytData(intStart + 1) = lngWord \ 256
End Sub

Private Function BytesToString(bytData() As Byte, ByVal intStart As Integer, ByVal intLength As Integer) As String
    Dim i As Integer, strString As String
    
    'copy the bytes
    For i = 0 To intLength - 1
        If bytData(intStart + i) = 0 Then
            Exit For
        Else
            strString = strString & Chr$(bytData(intStart + i))
        End If
    Next i
    
    'remove lfs codes, colors first
    For i = 0 To 9
        strString = Replace(strString, "^" & i, "")
    Next i
    
    'special LFS characters
    strString = Replace(strString, "^a", "*")
    strString = Replace(strString, "^c", ":")
    strString = Replace(strString, "^d", "\")
    strString = Replace(strString, "^l", "<")
    strString = Replace(strString, "^q", "?")
    strString = Replace(strString, "^r", ">")
    strString = Replace(strString, "^s", "/")
    strString = Replace(strString, "^t", """")  'double quote
    strString = Replace(strString, "^v", "|")
    
    'language codes
    strString = Replace(strString, "^L", "")    'Latin 1
    strString = Replace(strString, "^G", "")    'Greek
    strString = Replace(strString, "^C", "")    'Cyrillic
    strString = Replace(strString, "^J", "")    'Japanese
    strString = Replace(strString, "^E", "")    'Central Europe
    strString = Replace(strString, "^T", "")    'Turkish
    strString = Replace(strString, "^B", "")    'Baltic
    
    BytesToString = strString
End Function

'convert from a C++ word in a byte array to a long
Private Function BytesWordToLong(bytData() As Byte, ByVal intStart As Integer) As Long
    BytesWordToLong = bytData(intStart) + (CLng(bytData(intStart + 1)) * 256)
End Function

'convert from a C++ float in a byte array to a single
Private Function BytesFloatToSingle(bytData() As Byte, ByVal intStart As Integer) As Single
    Dim sngData As Single
    
    Call CopyMemory(sngData, bytData(intStart), 4)
    
    BytesFloatToSingle = sngData
End Function

'convert from a C++ int in a byte array to a long
Private Function BytesIntToLong(bytData() As Byte, ByVal intStart As Integer) As Long
    Dim lngData As Long
    
    Call CopyMemory(lngData, bytData(intStart), 4)
    
    BytesIntToLong = lngData
End Function

'convert from a C++ unsigned in a byte array to a double
Private Function BytesUnsignedToDouble(bytData() As Byte, ByVal intStart As Integer) As Double
    BytesUnsignedToDouble = bytData(intStart) + (CDbl(bytData(intStart + 1)) * 256) + (CDbl(bytData(intStart + 2)) * 65536) + (CDbl(bytData(intStart + 3)) * 16777216)
End Function

'convert from a LFS MSHT (thousandths not included) to seconds
Private Function BytesMSHTToSeconds(bytData() As Byte, ByVal intStart As Integer) As Single
    Dim sngSeconds As Single

    sngSeconds = bytData(intStart) * 60                     'minutes
    sngSeconds = sngSeconds + bytData(intStart + 1)         'seconds
    sngSeconds = sngSeconds + (bytData(intStart + 2) / 100) 'hundreths

    BytesMSHTToSeconds = sngSeconds
End Function
