<?php

/* Pringles Autocross Control script 
version:	0.1a

features:
- join lock: joining is prevented for a period of time when someone joins, this is to
a) prevent multiple cars from joining at the same time, inside each other
b) allow more time than the countdown for a driver to get enough space for a clean run
- automated spectate on:
a) pitting, this is to prevent race slot hogging
b) finish, to prevent race slot hogging and idiots interfering with other drivers after their run
- restart prevention: restart votes are cancelled automatically

/* Any changes to configuration via editing this file requires a script restart.
Configuration changes done via in-game commands do not require a script restart */

/* Connection Configuration */
$ip = ''; // LFS server's IP address
$port = 29999; // InSim port of your server
$admin = ''; // admin password for the server

/* Script Configuration
All of these settings can be changed via in-game commands, format: '!pax command value'
E.g.: !pax startdelay 15 / !pax silent 1 / !pax votelock 0 */
$startdelay = 10; // time in seconds during which join is prevented, when someone joins
$votelock = 1; // 0: restart votes allowed; 1: restart votes not allowed
$pitspec = 1; // 0: pitting allowed; 1: pitting not allowed (player spectated)
$finishspec = 1; // 0: players are not automatically spectated after finishing their run
			// 1: players are automatically spectated after finishing their run
$specmsg = 1; // 0: autospec messages disabled; 1: autospec messages enabled
$joinmsg = 1; // "Join Allowed" and "Join Not Allowed" messages, 0: disabled; 1: enabled

/* Code starts here, do not modify unless you know what you're doing! */

// setup socket
$sock = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);

// connect to insim
socket_connect($sock, $ip, $port);
socket_set_nonblock($sock);
socket_write($sock, pack('CCCCSSCCSa16a16', 44, 1, 0, 0, NULL, 0, 0, NULL, 0, $admin, 'paxctrl'));

// request all connections and players
socket_write($sock, pack('CCCC', 4, 3, 1, 13));
socket_write($sock, pack('CCCC', 4, 3, 1, 14));

// connection and player info
$guests = array();

/* joining disallowed when a player joins the race, allowed if: 
- last player to join, leaves
- $stardelay sec has passed */
$joinlock = FALSE;

$r = array($sock);
$w = NULL;
$e = NULL;
$t = NULL;

while(TRUE) {	
	$do = $r;
	/* if $startdelay sec has passed from join being disallowed, and is still disallowed, allow it */
	if($joinlock) {
		if(time()-$joinlock['stamp'] >= $startdelay) {
			$joinlock = FALSE;
			if($joinmsg) socket_write($sock, pack('CCCCa64', 68, 13, 0, 0, str_pad('/msg Join Allowed', 64, "\0")));
		}
	}
	if(socket_select($do, $w, $e, 0, 200)) {
		while($data = socket_read($sock, 4)) {
			$header = unpack('Csize/Ctype/Creqi/Cdata', $data);
			$data = socket_read($sock, $header['size'] - 4);
			
			switch($header['type']) {
			case 3: // TINY, keep-alive
				if($header['reqi'] === 0 && $header['data'] === 0) {
					socket_write($sock, pack('CCCC', 4, 3, 0, 0));
				}
				break;
		
			case 35: // RES
				$name = unpack('a24uname', substr($data, 0, 24));
				if($finishspec) autospec($name['uname']);
				break;
		
			case 22: // PLP
				echo "\r\npit";
				foreach($guests as $guest) {
					if($guest['plid'] == $header['data']) {
						if($pitspec) autospec($guest['uname']);
					}
				}
				break;
		
			case 21: // NPL
				if(($header['reqi'] == $header['data']) && $header['reqi'] !== 0) {
					foreach($guests as $guest) {
						if($guest['ucid'] == $ucid['val']) {
							autospec($guest['uname']);
						}
					}
				} else {
					if($joinlock) {
						$ucid = unpack('Cval', substr($data, 0, 1));
						foreach($guests as $guest) {
							if($guest['ucid'] == $ucid['val']) {
								autospec($guest['uname']);
							}
						}
					} else {
						$ucid = unpack('Cval', substr($data, 0, 1));
						foreach($guests as $guest) {
							if($guest['ucid'] == $ucid['val']) {
								$guests[$guest['uname']]['plid'] = $header['data'];
								$joinlock = array('plid' => $header['data'],
									'stamp' => time());
								if($joinmsg) socket_write($sock, pack('CCCCa64', 68, 13, 0, 0, str_pad('/msg Join Not Allowed', 64, "\0")));
								break;
							}
						}
					}
				}
				break;
		
			case 16: //VOTE
				if($votelock) socket_write($sock, pack('CCCC', 4, 3, 0, 5));
				break;
		
			case 25: //SPLIT
				
			break;
		
			case 18: //NCN
				$conn = unpack('a24uname/a24pname/Cadmin', substr($data, 0, 49));
				$guests[$conn['uname']] = array('uname' => $conn['uname'],
										'pname' => $conn['pname'],
										'ucid' => $header['data'],
										'admin' => $conn['admin'],
										'plid' => FALSE);
				break;
		
			case 19:
				echo "\r\ncnl";
				foreach($guests as $guest) {
					if($guest['ucid'] == $header['data']) {
						unset($guests[$guest['uname']]);
						break;
					}
				}
				break;
			
			case 23:
				foreach($guests as $guest) {
					if($guest['plid'] == $header['data']) {
						$guest['plid'] = NULL;
						if($joinlock) {
							if($joinlock['plid'] == $header['data']) {
								$joinlock = FALSE;
								if($joinmsg) socket_write($sock, pack('CCCCa64', 68, 13, 0, 0, str_pad('/msg Join Allowed', 64, "\0")));
							}
						}
						break;
					}
				}
				break;
			
			case 20: // rename
				$pname = unpack('a24val', substr($data, 0, 24));
				foreach($guests as $guest) {
					if($guest['ucid'] == $header['data']) {
						$guests[$guest['uname']]['pname'] = $pname['val'];
						break;
					}
				}
				break;
			
			case 11: // MSO
				$mso = unpack('Cucid/Cplid/Cusertype/Ctextstart/a128msg', $data);
				if(substr($mso['msg'], $mso['textstart'], 4) == '!pax') {
					//commands
					foreach($guests as $guest) {
						if($guest['ucid'] == $mso['ucid'] && $guest['admin'] == 1) {
							$pax = explode(' ', substr($mso['msg'], $mso['textstart']));
							$$pax[1] = $pax[2];
							socket_write($sock, pack('CCCCCCCCa64', 72, 14, 0, 0, $mso['ucid'], $mso['plid'], 0, 0, str_pad($pax[1] . '=' . $pax[2], "\0")));
						}
					}
				}
				break;
		
			default:
				//echo "\r\nunk : " . $header['type'];
				break;
			}
		}
	}
}

socket_close($sock);

function autospec($name) {
	global $sock, $specmsg;
	socket_write($sock, pack('CCCCa64', 68, 13, 0, 0, str_pad("/spec $name", 64, "\0")));
	if($specmsg) socket_write($sock, pack('CCCCa64', 68, 13, 0, 0, str_pad("/msg autospec : $name", 64, "\0")));
}

?>