VERSION 5.00
Begin VB.Form frmMain 
   AutoRedraw      =   -1  'True
   BorderStyle     =   1  'Fixed Single
   Caption         =   "pth Reader.."
   ClientHeight    =   3360
   ClientLeft      =   45
   ClientTop       =   375
   ClientWidth     =   4680
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3360
   ScaleWidth      =   4680
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton cmdPrev 
      Caption         =   "<- Prev"
      Enabled         =   0   'False
      Height          =   375
      Left            =   1200
      TabIndex        =   5
      Top             =   2880
      Width           =   735
   End
   Begin VB.CommandButton cmdNext 
      Caption         =   "Next! ->"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3720
      TabIndex        =   4
      Top             =   2880
      Width           =   855
   End
   Begin VB.TextBox txtNode 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   315
      Left            =   2160
      TabIndex        =   3
      Top             =   2910
      Width           =   615
   End
   Begin VB.CommandButton cmdOpen 
      Caption         =   "Open ..."
      Height          =   375
      Left            =   120
      TabIndex        =   1
      Top             =   2880
      Width           =   975
   End
   Begin VB.TextBox txtOut 
      Height          =   2655
      Left            =   1200
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   120
      Width           =   3375
   End
   Begin VB.Label lblHeader 
      Height          =   1935
      Left            =   120
      TabIndex        =   6
      Top             =   120
      Width           =   975
   End
   Begin VB.Label lblCount 
      Height          =   255
      Left            =   2880
      TabIndex        =   2
      Top             =   2955
      Width           =   615
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'num   unit    offset  description
'---   ----    ------  -----------
'HEADER BLOCK:
'6     char    0       LFSPTH              : do not read file if no match
'1     byte    6       version             : 0 - do not read file if > 0
'1     byte    7       revision            : 0 - do not read file if > 0
'1     int     8       num nodes           : number
'1     int     12      finish line         : number
'......NODE BLOCKS
Private Type pthHeader
    LFSPTH(5) As Byte
    version As Byte
    revision As Byte
    num_nodes As Long
    finish_line As Long     'int in C is long in VB6
End Type

'NODE BLOCK:
'1     int     0       centre X            : fp
'1     int     4       centre Y            : fp
'1     int     8       centre Z            : fp
'1     float   12      dir X               : float
'1     float   16      dir Y               : float
'1     float   20      dir Z               : float
'1     float   24      limit left          : outer limit
'1     float   28      limit right         : outer limit
'1     float   32      drive left          : road limit
'1     float   36      drive right         : road limit
Private Type pthNode
    centreX As Long
    centreY As Long
    centreZ As Long
    dirX As Single          'float in C is single in VB6
    dirY As Single
    dirZ As Single
    limit_left As Single
    limit_right As Single
    drive_left As Single
    drive_right As Single
End Type

Private thePath As String
Private Nodes() As pthNode

Private Sub cmdOpen_Click()
    Dim strFile As String

    'common dialog api :)
    If VBGetOpenFileName(strFile, , True, , True, True, "Path files (*.pth)|*.pth|All files (*.*)|*.*", , thePath, "Open path file..", "pth", Me.hWnd) Then
        Call ReadFile(strFile)
    End If
End Sub

Private Sub ReadFile(strFileName As String)
On Error GoTo ReadFileErr
    Dim udtHeader As pthHeader
    Dim intFileNum As Integer, i As Long
    Dim strLFSPTH As String
    
    'set the path correctly in case were in the root
    thePath = App.Path
    If Right(thePath, 1) <> "\" Then thePath = thePath & "\"

    'check file
    If Dir(strFileName) = "" Then
        'file not found, exit
        txtOut.Text = "File not found!"
        Exit Sub
    End If

    'get a free file reference then open the file
    intFileNum = FreeFile
    Open strFileName For Binary Access Read As #intFileNum
        'read in the header
        Get #intFileNum, , udtHeader
        
        With udtHeader
            'validate header
            If StrConv(.LFSPTH, vbUnicode) = "LFSPTH" _
            And .version = 0 And .revision = 0 Then
                'validated, output the header
                lblHeader.Caption = "LFSPTH" & vbNewLine & _
                                    "Version: " & .version & vbNewLine & _
                                    "Revision: " & .revision & vbNewLine & _
                                    "Finish: " & .finish_line & vbNewLine & _
                                    "Nodes: " & .num_nodes
                
                'refresh/size the node array
                ReDim Nodes(.num_nodes)
                
                'read in all the nodes to the array
                For i = 1 To .num_nodes
                    Get #intFileNum, , Nodes(i)
                Next i
                
                'set the total
                lblCount.Caption = "/ " & .num_nodes

                'start from beginning, doing this shows the node
                txtNode.Text = "1"
            Else
                lblHeader.Caption = "Invalid Header"
            End If
        End With
    Close #intFileNum
    
    Exit Sub
ReadFileErr:
    txtOut.Text = "Program ERROR " & Err.Number & ": " & Err.Description
    Close #intFileNum
End Sub

Private Sub cmdPrev_Click()
    Dim lngNode As Long
    
    'get current node
    lngNode = Val(txtNode.Text)
    'if too low, disable prev and exit
    If lngNode <= 1 Then
        cmdPrev.Enabled = False
    Else
        'enable next button
        cmdNext.Enabled = True
        'its fine, decrement
        'doing this calls the _Change event, which shows the new node
        txtNode.Text = lngNode - 1
    End If
End Sub
Private Sub cmdNext_Click()
    Dim lngNode As Long
    
    'get current node
    lngNode = Val(txtNode.Text)
    'if too high, disable next and exit
    If lngNode >= UBound(Nodes) Then
        cmdNext.Enabled = False
    Else
        'enable prev button
        cmdPrev.Enabled = True
        'increment node
        'doing this calls the _Change event, which shows the new node
        txtNode.Text = lngNode + 1
    End If
End Sub

Private Sub ShowNode()
    Dim lngNode As Long
    
    'start fresh
    txtOut.Text = ""
    txtNode.Enabled = True
    cmdPrev.Enabled = True
    cmdNext.Enabled = True
    
    'just output the node info to a text box
    lngNode = Val(txtNode.Text)
    'if too low, show 1
    If lngNode <= 1 Then
        lngNode = 1
        cmdPrev.Enabled = False
    End If
    'if too high, show max
    If lngNode >= UBound(Nodes) Then
        lngNode = UBound(Nodes)
        cmdNext.Enabled = False
    End If
    
    'out put the node
    With Nodes(lngNode)
        txtOut.Text = txtOut.Text & "Node: " & lngNode & vbNewLine
        txtOut.Text = txtOut.Text & "  Centre X: " & CStr(.centreX) & vbNewLine
        txtOut.Text = txtOut.Text & "  Centre Y: " & CStr(.centreY) & vbNewLine
        txtOut.Text = txtOut.Text & "  Centre Z: " & CStr(.centreZ) & vbNewLine
        txtOut.Text = txtOut.Text & "  Dir X: " & CStr(.dirX) & vbNewLine
        txtOut.Text = txtOut.Text & "  Dir Y: " & CStr(.dirY) & vbNewLine
        txtOut.Text = txtOut.Text & "  Dir Z: " & CStr(.dirZ) & vbNewLine
        txtOut.Text = txtOut.Text & "  Limit Left: " & CStr(.limit_left) & vbNewLine
        txtOut.Text = txtOut.Text & "  Limit Right: " & CStr(.limit_right) & vbNewLine
        txtOut.Text = txtOut.Text & "  Drive Left: " & CStr(.drive_left) & vbNewLine
        txtOut.Text = txtOut.Text & "  Drive Right: " & CStr(.drive_right) & vbNewLine
        txtOut.Text = txtOut.Text & vbNewLine
    End With
End Sub

Private Sub txtNode_Change()
    'show the node if its changed
    Call ShowNode
End Sub

Private Sub txtNode_Click()
    'select all the text
    txtNode.SelStart = 0
    txtNode.SelLength = Len(txtNode)
End Sub
