<?php

class Championship {
	function __construct($path, $name, $season) {
		$this->path = $path;
		$this->name = $name;
		$this->season = $season;
		$this->full = "{$path}/{$name}/Season{$season}";
		# XSV Database Vars
		$this->Cars = self::parseXSVFile("{$this->path}/{$this->name}/Season{$this->season}/Cars.csv");
		$this->Constructors = self::parseXSVFile("{$this->path}/{$this->name}/Season{$this->season}/Constructors.csv");
		$this->Drivers = self::parseXSVFile("{$this->path}/{$this->name}/Season{$this->season}/Drivers.csv");
		$this->Races = self::parseXSVFile("{$this->path}/{$this->name}/Season{$this->season}/Races.csv");
		$this->Points = self::parseXSVFile("{$this->path}/{$this->name}/Season{$this->season}/Points.csv");
		# Get Round Results
		foreach ($this->Races as $Race) {
			if (is_dir("{$this->full}/Round{$Race['Round']}")) {
				$this->Rounds[$Race['Round']]['Qual'] = self::ParseXSVFile("{$this->full}/Round{$Race['Round']}/Qual.csv");
				$this->Rounds[$Race['Round']]['Race'] = self::ParseXSVFile("{$this->full}/Round{$Race['Round']}/Race.csv");
			}
		}
	}
	/* Core Methods */
	# XSV Parser
	function parseXSVFile($path, $separator = ',', $firstLineIsHeader = TRUE) {
		foreach (file($path) as $line => $data) {
			if ($line == 0 && $firstLineIsHeader) {
				foreach (split($separator, $data) as $Item => $Key)
					$Keys[$Item] = trim($Key);
			} else {
				foreach (split($separator, $data) as $Item => $Val)
					$Data[$Item] = trim($Val);
				if ($firstLineIsHeader)
					$CSV[] = array_combine($Keys, $Data);
			}
		}
		return $CSV;
	}
	/* Super Methods */
	function makeDriverImage() {
		$Points = $this->getDriverPoints();
		$Keys = array_keys($Points);
		# Create Image
		$img = imagecreatefrompng('./background.png');
		$color['white'] = imagecolorallocate($img, 255, 255, 255);
		$color['black'] = imagecolorallocate($img, 0, 0, 0);
		$font = 3;
		# Place Text On Image;
		$title = "FiA {$this->name} {$this->season} Driver Championship Standings After " . count($this->Rounds). ' Rounds';
		imagestring($img, $font, (imagesx($img) / 2) - ((imagefontwidth($font) * strlen($title)) / 2), 6, $title, $color['white']);
		foreach ($Points as $id => $Point) {
			if (!isset($i)) { $i = 1; } else { $i++; }
			if ($i <= 4) {
				$y = 6 + ($i * 25);
				$x = 10;
			} else {
				$y = 6 + ($i * 25) - 100;
				$x = 235;
			}
			imagestring($img, $font, $x, $y, $i, $color['white']); // Number
			$x += 20;
			imagestring($img, $font, $x, $y, $this->getDriverValById($id, 'NameLong'), $color['black']);
			$x += 150;
			imagestring($img, $font, $x, $y, $Point, $color['white']); // Points
			if ($i == 8) { break; }
		}
		# Save and Release Resource.
		imagepng($img, "{$this->full}/varDrivers.png");
		imagedestroy($img);
	}
	function makeConstructorImage() {
		$Points = $this->getConstructorPoints();
		$Keys = array_keys($Points);
		# Create Image
		$img = imagecreatefrompng('./background.png');
		$color['white'] = imagecolorallocate($img, 255, 255, 255);
		$color['black'] = imagecolorallocate($img, 0, 0, 0);
		$font = 3;
		# Place Text On Image;
		$title = "FiA {$this->name} {$this->season} Constructor Championship Standings After " . count($this->Rounds). ' Rounds';
		imagestring($img, $font, (imagesx($img) / 2) - ((imagefontwidth($font) * strlen($title)) / 2), 6, $title, $color['white']);
		for ($i = 1; $i <= 8; $i++) {
			if ($i <= 4) {
				$y = 6 + ($i * 25);
				$x = 10;
			} else {
				$y = 6 + ($i * 25) - 100;
				$x = 235;
			}
			imagestring($img, $font, $x, $y, $i, $color['white']); // Number
			$x += 20;
			imagestring($img, $font, $x, $y, $this->getConstructorValById($Keys[($i - 1)], 'NameShort'), $color['black']);
			$x += 150;
			imagestring($img, $font, $x, $y, $Points[$Keys[($i - 1)]], $color['white']); // Points
		}
		# Save and Release Resource.
		imagepng($img, "{$this->full}/varConstructors.png");
		imagedestroy($img);
	}
	// SubHelper Methods
	# Driver
	function getDriverById($id) {
		foreach ($this->Drivers as $Info) {
			if ($Info['Id'] == $id) {
				return $Info;
			}
		}
		return FALSE;
	}
	function getDriverValById($id, $val) {
		if (($Driver = $this->GetDriverById($id)) !== FALSE) {
			if (isset($Driver[$val])) {
				return $Driver[$val];
			}
		}
		return FALSE;
	}
	# Constructor
	function getConstructorById($id) {
		foreach ($this->Constructors as $Info) {
			if ($Info['Id'] == $id) {
				return $Info;
			}
		}
		return FALSE;
	}
	function getConstructorValById($id, $val) {
		if (($Constructor = $this->GetConstructorById($id)) !== FALSE) {
			if (isset($Constructor[$val])) {
				return $Constructor[$val];
			}
		}
		return FALSE;
	}
	function getConstructorByDriverId($dId) {
		foreach ($this->Cars as $Info) {
			if ($Info['DriverId'] == $dId) {
				return $Info['ConstructorId'];
			}
		}
	}
	/* Get Points */
	# Get Driver Points
	function getDriverPoints() {
		foreach ($this->Rounds as $Round => $Info) {
			foreach ($Info['Race'] as $Place) {
				$Points[$Place['No']] += $this->Points[$Place['Pos'] - 1]['Points'];
			}
		}
		arsort($Points);
		return $Points;
	}
	# Get Constructor Points
	function getConstructorPoints() {
		foreach ($this->Rounds as $Round => $Info) {
			foreach ($Info['Race'] as $Place) {
				$Points[$this->getConstructorByDriverId($Place['No'], 'ConstructorId')] += $this->Points[$Place['Pos'] - 1]['Points'];
			}
		}
		arsort($Points);
		return $Points;
	}
	function __destruct() {
	}
}

?>