;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; FlipCams 1.0.2                                                     ;
;  2007-2008 Philippe Martin                                        ;
;                                                                    ;
; Source code released for information only. Please don't distribute ;
; edited versions without my authorization.                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


flDebug = 0
flParam = 0
flStarted = 0
flFinished = 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; make sure we're inside the LFS folder ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

IfNotExist data\views
	Gosub,ERROR1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; check if the parameter is present ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

If 0 < 1 ; the variable 0 contains the number of passed parameters
{
	; launched by double-click (no param)
	If flDebug = 1
	{
		; fake the parameter
		1 = cam2
		flParam = 1
	}
} 
Else 
{
	; launched by LFS (param present)
	flParam = 1
}

;;;;;;;;;;;;;;;;;;;;;
; get the parameter ;
;;;;;;;;;;;;;;;;;;;;;

If flParam = 1
{
	; the variable 1 contains the first passed parameter
	param = %1% 
}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; determine the current set ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

flCam1 = 1
flCam2 = 1
flCam3 = 1
flCam4 = 1
flCam5 = 1

IfExist data\views_cam1
	flCam1 = 0
IfExist data\views_cam2
	flCam2 = 0
IfExist data\views_cam3
	flCam3 = 0
IfExist data\views_cam4
	flCam4 = 0
IfExist data\views_cam5
	flCam5 = 0

If flDebug = 1
{
	ListVars
	Pause
}

;;;;;;;;;;;;;;;;;;;;;
; check the folders ;
;;;;;;;;;;;;;;;;;;;;;

If flCam1 = 0 
	IF flCam2 = 0
		IF flCam3 = 0
			IF flCam4 = 0
				IF flCam5 = 0
					Gosub,ERROR3 ; all the folders exist
If flCam1 = 1 
	IF flCam2 = 1
		IF flCam3 = 1
			IF flCam4 = 1
				IF flCam5 = 1
					If flParam = 1 
					{
						Gosub,ERROR4 ; none of the folders exist (called from lfs)
					}
					Else 
					{
						Gosub,ERROR5 ; none of the folders exist (launched by 2-click)
					}
					
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; do the switching, or not ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;

If flParam
	Gosub,SWITCH1
Else
	Gosub,ERROR2


;;;;;;;;;;;;;;;;;;;;;;
;;;  subfonctions  ;;;
;;;;;;;;;;;;;;;;;;;;;;

SWITCH1:
	; rename view into views_cam*

	If flDebug = 1
		MsgBox,0,FlipCams,Entering switch1
	
	If flCam1 = 1
	{
		FileMoveDir,data\views,data\views_cam1
		flStarted = 1
		Gosub,SWITCH2
	}
	If flCam2 = 1
	{
		FileMoveDir,data\views,data\views_cam2
		flStarted = 1
		Gosub,SWITCH2
	}
	If flCam3 = 1
	{
		FileMoveDir,data\views,data\views_cam3
		flStarted = 1
		Gosub,SWITCH2
	}
	If flCam4 = 1
	{
		FileMoveDir,data\views,data\views_cam4
		flStarted = 1
		Gosub,SWITCH2
	}
	If flCam5 = 1
	{
		FileMoveDir,data\views,data\views_cam5
		flStarted = 1
		Gosub,SWITCH2
	}

	If flDebug = 1
		MsgBox,0,FlipCams,Exiting switch1


SWITCH2:
	; rename views_cam* into views
	
	If flDebug = 1
		MsgBox,0,FlipCams,Entering switch2
	
	If param = cam1
	{
		IfExist data\views_cam1
		{
			FileMoveDir,data\views_cam1,data\views
			flFinished = 1
		}
	}
	If param = cam2
	{
		IfExist data\views_cam2
		{
			FileMoveDir,data\views_cam2,data\views
			flFinished = 1
		}
	}
	If param = cam3
	{
		IfExist data\views_cam3
		{
			FileMoveDir,data\views_cam3,data\views
			flFinished = 1
		}
	}
	If param = cam4
	{
		IfExist data\views_cam4
		{
			FileMoveDir,data\views_cam4,data\views
			flFinished = 1
		}
	}
	If param = cam5
	{
		IfExist data\views_cam5
		{
			FileMoveDir,data\views_cam5,data\views
			flFinished = 1
		}
	}

	If flDebug = 1
	{
		ListVars
		Pause
	}

	; check that everything went fine
	If flStarted = 1
	{
		If flFinished = 0
		{
			Gosub,ERROR6
		}
	}
	
	If flDebug = 1
		MsgBox,0,FlipCams,Exiting switch2
	
	Gosub,END

ERROR1:
	MsgBox,0,FlipCams,Error:`nThis application must be in LFS' folder (at the same level as the data folder).`nIf this is the case, make sure the data\views folder exists.
	Gosub,END

ERROR2:
	MsgBox,0,FlipCams,Error:`nFlipCams is intended to be launched from LFS. 
	Gosub,END

ERROR3:
	; all the views_cam* folders exist at once
	MsgBox,0,FlipCams,Error:`nCannot determine the current view. Make sure LFS's data folder contain the "views"`nfolder and four "views_cam*" folders.
	Gosub,END

ERROR4:
	; called from LFS but views_cam folders weren't found
	MsgBox,1,FlipCams,Error:`nThe required folders weren't found. Do you wish FlipCams to create them? (this will`nbe done by duplicating the current views folder).
	IfMsgBox,OK
		Gosub,INIT
	Else
		Gosub,END

ERROR5:
	; called by double-click
	MsgBox,1,FlipCams,The required folders weren't found. Do you wish FlipCams to create them? (this will be done`nby duplicating the current views folder).
	IfMsgBox,OK
		Gosub,INIT
	Else
		Gosub,END
	
ERROR6:
	; the views folder was renamed but wasn't replaced, and we don't want to leave the user without a views folder.
	IfExist data\views_cam1
	{
		FileMoveDir,data\views_cam1,data\views
	}
	Else
	{
		IfExist data\views_cam2
		{
			FileMoveDir,data\views_cam2,data\views
		}
		Else
		{
			IfExist data\views_cam3
			{
				FileMoveDir,data\views_cam3,data\views
			}
			Else
			{
				IfExist data\views_cam4
				{
					FileMoveDir,data\views_cam4,data\views
				}
				Else
				{
					IfExist data\views_cam5
					{
						FileMoveDir,data\views_cam5,data\views
					}
				}
			}
		}
	}
	MsgBox,0,FlipCams,Error: One or several views_cam* folders are missing and will be created by duplicating`nyour current views folder.
	Gosub,INIT

INIT:
	n = 0
	IfNotExist data\views_cam2
	{
		FileCopyDir,data\views,data\views_cam2
		n := %n% + 1
	}
	IfNotExist data\views_cam3
	{
		FileCopyDir,data\views,data\views_cam3
		n := %n% + 1
	}
	IfNotExist data\views_cam4
	{
		FileCopyDir,data\views,data\views_cam4
		n := %n% + 1
	}
	IfNotExist data\views_cam5
	{
		FileCopyDir,data\views,data\views_cam5
		n := %n% + 1
	}
	MsgBox,0,FlipCams,%n% new views_cam* folder(s) have been created.
	Gosub,END

END:
	If flDebug = 1
		MsgBox,0,FlipCams,Exiting.
		
ExitApp