<?php

define('FOGREAR',   1048576);
define('FOGFRONT',  2097152);
define('EXTRA',     4194304);

function PIE_settings()
  {
    return array('flags'            => ISF_LOCAL,
                 'insimname'        => 'DriftLights',
                 'outgaugehost'     => '127.0.0.1',
                 'outgaugeport'     => 49999);
  }
  
function PIE_start()
  {
    $PIE = PIE::connect();     
    $PIE->set('thresholdthrottle',  0.1);
    $PIE->set('thresholdclutch',    0.1);    
    $PIE->set('lastlights',         0);
    $PIE->set('lastoutgauge',       0);
  }
  
function PIE_OutGauge($data)
  {
    $PIE = PIE::connect();
    
    // skip delayed packets
    $lasttime   = $PIE->get('lastoutgauge');
    $thistime   = $data['Time'];        
    if ($lasttime > $thistime)
      return;
    $PIE->set('lastoutgauge', $thistime);
    
    // skip in replay above 2x speed (anti-lag / anti-crash)
    $STA = $PIE->get('PIE_STA');
    if (!empty($STA['ReplaySpeed']) && ($STA['ReplaySpeed'] > 2))
      return;
    
    // get data
    $throttle   = ($data['Throttle']  > $PIE->get('thresholdthrottle'));
    $clutch     = ($data['Clutch']    > $PIE->get('thresholdclutch'));
    $handbrake  = (bool)($data['ShowLights'] & 4);
    
    // calculate lights
    $lights = 112; // 112 = enable ffog/rfog/extra, ignore others
    if ($throttle)  $lights |= FOGREAR;    
    if ($clutch)    $lights |= FOGFRONT;    
    if ($handbrake) $lights |= EXTRA;
    
    // skip if no change
    if ($lights == $PIE->get('lastlights'))
      return;
    
    // set lights
    $PIE->set('lastlights', $lights);
    PIE_sendSMALL(SMALL_LCL, $lights);
  }   

