/*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using WebCamService;
using System.Threading;
using System.IO;


public class ThreadUpload
{
		private string server = "localhost";
		private string remotePath = ".";
		private string username = "anonymous";
        private string password = "anonymous@anonymous.net";
        private string filename = "Filename";
        private string filenameDest = "Filename";
        private Object thisLock = new Object();
        private Mutex myMutex;  

	// Constructeur
    public ThreadUpload(string server, string remotePath, string username, string password, string filename, Mutex mut )
	{
		this.server = server;
		this.remotePath = remotePath;
		this.username = username;
		this.password = password;
		this.filename = filename;
        this.filenameDest = Path.GetDirectoryName( filename ) + Path.DirectorySeparatorChar + "TMP" + Path.GetFileName(filename);
        this.myMutex = mut ;


	}
	
	// Mthode boucle du thread
	public void UpLoad()
	{
        lock (thisLock)
        {
            // RENAME WITH Mutex
                if (myMutex.WaitOne())
                {
                    try
                    {
                        File.Copy(filename, filenameDest, true);
                    }
                    catch (Exception e)
                    {
                        Console.WriteLine("Caught Error ftp.Copy:" + e.Message);
                        System.Threading.Thread.Sleep(200);
                        return;
                    }
                    finally
                    {
                        myMutex.ReleaseMutex();
                    }
                }
            //UPLOAD
                FtpClient ftp = new FtpClient(this.server, this.username, this.password);
                ftp.RemotePath = this.remotePath;
                try
                {
                    ftp.Login();
                }
                catch (Exception e)
                {
                    Console.WriteLine("Caught Error ftp.login:" + e.Message);
                    return;
                }
                try
                {
                    // Upload Temp file to FTP
                    ftp.Upload(this.filenameDest, this.filename);
                }
                catch (Exception e)
                {
                    Console.WriteLine("Caught Error ftp.Upload:" + e.Message);
                    System.Threading.Thread.Sleep(200);
                }
                finally
                {
                    File.Delete(this.filenameDest);
                }
                try
                {
                    ftp.Close();
                }
                catch (Exception e)
                {
                    Console.WriteLine("Caught Error ftp.Close:" + e.Message);
                    System.Threading.Thread.Sleep(200);
                }
       }
    }
}