/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
namespace LFSLapper
{
    partial class LFSClient
    {
        void OnPenalties(infoPlayer currInfoPlayer, InSim.Decoder.PEN pen)
        {
            string action ="";
            switch (pen.Reason)
            {
                case ((int)InSim.penr.PENR_FALSE_START):
                    if (pen.NewPen == (int)(InSim.pen.PENALTY_30) || pen.NewPen == (int)(InSim.pen.PENALTY_DT))
                    {
                        action = "OnFalseStartL1";
                    }
                    if (pen.NewPen == (int)(InSim.pen.PENALTY_45) || pen.NewPen == (int)(InSim.pen.PENALTY_SG))
                    {
                        action = "OnFalseStartL2";
                    }
                    break;
                case ((int)InSim.penr.PENR_SPEEDING):
                    if (pen.NewPen == (int)(InSim.pen.PENALTY_30) || pen.NewPen == (int)(InSim.pen.PENALTY_DT))
                    {
                        action = "OnFastDriveOnPitL1";
                    }
                    if (pen.NewPen == (int)(InSim.pen.PENALTY_45) || pen.NewPen == (int)(InSim.pen.PENALTY_SG))
                    {
                        action = "OnFastDriveOnPitL2";
                    }
                    currInfoPlayer.NbFastDriveOnPit++;
                    if (currInfoPlayer.NbFastDriveOnPit >= newCfg.varsLapper.MaxFastDriveOnPit)
                        action = "OnMaxFastDriveOnPit";
                    break;
                default:
//                    Console.WriteLine("Penalty not catched " + Enum.GetName(typeof(InSim.penr), pen.Reason));
                    break;
            }
            try
            {
                if (newCfg.varsLapper.MaxFastDriveOnPit != 9999)
                    newCfg.setLocalVar("RemainFDIP", (newCfg.varsLapper.MaxFastDriveOnPit - currInfoPlayer.NbFastDriveOnPit).ToString());
                executeFunction(action, currInfoPlayer);

            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }
    }
}