/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Collections;
using System.Text;
using lexCfg;
using System.Text.RegularExpressions;
using LFSLapper;


namespace LFSLapper
{
    partial class LFSClient
    {
        public bool executeFunction(string function, infoPlayer currInfoPlayer)
        {

            if (function == "")
                return false;

            if ( !newCfg.functionsLapper.ContainsKey(function) )
            {
                if (!Enum.IsDefined(typeof(lexCfg.eventAllowed), function))
                    Console.WriteLine("Sub '" + function + "' not found in your config file");
                return false;
            }
            FUNCTION currFunc = (FUNCTION)newCfg.functionsLapper[function];
            Scanner scnr = new Scanner();
            bool ret = executeFunction(currFunc, function, currInfoPlayer);
            return ret;

        }
        public string quote(string str)
        {
            return "\"" + str + "\"";
        }
        public bool executeFunction(FUNCTION currFunc,string function, infoPlayer currInfoPlayer  )
        {


            int tok;
            string yytext;
            string argLine = "";
            char breakCar;
            int currLevelIf = 0;
            int currLine = 0;
            string errorMsg = "";
            System.Collections.ArrayList doElse = new System.Collections.ArrayList();


            Scanner scnr = new Scanner();
            doElse.Add(true);
            scnr.SetSource(currFunc.buffer, 0);
                do
                {
                    errorMsg = "";
                    tok = scnr.yylex();
                    yytext = scnr.yytext;
                    currLine = (scnr.GyyLine + currFunc.lineInCfg - 1);
//                                    Console.WriteLine(yytext);
                    switch (tok)
                    {
                        case lexCfg.Scanner.E_PLAYERVAR:
                            {
                                if (function != "OnLapperStart")
                                {
                                    errorMsg = "You can define PlayerVar only in 'OnLapperStart' event";
                                    goto endFunction;
                                }
                                if (scnr.yylex() != lexCfg.Scanner.E_VAR)
                                {
                                    errorMsg = "var ident need";
                                    goto endFunction;
                                }
                                string idVar = scnr.yytext.Substring(1);
                                if (scnr.yylex() != lexCfg.Scanner.E_EQUAL)
                                {
                                    errorMsg = "var $" + idVar + " need '='";
                                    goto endFunction;
                                }
                                breakCar = ' ';
                                string val = retrieveEvalVar(scnr, currInfoPlayer, currFunc, false, ref breakCar);
                                if (newCfg.isUserGlobalVar(idVar))
                                {
                                    errorMsg = "var $" + idVar + " already defined in GlobalVar";
                                    goto endFunction;
                                }
                                newCfg.setPlayerVar(idVar, val);
                            }
                            break;
                        case lexCfg.Scanner.E_GLOBALVAR:
                            {
                                if (function != "OnLapperStart")
                                {
                                    errorMsg = "You can define GlobalVar only in 'OnLapperStart' event";
                                    goto endFunction;
                                }
                                if (scnr.yylex() != lexCfg.Scanner.E_VAR)
                                {
                                    errorMsg = "var ident need";
                                    goto endFunction;
                                }
                                string idVar = scnr.yytext.Substring(1);
                                if (scnr.yylex() != lexCfg.Scanner.E_SEMICOLON)
                                {
                                    errorMsg = "';' needed at end of line";
                                    goto endFunction;
                                }
                                if (newCfg.isPlayerVar(idVar))
                                {
                                    errorMsg = "var $" + idVar + " already defined in PlayerVar";
                                    goto endFunction;
                                }
                                newCfg.setUserGlobalVar(idVar, "0");
                            }
                            break;
                        case lexCfg.Scanner.E_VAR:
                            try
                            {
                                string idVar = scnr.yytext.Substring(1);
                                if (scnr.yylex() != lexCfg.Scanner.E_EQUAL)
                                {
                                    errorMsg = "var $" + idVar + " need '='";
                                    goto endFunction;
                                }
                                breakCar = ' ';
                                string val = retrieveEvalVar(scnr, currInfoPlayer, currFunc, false, ref breakCar);
                                if (idVar == "allow")
                                {
                                    if (!isAllowUserCmd(currInfoPlayer, utils.unquote(val)))
                                    {
                                        newCfg.clearLocalVar();
                                        return false;
                                    }
                                }
                                if (newCfg.varsUserGlobal.ContainsKey(idVar))
                                    newCfg.setUserGlobalVar(idVar, val);
                                else if (currInfoPlayer.playerVars.ContainsKey(idVar))
                                    currInfoPlayer.playerVars[idVar] = val;
                                else
                                    newCfg.setLocalVar(idVar, val);
                                //                        Console.WriteLine("Var Set -> $" + idVar + " = " + (string)varsLocal[idVar] + " BreakCar = " + breakCar);
                            }
                            catch( System.Exception ev ) {
                                errorMsg = ev.Message;
                                break;
                            }
                            break;
                        case lexCfg.Scanner.E_IDENT:
                            string ident = "";
                            System.Collections.ArrayList args;
                            try
                            {
                                ident = yytext;
                                args = new System.Collections.ArrayList();
                                if (scnr.yylex() != lexCfg.Scanner.E_PAR_OPEN){
                                    errorMsg = "'(' needed";
                                    goto endFunction;
                                }

                                breakCar = ' ';
                                while (true)
                                {
                                    args.Add(retrieveEvalVar(scnr, currInfoPlayer, currFunc, true, ref breakCar));
                                    if (breakCar == ')')
                                        break;
                                    if (breakCar != ','){
                                        errorMsg = "unmatched ')'"; 
                                        goto endFunction;
                                    }

                                }

                                //                        for (int i = 0; i < args.Count; i++)
                                //                            Console.WriteLine(args[i]);

                                if (scnr.yylex() != lexCfg.Scanner.E_SEMICOLON){
                                    errorMsg = "';' needed at end of line";
                                    goto endFunction;
                                }
                            }
                            catch (System.Exception ev)
                            {
                                errorMsg = ev.Message;
                                newCfg.clearLocalVar();
                                return false;
                            }
                            if (!newCfg.functionsLapper.ContainsKey(ident))
                            {
                                if (!execCmd(ident, args, currInfoPlayer, scnr.GyyLine + currFunc.lineInCfg - 1))
                                    return false;
                            }
                            else
                            {
                                  executeFunction(ident, currInfoPlayer);
                            }
                            break;
                        case lexCfg.Scanner.E_IF:
                            int curLineIf = (scnr.GyyLine + currFunc.lineInCfg - 1);
                            currLevelIf++;
                            bool resultIf = false;
                            ident = yytext;
                            args = new System.Collections.ArrayList();
                            if (scnr.yylex() != lexCfg.Scanner.E_PAR_OPEN)
                            {
                                errorMsg = "'(' needed";
                                goto endFunction;
                            }
                            breakCar = ' ';
                            argLine = retrieveEvalVar(scnr, currInfoPlayer, currFunc, true, ref breakCar);
                            try
                            {
                                float fvalue = float.Parse(argLine);
                                if (fvalue > 0)
                                    resultIf = true;
                                else
                                    resultIf = false;
                            }
                            catch
                            {
                                if (argLine.Length > 0)
                                    resultIf = true;
                                else
                                    resultIf = false;
                            }
                            if (scnr.yylex() != lexCfg.Scanner.E_THEN)
                            {
                                errorMsg = "'THEN' needed";
                                goto endFunction;
                            }
                            if (resultIf == false)
                            {
                                doElse.Add(true);
                                int enteredLevelIf = currLevelIf;
                                while (true)
                                {
                                    tok = scnr.yylex();

                                    if (tok == lexCfg.Scanner.E_IF)
                                        currLevelIf++;
                                    if (tok == lexCfg.Scanner.E_ELSE && currLevelIf == enteredLevelIf )
                                        break; ;
                                    if (tok == lexCfg.Scanner.E_ENDIF)
                                    {
                                        if (enteredLevelIf == currLevelIf)
                                        {
                                            doElse.RemoveAt(currLevelIf);
                                            currLevelIf--;
                                            break;
                                        }
                                        currLevelIf--;
                                    }
                                    else if (tok == lexCfg.Scanner.E_END)
                                    {
                                        errorMsg = "EOF Function reached in 'IF' statement (#" + curLineIf + ") without 'ELSE' or 'ENDIF' reached";
                                        goto endFunction;
                                    }
                                }
                            }
                            else
                                doElse.Add(false);
                            break;
                        case lexCfg.Scanner.E_THEN:
                            errorMsg = "'THEN' not attempted";
                            goto endFunction;
                            break;
                        case lexCfg.Scanner.E_ELSE:
                            int curLineElse = (scnr.GyyLine + currFunc.lineInCfg - 1);
                            if (currLevelIf == 0)
                            {
                                errorMsg = "'ELSE' not attempted";
                                goto endFunction;
                            }
                            if ((bool)doElse[currLevelIf] == false)
                            {
                                int enteredLevelIf = currLevelIf;
                                while (true)
                                {
                                    tok = scnr.yylex();
                                    if (tok == lexCfg.Scanner.E_IF)
                                        currLevelIf++;
                                    else if (tok == lexCfg.Scanner.E_ELSE && enteredLevelIf == currLevelIf)
                                    {
                                        errorMsg = "'ELSE' not attempted";
                                        goto endFunction;
                                    }
                                    else if (tok == lexCfg.Scanner.E_ENDIF)
                                    {
                                        if (enteredLevelIf == currLevelIf)
                                        {
                                            doElse.RemoveAt(currLevelIf);
                                            currLevelIf--;
                                            break;
                                        }
                                        currLevelIf--;
                                    }
                                    else if (tok == lexCfg.Scanner.E_END)
                                    {
                                        errorMsg = "EOF Function reached in 'ELSE' statement (#" + curLineElse + ") without 'ENDIF' reached";
                                        goto endFunction;
                                    }
                                }
                            }
                            break;
                        case lexCfg.Scanner.E_ENDIF:
                            if (currLevelIf == 0)
                            {
                                errorMsg = "'ENDIF' not attempted";
                                goto endFunction;
                            }
                            doElse.RemoveAt(currLevelIf);
                            currLevelIf--;
                            break;
                        case lexCfg.Scanner.E_END:
                            newCfg.clearLocalVar();
                            return true;
                        default:
                            errorMsg = "Token not catched";
                            goto endFunction;
                    }

                } while (tok > (int)Tokens.EOF);
            newCfg.clearLocalVar();
            return true;
endFunction:
            newCfg.clearLocalVar();
            errorMsg = "Syntax error in cfg file: " + errorMsg + " at line #" + currLine + " in function '" + function + "' script aborted";
            Console.WriteLine( errorMsg );
            return  false;
        }
        string retrieveEvalVar(Scanner scnr, infoPlayer currInfoPlayer, FUNCTION currFunc, bool breakFunc, ref char breakCar)
        {
            System.Collections.ArrayList tokens = new System.Collections.ArrayList();
            string idVar;
            int par = 0;
            bool flagIdent = false;
            while (true)
            {
                int tok = scnr.yylex();
                string str = scnr.yytext;
                if (tok == lexCfg.Scanner.E_IDENT)
                {
                    tokens.Add(str);
                    flagIdent = true;
                    continue;
                }
                if (tok == lexCfg.Scanner.E_VAR)
                {
                    idVar = str.Substring(1);
                    if (newCfg.varsUserGlobal.Contains(idVar))
                    {
                        tokens.Add((string)newCfg.varsUserGlobal[idVar]);
                        continue;
                    }
                    try
                    {
                        if (currInfoPlayer.playerVars.Contains(idVar))
                        {
                            tokens.Add((string)currInfoPlayer.playerVars[idVar]);
                            continue;
                        }
                    }
                    catch { }
                    if (newCfg.varsLocal.Contains(idVar))
                    {
                        tokens.Add((string)newCfg.varsLocal[idVar]);
                        continue;
                    }
                    if (newCfg.varsGlobal.Contains(idVar))
                    {
                        tokens.Add((string)newCfg.varsGlobal[idVar]);
                        continue;
                    }
                    try
                    {
                        tokens.Add(retreiveVarPlayer(idVar, currInfoPlayer));
                        continue;
                    }
                    catch { }

                    Console.WriteLine("Syntax error '" + str + "' in Sub or Event at line #"
                                            + (scnr.GyyLine + currFunc.lineInCfg - 1).ToString() + " " + idVar + " Not defined");
                    tokens.Add("$" + idVar);
                    continue;
                }
                if (tok == lexCfg.Scanner.E_PAR_OPEN)
                {
                    tokens.Add(str);
                    par++;
                    continue;
                }
                if (tok == lexCfg.Scanner.E_PAR_CLOSE && par > 0)
                {
                    tokens.Add(str);
                    par--;
                    continue;
                }
                if (tok == lexCfg.Scanner.E_SEMICOLON )
                {
                    breakCar = ';';
                    break;
                }
                if ((tok == lexCfg.Scanner.E_COLON || (tok == lexCfg.Scanner.E_PAR_CLOSE && par == 0)) && breakFunc == true)
                {
                    if (tok == lexCfg.Scanner.E_COLON)
                        breakCar = ',';
                    else
                        breakCar = ')';
                    break;
                }
                tokens.Add(str);

            }
            string analString = "";
            for (int i = 0; i < tokens.Count; i++)
                analString += tokens[i];
            if (flagIdent)
                return analString;

            Parseur p = new Parseur(analString);
            lexCfg.unionVal retVal = p.getval();
            if (retVal.typVal == typVal.num )
                return retVal.fval.ToString();
            else
            {
                return retVal.sval;

                int l = retVal.sval.Length;
                if (retVal.sval.Length > 1)
                    return retVal.sval.Substring(1, l - 2);
                else
                    return retVal.sval;
            }

        }
        string retreiveVarPlayer(string idVar, infoPlayer currInfoPlayer)
        {
            #region Var currInfoPlayer
            if (currInfoPlayer != null)
            {
                switch (idVar)
                {
                    case "Nickname":
                        return quote( currInfoPlayer.nickName );
                        break;
                    case "Username":
                        return quote( currInfoPlayer.userName );
                        break;
                    case "Laps":
                        return currInfoPlayer.laps.ToString();
                        break;
                    case "SessLaps":
                        return currInfoPlayer.sessLaps.ToString();
                        break;

                    case "TotalPitTime":
                        return quote( unitConv.LongToHMS(currInfoPlayer.totalPitTime) );
                        break;
                    case "Car":
                        return quote( currInfoPlayer.CName );
                        break;
                    case "Posabs":
                        {
                            posQualUser tmpPosQualUser = getPosQual( currInfoPlayer.nickName, "", false);
                            if (tmpPosQualUser.posUser != 0)
                                return quote(tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                            else
                                return quote("-/-");
                        }
                        break;
                    case "Posqual":
                        {
                            posQualUser tmpPosQualUser = getPosQual(currInfoPlayer.nickName,"", true);
                            if (tmpPosQualUser.posUser != 0)
                                return quote( tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser );
                            else
                                return quote( "-/-" );
                        }
                        break;
                    case "Groupqual":
                        {
                            posQualUser tmpPosQualUser = getPosQual(currInfoPlayer.nickName, "", true);
                            if (tmpPosQualUser.groupUser != -1)
                                return quote( ((char)(tmpPosQualUser.groupUser + 65)).ToString() );
                            else
                                return quote( "-" );
                        }
                        break;
                    case "SwearWordsRem":
                        return ( newCfg.varsLapper.SwearWordsMax - currInfoPlayer.swearWordsCount).ToString();
                    case "H_Mass":
                    case "H_TRes":
                        int cumH_Mass = 0;
                        int cumH_Tres = 0;
                        if (carHandicap.ContainsKey(currInfoPlayer.CName.ToLower()))
                        {
                            cumH_Mass = (carHandicap[currInfoPlayer.CName.ToLower()] as infoHandicap).H_Mass;
                            cumH_Tres = (carHandicap[currInfoPlayer.CName.ToLower()] as infoHandicap).H_TRes;
                        }
                        // Car/Tarck handicap
                        string carTrack = currInfoPlayer.CName.ToLower() + "/" + (newCfg.varsGlobal["ShortTrackName"] as string).ToLower();
                        //                            Console.WriteLine(carTrack);
                        if (carTrackHandicap.ContainsKey(carTrack))
                        {
                            cumH_Mass = (carTrackHandicap[carTrack] as infoHandicap).H_Mass;
                            cumH_Tres = (carTrackHandicap[carTrack] as infoHandicap).H_TRes;
                        }
                        // Player handicap
                        if (playerHandicap.ContainsKey(currInfoPlayer.userName.ToLower()))
                        {
                            cumH_Mass = (playerHandicap[currInfoPlayer.userName.ToLower()] as infoHandicap).H_Mass;
                            cumH_Tres = (playerHandicap[currInfoPlayer.userName.ToLower()] as infoHandicap).H_TRes;
                        }
                        if (idVar == "H_TRes")
                            return cumH_Tres.ToString();
                        else
                            return cumH_Mass.ToString();
                    case "P_Mass":
                        return currInfoPlayer.H_Mass.ToString();
                    case "P_TRes":
                        return currInfoPlayer.H_TRes.ToString();
                    case "Split1":
                        return quote(unitConv.LongToHMS(currInfoPlayer.split[0]));
                    case "Split2":
                        return quote(unitConv.LongToHMS(currInfoPlayer.split[1]));
                    case "Split3":
                        return quote(unitConv.LongToHMS(currInfoPlayer.split[2]));
                    case "LapTime":
                        return quote(unitConv.LongToHMS(currInfoPlayer.lapTime));
                    case "PBLapTime":
                        return quote(unitConv.LongToHMS(currInfoPlayer.PBLTime));
                    case "DiffLapTimeToPB":
                        return quote(unitConv.LongToHMS(currInfoPlayer.diffLapTimeToPb));

                    case "SplitTime":
                        return quote( unitConv.LongToHMS(currInfoPlayer.lastSplitTime) );
                    case "SectorSplit1":
                        return quote(unitConv.LongToHMS(currInfoPlayer.sectorSplit[0]));
                    case "SectorSplit2":
                        return quote(unitConv.LongToHMS(currInfoPlayer.sectorSplit[1]));
                    case "SectorSplit3":
                        return quote(unitConv.LongToHMS(currInfoPlayer.sectorSplit[2]));
                    case "SectorSplitLast":
                        return quote(unitConv.LongToHMS(currInfoPlayer.sectorSplitLast));

                    case "BestSectorSplit1":
                        return quote(unitConv.LongToHMS(currInfoPlayer.bestSectorSplit[0]));
                    case "BestSectorSplit2":
                        return quote(unitConv.LongToHMS(currInfoPlayer.bestSectorSplit[1]));
                    case "BestSectorSplit3":
                        return quote(unitConv.LongToHMS(currInfoPlayer.bestSectorSplit[2]));
                    case "BestSectorSplitLast":
                        return quote(unitConv.LongToHMS(currInfoPlayer.bestSectorSplitLast));

                    case "DiffSectorSplit1":
                        return quote(unitConv.LongToHMS(currInfoPlayer.diffSectorSplit[0]));
                    case "DiffSectorSplit2":
                        return quote(unitConv.LongToHMS(currInfoPlayer.diffSectorSplit[1]));
                    case "DiffSectorSplit3":
                        return quote(unitConv.LongToHMS(currInfoPlayer.diffSectorSplit[2]));
                    case "DiffSectorSplitLast":
                        return quote(unitConv.LongToHMS(currInfoPlayer.diffSectorSplitLast));

                    case "isBestSectorSplit1":
                        if (currInfoPlayer.isBestSectorSplit[0])
                            return "1";
                        else
                            return "0";
                    case "isBestSectorSplit2":
                        if (currInfoPlayer.isBestSectorSplit[1])
                            return "1";
                        else
                            return "0";
                    case "isBestSectorSplit3":
                        if (currInfoPlayer.isBestSectorSplit[2])
                            return "1";
                        else
                            return "0";
                    case "isBestSectorSplitLast":
                        if (currInfoPlayer.isBestSectorSplitLast)
                            return "1";
                        else
                            return "0";
                  
                    case "AvgSpeed":
                        return quote(string.Format("{0:n}", unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, trackInfo.getAvgSpeed(currentTrackName, currInfoPlayer.lapTime))));
                    case "BestSpeed":
                        return string.Format("{0:n}", unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, currInfoPlayer.bestSpeed));
                    case "UnitSpeed":
                        return quote( getUnitSpeed(currInfoPlayer.unitSpeedKmh) );
                    case "Tpb":
                        return quote( unitConv.LongToHMS(currInfoPlayer.TPb) );
                    case "DriftScore":
                        return currInfoPlayer.totaldriftscore.ToString("F0");
                    case "typ":
                        if (currInfoPlayer.viewSPBSplit == 'P')
                            return quote( "PB" );
                        if (currInfoPlayer.viewSPBSplit == 'S')
                            return quote( "Sess" );
                        if (currInfoPlayer.viewSPBSplit == 'W')
                            return quote( "WR" );
                        return "typ";
                        break;
                    case "AngleVelocity":
                        return currInfoPlayer.AngVel.ToString("F0");
                    case "LastDriftScore":
                        return currInfoPlayer.lastdriftscore.ToString("F0");
                    case "AccelerationStartSpeed":
                        if (currInfoPlayer.unitSpeedKmh)
                            return newCfg.varsLapper.AccelerationStartSpeed.ToString("F0");
                        else
                            return newCfg.varsLapper.AccelerationStartSpeedMph.ToString("F0");
                        break;
                    case "AccelerationEndSpeed":
                        if (currInfoPlayer.unitSpeedKmh)
                            return newCfg.varsLapper.AccelerationEndSpeed.ToString("F0");
                        else
                            return newCfg.varsLapper.AccelerationEndSpeedMph.ToString("F0");
                        break;
                    case "AccelerationTime":
                        return quote( currInfoPlayer.accelerationTime.TotalSeconds.ToString("F1") );
                        break;
                    case "MaxAllowedLapTime1":
                        long msec1 = (long)(((double)newCfg.varsLapper.MaxAllowedLapTime1 / 100) * ((double)currInfoPlayer.MaxLapTime));
                        return quote( unitConv.LongToHMS(msec1) );
                        break;
                    case "MaxAllowedLapTime2":
                        if (newCfg.varsLapper.MaxAllowedLapTime2 != 1)
                        {
                            long msec2 = (long)(((double)newCfg.varsLapper.MaxAllowedLapTime2 / 100) * ((double)currInfoPlayer.MaxLapTime));
                            return quote( unitConv.LongToHMS(msec2) );
                        }
                        else
                            return quote( "N/A" );
                        break;
                    case "Dist":
                        {
                            double len = trackInfo.getLen(currentTrackName);
                            int dist = (int)(len * (double)currInfoPlayer.laps);
                            return quote( unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, (double)dist).ToString() + " " + getUnitDist(currInfoPlayer.unitSpeedKmh) );
                        }

                    case "SessDist":
                        {
                            double len = trackInfo.getLen(currentTrackName);
                            int sess_dist = (int)(len * (double)currInfoPlayer.sessLaps);
                            return quote(unitConv.getSpeed(currInfoPlayer.unitSpeedKmh, (double)sess_dist).ToString() + " " + getUnitDist(currInfoPlayer.unitSpeedKmh));
                        }


                    default:
                        break;
                }
            }
            #endregion
            #region globalVar
            switch (idVar)
            {
                case "RotateIn":
                    if (newCfg.varsLapper.EnableRotation)
                        return (newCfg.varsLapper.RotateEveryNbRaces - currRace.racesDone).ToString();
                    else
                        return "0";
                case "HostName":
                    return quote(currentHName);
                case "ShortTrackName":
                    return quote(currentTrackName);
                case "LongTrackName":
                    return quote( InSim.Decoder.getLongTrackName(currentTrackName) );
                case "ShortTime":
                    return quote( System.DateTime.Now.ToShortTimeString() );
                case "LongTime":
                    return quote( System.DateTime.Now.ToLongTimeString() );
                case "ShortDate":
                    return quote( System.DateTime.Now.ToShortDateString() );
                case "LongDate":
                    return quote( System.DateTime.Now.ToLongDateString() );
                case "NextRotateCar":
                    {
                        int nextCar = currRace.currRotateCar + 1;
                        string[] tmpCars = newCfg.varsLapper.RotateCars.Split(',');
                        if (nextCar > tmpCars.Length - 1)
                            nextCar = 0;
                        return quote(tmpCars[nextCar]);
                    }
                case "NextRotateTrack":
                case "NextLongRotateTrack":
                    {
                        int nextTrack = currRace.currRotateTrack + 1;
                        string[] tmpTracks = newCfg.varsLapper.RotateTracks.Split(',');
                        if (nextTrack > tmpTracks.Length - 1)
                            nextTrack = 0;
                        if( idVar == "NextRotateTrack" )
                            return quote(tmpTracks[nextTrack]);
                        else
                            return quote(InSim.Decoder.getLongTrackName(tmpTracks[nextTrack]));

                    }
                case "CurrRotateCar":
                    {
                        int nextCar = currRace.currRotateCar;
                        string[] tmpCars = newCfg.varsLapper.RotateCars.Split(',');
                        if (nextCar > tmpCars.Length - 1)
                            nextCar = 0;
                        return quote(tmpCars[nextCar]);
                    }
                case "CurrRotateTrack":
                case "CurrLongRotateTrack":
                    {
                        int nextTrack = currRace.currRotateTrack;
                        string[] tmpTracks = newCfg.varsLapper.RotateTracks.Split(',');
                        if (nextTrack > tmpTracks.Length - 1)
                            nextTrack = 0;
                        if (idVar == "CurrRotateTrack")
                            return quote(tmpTracks[nextTrack]);
                        else
                            return quote(InSim.Decoder.getLongTrackName(tmpTracks[nextTrack]));
                    }
                default:
                    return quote( "(unknown)" );
                    break;
            }
            #endregion
        }
        public bool execCmd( string ident, System.Collections.ArrayList args, infoPlayer currInfoPlayer, int currLine )
        {
            for (int i = 0; i < args.Count; i++)
            {
                int l = args[i].ToString().Length;
                if( l > 1 ){
                    if (args[i].ToString()[0] == '"' && args[i].ToString()[l - 1] == '"')
                    {
                        args[i] = args[i].ToString().Substring(1,l-2);
                    }
                }
            }
            switch (ident)
            {

                case "cmdLFS":
                    if (!testArgs(ident, "S", args, currLine))
                        return false;

                    if (args[0].ToString().IndexOf( "/rcm_" ) != -1 )
                    {
                        RestartTimer();
                    }

                    byte[] outMsg = InSim.Encoder.MST(args[0].ToString());
                    insimConnection.Send(outMsg, outMsg.Length);

                    break;
                case "setLicense":
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    {
                        string val = args[0].ToString().Trim().ToLower();
                        if (val == "on")
                        {
                            SendMsg(0, "License ON");
                            AuthOn = true;
                        }
                        if (val == "off")
                        {
                            SendMsg(0, "License OFF");
                            AuthOn = false;
                        }
                        if (val == "?" || val == "")
                        {
                            if (AuthOn)
                                SendMsg(0, "License Status = ON");
                            else
                                SendMsg(0, "License Status = OFF");
                        }
                    }
                    break;

                case "console":
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    Console.WriteLine(args[0].ToString());
                    break;
                case "privMsg":
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    SendMsgToConnection(currInfoPlayer.UCID, args[0].ToString());
                    break;
                case "cleanSpb":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    currInfoPlayer.splitLast = 0;
                    for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                        currInfoPlayer.sessBestSplitDiff[i] = 0;
                    currInfoPlayer.sessBestSplitDiffLast = 0;
                    currInfoPlayer.bestSpeed = (double)0;
                    SendMsgToConnection(currInfoPlayer.UCID, currInfoPlayer.nickName + "^8 SPB Cleaned");
                    break;
                case "showSpb":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    string spb = "";
                    try
                    {
                        switch (currInfoPlayer.viewSPBSplit)
                        {
                            case 'W':
                            case 'P':
                                spb = "PB ";
                                for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                                {
                                    if (currInfoPlayer.PBBestSplitDiff[i] != 0)
                                        spb = spb + "^7SP" + (i + 1).ToString() + ":^8" + unitConv.LongToHMS(currInfoPlayer.PBBestSplitDiff[i]);
                                }
                                if (currInfoPlayer.PBBestSplitDiffLast != 0)
                                    spb = spb + "^7SPL:^8" + unitConv.LongToHMS(currInfoPlayer.PBBestSplitDiffLast);
                                break;
                            case 'S':
                                spb = "Sess ";
                                for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                                {
                                    if (currInfoPlayer.sessBestSplitDiff[i] != 0)
                                        spb = spb + "^7SP" + (i + 1).ToString() + ":^8" + unitConv.LongToHMS(currInfoPlayer.sessBestSplitDiff[i]);
                                }
                                if (currInfoPlayer.sessBestSplitDiffLast != 0)
                                    spb = spb + "^7SPL:^8" + unitConv.LongToHMS(currInfoPlayer.sessBestSplitDiffLast);
                                break;
                        }
                        SendMsgToConnection(currInfoPlayer.UCID, spb);
                        SendMsgToConnection(currInfoPlayer.UCID, unitConv.LongToHMS(currInfoPlayer.TPb));
                    }
                    catch (Exception) { }
                    break;
                case "showHand":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (newCfg.varsLapper.RefreshHandicapUsers)
                        UpdateHandicapUsers(newCfg.varsLapper.HandicapUsers);
                    ShowHand(currInfoPlayer, args[0].ToString());
                    break;  
                case "lapperVersion":
                    Ver(currInfoPlayer.UCID);
                    break;
                case "authLevel":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    ShowAuth(currInfoPlayer, args[0].ToString() );
                    break;
                case "stats":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    ShowStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), false);
                    break;
                case "statsQual":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    ShowStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true);
                    break;
                case "dStats":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    ShowDriftStats(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString());
                    break;
                case "drf":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    TopDrift(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString());
                    break;
                case "top":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (!testArgs(ident, "S", args, currLine))
                        return false;

                    Top(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), false);
                    break;
                case "topQual":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    if (newCfg.varsLapper.RefreshQualUsers)
                        UpdateQualUsers(newCfg.varsLapper.QualUsers);
                    Top(currInfoPlayer.UCID, currInfoPlayer.userName, currInfoPlayer.nickName, args[0].ToString(), true);
                    break;

                case "nearQual":
                    {
                        if (currInfoPlayer == null)
                        {
                            Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                            return false;
                        }

                        // Update the FilterTop for qualified
                        if (newCfg.varsLapper.RefreshQualUsers)
                            UpdateQualUsers(newCfg.varsLapper.QualUsers);
                        posQualUser retValue = getPosQual(currInfoPlayer.nickName, args[0].ToString(), true);
                        int iposabs = retValue.posUser;
                        if (iposabs == 0)
                            iposabs = 1;
                        int maxCol = (int)paramLapper.nbLineTop;
                        if (iposabs > (maxCol / 2))
                            iposabs -= (maxCol / 2);
                        else
                            iposabs = 1;
                        args[0] = iposabs.ToString();
                        if (retValue.userName == "" || retValue.nickName == "")
                        {
                            retValue.userName = currInfoPlayer.userName;
                            retValue.nickName = currInfoPlayer.nickName;
                        }
                        Top(currInfoPlayer.UCID, retValue.userName, retValue.nickName, args[0].ToString(), true);
                    }
                    break;
                case "near":
                    {
                        if (currInfoPlayer == null)
                        {
                            Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                            return false;
                        }

                        posQualUser retValue = getPosQual(currInfoPlayer.nickName, args[0].ToString(), false);
                        int iposabs = retValue.posUser;

                        if (iposabs == 0)
                            iposabs = 1;
                        if (iposabs > 8)
                            iposabs -= 7;
                        else
                            iposabs = 1;
                        args[0] = iposabs.ToString();
                        if (retValue.userName == "" || retValue.nickName == "")
                        {
                            retValue.userName = currInfoPlayer.userName;
                            retValue.nickName = currInfoPlayer.nickName;
                        }
                        Top(currInfoPlayer.UCID, retValue.userName, retValue.nickName, args[0].ToString(), false);
                    }
                    break;

                case "openPrivButton":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (args.Count == 9)
                        args.Add("");
                    if (!testArgs(ident, "SIIIIIIISS", args, currLine))
                        return false;
                    currInfoPlayer.playerBox.create(args[0].ToString(),
                                                        currInfoPlayer.UCID,
                                                        int.Parse(args[1].ToString()),
                                                        int.Parse(args[2].ToString()),
                                                        int.Parse(args[3].ToString()),
                                                        int.Parse(args[4].ToString()),
                                                        int.Parse(args[5].ToString()),
                                                        int.Parse(args[6].ToString()),
                                                        0,
                                                        int.Parse(args[7].ToString()),
                                                        "",
                                                        args[8].ToString(),
                                                        args[9].ToString()
                    );
                    currInfoPlayer.playerBox.show(args[0].ToString(), currInfoPlayer.UCID);
                    break;
                case "openGlobalButton":
                    if (args.Count == 9)
                        args.Add("");
                    if (!testArgs(ident, "SIIIIIIISS", args, currLine))
                        return false;
                    listOfPlayers.globalButtonMessage(args[0].ToString(),
                                                        currInfoPlayer.UCID,
                                                        int.Parse(args[1].ToString()),
                                                        int.Parse(args[2].ToString()),
                                                        int.Parse(args[3].ToString()),
                                                        int.Parse(args[4].ToString()),
                                                        int.Parse(args[5].ToString()),
                                                        int.Parse(args[6].ToString()),
                                                        0,
                                                        int.Parse(args[7].ToString()),
                                                        "",
                                                        args[8].ToString(),
                                                        args[9].ToString()
                    );
                    break;
                case "closeGlobalButton":
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    listOfPlayers.globalButtonClose( args[0].ToString() );
                    break;
                case "closePrivButton":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    currInfoPlayer.privateButtonClose(args[0].ToString());
                    break;
                case "http":
                    if (currInfoPlayer == null)
                    {
                        Console.WriteLine("You can't use privMsg in this context, not a player event at line #" + currLine);
                        return false;
                    }
                    if (!testArgs(ident, "S", args, currLine))
                        return false;
                    objWebCmd.sendWebCmd( currInfoPlayer.UCID, args[0].ToString() );
                    break;
                default:
                    Console.WriteLine("'" + ident + "' is not a Lapper function" );
                    return false;
            }
            return true;
        }
        bool testArgs(string ident, string pattern, System.Collections.ArrayList args, int currLine )
        {
            if (pattern.Length != args.Count)
            {
                Console.WriteLine("Command '" + ident + "' incorrect number of parameter at line #" + currLine);
                return false;
            }
            for( int i = 0; i < pattern.Length; i++ ){
                if( pattern[i] == 'I' ){
                    try{
                        int val = int.Parse( args[i].ToString() );

                    }
                    catch{
                        Console.WriteLine("'" + ident + "' parameter #" + i.ToString() + " is wrong type at line #" + currLine);
                        return false;
                    }
                }
            }
            return true;

        }
        bool isAllowUserCmd(infoPlayer currInfoPlayer, string allowedUsers)
        {
            string nickWithoutColor = currInfoPlayer.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").Replace("^9", "");

            allowedUsers = allowedUsers.Trim();
            if (allowedUsers == "")
                return true;
            if (allowedUsers[0] != '&')
            {
                string[] authUsers = allowedUsers.Split(',');
                foreach (string authuser in authUsers)
                {
                    string testUser = authuser.Trim();
                    bool TypeAuthent = newCfg.varsLapper.UseUsernameForAuthentication;
                    if (testUser[0] == '!')
                    {
                        testUser = testUser.Substring(1);
                        TypeAuthent = !TypeAuthent;
                    }
                    int regidx = testUser.IndexOf("regex=");
                    if (regidx != -1)
                    {
                        testUser = testUser.Substring(regidx + 7);
                        Regex myRegexp = new Regex(testUser);

                        if (TypeAuthent)
                        {
                            if (myRegexp.IsMatch(currInfoPlayer.userName.Trim().ToLower()))
                                return true;
                        }
                        else
                        {
                            if (myRegexp.IsMatch(nickWithoutColor.Trim()))
                                return true;
                        }
                    }
                    else
                    {
                        if (TypeAuthent)
                        {
                            if (currInfoPlayer.userName.Trim().ToLower() == testUser.ToLower())//   <- for licensed players
                                return true;
                        }
                        else
                        {
                            if (nickWithoutColor.Trim() == testUser)//   <- for demo players
                                return true;
                        }
                    }
                }
                return false;
            }
            else
            {
                string authUsersFile = allowedUsers.Substring(1);
                if (authUsersFile != "")
                {
                    try
                    {
                        using (System.IO.StreamReader sr = new System.IO.StreamReader(authUsersFile))
                        {
                            string lusername;
                            while (true)
                            {
                                lusername = sr.ReadLine();

                                if (lusername == null)
                                    break;
                                string testUser = lusername.Trim();
                                bool TypeAuthent = newCfg.varsLapper.UseUsernameForAuthentication;
                                if (testUser[0] == '!')
                                {
                                    testUser = testUser.Substring(1);
                                    TypeAuthent = !TypeAuthent;
                                }
                                int regidx = testUser.IndexOf("regex=");
                                if (regidx != -1)
                                {
                                    testUser = testUser.Substring(regidx + 7);
                                    Regex myRegexp = new Regex(testUser);
                                    if (TypeAuthent)
                                    {
                                        if (myRegexp.IsMatch(currInfoPlayer.userName.Trim().ToLower()))
                                            return true;
                                    }
                                    else
                                    {
                                        if (myRegexp.IsMatch(nickWithoutColor.Trim()))
                                            return true;
                                    }
                                }
                                else
                                {

                                    if (TypeAuthent)
                                    {
                                        if (currInfoPlayer.userName.Trim().ToLower() == testUser.ToLower())//   <- for licensed players
                                            return true;
                                    }
                                    else
                                    {
                                        if (nickWithoutColor.Trim() == testUser.Trim())//   <- for demo players
                                            return true;
                                    }
                                }
                            }
                            return false;
                        }
                    }
                    catch
                    {
                        return false;
                    }
                }
                return false;
            }

        }

    }

}
