/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
namespace LFSLapper
{
    partial class LFSClient
    {
/*
        bool executeCmdLapper(int UCID, string msg)
        {
            infoPlayer currPly = listOfPlayers.getPlayerByUCID(UCID);
            if (msg.ToLower().IndexOf("/http") == 0)
            {
                int idx = msg.ToLower().IndexOf("/http ");
                //                Console.WriteLine(msg);
                //                Console.WriteLine(msg.Substring(6));
                objWebCmd.sendWebCmd(UCID, GlobalReplace.GlobalOptionsReplace( msg.Substring(6)));
                return true;
            }
            if (msg.ToLower().IndexOf("/pbut") == 0)
            {
                int idx = msg.ToLower().IndexOf("/pbut ");
                string cmd = msg.Substring(6);
//                Console.WriteLine(cmd);
//                Console.WriteLine("");
                currPly.privateButtonMessage(cmd);
                return true;
            }
            if (msg.ToLower().IndexOf("/cpbut") == 0)
            {
                int idx = msg.ToLower().IndexOf("/cpbut ");
                string cmd = msg.Substring(7);
                currPly.privateButtonClose(cmd);
                return true;
            }
            if (msg.ToLower().IndexOf("/cgbut") == 0)
            {
                int idx = msg.ToLower().IndexOf("/cgbut ");
                string cmd = msg.Substring(7);
                listOfPlayers.globalButtonClose(cmd);
                return true;
            }
            if (msg.ToLower().IndexOf("/gbut") == 0)
            {
                int idx = msg.ToLower().IndexOf("/gbut ");
                string cmd = msg.Substring(6);
//                listOfPlayers.globalButtonMessage(cmd);
                return true;
            }
            if (msg.ToLower().IndexOf("/pm") == 0)
            {
                int idx = msg.ToLower().IndexOf("/pm ");
                SendMsgToConnection(UCID, GlobalReplace.GlobalOptionsReplace( msg.Substring(4) ));
                return true;
            }
            if (msg.IndexOf("/cleanspb") == 0)
            {
                msg = "!" + msg.Substring(1);

                currPly.splitLast = 0;
                for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                    currPly.sessBestSplitDiff[i] = 0;
                currPly.sessBestSplitDiffLast = 0;
                currPly.bestSpeed = (double)0;

                try
                {
                    SendMsgToConnection(UCID, currPly.nickName + "^8 SPB Cleaned");
                }
                catch { }
                return true;
            }

            if (msg.IndexOf("/spb") == 0)
            {
                msg = "!" + msg.Substring(1);

                string spb = "";
                try
                {
                    switch (currPly.viewSPBSplit)
                    {
                        case 'W':
                        case 'P':
                            spb = "PB ";
                            for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                            {
                                if (currPly.PBBestSplitDiff[i] != 0)
                                    spb = spb + "^7SP" + (i + 1).ToString() + ":^8" + unitConv.LongToHMS(currPly.PBBestSplitDiff[i]);
                            }
                            if (currPly.PBBestSplitDiffLast != 0)
                                spb = spb + "^7SPL:^8" + unitConv.LongToHMS(currPly.PBBestSplitDiffLast);
                            break;
                        case 'S':
                            spb = "Sess ";
                            for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                            {
                                if (currPly.sessBestSplitDiff[i] != 0)
                                    spb = spb + "^7SP" + (i + 1).ToString() + ":^8" + unitConv.LongToHMS(currPly.sessBestSplitDiff[i]);
                            }
                            if (currPly.sessBestSplitDiffLast != 0)
                                spb = spb + "^7SPL:^8" + unitConv.LongToHMS(currPly.sessBestSplitDiffLast);
                            break;
                    }
                    SendMsgToConnection(UCID, spb);
                    SendMsgToConnection(UCID, unitConv.LongToHMS(currPly.TPb));
                }
                catch (Exception) { }
                return true;

            }

            if (msg.IndexOf("/statsqual") == 0)
            {
                msg = "!" + msg.Substring(1);
                ShowStats(UCID, currPly.userName, currPly.nickName, msg, true);
                return true;
            }
            if (msg.IndexOf("/stats") == 0)
            {
                msg = "!" + msg.Substring(1);
                ShowStats(UCID, currPly.userName, currPly.nickName, msg, false);
                return true;
            }

            if (msg.IndexOf("/hand") == 0)
            {
                msg = "!" + msg.Substring(1);
                if (newCfg.varsLapper.RefreshHandicapUsers)
                    UpdateHandicapUsers(newCfg.varsLapper.HandicapUsers);
                ShowHand(currPly, msg);
                return true;
            }
            if (msg.IndexOf("/license") == 0)
            {
                string [] arg = msg.Split(' ');
                int minarg = 1;
                if (arg.Length > minarg)
                {
                    if (arg[1].Trim() == "on")
                    {
                        SendMsg(0, "License ON");
                        AuthOn = true;
                    }
                    if (arg[1].Trim() == "off")
                    {
                        SendMsg(0, "License OFF");
                        AuthOn = false;
                    }
                    if (arg[1].Trim() == "?")
                    {
                        if (AuthOn)
                            SendMsg(0, "License Status = ON");
                        else
                            SendMsg(0, "License Status = OFF");
                    }
                }
                else
                {
                    SendMsg(UCID, "This command need " + minarg.ToString() + " argument");
                }
                return true;
            }
            if (msg.IndexOf("/dstats") == 0)
            {
                msg = "!" + msg.Substring(1);
                ShowDriftStats(UCID, currPly.userName, currPly.nickName, msg);
                return true;
            }
            if (msg.IndexOf("/ver") == 0)
            {
                Ver(UCID);
                return true;
            }
            if (msg.IndexOf("/termlapper") == 0)
            {
                TermProg = true;
                return true;
            }
            if (msg.IndexOf("/nearqual") == 0)
            {
                string mymess;
                msg = "!" + msg.Substring(1);
                // Update the FilterTop for qualified
                if (newCfg.varsLapper.RefreshQualUsers)
                    UpdateQualUsers(newCfg.varsLapper.QualUsers);
                posQualUser retValue = getPosQual( currPly.nickName,"", true);
                int iposabs = retValue.posUser;
                if (iposabs == 0)
                    iposabs = 1;
                int maxCol = (int)paramLapper.nbLineTop;
                if (iposabs > ( maxCol / 2 ))
                    iposabs -= ( maxCol / 2 );
                else
                    iposabs = 1;
                mymess = "!topqual " + iposabs.ToString();
                Top(UCID, currPly.userName, currPly.nickName,  mymess, true);
                return true;
            }
            if (msg.IndexOf("/near") == 0)
            {

                string mymess;
                msg = "!" + msg.Substring(1);
                posQualUser retValue = getPosQual(currPly.nickName,"", false);
//                Console.WriteLine(retValue.posUser);
                int iposabs = retValue.posUser;

                if (iposabs == 0)
                    iposabs = 1;
                if (iposabs > 8)
                    iposabs -= 7;
                else
                    iposabs = 1;
                mymess = "!top " + iposabs.ToString();
                Top(UCID, currPly.userName, currPly.nickName, mymess, false);
                return true;
            }
            if (msg.IndexOf("/drf") == 0)
            {
                msg = "!" + msg.Substring(1);
                TopDrift(UCID, currPly.userName, currPly.nickName,  msg);
                return true;
            }
            if (msg.IndexOf("/topqual") == 0)
            {
                msg = "!" + msg.Substring(1);
                if (newCfg.varsLapper.RefreshQualUsers)
                    UpdateQualUsers(newCfg.varsLapper.QualUsers);
                Top(UCID, currPly.userName, currPly.nickName,  msg, true);
                return true;
            }
            if (msg.IndexOf("/top") == 0)
            {
                msg = "!" + msg.Substring(1);
                Top(UCID, currPly.userName, currPly.nickName,  msg, false);
                return true;
            }
            if (msg.IndexOf("/auth") == 0)
            {
                msg = "!" + msg.Substring(1);
                ShowAuth(currPly, msg);
                return true;
            }
            return false;
        }
 */
        void Ver(int UCID)
        {
            try
            {
                //                playerIdToSend = (byte)(playerTmpStatTable[(string)playerNameToSend] as tempStat).PLID;


                SendMsgToConnection(UCID, "LFSLapper, Version=" + LFSLapper.getShortVersion(3) + " by Robert BRACCAGNI ( Gai-Luron )");
                SendMsgToConnection(UCID, "^3http://www.lfsforum.net/showthread.php?t=25756");
            }
            catch (System.Exception)
            {
                return;
            }
        }
        void Top(int UCID, string username, string nickname, string cmd, bool flagqual)
        {

            string playerNameToSend = nickname;
            string filtervalue = "";
            int decal = 0;
            int larg = 0;


            string carName = newCfg.varsLapper.DefaultTopCar;

            int from = 1;

            infoPlayer currPly = listOfPlayers.getPlayerByUCID(UCID);


            string[] splitCmd = cmd.Split(' ');
            for (int i = 0; i <= splitCmd.GetUpperBound(0); i++)
            {
                if (splitCmd[i].Trim() == "")
                    continue;
                // find if filter is present
                if (splitCmd[i] == "filter")
                {
                    i++;
                    try { filtervalue = splitCmd[i]; continue; }
                    catch { filtervalue = ""; continue; }
                }
                // Find if car is present in line of command
                int j = 0;
                bool flagFind = false;
                foreach (string shortCarName in shortCarNames)
                {
                    if (splitCmd[i].ToLower().IndexOf(shortCarName.ToLower()) != -1)
                    {
//                        carName = (string)shortCarNames[j];
                        carName = splitCmd[i].ToUpper();
                        flagFind = true;
                        break;
                    }
                    j++;
                }
                if (flagFind)
                    continue;
                // Find if offset
                try { from = int.Parse(splitCmd[i]); }
                catch (System.Exception) { }
            }
            from = from + 0;
            System.Collections.ArrayList list;
            if (flagqual)
                list = lfsDb.GetTable(currentTrackName, carName, filtervalue, false, playerFilter, MaxGroupQual, MaxUserGroupQual, MinUserGroupQual);
            else
                list = lfsDb.GetTable(currentTrackName, carName, filtervalue, false, null, 0, 0, 0);

            int currButt = 0;
            string colpos;
            string colcar;
            string colpb;
            string colgroup;
            string colnick;
            string colsplit;
            bool flagFirst = true;
            int P_L = 50;
            int P_H = 6;
            int P_T;
            string idButt;

            if (flagqual)
            {
                P_L -= 4;
            }

//            Console.WriteLine(DateTime.Now.ToString() + " : Start button Top list");
            string idButtClose = "Close";
            currPly.playerBox.create(idButtClose, UCID, 87, 150, 25, 10, 10, -1, 0, 32 + 8, "", "Ok","__LapperCloseTop");
            int initTop = 35;
            string butCloseAction = "&Close";
            for (int i = from - 1; i >= 0 && i < System.Math.Min(list.Count, from + ((int)lexCfg.paramLapper.nbLineTop - 1)); i++)
            {

                System.Text.StringBuilder sname = new System.Text.StringBuilder();

                string userName = (list[i] as LFS.Db.DriverLapEntry).userName;
                string nickName = (list[i] as LFS.Db.DriverLapEntry).playerStats.nickName;
                sname.Append(nickName);

                System.Text.StringBuilder sb = new System.Text.StringBuilder();
                string sGroup = "";
                if ((list[i] as LFS.Db.DriverLapEntry).group != -1)
                {
                    sGroup = ((char)((list[i] as LFS.Db.DriverLapEntry).group + 65)).ToString();
                }
                colpos = (i + 1).ToString();
                colpb = unitConv.LongToHMS((list[i] as LFS.Db.DriverLapEntry).playerStats.personalBestLapTime);
                colnick = sname.ToString();
                colgroup = sGroup;
                colcar = (list[i] as LFS.Db.DriverLapEntry).carName;

                string form;
                if (username.ToLower() == userName.ToLower())
                    form = "^3{0}. ({4}) {3}^8 {1} {2}^8";
                else
                    form ="^7{0}. ({4}) {3}^8 {1} {2}^8";

                sb.AppendFormat(form,colpos,colpb,colnick,colgroup,colcar );
                colsplit = "";
                for (int k = 0; k < 3; k++)
                {
                    long SplitTime = (list[i] as LFS.Db.DriverLapEntry).playerStats.splitTime[k];

                    //only show split time if it is not zero
                    if (SplitTime != 0)
                    {
                        colsplit += " ";
                        colsplit += unitConv.LongToHMS(SplitTime);
                    }
                }
                sb.Append(colsplit);
                int bStyle = 32;
                if (username.ToLower() == userName.ToLower())
                {
                    bStyle = 16;
                    sb.Append("^3 <--------------");

                }

                string lid;
                if (flagFirst)
                {
                    decal = 0;
                    flagFirst = false;
                    P_T = initTop + (P_H * currButt);
                    idButt = "Top" + currButt.ToString();

                    larg = 10;
                    lid = idButt + "colpos";
                    currPly.playerBox.create(lid, UCID, P_L + decal, P_T, larg, P_H, P_H, -1, 0, bStyle + 1, "", "Pos","");
                    currPly.playerBox.show(lid, UCID);
                    butCloseAction += "&" + lid;
                    decal += larg;

                    if (flagqual)
                    {
                        larg = 8;
                        lid = idButt + "colgroup";
                        currPly.playerBox.create(lid, UCID, P_L + decal, P_T, larg, P_H, P_H, -1, 0, bStyle + 1, "", " Grp", "");
                        currPly.playerBox.show(lid, UCID);
                        butCloseAction += "&" + lid;
                        decal += larg;
                    }

                    larg = 10;
                    lid = idButt + "colcar";
                    currPly.playerBox.create(lid, UCID, P_L + decal, P_T, larg, P_H, P_H, -1, 0, bStyle + 1, "", "Car", "");
                    currPly.playerBox.show(lid, UCID);
                    butCloseAction += "&" + lid;
                    decal += larg;


                    larg = 40;
                    lid = idButt + "colnick";
                    currPly.playerBox.create(lid, UCID, P_L + decal, P_T, larg, P_H, P_H, -1, 0, bStyle + 1, "", "NickName", "");
                    currPly.playerBox.show(lid, UCID);
                    butCloseAction += "&" + lid;
                    decal += larg;

                    larg = 15;
                    lid = idButt + "colpb";
                    currPly.playerBox.create(lid, UCID, P_L + decal, P_T, larg, P_H, P_H, -1, 0, bStyle + 1, "", "Pb", "");
                    currPly.playerBox.show(lid, UCID);
                    butCloseAction += "&" + lid;
                    decal += larg;

                    larg = 25;
                    lid = idButt + "colsplit";
                    currPly.playerBox.create(lid, UCID, P_L + decal, P_T, larg, P_H, P_H, -1, 0, bStyle + 1, "", "Split", "");
                    currPly.playerBox.show(lid, UCID);
                    butCloseAction += "&" + lid;
                    decal += larg;

                    currButt++;
                }
                P_T = initTop + (P_H * currButt);
                idButt = "Top" + currButt.ToString();
                decal = 0;
                larg = 0;
                lid = idButt + "colpos";

                larg = 10;
                currPly.playerBox.create(lid, UCID, P_L + decal, P_T, larg, P_H, P_H, -1, 0, bStyle + 6, "", colpos, "");
                currPly.playerBox.show(lid, UCID);
                butCloseAction += "&" + lid;
                decal += larg;

                if (flagqual)
                {
                    larg = 8;
                    lid = idButt + "colgroup";
                    currPly.playerBox.create(lid, UCID, P_L + decal, P_T, larg, P_H, P_H, -1, 0, bStyle, "", " " + colgroup, "");
                    currPly.playerBox.show(lid, UCID);
                    butCloseAction += "&" + lid;
                    decal += larg;
                }

                larg = 10;
                lid = idButt + "colcar";
                currPly.playerBox.create(lid, UCID, P_L + decal, P_T, larg, P_H, P_H, -1, 0, bStyle, "", colcar, "");
                currPly.playerBox.show(lid, UCID);
                butCloseAction += "&" + lid;
                decal += larg;

                larg = 40;
                lid = idButt + "colnick";
                currPly.playerBox.create(lid, UCID, P_L + decal, P_T, larg, P_H, P_H, -1, 0, bStyle + 64, "", colnick, "");
                currPly.playerBox.show(lid, UCID);
                butCloseAction += "&" + lid;
                decal += larg;

                larg = 15;
                lid = idButt + "colpb";
                currPly.playerBox.create(lid, UCID, P_L + decal, P_T, 15, P_H, P_H, -1, 0, bStyle, "", colpb, "");
                currPly.playerBox.show(lid, UCID);
                butCloseAction += "&" + lid;
                decal += larg;

                larg = 25;
                lid = idButt + "colsplit";
                currPly.playerBox.create(lid, UCID, P_L + decal, P_T, 25, P_H, P_H, -1, 0, bStyle, "", colsplit, "");
                currPly.playerBox.show(lid, UCID);
                butCloseAction += "&" + lid;
                decal += larg;

                currButt++;
//                SendMsgToConnection(UCID, sb.ToString());
            }
            currPly.playerBox.UpdateLT(idButtClose, (decal) / 2 + P_L - 12, initTop + 2 + (P_H * currButt));
            newCfg.functionsLapper["__LapperCloseTop"] = new lexCfg.FUNCTION(lexCfg.typFunction.Sub, "closePrivButton(\"" + butCloseAction.Substring(1) + "\");", 0);
            currPly.playerBox.show(idButtClose, UCID);
//            Console.WriteLine(DateTime.Now.ToString() + " : End button Top list");


        }


        void TopDrift(int UCID, string username, string nickname, string cmd)
        {

            string playerNameToSend = nickname;
            string filtervalue = "";

            string carName = newCfg.varsLapper.DefaultTopCar;
/*
            if (plyCname != null && plyCname != "")
                carName = plyCname;
*/

            int from = 1;

            string[] splitCmd = cmd.Split(' ');
            for (int i = 1; i <= splitCmd.GetUpperBound(0); i++)
            {
                if (splitCmd[i].Trim() == "")
                    continue;
                // find if filter is present
                if (splitCmd[i] == "filter")
                {
                    i++;
                    try { filtervalue = splitCmd[i]; continue; }
                    catch { filtervalue = ""; continue; }
                }
                // Find if car is present in line of command
                int j = 0;
                bool flagFind = false;
                foreach (string shortCarName in shortCarNames)
                {
                    if (splitCmd[i].IndexOf(shortCarName) != -1)
                    {
//                        carName = (string)shortCarNames[j];
                        carName = splitCmd[i];
                        flagFind = true;
                        break;
                    }
                    j++;
                }
                if (flagFind)
                    continue;
                // Find if offset
                try { from = int.Parse(splitCmd[i]); }
                catch (System.Exception) { }
            }

            System.Collections.ArrayList list = lfsDriftDb.GetTable(currentTrackName, carName, filtervalue, false);

            for (int i = from - 1; i >= 0 && i < System.Math.Min(list.Count, from + 14); i++)
            {
                string userName = (list[i] as LFS.DriftDb.DriverLapEntry).userName;
                string nickName = (list[i] as LFS.DriftDb.DriverLapEntry).playerStats.nickName;
                string CName = (list[i] as LFS.DriftDb.DriverLapEntry).carName;
                System.Text.StringBuilder sb = new System.Text.StringBuilder();
                if (username.ToLower() == userName.ToLower())
                    sb.AppendFormat("^3{0}.^8 ({3}) {1} {2}^8", i + 1, (list[i] as LFS.DriftDb.DriverLapEntry).playerStats.personalBestLap, nickName, CName);
                else
                    sb.AppendFormat("^7{0}.^8 ({3}) {1} {2}^8", i + 1, (list[i] as LFS.DriftDb.DriverLapEntry).playerStats.personalBestLap, nickName, CName);

                if (username.ToLower() == userName.ToLower())
                    sb.Append("^3 <--------------");
                SendMsgToConnection(UCID, sb.ToString());
            }

        }

        void ShowHand(infoPlayer currInfoPlayer, string cmd)
        {
            string searchUserName = "";
            string dispName = "";

            searchUserName = searchUserName = cmd;
            dispName = searchUserName;
            if (searchUserName == "")
            {
                searchUserName = currInfoPlayer.userName;
                dispName = currInfoPlayer.nickName;
            }

            int H_Mass = 0;
            int H_TRes = 0;
// Search handicap for a player
// Priority level low to high -> Car, Car/Track, Player
            //Car Handicap
            try
            {
                H_Mass = (carHandicap[currInfoPlayer.CName.ToLower()] as infoHandicap).H_Mass;
                H_TRes = (carHandicap[currInfoPlayer.CName.ToLower()] as infoHandicap).H_TRes;
            }
            catch { }
            // Car/Track Handicap
            try
            {
                string carTrack = currInfoPlayer.CName.ToLower() + "/" + currentTrackName.ToLower();
                H_Mass = (carTrackHandicap[carTrack] as infoHandicap).H_Mass;
                H_TRes = (carTrackHandicap[carTrack] as infoHandicap).H_TRes;
            }
            catch { }
            //Player Handicap
            try
            {
                H_Mass = (playerHandicap[searchUserName.ToLower()] as infoHandicap).H_Mass;
                H_TRes = (playerHandicap[searchUserName.ToLower()] as infoHandicap).H_TRes;
            }
            catch { }
            SendMsgToConnection(currInfoPlayer.UCID,
                            "^3" + dispName + "^9 handicap: "
            );
            if (searchUserName == currInfoPlayer.userName)
            {
                SendMsgToConnection(currInfoPlayer.UCID,
                                "  - Current " + currInfoPlayer.H_Mass.ToString() + "Kg - Intake Restr.: " + currInfoPlayer.H_TRes.ToString() + "%"
                );
            }
            SendMsgToConnection(currInfoPlayer.UCID,
                            "  - Required " + dispName + "^9 " + H_Mass.ToString() + "Kg - Intake Rest.: " + H_TRes.ToString() + "%"
            );

        }
        void ShowAuth(infoPlayer currInfoPlayer, string cmd)
        {
            string[] sAuth = GetAuth(currInfoPlayer).Split('|');
            if (sAuth.Length != 0)
            {
                for (int i = 0; i < sAuth.Length; i++)
                {
                    if (sAuth[i] != "")
                    {
                        newCfg.setLocalVar("auth", quote( (int.Parse(sAuth[i]) + 1).ToString()));
                        executeFunction("OnAuthReached", currInfoPlayer);
                    }
                }
            }
            else
            {
                newCfg.setLocalVar("auth", quote(  "None" ));
                executeFunction("OnAuthReached", currInfoPlayer);
            }
        }
        void ShowStats(int UCID, string username, string nickname, string cmd, bool flagqual)
        {
            string searchName = "";
            string playerNameToSend = nickname;

            // get parameter of command

            searchName = cmd;

            if (searchName.Trim() == "")
                searchName = nickname.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "");
            try
            {
                System.Collections.ArrayList cars = lfsDb.GetCars(currentTrackName);

                foreach (string carName in cars)
                {
                    System.Collections.ArrayList list;
                    if (flagqual)
                        list = lfsDb.GetTable(currentTrackName, carName, playerFilter, MaxGroupQual, MaxUserGroupQual, MinUserGroupQual);
                    else
                        list = lfsDb.GetTable(currentTrackName, carName, null, 0, 0, 0);
                    int position = -1;
                    int tmppos = 0;
                    int nb = list.Count;
                    foreach (LFS.Db.DriverLapEntry de in list)
                    {
                        if (de.playerStats.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").IndexOf(searchName) != -1)
                        {
                            position = tmppos;
                            break;
                        }
                        else tmppos++;
                    }

                    if (position == -1) continue;

                    System.Text.StringBuilder sname = new System.Text.StringBuilder();

                    string userName = (list[position] as LFS.Db.DriverLapEntry).userName;
                    string nickName = (list[position] as LFS.Db.DriverLapEntry).playerStats.nickName;
                    sname.Append(nickName);
                    SendMsgToConnection(UCID, string.Format("{3}/{4}. {0}^8 {1} {2}",
                                                                    sname,
                                                                    unitConv.LongToHMS((list[position] as LFS.Db.DriverLapEntry).playerStats.personalBestLapTime),
                                                                    carName,
                                                                    position + 1,
                                                                    nb)
                     );

                    System.Text.StringBuilder sb = new System.Text.StringBuilder();

                    for (int k = 0; k < 3; k++)
                    {
                        long SplitTime = (list[position] as LFS.Db.DriverLapEntry).playerStats.splitTime[k];

                        //only show split time if it is not zero
                        if (SplitTime != 0)
                        {
                            sb.Append(" ");
                            sb.Append(unitConv.LongToHMS(SplitTime));
                        }
                    }
                    SendMsgToConnection(UCID, sb.ToString());
                }

            }
            catch (System.Exception)
            {
                return;
            }
        }
        public posQualUser getPosQual( string nickName, string cmd, bool flagqual)
        {
            string searchName = "";
            if (cmd.Trim() == "")
                searchName = nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "");
            else
                searchName = cmd;

            string playerNameToSend = nickName;
            try
            {
                string carName;
                carName = newCfg.varsLapper.DefaultTopCar;
                System.Collections.ArrayList list;
                if (flagqual)
                    list = lfsDb.GetTable(currentTrackName, carName, playerFilter, MaxGroupQual, MaxUserGroupQual, MinUserGroupQual);
                else
                    list = lfsDb.GetTable(currentTrackName, carName, null, 0, 0, 0);
                string findUserName = "";
                string findNickName = "";
                int findPosition = -1;
                int tmppos = 0;
                int nb = list.Count;
                foreach (LFS.Db.DriverLapEntry de in list)
                {
                    if (de.playerStats.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").ToLower().IndexOf(searchName.ToLower()) != -1)
                    {
                        if (!playerFilter.ContainsKey(de.playerStats.userName.ToLower()) && flagqual)
                            break;
                        findPosition = tmppos;
                        findUserName = de.playerStats.userName;
                        findNickName = de.playerStats.nickName;
                        break;
                    }
                    else tmppos++;
                }
                if (findPosition == -1) return new posQualUser("", "", 0, 0, -1);


                return new posQualUser(findUserName, findNickName, findPosition + 1, nb, (list[findPosition] as LFS.Db.DriverLapEntry).group);
            }
            catch (System.Exception)
            {
                return new posQualUser("","",0, 0, -1);
            }
        }

        void ShowDriftStats(int UCID, string username, string nickname, string cmd)
        {
            string searchName = "";
            string playerNameToSend = nickname;

            // get parameter of command

            searchName = cmd;

            if (searchName.Trim() == "")
                searchName = nickname.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "");
            try
            {
                System.Collections.ArrayList cars = lfsDriftDb.GetCars(currentTrackName);

                foreach (string carName in cars)
                {
                    System.Collections.ArrayList list = lfsDriftDb.GetTable(currentTrackName, carName);
                    int position = -1;
                    int tmppos = 0;
                    foreach (LFS.DriftDb.DriverLapEntry de in list)
                    {
                        if (de.playerStats.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").IndexOf(searchName) != -1)
                        {
                            position = tmppos;
                            break;
                        }
                        else tmppos++;
                    }

                    if (position == -1) continue;

                    string userName = (list[position] as LFS.DriftDb.DriverLapEntry).userName;
                    string nickName = (list[position] as LFS.DriftDb.DriverLapEntry).playerStats.nickName;
                    int driftScore = (list[position] as LFS.DriftDb.DriverLapEntry).playerStats.personalBestLap;

                    SendMsgToConnection(UCID, string.Format("{3}. {0}^8 {1} {2}", nickName, driftScore, carName, position + 1));
                }

            }
            catch (System.Exception)
            {
                return;
            }
        }
        string GetAuth(infoPlayer currInfoPlayer)
        {
            string myAuth = "";
            for (int i = 0; i < 10; i++)
            {
                if (Auth[i] == "")
                    continue;
                string[] OrAuth = Auth[i].Split('|');
                for (int j = 0; j < OrAuth.Length; j++)
                {
                    bool AndAllow = true;
                    string[] AndAuth = OrAuth[j].Split('&');
                    for (int k = 0; k < AndAuth.Length; k++)
                    {
                        string[] arg = AndAuth[k].Split(':');
                        if (arg[0].ToLower() == "all")
                        {
                            AndAllow = true;
                            break;
                        }
                        string cname = arg[0];
                        string tname = arg[1];
                        long time = unitConv.HMSToLong(arg[2]);
                        long PBTime = lfsDb.retreivePB(currInfoPlayer.userName, cname, tname);
                        if (PBTime == -1 || PBTime > time)
                        {
                            AndAllow = false;
                            break;
                        }
                    }
                    if (AndAllow == true)
                    {
                        myAuth = myAuth + "|" + i;
                        break;
                    }
                }
            }
            if (myAuth.Length > 0)
                return myAuth.Substring(1);
            else
                return myAuth;
        }

    }
}