/*
This is a simple parser for html.  It tries to turn the html into something that
can be displayed by a wiki.
 */

%namespace lexCfg
%option noparser
%using System.Text;


%x COMMENT
%x COMMENTSHARP
%x BLOCCMD
%x BLOCFUNC



ALPHA [A-Za-z]
DIGIT [0-9]
NONNEWLINE_WHITE_SPACE_CHAR [\ \r\t\b\012]
WHITE_SPACE_CHAR [\n\r\ \t\b\012]
STRING_TEXT (\\\"|[^\n\"]|\\{WHITE_SPACE_CHAR}+\\)*
COMMENT_TEXT ([^/*\n]|[^*\n]"/"[^*\n]|[^/\n]"*"[^/\n]|"*"[^/\n]|"/"[^*\n])*
COMMENT_TEXT_SHARP ([^\n])*
BLOC_TEXT [^{}\n\r]*
VAR ${ALPHA}(({ALPHA}|{DIGIT}|_)*)


%%

<INITIAL> "," { GyyLine = yyline;return E_COLON; }
<INITIAL> ":" { GyyLine = yyline;return 1; }
<INITIAL> ";" { GyyLine = yyline;return E_SEMICOLON; }
<INITIAL> "(" { GyyLine = yyline;return E_PAR_OPEN; }
<INITIAL> ")" { GyyLine = yyline;return E_PAR_CLOSE; }
<INITIAL> "[" { GyyLine = yyline;return 5; }
<INITIAL> "]" { GyyLine = yyline;return 6; }
/* <INITIAL> "{" { GyyLine = yyline;return 7; } */
/* <INITIAL> "}" { GyyLine = yyline;return 8; } */
<INITIAL> "." { GyyLine = yyline;return E_POINT; }
<INITIAL> "+" { GyyLine = yyline;return E_PLUS; }
<INITIAL> "-" { GyyLine = yyline;return E_MOINS; }
<INITIAL> "*" { GyyLine = yyline;return E_MULT; }
<INITIAL> "/" { GyyLine = yyline;return E_DIV; }
<INITIAL> "=" { GyyLine = yyline;return E_EQUAL; }
<INITIAL> "<>" { GyyLine = yyline;return 15; }
<INITIAL> "<"  { GyyLine = yyline;return 16; }
<INITIAL> "<=" { GyyLine = yyline;return 17; }
<INITIAL> ">"  { GyyLine = yyline;return 18; }
<INITIAL> ">=" { GyyLine = yyline;return 19; }
<INITIAL> "&"  { GyyLine = yyline;return 20; }
<INITIAL> "|"  { GyyLine = yyline;return 21; }
<INITIAL> "!=" { GyyLine = yyline;return 22; }
<INITIAL> "§" { GyyLine = yyline;return 23; }
<INITIAL,BLOCFUNC> [eE][vV][eE][nN][tT]|[sS][uU][bB] { GyyLine = yyline;return E_BEGIN_FUNCTION; }
<INITIAL,BLOCFUNC> [eE][nN][dD][eE][vV][eE][nN][tT]|[eE][nN][dD][sS][uU][bB] { GyyLine = yyline;return E_END_FUNCTION; }
<INITIAL> [iI][fF] { GyyLine = yyline;return E_IF; }
<INITIAL> [tT][hH][eE][nN] { GyyLine = yyline;return E_THEN; }
<INITIAL> [eE][lL][sS][eE] { GyyLine = yyline;return E_ELSE; }
<INITIAL> [eE][nN][dD][iI][fF] { GyyLine = yyline;return E_ENDIF; }
<INITIAL> [gG][lL][oO][bB][aA][lL][vV][aA][rR] { GyyLine = yyline;return E_GLOBALVAR; }
<INITIAL> [pP][lL][aA][yY][eE][rR][vV][aA][rR] { GyyLine = yyline;return E_PLAYERVAR; }
<INITIAL> {NONNEWLINE_WHITE_SPACE_CHAR}+ { }

<INITIAL,INITIAL> \n {
	if( comment_sharp ){
	  comment_sharp = false;
		BEGIN(INITIAL);
	}
		break;
}
<INITIAL> "}" {
//	Console.WriteLine("Error unmatched '}' at line #" + yyline);
	Utility.assert(false,"Error unmatched '}'");

}
<INITIAL> "{" {
								BEGIN(BLOCCMD);
								bloc_count++;
								strBloc = "";
								break;
}
<INITIAL> "#" { BEGIN(COMMENTSHARP);break; }
<INITIAL> "/*" { BEGIN(COMMENT); comment_count = comment_count + 1;break; }

<COMMENTSHARP> "\n" { BEGIN(INITIAL);break; }

<BLOCCMD> "{" {
								bloc_count++;
								strBloc += "{";
								break;
					}
<BLOCCMD> "}" {
	bloc_count--;
	if (bloc_count == 0) {
    		BEGIN(INITIAL);
    		GyyLine = yyline;
    		return E_BLOC;

	}
	else
			strBloc += "}";
	break;
}
<COMMENT> "/*" { comment_count = comment_count + 1;break; }
<COMMENT> "*/" {
	comment_count = comment_count - 1;
	Utility.assert(comment_count >= 0, "To much ')'");
	if (comment_count == 0) {
    		BEGIN(INITIAL);

	}
	break;
}
<COMMENTSHARP> {COMMENT_TEXT_SHARP} { }
<COMMENT> {COMMENT_TEXT} { }
<BLOCCMD> {BLOC_TEXT} {
	strBloc += yytext;
}
<BLOCFUNC> {BLOC_TEXT} {
	return E_BLOC;
}
<BLOCFUNC> "\n" {
	return E_BLOC;
}

<INITIAL> \"{STRING_TEXT}\" {
	string str =  yytext.Substring(1,yytext.Length - 2);

	Utility.assert(str.Length == yytext.Length - 2, "Error on '\"'");
//	Console.WriteLine( "String " + yytext);
	GyyLine = yyline;
	return E_STRING;
}
<INITIAL> \"{STRING_TEXT} {
//	string str =  yytext.Substring(1,yytext.Length);

//	Utility.error(yyline,Utility.E_UNCLOSEDSTR);
	Utility.assert(false,"Unclosed string");
	break;
//	return 41;
}
<INITIAL> -?{DIGIT}+ {
	GyyLine = yyline;
	return E_INTEGER;
}
<INITIAL> {ALPHA}({ALPHA}|{DIGIT}|_)* {
	GyyLine = yyline;
	return E_IDENT;
}
<INITIAL> {DIGIT}+"."{DIGIT}+"."{DIGIT}+"."{DIGIT}+ {
	GyyLine = yyline;
	return E_IP;
}
<INITIAL> {DIGIT}+"."{DIGIT}+ {
	GyyLine = yyline;
	return E_FLOAT;
}
<INITIAL> {VAR} {
	GyyLine = yyline;
	return E_VAR;
}
<INITIAL,COMMENT> . {
        System.Console.WriteLine("Illegal character: <" + yytext + "> at line #" + yyline);
	Utility.error(yyline,Utility.E_UNMATCHED);
	break;
}

%%
bool comment_sharp = false;
int comment_count = 0;
int bloc_count = 0;
public string strBloc = "";
public int GyyLine = 0;
/*
class Sample {
    public static void Main(string[] argv)  {
        try
        {
            int tok;
            FileStream file = new FileStream("LFSLapper.cfg", FileMode.Open);
            Scanner scnr = new Scanner(file);
             do {
                 tok = scnr.yylex();
                 Console.WriteLine("#"+tok + ": " + scnr.yytext);
             } while (tok > (int)Tokens.EOF);
        }
        catch (System.Exception e)
        {
            Console.WriteLine(e.Message);
        }
                Console.ReadKey();
    }

}
*/
public const int E_END = 0;
public const int E_SEMICOLON = 2;
public const int E_PAR_OPEN = 3;
public const int E_PAR_CLOSE = 4;
public const int E_POINT = 9;
public const int E_PLUS = 10;
public const int E_MOINS = 11;
public const int E_MULT = 12;
public const int E_DIV = 13;
public const int E_COLON = 24;
public const int E_INTEGER = 49;
public const int E_STRING = 40;
public const int E_EQUAL = 42;
public const int E_IDENT = 43;
public const int E_IP = 45;
public const int E_FLOAT = 46;
public const int E_VAR = 47;
public const int E_BLOC = 48;
public const int E_BEGIN_FUNCTION = 100;
public const int E_END_FUNCTION = 101;
public const int E_IF = 102;
public const int E_THEN = 103;
public const int E_ELSE = 104;
public const int E_ENDIF = 105;
public const int E_GLOBALVAR = 106;
public const int E_PLAYERVAR = 107;

class Utility {
  public static void assert( bool expr, string errMsg )
  {
		if (false == expr) {
		  throw (new System.Exception("Error: " + errMsg));
		}
  }

  private static readonly string[] errorMsg =new string[] {
    "Error: Unmatched end-of-comment punctuation.",
    "Error: Unmatched start-of-comment punctuation.",
    "Error: Unclosed string.",
    "Error: Illegal character."
    };

  public const int E_ENDCOMMENT = 0;
  public const int E_STARTCOMMENT = 1;
  public const int E_UNCLOSEDSTR = 2;
  public const int E_UNMATCHED = 3;
  

  public static void error(int yy,int code)
      {
	System.Console.WriteLine(errorMsg[code] + " at line #" + yy);
      }
}


