//
//  This CSharp output file generated by Gardens Point LEX
//  Version:  0.6.2.196 (2007-11-13)
//  Machine:  GAI-LURON
//  DateTime: 27/07/2008 20:12:02
//  UserName: robert
//  GPLEX input file <cfglex.lex>
//  GPLEX frame file <gplexx.frame>
//
//  Option settings: unicode, verbose, noparser, minimize, classes, compressmap, compressnext
//

#define BACKUP
#define STANDALONE
//
// gplexx.frame
// Version 0.6.2 of 13-November-2007
// Derived from gplex.frame version of 2-September-2006. 
// Left and Right Anchored state support.
// Start condition stack. Two generic params.
// Using fixed length context handling for right anchors
//
using System;
using System.IO;
using System.Collections.Generic;
#if !STANDALONE
using gppg;
#endif

using System.Text;

namespace lexCfg
{   
    /// <summary>
    /// Summary Canonical example of GPLEX automaton
    /// </summary>
    
#if STANDALONE
    //
    // These are the dummy declarations for stand-alone GPLEX applications
    // normally these declarations would come from the parser.
    // If you declare /noparser, or %option noparser then you get this.
    //

    public enum Tokens
    { 
      EOF = 0, maxParseToken = int.MaxValue 
      // must have at least these two, values are almost arbitrary
    }

    public abstract class ScanBase
    {
        public abstract int yylex();
#if BABEL
        protected abstract int CurrentSc { get; set; }
        // EolState is the 32-bit of state data persisted at 
        // the end of each line for Visual Studio colorization.  
        // The default is to return CurrentSc.  You must override
        // this if you want more complicated behavior.
        public virtual int EolState { 
            get { return CurrentSc; }
            set { CurrentSc = value; } 
        }
    }
    
    public interface IColorScan
    {
        void SetSource(string source, int offset);
        int GetNext(ref int state, out int start, out int end);
#endif // BABEL
    }

#endif // STANDALONE

    public abstract class ScanBuff
    {
        public const int EOF = -1;
        public abstract int Pos { get; set; }
        public abstract int Read();
        public abstract int Peek();
        public abstract int ReadPos { get; }
        public abstract string GetString(int b, int e);
    }
    
    // If the compiler can't find ScanBase maybe you need to run
    // GPPG with the /gplex option, or GPLEX with /noparser
#if BABEL
    public sealed partial class Scanner : ScanBase, IColorScan
    {
        public ScanBuff buffer;
        int currentScOrd;  // start condition ordinal
        
        protected override int CurrentSc 
        {
             // The current start state is a property
             // to try to avoid the user error of setting
             // scState but forgetting to update the FSA
             // start state "currentStart"
             //
             get { return currentScOrd; }  // i.e. return YY_START;
             set { currentScOrd = value;   // i.e. BEGIN(value);
                   currentStart = startState[value]; }
        }
#else  // BABEL
    public sealed partial class Scanner : ScanBase
    {
        public ScanBuff buffer;
        int currentScOrd;  // start condition ordinal
#endif // BABEL
        
        private static int GetMaxParseToken() {
            System.Reflection.FieldInfo f = typeof(Tokens).GetField("maxParseToken");
            return (f == null ? int.MaxValue : (int)f.GetValue(null));
        }
        
        static int parserMax = GetMaxParseToken();
        
        enum Result {accept, noMatch, contextFound};

        const int maxAccept = 121;
        const int initial = 122;
        const int eofNum = 0;
        const int goStart = -1;
        const int INITIAL = 0;
        const int COMMENT = 1;
        const int COMMENTSHARP = 2;
        const int BLOCCMD = 3;
        const int BLOCFUNC = 4;

/*
This is a simple parser for html.  It tries to turn the html into something that
can be displayed by a wiki.
 */
        int state;
        int currentStart = initial;
        int chr;           // last character read
        int cNum = 0;      // ordinal number of chr
        int lNum = 0;      // current line number
        int lineStartNum;  // ordinal number at start of line
        //
        // The following instance variables are used, among other
        // things, for constructing the yylloc location objects.
        //
        int tokPos;        // buffer position at start of token
        int tokNum;        // ordinal number of first character
        int tokLen;        // number of characters in token
        int tokCol;        // zero-based column number at start of token
        int tokLin;        // line number at start of token
        int tokEPos;       // buffer position at end of token
        int tokECol;       // column number at end of token
        int tokELin;       // line number at end of token
        string tokTxt;     // lazily constructed text of token
#if STACK          
        private Stack<int> scStack = new Stack<int>();
#endif // STACK

#region ScannerTables
    struct Table {
        public int min; public int rng; public int dflt;
        public short[] nxt;
        public Table(int m, int x, int d, short[] n) {
            min = m; rng = x; dflt = d; nxt = n;
        }
    };

    static int[] startState = {122, 88, 96, 99, 103, 0};

#region CharacterMap
    //
    // There are 51 equivalence classes
    // There are 2 character sequence regions
    // There are 1 tables, 195 entries
    // There are 1 runs, 0 singletons
    //
    static sbyte[] map0 = new sbyte[195] {
/* \0     */ 0, 0, 0, 0, 0, 0, 0, 0, 44, 44, 40, 0, 0, 39, 0, 0, 
/* \020   */ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
/* \040   */ 44, 18, 45, 43, 50, 0, 16, 0, 4, 5, 11, 9, 1, 10, 8, 12, 
/* 0      */ 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 2, 3, 14, 13, 15, 0, 
/* @      */ 0, 35, 27, 48, 28, 21, 30, 33, 31, 29, 48, 48, 32, 48, 23, 34, 
/* P      */ 37, 48, 36, 25, 24, 26, 22, 48, 48, 38, 48, 6, 46, 7, 0, 49, 
/* `      */ 0, 35, 27, 48, 28, 21, 30, 33, 31, 29, 48, 48, 32, 48, 23, 34, 
/* p      */ 37, 48, 36, 25, 24, 26, 22, 48, 48, 38, 48, 42, 17, 41, 0, 0, 
/* \200   */ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
/* \220   */ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
/* \240   */ 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 
/* \260   */ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
/* \300   */ 0, 0, 19 };

    sbyte Map(int chr)
    { // '\0' <= chr <= '\uFFFF'
      if (chr < 195) return map0[chr - 0];
      else return (sbyte)0;
    }
#endregion

    static Table[] NxS = new Table[130];

    static Scanner() {
    NxS[0] = new Table(0, 0, 0, null); // Shortest string ""
    NxS[1] = new Table(0, 0, -1, null); // Shortest string "\247"
    NxS[2] = new Table(0, 0, -1, null); // Shortest string ","
    NxS[3] = new Table(0, 0, -1, null); // Shortest string ":"
    NxS[4] = new Table(0, 0, -1, null); // Shortest string ";"
    NxS[5] = new Table(0, 0, -1, null); // Shortest string "("
    NxS[6] = new Table(0, 0, -1, null); // Shortest string ")"
    NxS[7] = new Table(0, 0, -1, null); // Shortest string "["
    NxS[8] = new Table(0, 0, -1, null); // Shortest string "]"
    NxS[9] = new Table(0, 0, -1, null); // Shortest string "."
    NxS[10] = new Table(0, 0, -1, null); // Shortest string "+"
    NxS[11] = // Shortest string "-"
      new Table(47, 1, -1, new short[] {87});
    NxS[12] = new Table(0, 0, -1, null); // Shortest string "*"
    NxS[13] = // Shortest string "/"
      new Table(11, 1, -1, new short[] {86});
    NxS[14] = new Table(0, 0, -1, null); // Shortest string "="
    NxS[15] = // Shortest string "<"
      new Table(13, 3, -1, new short[] {84, -1, 85});
    NxS[16] = // Shortest string ">"
      new Table(13, 1, -1, new short[] {83});
    NxS[17] = new Table(0, 0, -1, null); // Shortest string "&"
    NxS[18] = new Table(0, 0, -1, null); // Shortest string "|"
    NxS[19] = // Shortest string "!"
      new Table(13, 1, -1, new short[] {82});
    NxS[20] = // Shortest string "\302"
      new Table(20, 1, -1, new short[] {81});
    NxS[21] = // Shortest string "E"
      new Table(21, 29, -1, new short[] {22, 64, 65, 22, 22, 22, 
          22, 22, 22, 22, 22, 66, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[22] = // Shortest string "V"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[23] = // Shortest string "T"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 61, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[24] = // Shortest string "S"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 59, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[25] = // Shortest string "I"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 58, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[26] = // Shortest string "G"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 50, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[27] = // Shortest string "P"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 42, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[28] = // Shortest string "\r"
      new Table(39, 6, -1, new short[] {28, 28, -1, -1, -1, 28});
    NxS[29] = new Table(0, 0, -1, null); // Shortest string "}"
    NxS[30] = new Table(0, 0, -1, null); // Shortest string "{"
    NxS[31] = new Table(0, 0, -1, null); // Shortest string "#"
    NxS[32] = // Shortest string """
      new Table(40, 7, 32, new short[] {-1, 32, 32, 32, 32, 38, 
          39});
    NxS[33] = // Shortest string "0"
      new Table(47, 13, -1, new short[] {33, -1, -1, -1, -1, -1, 
          -1, -1, -1, -1, -1, -1, 123});
    NxS[34] = // Shortest string "$"
      new Table(21, 28, -1, new short[] {35, 35, 35, 35, 35, 35, 
          35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, -1, -1, -1, -1, 
          -1, -1, -1, -1, -1, 35});
    NxS[35] = // Shortest string "$E"
      new Table(21, 29, -1, new short[] {35, 35, 35, 35, 35, 35, 
          35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, -1, -1, -1, -1, 
          -1, -1, -1, -1, 35, 35, 35});
    NxS[36] = // Shortest string "0.0"
      new Table(47, 13, -1, new short[] {36, -1, -1, -1, -1, -1, 
          -1, -1, -1, -1, -1, -1, 124});
    NxS[37] = // Shortest string "0.0.0.0"
      new Table(47, 1, -1, new short[] {37});
    NxS[38] = new Table(0, 0, -1, null); // Shortest string """"
    NxS[39] = // Shortest string ""\"
      new Table(39, 8, 32, new short[] {40, 127, 32, 32, 32, 40, 
          41, 39});
    NxS[40] = // Shortest string ""\\r"
      new Table(39, 8, 32, new short[] {40, 127, 32, 32, 32, 40, 
          38, 39});
    NxS[41] = // Shortest string ""\""
      new Table(40, 7, 32, new short[] {-1, 32, 32, 32, 32, 38, 
          39});
    NxS[42] = // Shortest string "PL"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 43, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[43] = // Shortest string "PLA"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 44, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[44] = // Shortest string "PLAY"
      new Table(21, 29, -1, new short[] {45, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[45] = // Shortest string "PLAYE"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 46, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[46] = // Shortest string "PLAYER"
      new Table(21, 29, -1, new short[] {22, 47, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[47] = // Shortest string "PLAYERV"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 48, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[48] = // Shortest string "PLAYERVA"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 49, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[49] = // Shortest string "PLAYERVAR"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[50] = // Shortest string "GL"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 51, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[51] = // Shortest string "GLO"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          52, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[52] = // Shortest string "GLOB"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 53, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[53] = // Shortest string "GLOBA"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 54, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[54] = // Shortest string "GLOBAL"
      new Table(21, 29, -1, new short[] {22, 55, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[55] = // Shortest string "GLOBALV"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 56, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[56] = // Shortest string "GLOBALVA"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 57, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[57] = // Shortest string "GLOBALVAR"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[58] = // Shortest string "IF"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[59] = // Shortest string "SU"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          60, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[60] = // Shortest string "SUB"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[61] = // Shortest string "TH"
      new Table(21, 29, -1, new short[] {62, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[62] = // Shortest string "THE"
      new Table(21, 29, -1, new short[] {22, 22, 63, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[63] = // Shortest string "THEN"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[64] = // Shortest string "EV"
      new Table(21, 29, -1, new short[] {79, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[65] = // Shortest string "EN"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 69, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[66] = // Shortest string "EL"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 67, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[67] = // Shortest string "ELS"
      new Table(21, 29, -1, new short[] {68, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[68] = // Shortest string "ELSE"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[69] = // Shortest string "END"
      new Table(21, 29, -1, new short[] {70, 22, 22, 22, 71, 22, 
          22, 22, 72, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[70] = // Shortest string "ENDE"
      new Table(21, 29, -1, new short[] {22, 76, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[71] = // Shortest string "ENDS"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 74, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[72] = // Shortest string "ENDI"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 73, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[73] = // Shortest string "ENDIF"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[74] = // Shortest string "ENDSU"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          75, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[75] = // Shortest string "ENDSUB"
      new Table(21, 29, -1, new short[] {22, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[76] = // Shortest string "ENDEV"
      new Table(21, 29, -1, new short[] {77, 22, 22, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[77] = // Shortest string "ENDEVE"
      new Table(21, 29, -1, new short[] {22, 22, 78, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[78] = // Shortest string "ENDEVEN"
      new Table(21, 29, -1, new short[] {22, 22, 22, 75, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[79] = // Shortest string "EVE"
      new Table(21, 29, -1, new short[] {22, 22, 80, 22, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[80] = // Shortest string "EVEN"
      new Table(21, 29, -1, new short[] {22, 22, 22, 60, 22, 22, 
          22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, -1, -1, -1, -1, 
          -1, -1, -1, -1, 22, 22, 22});
    NxS[81] = new Table(0, 0, -1, null); // Shortest string "\302\247"
    NxS[82] = new Table(0, 0, -1, null); // Shortest string "!="
    NxS[83] = new Table(0, 0, -1, null); // Shortest string ">="
    NxS[84] = new Table(0, 0, -1, null); // Shortest string "<="
    NxS[85] = new Table(0, 0, -1, null); // Shortest string "<>"
    NxS[86] = new Table(0, 0, -1, null); // Shortest string "/*"
    NxS[87] = // Shortest string "-0"
      new Table(47, 1, -1, new short[] {87});
    NxS[88] = // Shortest string ""
      new Table(40, 24, 91, new short[] {-1, 91, 91, 91, 91, 91, 
          91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 
          89, 90});
    NxS[89] = // Shortest string "*"
      new Table(40, 24, 91, new short[] {-1, 91, 91, 91, 91, 91, 
          91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 
          94, 95});
    NxS[90] = // Shortest string "/"
      new Table(40, 24, 91, new short[] {-1, 91, 91, 91, 91, 91, 
          91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 
          92, 93});
    NxS[91] = // Shortest string ","
      new Table(40, 24, 91, new short[] {-1, 91, 91, 91, 91, 91, 
          91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 
          128, 129});
    NxS[92] = new Table(0, 0, -1, null); // Shortest string "/*"
    NxS[93] = // Shortest string "//"
      new Table(40, 24, 91, new short[] {-1, 91, 91, 91, 91, 91, 
          91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 
          128, 93});
    NxS[94] = // Shortest string "**"
      new Table(40, 24, 91, new short[] {-1, 91, 91, 91, 91, 91, 
          91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 
          94, 129});
    NxS[95] = new Table(0, 0, -1, null); // Shortest string "*/"
    NxS[96] = // Shortest string ""
      new Table(40, 1, 97, new short[] {98});
    NxS[97] = // Shortest string ","
      new Table(40, 1, 97, new short[] {-1});
    NxS[98] = new Table(0, 0, -1, null); // Shortest string "\n"
    NxS[99] = // Shortest string ""
      new Table(39, 4, 100, new short[] {-1, -1, 101, 102});
    NxS[100] = // Shortest string ","
      new Table(39, 4, 100, new short[] {-1, -1, -1, -1});
    NxS[101] = new Table(0, 0, -1, null); // Shortest string "}"
    NxS[102] = new Table(0, 0, -1, null); // Shortest string "{"
    NxS[103] = // Shortest string ""
      new Table(21, 22, 104, new short[] {105, 104, 104, 104, 106, 104, 
          104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, -1, 107, -1, -1});
    NxS[104] = // Shortest string ","
      new Table(39, 4, 104, new short[] {-1, -1, -1, -1});
    NxS[105] = // Shortest string "E"
      new Table(22, 21, 104, new short[] {110, 111, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[106] = // Shortest string "S"
      new Table(26, 17, 104, new short[] {108, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[107] = new Table(0, 0, -1, null); // Shortest string "\n"
    NxS[108] = // Shortest string "SU"
      new Table(27, 16, 104, new short[] {109, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[109] = // Shortest string "SUB"
      new Table(39, 4, 104, new short[] {-1, -1, -1, -1});
    NxS[110] = // Shortest string "EV"
      new Table(21, 22, 104, new short[] {120, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[111] = // Shortest string "EN"
      new Table(28, 15, 104, new short[] {112, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[112] = // Shortest string "END"
      new Table(21, 22, 104, new short[] {113, 104, 104, 104, 114, 104, 
          104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[113] = // Shortest string "ENDE"
      new Table(22, 21, 104, new short[] {117, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[114] = // Shortest string "ENDS"
      new Table(26, 17, 104, new short[] {115, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[115] = // Shortest string "ENDSU"
      new Table(27, 16, 104, new short[] {116, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[116] = // Shortest string "ENDSUB"
      new Table(39, 4, 104, new short[] {-1, -1, -1, -1});
    NxS[117] = // Shortest string "ENDEV"
      new Table(21, 22, 104, new short[] {118, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[118] = // Shortest string "ENDEVE"
      new Table(23, 20, 104, new short[] {119, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[119] = // Shortest string "ENDEVEN"
      new Table(24, 19, 104, new short[] {116, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[120] = // Shortest string "EVE"
      new Table(23, 20, 104, new short[] {121, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[121] = // Shortest string "EVEN"
      new Table(24, 19, 104, new short[] {109, 104, 104, 104, 104, 104, 
          104, 104, 104, 104, 104, 104, 104, 104, 104, -1, -1, -1, -1});
    NxS[122] = // Shortest string ""
      new Table(29, 48, 22, new short[] {25, 22, 22, 22, 26, 22, 
          22, 22, 27, 22, 28, 28, 29, 30, 31, 28, 32, 1, 33, 22, 1, 34, 
          1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
          17, 18, 19, 20, 1, 21, 22, 22, 23, 24});
    NxS[123] = // Shortest string "0."
      new Table(47, 1, -1, new short[] {36});
    NxS[124] = // Shortest string "0.0."
      new Table(47, 1, -1, new short[] {125});
    NxS[125] = // Shortest string "0.0.0"
      new Table(47, 13, -1, new short[] {125, -1, -1, -1, -1, -1, 
          -1, -1, -1, -1, -1, -1, 126});
    NxS[126] = // Shortest string "0.0.0."
      new Table(47, 1, -1, new short[] {37});
    NxS[127] = // Shortest string ""\\n"
      new Table(39, 8, -1, new short[] {127, 127, -1, -1, -1, 127, 
          -1, 32});
    NxS[128] = // Shortest string ",*"
      new Table(40, 24, 91, new short[] {-1, 91, 91, 91, 91, 91, 
          91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 
          94, -1});
    NxS[129] = // Shortest string ",/"
      new Table(40, 24, 91, new short[] {-1, 91, 91, 91, 91, 91, 
          91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 
          -1, 93});
    }

int NextState(int qStat) {
    if (chr == ScanBuff.EOF)
        return (qStat <= maxAccept && qStat != currentStart ? currentStart : eofNum);
    else {
        int rslt;
        int idx = Map(chr) - NxS[qStat].min;
        if (idx < 0) idx += 51;
        if ((uint)idx >= (uint)NxS[qStat].rng) rslt = NxS[qStat].dflt;
        else rslt = NxS[qStat].nxt[idx];
        return (rslt == goStart ? currentStart : rslt);
    }
}

int NextState() {
    if (chr == ScanBuff.EOF)
        return (state <= maxAccept && state != currentStart ? currentStart : eofNum);
    else {
        int rslt;
        int idx = Map(chr) - NxS[state].min;
        if (idx < 0) idx += 51;
        if ((uint)idx >= (uint)NxS[state].rng) rslt = NxS[state].dflt;
        else rslt = NxS[state].nxt[idx];
        return (rslt == goStart ? currentStart : rslt);
    }
}
#endregion


#if BACKUP
        // ====================== Nested class ==========================

        internal class Context // class used for automaton backup.
        {
            public int bPos;
            public int cNum;
            public int state;
            public int cChr;
        }
#endif // BACKUP

        // ==============================================================
        // ===== Nested classes for various ScanBuff derived classes ====
        // ==============================================================

        public sealed class StringBuff : ScanBuff
        {
            string str;        // input buffer
            int bPos;          // current position in buffer
            int sLen;

            public StringBuff(string str)
            {
                this.str = str;
                this.sLen = str.Length;
            }

            public override int Read()
            {
                if (bPos < sLen) return str[bPos++];
#if BABEL
                else if (bPos == sLen) { bPos++; return '\n'; }   // one strike, see newline
#endif // BABEL
                else { bPos++; return EOF; }                      // two strikes and you're out!
            }
            
            public override int ReadPos { get { return bPos - 1; } }

            public override int Peek()
            {
                if (bPos < sLen) return str[bPos];
                else return '\n';
            }

            public override string GetString(int beg, int end)
            {
                //  "end" can be greater than sLen with the BABEL
                //  option set.  Read returns a "virtual" EOL if
                //  an attempt is made to read past the end of the
                //  string buffer.  Without the guard any attempt 
                //  to fetch yytext for a token that includes the 
                //  EOL will throw an index exception.
                if (end > sLen) end = sLen;
                if (end <= beg) return ""; 
                else return str.Substring(beg, end - beg);
            }

            public override int Pos
            {
                get { return bPos; }
                set { bPos = value; }
            }
        }

       // ====================== Nested class ==========================
       //  The LineBuff class contributed by Nigel Horspool, 
       //  nigelh@cs.uvic.cs
       // ==============================================================

        public sealed class LineBuff : ScanBuff
        {
            IList<string> line;    // list of source lines from a file
            int numLines;          // number of strings in line list
            string curLine;        // current line in that list
            int cLine;             // index of current line in the list
            int curLen;            // length of current line
            int curLineStart;      // position of line start in whole file
            int curLineEnd;        // position of line end in whole file
            int maxPos;            // max position ever visited in whole file
            int cPos;              // ordinal number of chr in source

            // Constructed from a list of strings, one per source line.
            // The lines have had trailing '\n' characters removed.
            public LineBuff(IList<string> lineList)
            {
                line = lineList;
                numLines = line.Count;
                cPos = curLineStart = 0;
                curLine = numLines>0? line[0] : "";
                maxPos = curLineEnd = curLen = curLine.Length;
                cLine = 1;
            }

            public override int Read()
            {
                if (cPos < curLineEnd)
                    return curLine[cPos++ - curLineStart];
                if (cPos++ == curLineEnd)
                    return '\n';
                if (cLine >= numLines)
                    return EOF;
                curLine = line[cLine];
                curLen = curLine.Length;
                curLineStart = curLineEnd + 1;
                curLineEnd = curLineStart + curLen;
                if (curLineEnd>maxPos)
                    maxPos = curLineEnd;
                cLine++;
                return curLen>0? curLine[0] : '\n';
            }

            public override int Peek()
            {
                return (cPos < curLineEnd)? curLine[cPos - curLineStart] : '\n';
            }

            // To speed up searches for the line containing a position
            private int cachedPos = 0;
            private int cachedIx = 0;
            private int cachedLstart = 0;

            // Given a position pos within the entire source, the results are
            //   ix     -- the index of the containing line
            //   lstart -- the position of the first character on that line
            private void findIndex( int pos, out int ix, out int lstart )
            {
                if (pos >= cachedPos) {
                    ix = cachedIx;  lstart = cachedLstart;
                } else {
                    ix = lstart = 0;
                }
                for( ; ; ) {
                    int len = line[ix].Length + 1;
                    if (pos < lstart+len) break;
                    lstart += len;
                    ix++;
                }
                cachedPos = pos;
                cachedIx = ix;
                cachedLstart = lstart;
            }
        
            public override string GetString(int beg, int end)
            {
                if (beg >= maxPos || end <= beg) return "";
                int endIx, begIx, endLineStart, begLineStart;
                findIndex(beg, out begIx, out begLineStart);
                int begCol = beg - begLineStart;
                findIndex(end, out endIx, out endLineStart);
                int endCol = end - endLineStart;
                string s = line[begIx];
                if (begIx == endIx) {
                    // the usual case, substring all on one line
                    return (endCol <= s.Length)?
                        s.Substring(begCol, endCol-begCol)
                        : s.Substring(begCol) + "\n";
                }
                // the string spans multiple lines, yuk!
                StringBuilder sb = new StringBuilder();
                if (begCol < s.Length)
                    sb.Append(s.Substring(begCol));
                for( ; ; ) {
                    sb.Append("\n");
                    s = line[++begIx];
                    if (begIx >= endIx) break;
                    sb.Append(s);
                }
                if (endCol <= s.Length) {
                    sb.Append(s.Substring(0, endCol));
                } else {
                    sb.Append(s);
                    sb.Append("\n");
                }
                return sb.ToString();
            }

            public override int Pos
            {
                get { return cPos; }
                set {
                    cPos = value;
                    findIndex(cPos, out cLine, out curLineStart);
                    curLine = line[cLine];
                    curLineEnd = curLineStart+curLine.Length;
                }
            }
            
            public override int ReadPos { get { return cPos - 1; } }
        }
        
        // ====================== Nested class ==========================

        public sealed class StreamBuff : ScanBuff
        {
            BufferedStream bStrm;   // input buffer
            int delta = 1;          // number of bytes in chr, could be 0 for EOF.

            public StreamBuff(Stream str) { this.bStrm = new BufferedStream(str); }

            public override int Read() {
                int ch0 = bStrm.ReadByte();
                delta = (ch0 == EOF ? 0 : 1);
                return ch0; 
            }
            
            public override int ReadPos {
                get { return (int)bStrm.Position - delta; }
            }

            public override int Peek()
            {
                int rslt = bStrm.ReadByte();
                bStrm.Seek(-delta, SeekOrigin.Current);
                return rslt;
            }

            public override string GetString(int beg, int end)
            {
                if (end - beg <= 0) return "";
                long savePos = bStrm.Position;
                char[] arr = new char[end - beg];
                bStrm.Position = (long)beg;
                for (int i = 0; i < (end - beg); i++)
                    arr[i] = (char)bStrm.ReadByte();
                bStrm.Position = savePos;
                return new String(arr);
            }

            // Pos is the position *after* reading chr!
            public override int Pos
            {
                get { return (int)bStrm.Position; }
                set { bStrm.Position = value; }
            }
        }

        // ====================== Nested class ==========================

        /// <summary>
        /// This is the Buffer for UTF8 files.
        /// It attempts to read the encoding preamble, which for 
        /// this encoding should be unicode point \uFEFF which is 
        /// encoded as EF BB BF
        /// </summary>
        public class TextBuff : ScanBuff
        {
            protected BufferedStream bStrm;   // input buffer
            protected int delta = 1;          // length of chr, zero for EOF!
            
            private Exception BadUTF8()
            { return new Exception(String.Format("BadUTF8 Character")); }

            /// <summary>
            /// TextBuff factory.  Reads the file preamble
            /// and returns a TextBuff, LittleEndTextBuff or
            /// BigEndTextBuff according to the result.
            /// </summary>
            /// <param name="strm">The underlying stream</param>
            /// <returns></returns>
            public static TextBuff NewTextBuff(Stream strm)
            {
                // First check if this is a UTF16 file
                //
                int b0 = strm.ReadByte();
                int b1 = strm.ReadByte();

                if (b0 == 0xfe && b1 == 0xff)
                    return new BigEndTextBuff(strm);
                if (b0 == 0xff && b1 == 0xfe)
                    return new LittleEndTextBuff(strm);
                
                int b2 = strm.ReadByte();
                if (b0 == 0xef && b1 == 0xbb && b2 == 0xbf)
                    return new TextBuff(strm);
                //
                // There is no unicode preamble, so we
                // must go back to the UTF8 default.
                //
                strm.Seek(0, SeekOrigin.Begin);
                return new TextBuff(strm);
            }

            protected TextBuff(Stream str) { 
                this.bStrm = new BufferedStream(str);
            }

            public override int Read()
            {
                int ch0 = bStrm.ReadByte();
                int ch1;
                int ch2;
                if (ch0 < 0x7f)
                {
                    delta = (ch0 == EOF ? 0 : 1);
                    return ch0;
                }
                else if ((ch0 & 0xe0) == 0xc0)
                {
                    delta = 2;
                    ch1 = bStrm.ReadByte();
                    if ((ch1 & 0xc0) == 0x80)
                        return ((ch0 & 0x1f) << 6) + (ch1 & 0x3f);
                    else
                        throw BadUTF8();
                }
                else if ((ch0 & 0xf0) == 0xe0)
                {
                    delta = 3;
                    ch1 = bStrm.ReadByte();
                    ch2 = bStrm.ReadByte();
                    if ((ch1 & ch2 & 0xc0) == 0x80)
                        return ((ch0 & 0xf) << 12) + ((ch1 & 0x3f) << 6) + (ch2 & 0x3f);
                    else
                        throw BadUTF8();
                }
                else
                    throw BadUTF8();
            }

            public sealed override int ReadPos
            {
                get { return (int)bStrm.Position - delta; }
            }

            public sealed override int Peek()
            {
                int rslt = Read();
                bStrm.Seek(-delta, SeekOrigin.Current);
                return rslt;
            }

            /// <summary>
            /// Returns the string from the buffer between
            /// the given file positions.  This needs to be
            /// done carefully, as the number of characters
            /// is, in general, not equal to (end - beg).
            /// </summary>
            /// <param name="beg">Begin filepos</param>
            /// <param name="end">End filepos</param>
            /// <returns></returns>
            public sealed override string GetString(int beg, int end)
            {
                int i;
                if (end - beg <= 0) return "";
                long savePos = bStrm.Position;
                char[] arr = new char[end - beg];
                bStrm.Position = (long)beg;
                for (i = 0; bStrm.Position < end; i++)
                    arr[i] = (char)Read();
                bStrm.Position = savePos;
                return new String(arr, 0, i);
            }

            // Pos is the position *after* reading chr!
            public sealed override int Pos
            {
                get { return (int)bStrm.Position; }
                set { bStrm.Position = value; }
            }
        }

        // ====================== Nested class ==========================
        /// <summary>
        /// This is the Buffer for Big-endian UTF16 files.
        /// </summary>
        public sealed class BigEndTextBuff : TextBuff
        {
            internal BigEndTextBuff(Stream str) : base(str) { } // 

            public override int Read()
            {
                int ch0 = bStrm.ReadByte();
                int ch1 = bStrm.ReadByte();
                if (ch1 == EOF)
                {
                    // An EOF in either byte counts as an EOF
                    delta = (ch0 == EOF ? 0 : 1);
                    return -1;
                }
                else
                {
                    delta = 2;
                    return (ch0 << 8) + ch1;
                }
            }
        }
        
        // ====================== Nested class ==========================
        /// <summary>
        /// This is the Buffer for Little-endian UTF16 files.
        /// </summary>
        public sealed class LittleEndTextBuff : TextBuff
        {
            internal LittleEndTextBuff(Stream str) : base(str) { } // { this.bStrm = new BufferedStream(str); }

            public override int Read()
            {
                int ch0 = bStrm.ReadByte();
                int ch1 = bStrm.ReadByte();
                if (ch1 == EOF)
                {
                    // An EOF in either byte counts as an EOF
                    delta = (ch0 == EOF ? 0 : 1);
                    return -1;
                }
                else
                {
                    delta = 2;
                    return (ch1 << 8) + ch1;
                }
            }
        }
        // =================== End Nested classes =======================

        public Scanner(Stream file) {
            buffer = TextBuff.NewTextBuff(file); // selected by /unicode option
            this.cNum = -1;
            this.chr = '\n'; // to initialize yyline, yycol and lineStart
            GetChr();
        }

        public Scanner() { }

        void GetChr()
        {
            if (chr == '\n') 
            { 
                lineStartNum = cNum + 1; 
                lNum++; 
            }
            chr = buffer.Read();
            cNum++;
        }

        void MarkToken()
        {
            tokPos = buffer.ReadPos;
            tokNum = cNum;
            tokLin = lNum;
            tokCol = cNum - lineStartNum;
        }
        
        void MarkEnd()
        {
            tokTxt = null;
            tokLen = cNum - tokNum;
            tokEPos = buffer.ReadPos;
            tokELin = lNum;
            tokECol = cNum - lineStartNum;
        }

        // ==============================================================
        // =====    Initialization of string-based input buffers     ====
        // ==============================================================

        public void SetSource(string source, int offset)
        {
            this.buffer = new StringBuff(source);
            this.buffer.Pos = offset;
            this.cNum = offset - 1;
            this.chr = '\n'; // to initialize yyline, yycol and lineStart
            GetChr();
        }
        
        // ================ LineBuffer Initialization ===================

        public void SetSource(IList<string> source)
        {
            this.buffer = new LineBuff(source);
            this.chr = '\n'; // to initialize yyline, yycol and lineStart
            this.cNum = -1;
            GetChr();
        }
        
        // ==============================================================

#if BABEL
        //
        //  Get the next token for Visual Studio
        //
        //  "state" is the inout mode variable that maintains scanner
        //  state between calls, using the EolState property. In principle,
        //  if the calls of EolState are costly set could be called once
        //  only per line, at the start; and get called only at the end
        //  of the line. This needs more infrastructure ...
        //
        public int GetNext(ref int state, out int start, out int end)
        {
            Tokens next;
            int s, e;
            s = state;        // state at start
            EolState = state;
            next = (Tokens)Scan();
            state = EolState;
            e = state;       // state at end;
            start = tokPos;
            end = tokEPos - 1; // end is the index of last char.
            return (int)next;
        }        
#endif // BABEL

        // ======== IScanner<> Implementation =========

        public override int yylex()
        {
            // parserMax is set by reflecting on the Tokens
            // enumeration.  If maxParseTokeen is defined
            // that is used, otherwise int.MaxValue is used.
            int next;
            do { next = Scan(); } while (next >= parserMax);
            return next;
        }
        
        int yyleng { get { return tokLen; } }
        int yypos { get { return tokPos; } }
        int yyline { get { return tokLin; } }
        int yycol { get { return tokCol; } }

        public string yytext
        {
            get 
            {
                if (tokTxt == null) 
                    tokTxt = buffer.GetString(tokPos, tokEPos);
                return tokTxt;
            }
        }

        void yyless(int n) { 
            buffer.Pos = tokPos;
            // Must read at least one char, so set before start.
            cNum = tokNum - 1;
            for (int i = 0; i <= n; i++) GetChr();
            MarkEnd();
        }

        // ============ methods available in actions ==============

        internal int YY_START {
            get { return currentScOrd; }
            set { currentScOrd = value; } 
        }
        
        internal void BEGIN(int next) {
            currentScOrd = next;
            currentStart = startState[next];
        }

        // ============== The main tokenizer code =================

        int Scan()
        {
                for (; ; )
                {
                    int next;              // next state to enter                   
#if BACKUP
                    bool inAccept = false; // inAccept ==> current state is an accept state
                    Result rslt = Result.noMatch;
                    // skip "idle" transitions
#if LEFTANCHORS
                    if (lineStartNum == cNum && NextState(anchorState[currentScOrd]) != currentStart)
                        state = anchorState[currentScOrd];
                    else {
                        state = currentStart;
                        while (NextState() == state) {
                            GetChr();
                            if (lineStartNum == cNum) {
                                int anchor = anchorState[currentScOrd];
                                if (NextState(anchor) != state) {
                                    state = anchor; 
                                    break;
                                }
                            }
                        }
                    }
#else // !LEFTANCHORS
                    state = currentStart;
                    while (NextState() == state) 
                        GetChr(); // skip "idle" transitions
#endif // LEFTANCHORS
                    MarkToken();
                    
                    while ((next = NextState()) != currentStart)
                        if (inAccept && next > maxAccept) // need to prepare backup data
                        {
                            Context ctx = new Context();
                            rslt = Recurse2(ctx, next);
                            if (rslt == Result.noMatch) RestoreStateAndPos(ctx);
                            break;
                        }
                        else
                        {
                            state = next;
                            GetChr();
                            if (state <= maxAccept) inAccept = true;
                        }
#else // !BACKUP
#if LEFTANCHORS
                    if (lineStartNum == cNum) {
                        int anchor = anchorState[currentScOrd];
                        if (NextState(anchor) != currentStart)
                            state = anchor;
                    }
                    else {
                        state = currentStart;
                        while (NextState() == state) {
                            GetChr();
                            if (lineStartNum == cNum) {
                                int anchor = anchorState[currentScOrd];
                                if (NextState(anchor) != state) {
                                    state = anchor;
                                    break;
                                }
                            }
                        }
                    }
#else // !LEFTANCHORS
                    state = currentStart;
                    while (NextState() == state) 
                        GetChr(); // skip "idle" transitions
#endif // LEFTANCHORS
                    MarkToken();
                    // common code
                    while ((next = NextState()) != currentStart)
                    {
                        state = next;
                        GetChr();
                    }
#endif // BACKUP
                    if (state > maxAccept) 
                        state = currentStart;
                    else
                    {
                        MarkEnd();
#region ActionSwitch
#pragma warning disable 162
    switch (state)
    {
        case eofNum:
            return (int)Tokens.EOF;
        case 1:
        case 19:
        case 20:
        case 34:
        case 89:
        case 90:
System.Console.WriteLine("Illegal character: <" + yytext + "> at line #" + yyline);
	Utility.error(yyline,Utility.E_UNMATCHED);
	break;
            break;
        case 2:
GyyLine = yyline;return E_COLON;
            break;
        case 3:
GyyLine = yyline;return 1;
            break;
        case 4:
GyyLine = yyline;return E_SEMICOLON;
            break;
        case 5:
GyyLine = yyline;return E_PAR_OPEN;
            break;
        case 6:
GyyLine = yyline;return E_PAR_CLOSE;
            break;
        case 7:
GyyLine = yyline;return 5;
            break;
        case 8:
GyyLine = yyline;return 6;
            break;
        case 9:
GyyLine = yyline;return E_POINT;
            break;
        case 10:
GyyLine = yyline;return E_PLUS;
            break;
        case 11:
GyyLine = yyline;return E_MOINS;
            break;
        case 12:
GyyLine = yyline;return E_MULT;
            break;
        case 13:
GyyLine = yyline;return E_DIV;
            break;
        case 14:
GyyLine = yyline;return E_EQUAL;
            break;
        case 15:
GyyLine = yyline;return 16;
            break;
        case 16:
GyyLine = yyline;return 18;
            break;
        case 17:
GyyLine = yyline;return 20;
            break;
        case 18:
GyyLine = yyline;return 21;
            break;
        case 21:
        case 22:
        case 23:
        case 24:
        case 25:
        case 26:
        case 27:
        case 42:
        case 43:
        case 44:
        case 45:
        case 46:
        case 47:
        case 48:
        case 50:
        case 51:
        case 52:
        case 53:
        case 54:
        case 55:
        case 56:
        case 59:
        case 61:
        case 62:
        case 64:
        case 65:
        case 66:
        case 67:
        case 69:
        case 70:
        case 71:
        case 72:
        case 74:
        case 76:
        case 77:
        case 78:
        case 79:
        case 80:
GyyLine = yyline;
	return E_IDENT;
            break;
        case 28:
{ }
            break;
        case 29:
//	Console.WriteLine("Error unmatched '}' at line #" + yyline);
	Utility.assert(false,"Error unmatched '}'");
            break;
        case 30:
BEGIN(BLOCCMD);
								bloc_count++;
								strBloc = "";
								break;
            break;
        case 31:
BEGIN(COMMENTSHARP);break;
            break;
        case 32:
        case 39:
        case 40:
//	string str =  yytext.Substring(1,yytext.Length);

//	Utility.error(yyline,Utility.E_UNCLOSEDSTR);
	Utility.assert(false,"Unclosed string");
	break;
//	return 41;
            break;
        case 33:
        case 87:
GyyLine = yyline;
	return E_INTEGER;
            break;
        case 35:
GyyLine = yyline;
	return E_VAR;
            break;
        case 36:
GyyLine = yyline;
	return E_FLOAT;
            break;
        case 37:
GyyLine = yyline;
	return E_IP;
            break;
        case 38:
        case 41:
string str =  yytext.Substring(1,yytext.Length - 2);

	Utility.assert(str.Length == yytext.Length - 2, "Error on '\"'");
//	Console.WriteLine( "String " + yytext);
	GyyLine = yyline;
	return E_STRING;
            break;
        case 49:
GyyLine = yyline;return E_PLAYERVAR;
            break;
        case 57:
GyyLine = yyline;return E_GLOBALVAR;
            break;
        case 58:
GyyLine = yyline;return E_IF;
            break;
        case 60:
        case 109:
GyyLine = yyline;return E_BEGIN_FUNCTION;
            break;
        case 63:
GyyLine = yyline;return E_THEN;
            break;
        case 68:
GyyLine = yyline;return E_ELSE;
            break;
        case 73:
GyyLine = yyline;return E_ENDIF;
            break;
        case 75:
        case 116:
GyyLine = yyline;return E_END_FUNCTION;
            break;
        case 81:
GyyLine = yyline;return 23;
            break;
        case 82:
GyyLine = yyline;return 22;
            break;
        case 83:
GyyLine = yyline;return 19;
            break;
        case 84:
GyyLine = yyline;return 17;
            break;
        case 85:
GyyLine = yyline;return 15;
            break;
        case 86:
BEGIN(COMMENT); comment_count = comment_count + 1;break;
            break;
        case 88:
        case 91:
        case 93:
        case 94:
{ }
            break;
        case 92:
comment_count = comment_count + 1;break;
            break;
        case 95:
comment_count = comment_count - 1;
	Utility.assert(comment_count >= 0, "To much ')'");
	if (comment_count == 0) {
    		BEGIN(INITIAL);

	}
	break;
            break;
        case 96:
        case 97:
{ }
            break;
        case 98:
BEGIN(INITIAL);break;
            break;
        case 99:
        case 100:
strBloc += yytext;
            break;
        case 101:
bloc_count--;
	if (bloc_count == 0) {
    		BEGIN(INITIAL);
    		GyyLine = yyline;
    		return E_BLOC;

	}
	else
			strBloc += "}";
	break;
            break;
        case 102:
bloc_count++;
								strBloc += "{";
								break;
            break;
        case 103:
        case 104:
        case 105:
        case 106:
        case 108:
        case 110:
        case 111:
        case 112:
        case 113:
        case 114:
        case 115:
        case 117:
        case 118:
        case 119:
        case 120:
        case 121:
return E_BLOC;
            break;
        case 107:
return E_BLOC;
            break;
        default:
            break;
    }
#pragma warning restore 162
#endregion
                    }
                }
        }

#if BACKUP
        Result Recurse2(Context ctx, int next)
        {
            // Assert: at entry "state" is an accept state AND
            //         NextState(state, chr) != currentStart AND
            //         NextState(state, chr) is not an accept state.
            //
            bool inAccept;
            SaveStateAndPos(ctx);
            state = next;
            if (state == eofNum) return Result.accept;
            GetChr();
            inAccept = false;

            while ((next = NextState()) != currentStart)
            {
                if (inAccept && next > maxAccept) // need to prepare backup data
                    SaveStateAndPos(ctx);
                state = next;
                if (state == eofNum) return Result.accept;
                GetChr(); 
                inAccept = (state <= maxAccept);
            }
            if (inAccept) return Result.accept; else return Result.noMatch;
        }

        void SaveStateAndPos(Context ctx)
        {
            ctx.bPos  = buffer.Pos;
            ctx.cNum  = cNum;
            ctx.state = state;
            ctx.cChr  = chr;
        }

        void RestoreStateAndPos(Context ctx)
        {
            buffer.Pos = ctx.bPos;
            cNum  = ctx.cNum;
            state = ctx.state;
            chr   = ctx.cChr;
        }

        void RestorePos(Context ctx) { buffer.Pos = ctx.bPos; cNum = ctx.cNum; }
#endif // BACKUP

        // ============= End of the tokenizer code ================

#if STACK        
        internal void yy_clear_stack() { scStack.Clear(); }
        internal int yy_top_state() { return scStack.Peek(); }
        
        internal void yy_push_state(int state)
        {
            scStack.Push(currentScOrd);
            BEGIN(state);
        }
        
        internal void yy_pop_state()
        {
            // Protect against input errors that pop too far ...
            if (scStack.Count > 0) {
				int newSc = scStack.Pop();
				BEGIN(newSc);
            } // Otherwise leave stack unchanged.
        }
 #endif // STACK

        internal void ECHO() { Console.Out.Write(yytext); }
        
#region UserCodeSection

bool comment_sharp = false;
int comment_count = 0;
int bloc_count = 0;
public string strBloc = "";
public int GyyLine = 0;
/*
class Sample {
    public static void Main(string[] argv)  {
        try
        {
            int tok;
            FileStream file = new FileStream("LFSLapper.cfg", FileMode.Open);
            Scanner scnr = new Scanner(file);
             do {
                 tok = scnr.yylex();
                 Console.WriteLine("#"+tok + ": " + scnr.yytext);
             } while (tok > (int)Tokens.EOF);
        }
        catch (System.Exception e)
        {
            Console.WriteLine(e.Message);
        }
                Console.ReadKey();
    }

}
*/
public const int E_END = 0;
public const int E_SEMICOLON = 2;
public const int E_PAR_OPEN = 3;
public const int E_PAR_CLOSE = 4;
public const int E_POINT = 9;
public const int E_PLUS = 10;
public const int E_MOINS = 11;
public const int E_MULT = 12;
public const int E_DIV = 13;
public const int E_COLON = 24;
public const int E_INTEGER = 49;
public const int E_STRING = 40;
public const int E_EQUAL = 42;
public const int E_IDENT = 43;
public const int E_IP = 45;
public const int E_FLOAT = 46;
public const int E_VAR = 47;
public const int E_BLOC = 48;
public const int E_BEGIN_FUNCTION = 100;
public const int E_END_FUNCTION = 101;
public const int E_IF = 102;
public const int E_THEN = 103;
public const int E_ELSE = 104;
public const int E_ENDIF = 105;
public const int E_GLOBALVAR = 106;
public const int E_PLAYERVAR = 107;

class Utility {
  public static void assert( bool expr, string errMsg )
  {
		if (false == expr) {
		  throw (new System.Exception("Error: " + errMsg));
		}
  }

  private static readonly string[] errorMsg =new string[] {
    "Error: Unmatched end-of-comment punctuation.",
    "Error: Unmatched start-of-comment punctuation.",
    "Error: Unclosed string.",
    "Error: Illegal character."
    };

  public const int E_ENDCOMMENT = 0;
  public const int E_STARTCOMMENT = 1;
  public const int E_UNCLOSEDSTR = 2;
  public const int E_UNMATCHED = 3;
  

  public static void error(int yy,int code)
      {
	System.Console.WriteLine(errorMsg[code] + " at line #" + yy);
      }
}

#endregion
    } // end class Scanner
} // end namespace
