/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Text.RegularExpressions;
using LapperThreads;

namespace LFSLapper
{
    partial class LFSClient
    {
        string getUnitSpeed(bool unitSpeedKmh)
        {
            if (unitSpeedKmh)
                return "Km/h";
            else
                return "Mph";
        }
        string getUnitDist(bool unitSpeedKmh)
        {
            if (unitSpeedKmh)
                return "Km";
            else
                return "Miles";
        }
        bool UpdateQualUsers(string QualUsers)
        {
            int authidx;

            playerFilter.Clear();
            if (QualUsers == "")
                return true;

            authidx = QualUsers.IndexOf("@"); // If list of user is in cfg file
            if (authidx != -1)
            {
                string[] ListUsers = QualUsers.Substring(authidx + 1).Split(',');
                foreach (string userinfo in ListUsers)
                {
                    if (userinfo.IndexOf("DefGroup") != -1)
                    {
                        string[] value = userinfo.Split(':');
                        try
                        {
                            MaxGroupQual = int.Parse(value[1]);
                            MaxUserGroupQual = int.Parse(value[2]);
                            MinUserGroupQual = int.Parse(value[3]);
                        }
                        catch (Exception)
                        {
                            MaxGroupQual = 0;
                            MaxUserGroupQual = 0;
                            MinUserGroupQual = 0;
                        }

                    }
                    else
                    {
                        string[] luserinfo = userinfo.Split(':');
                        if (luserinfo.Length > 1)
                            playerFilter[luserinfo[0].ToLower()] = luserinfo[1];
                        else
                            playerFilter[luserinfo[0].ToLower()] = "";
                    }
                }
                return true;
            }
            authidx = QualUsers.IndexOf("&"); // if QualUsers is a name of file containing list of user
            if (authidx != -1)
            {
                string userinfo;
                try
                {
                    using (System.IO.StreamReader sr = new System.IO.StreamReader(QualUsers.Substring(authidx + 1)))
                    {
                        while (true)
                        {
                            userinfo = sr.ReadLine();
                            if (userinfo == null)
                                return true;
                            if (userinfo.IndexOf("DefGroup") != -1)
                            {
                                // For compatibility with old system
                                userinfo = userinfo.Replace(";", ":");
                                string[] value = userinfo.Split(':');
                                try
                                {
                                    MaxGroupQual = int.Parse(value[1]);
                                    MaxUserGroupQual = int.Parse(value[2]);
                                    MinUserGroupQual = int.Parse(value[3]);
                                }
                                catch (Exception)
                                {
                                    MaxGroupQual = 0;
                                    MaxUserGroupQual = 0;
                                    MinUserGroupQual = 0;
                                }

                            }
                            else
                            {
                                string[] luserinfo = userinfo.Split(':');
                                if (luserinfo.Length > 1)
                                    playerFilter[luserinfo[0].ToLower()] = luserinfo[1];
                                else
                                    playerFilter[luserinfo[0].ToLower()] = "";
                            }
                        }
                    }
                }
                catch (System.Exception ex)
                {
                    Console.WriteLine("(" + QualUsers + ")" + ex.Message);   // Print the error message.
                    return false;
                }
            }
            return false;
        }
        bool UpdateHandicapUsers(string HandicapUsers)
        {
            int authidx;

            playerHandicap.Clear();
            if (HandicapUsers == "")
                return true;

            authidx = HandicapUsers.IndexOf("@"); // If list of user is in cfg file
            if (authidx != -1)
            {
                string[] ListUsers = HandicapUsers.Substring(authidx + 1).Split(',');
                foreach (string userinfo in ListUsers)
                {
                    string[] usersplit = userinfo.Split(':');
                    int H_Mass = 0;
                    int H_TRes = 0;
                    try
                    {
                        H_Mass = int.Parse(usersplit[1]);
                    }
                    catch { H_Mass = 0; }
                    try
                    {
                        H_TRes = int.Parse(usersplit[2]);
                    }
                    catch { H_TRes = 0; }
                    playerHandicap[usersplit[0].ToLower()] = new infoHandicap(H_Mass, H_TRes);

                }
                return true;
            }
            authidx = HandicapUsers.IndexOf("&"); // if QualUsers is a name of file containing list of user
            if (authidx != -1)
            {
                string userinfo;
                try
                {
                    using (System.IO.StreamReader sr = new System.IO.StreamReader(newCfg.varsLapper.QualUsers.Substring(authidx + 1)))
                    {
                        while (true)
                        {
                            userinfo = sr.ReadLine();
                            if (userinfo == null)
                                return true;
                            string[] usersplit = userinfo.Split(':');
                            int H_Mass = 0;
                            int H_TRes = 0;
                            try
                            {
                                H_Mass = int.Parse(usersplit[1]);
                            }
                            catch { H_Mass = 0; }
                            try
                            {
                                H_TRes = int.Parse(usersplit[2]);
                            }
                            catch { H_TRes = 0; }
                            playerHandicap[usersplit[0].ToLower()] = new infoHandicap(H_Mass, H_TRes);
                        }
                    }
                }
                catch (System.Exception ex)
                {
                    Console.WriteLine("(" + newCfg.varsLapper.QualUsers + ")" + ex.Message);   // Print the error message.
                    return false;
                }
            }
            return false;
        }
        bool UpdateHandicapCars(string HandicapCars)
        {

            carHandicap.Clear();
            if (HandicapCars == "")
                return true;

            string[] ListCars = HandicapCars.Split(',');
            foreach (string carinfo in ListCars)
            {
                string[] carsplit = carinfo.Split(':');
                int H_Mass = 0;
                int H_TRes = 0;
                try
                {
                    H_Mass = int.Parse(carsplit[1]);
                }
                catch { H_Mass = 0; }
                try
                {
                    H_TRes = int.Parse(carsplit[2]);
                }
                catch { H_TRes = 0; }
                carHandicap[carsplit[0].ToLower()] = new infoHandicap(H_Mass, H_TRes);

            }
            return true;
        }
        bool UpdateHandicapCarsTracks(string HandicapCarsTracks)
        {

            carTrackHandicap.Clear();
            if (HandicapCarsTracks == "")
                return true;

            string[] ListCarsTracks = HandicapCarsTracks.Split(',');
            foreach (string carTrackinfo in ListCarsTracks)
            {
                string[] carTracksplit = carTrackinfo.Split(':');
                int H_Mass = 0;
                int H_TRes = 0;
                try
                {
                    H_Mass = int.Parse(carTracksplit[1]);
                }
                catch { H_Mass = 0; }
                try
                {
                    H_TRes = int.Parse(carTracksplit[2]);
                }
                catch { H_TRes = 0; }
//                Console.WriteLine(carTracksplit[0].ToLower());
                carTrackHandicap[carTracksplit[0].ToLower()] = new infoHandicap(H_Mass, H_TRes);

            }
            return true;
        }
        void SendMsg(int UCID, string msg)
        {
            msg = msg.Trim();
            if (msg.Length > 0)
            {
                byte[] outMsg = InSim.Encoder.MST(msg);
                insimConnection.Send(outMsg, outMsg.Length);
            }

        }
        void SendMsgToConnection(int UCID, string msg)
        {
            if (msg.Length > 0)
            {
                if (UCID != -1)
                {
                    byte[] outMsg = InSim.Encoder.MTC(UCID, 0, msg);
                    insimConnection.Send(outMsg, outMsg.Length);
                }
            }
        }
        public string bufferToHexa(byte[] buffer, int buffLen)
        {
            string retString = "";
            string sep = "";
            for (int i = 0; i < buffLen; i++)
            {
                retString = retString + sep + string.Format("0x{0:X2}", buffer[i]);
                sep = ", ";
            }
            return retString;
        }
        public string stringToHexa(string str)
        {
            string retString = "";
            string sep = "";
            for (int i = 0; i < str.Length; i++)
            {
                retString = retString + sep + string.Format("0x{0:X2}", (byte)str[i]);
                sep = ", ";
            }
            return retString;
        }

/*
        void SendMultilineMsgPrivate(int UCID, string resp, char splitcar)
        {
            string[] multilineresp = resp.Split(splitcar);
            try
            {
                for (int i = 0; i < multilineresp.Length; i++)
                {
                    string lineToSend = multilineresp[i];

                    //                    lineToSend = lineToSend.Replace("{Nickname}", playerNameToSend);
                    SendMsgToConnection(UCID, lineToSend);
                }
            }
            catch (System.Exception)
            {
                return;
            }
        }
*/
        void ClearButton(infoPlayer currInfoPlayer)
        {
            // Clear all buttons
            byte[] bfn = InSim.Encoder.BFN(0,1, currInfoPlayer.UCID, 0);
            insimConnection.Send(bfn, bfn.Length);
        }
        void AddButton(int L, int T, int W, int H, int UCID, btnID ClickID, string Caption, string Text, bool ClickButton, bool Selected)
        {
            int style;
            byte[] btn;

            if (ClickButton)
            {
                style = (int)InSim.BTN_style.ISB_CLICK;
                if (Selected)
                    style |= (int)InSim.BTN_style.ISB_LIGHT | 3;
                else
                    style |= (int)InSim.BTN_style.ISB_LIGHT | 2;
            }
            else
                style = (int)InSim.BTN_style.ISB_DARK | (int)InSim.BTN_style.ISB_LEFT;


            btn = InSim.Encoder.BTN(1,L, T, W, H, UCID, (int)ClickID, style,0, Caption, Text);
            insimConnection.Send(btn, btn.Length);


        }
        void UpButton(infoPlayer currInfoPlayer)
        {

            switch (currInfoPlayer.showButton)
            {
                case 0:
                    break;
                case 1:
                    bool select_PB = false;
                    bool select_session = false;
                    bool select_wr = false;

                    switch (currInfoPlayer.viewSPBSplit)
                    {
                        case 'S':
                            select_session = true;
                            break;
                        case 'P':
                            select_PB = true;
                            break;
                        case 'W':
                            select_wr = true;
                            break;
                    }
                    AddButton(60, 30, 30, 5, currInfoPlayer.UCID, btnID.LIBEL_SPB, "", "Sector time relative to: ", false, false);
                    AddButton(90, 30, 20, 5, currInfoPlayer.UCID, btnID.BUT_SESS, "", "Session", true, select_session);
                    AddButton(110, 30, 20, 5, currInfoPlayer.UCID, btnID.BUT_PB, "", "Server", true, select_PB);
                    if (wrLoaded)
                    {
                        AddButton(130, 30, 20, 5, currInfoPlayer.UCID, btnID.BUT_WR, "", "World Record", true, select_wr);
                    }
                    // Button for show of not Sector PB
                    AddButton(60, 35, 30, 5, currInfoPlayer.UCID, btnID.LIBEL_SHOW_SPB, "", "Show splitting info: ", false, false);
                    AddButton(90, 35, 20, 5, currInfoPlayer.UCID, btnID.BUT_SHOW, "", "Show", true, currInfoPlayer.showSplitPB);
                    AddButton(110, 35, 20, 5, currInfoPlayer.UCID, btnID.BUT_HIDE, "", "Hide", true, !currInfoPlayer.showSplitPB);
                    // Is speed Km/h
                    AddButton(60, 40, 30, 5, currInfoPlayer.UCID, btnID.LIBEL_SPEED_UNIT, "", "Speed Unit: ", false, false);
                    AddButton(90, 40, 20, 5, currInfoPlayer.UCID, btnID.BUT_KMH, "", "Km/h", true, currInfoPlayer.unitSpeedKmh);
                    AddButton(110, 40, 20, 5, currInfoPlayer.UCID, btnID.BUT_MPH, "", "Mph", true, !currInfoPlayer.unitSpeedKmh);
                    break;
            }
        }
        bool SplitNotify(infoPlayer currInfoPlayer, InSim.Decoder.SPX splitdec)
        {
            string splitAction = "";

            splitAction = trackInfo.getSplitAction(currentTrackName, currInfoPlayer.CName, splitdec.Split, splitdec.STime);
            if (splitAction != "")
                executeFunction(splitAction, currInfoPlayer);
            try
            {
                if (newCfg.varsLapper.ShowSplitPB && currInfoPlayer.showSplitPB)
                    executeFunction("OnSpbSplit" + splitdec.Split.ToString(), currInfoPlayer);
            }
            catch
            {
                Console.WriteLine("Error on onSpbSplit" + splitdec.Split.ToString());
            }
            try
            {
                executeFunction("OnSplit" + splitdec.Split.ToString(), currInfoPlayer);
            }
            catch
            {
                Console.WriteLine("Error on onSplit" + splitdec.Split.ToString());
            }

            return true;

        }
        void CheckForFlooding(infoPlayer currInfoPlayer)
        {
            try
            {
                DateTime now = DateTime.Now;

                System.TimeSpan ts = now - currInfoPlayer.LastLine;
                currInfoPlayer.LastLine = now;

                if (ts.TotalMilliseconds < newCfg.varsLapper.MaxFloodLinesTime) //Maximum time betweeen lines to count as flood
                    currInfoPlayer.floodcount++;
                else
                {
                    currInfoPlayer.floodcount = 1;
                    return;
                }

                if (currInfoPlayer.floodcount > newCfg.varsLapper.MaxFloodLines)   //max lines to tolerate
                {
                    currInfoPlayer.floodcount = 0;
                    executeFunction("FloodAction", currInfoPlayer);
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }
        void trVote( infoPlayer currInfoPlayer, InSim.Decoder.VTN vtn, int percVoteNeed,int voted, string action, string actionReach ){
// Stop Voting
            byte[] vtc = InSim.Encoder.VTC();
            insimConnection.Send(vtc, vtc.Length);
            int PercVote = (voted * 100) / listOfPlayers.nbPlayerOnTrack;
            string lstr = "";
            if (PercVote != 0)
            {
                lstr = "";
                for (int i = 0; i < voted; i++)
                    lstr += barGraphChar;
                if (PercVote > percVoteNeed)
                {
                    action = actionReach;
                    listOfPlayers.voteClear();
//                    Console.WriteLine("voteClear in trVote");
                }
                newCfg.setLocalVar("Vote", voted.ToString());
                newCfg.setLocalVar("Players", listOfPlayers.nbPlayerOnTrack.ToString());
                int tmpint = listOfPlayers.nbPlayerOnTrack * newCfg.varsLapper.VoteRestart / 100;
                int tmpint2 = tmpint * 100 / newCfg.varsLapper.VoteRestart;
                if (tmpint2 < listOfPlayers.nbPlayerOnTrack)
                    tmpint++;
                newCfg.setLocalVar("Remain", (tmpint - voted).ToString());
                newCfg.setLocalVar("Need", tmpint.ToString());
                executeFunction(action, currInfoPlayer);
            }
            refreshVote();
        }
        void refreshVote(){
            if (newCfg.varsLapper.VoteRestart != -1 && listOfPlayers.voteRestart == 0)
                executeFunction("onVoteRestartZero", null);
            if (newCfg.varsLapper.VoteQualify != -1 && listOfPlayers.voteQualify == 0)
                executeFunction("onVoteQualifyZero", null);
            if (newCfg.varsLapper.VoteEnd != -1 && listOfPlayers.voteEnd == 0)
                executeFunction("onVoteEndZero", null);
        }
        void actionPlayerFlags(  int flags, infoPlayer currInfoPlayer, bool displayFlags )
        {
            // Player Flags
            string addInfo = "";
            bool PlayerAllowedF = true;
            string FlagsRequired = "";
            for (int i = 0; i < 14; i++)
            {
                if (((uint)(flags) & (uint)(1 << i)) != 0)
                    addInfo += ((InSim.Decoder.NPL.PlayerFlags)(1 << i)).ToString() + " ";
                if (FlagsPlayerAllow[i].ToLower() == "y")
                {
                    FlagsRequired = FlagsRequired
                                        + ((InSim.Decoder.NPL.PlayerFlags)(1 << i)).ToString()
                                        + " = Y ";
                    if (((uint)(flags) & (uint)(1 << i)) == 0)
                        PlayerAllowedF = false;
                }
                if (FlagsPlayerAllow[i].ToLower() == "n")
                {
                    FlagsRequired = FlagsRequired
                                        + ((InSim.Decoder.NPL.PlayerFlags)(1 << i)).ToString()
                                        + " = N ";
                    if (((uint)(flags) & (uint)(1 << i)) != 0)
                        PlayerAllowedF = false;
                }
            }
            if (addInfo.Length != 0 && newCfg.varsLapper.ShowPlayerControl && displayFlags )
                SendMsg(currInfoPlayer.UCID, "/msg " + addInfo);
            if (!PlayerAllowedF)
            {
                newCfg.setLocalVar("RequiredFlags", quote(FlagsRequired));
                newCfg.setLocalVar("PlayerFlags", quote(addInfo));
                executeFunction("OnNotMatchFlags", currInfoPlayer);
            }


        }
        void Loop(InSim.Connect insimConnection)
        {
            bool flagFirst = true;
            bool imediateSaveDb = false;
            bool delayedSaveDb = false;
            DateTime nextSaveDb = DateTime.Now.AddSeconds((double)lexCfg.paramLapper.delayedSave);
            bool imediateSaveDriftDb = false;
            bool delayedSaveDriftDb = false;
            DateTime nextSaveDriftDb = DateTime.Now.AddSeconds((double)lexCfg.paramLapper.delayedSave);
            DateTime nextLoopButton = DateTime.Now.AddSeconds((double)1);
            infoPlayer currInfoPlayer;

// Init the rotation if needed
            if (newCfg.varsLapper.EnableRotation)
            {

                string[] tmpTracks = newCfg.varsLapper.RotateTracks.Split(',');
                string[] tmpCars = newCfg.varsLapper.RotateCars.Split(',');
                SendMsg(0, "/end");
                System.Threading.Thread.Sleep(6000);
                SendMsg(0, "/qual=0");
                SendMsg(0, "/clear");
                if (newCfg.varsLapper.RotateCars != "")
                {
                    SendMsg(0, "/cars=" + tmpCars[currRace.currRotateCar]);
//                    SendMsg(0, "^7New cars!&^2Go to pit!");
                    executeFunction("OnRotateCar", null);
                    RestartTimer();
                }
                if (newCfg.varsLapper.RotateTracks != "")
                {
                    SendMsg(0, "/track=" + tmpTracks[currRace.currRotateTrack]);
                    executeFunction("OnRotateTrack", null);

                }
            }
            SendMsg(0, "/vote=no");
            executeFunction("OnLapperStart", null);

            while (true)
            {
                byte[] recvPacket = insimConnection.Receive();

                if (TermProg == true)
                    break;

                #region save database and Sync DB
                if (imediateSaveDb || (delayedSaveDb && DateTime.Now > nextSaveDb))
                {
                    delayedSaveDb = false;
                    imediateSaveDb = false;
                    nextSaveDb = DateTime.Now.AddSeconds((double)lexCfg.paramLapper.delayedSave);
                    lfsDb.Save();
                }
                // Query of save DBS
                if (imediateSaveDriftDb || (delayedSaveDriftDb && DateTime.Now > nextSaveDriftDb))
                {
                    delayedSaveDriftDb = false;
                    imediateSaveDriftDb = false;
                    nextSaveDriftDb = DateTime.Now.AddSeconds((double)lexCfg.paramLapper.delayedSave);
                    lfsDriftDb.Save();
                }
                #region Race restart Auto and Race Rotation
                // Race restart Auto and Race Rotation
                if (newCfg.varsLapper.AutoRestartRaceMn > 0 && currRace.inRace == false && DateTime.Now > currRace.nextRestart)
                {
                    currRace.nextRestart = DateTime.Now.AddMinutes(newCfg.varsLapper.AutoRestartRaceMn);
                    if (newCfg.varsLapper.EnableRotation && currRace.racesDone >= newCfg.varsLapper.RotateEveryNbRaces)
                    {
                        currRace.racesDone = 0;
                        currRace.currRotateTrack++;
                        currRace.currRotateCar++;
                        string[] tmpTracks = newCfg.varsLapper.RotateTracks.Split(',');
                        string[] tmpCars = newCfg.varsLapper.RotateCars.Split(',');
                        if (currRace.currRotateTrack > tmpTracks.Length-1)
                            currRace.currRotateTrack = 0;
                        if (currRace.currRotateCar > tmpCars.Length-1)
                            currRace.currRotateCar = 0;
                        SendMsg(0, "/end");
                        System.Threading.Thread.Sleep(6000);
                        SendMsg(0, "/qual=0");
                        SendMsg(0, "/clear");
                        if (newCfg.varsLapper.RotateCars != "")
                        {
                            SendMsg(0, "/cars=" + tmpCars[currRace.currRotateCar]);
                            executeFunction("OnRotateCar", null);
                            RestartTimer();
                        }
                        if (newCfg.varsLapper.RotateTracks != "")
                        {
                            SendMsg(0, "/track=" + tmpTracks[currRace.currRotateTrack]);
                            executeFunction("OnRotateTrack", null);
                        }

                    }
                    else
                        SendMsg(0, "/restart");
                }
                #endregion

// Do a loop of button every second
                if ( DateTime.Now > nextLoopButton )
                {
                    listOfPlayers.loopButton();
                    nextLoopButton = DateTime.Now.AddSeconds((double)1);
                }
                // On each iteration retreive new packet to sync DB, if new packet, force Save DB
                if (modeSync)
                    imediateSaveDb = threadSyncDownload.popInfoToSync(lfsDb);
                #endregion

                #region Retreive return from web commands
                webReturn wr = objWebCmd.getWebReturn();
                if (wr != null)
                {
                    currInfoPlayer = listOfPlayers.getPlayerByUCID(wr.UCID);
                    lexCfg.FUNCTION func = new lexCfg.FUNCTION( lexCfg.typFunction.Sub, wr.WebRet, 0 );
                    executeFunction(func, "WebReturnFunction", currInfoPlayer);
                }
                #endregion

                if (recvPacket.Length > 3)
                {
                    string packetHead = insimConnection.packetHead(recvPacket);
                    uint verifyID = insimConnection.verifyID(recvPacket);
//                                        if (packetHead != "MCI")
//                                            Console.WriteLine(packetHead);
                    switch (packetHead)
                    {
                        case "TINY"://confirm ack with ack
                            #region TINY
                            // Keep ALIVE
                            InSim.Decoder.TINY tiny = new InSim.Decoder.TINY(recvPacket);
                            // Keep alive connection
//                            Console.WriteLine(tiny.SubT);
                            if (tiny.SubT == "TINY_NONE")
                            {
                                byte[] stiny = InSim.Encoder.TINY_NONE();
                                insimConnection.Send(stiny, stiny.Length);
                            }
                            #endregion
                            break;
                        case "SMALL":
                            #region SMALL
                            InSim.Decoder.SMALL small = new InSim.Decoder.SMALL(recvPacket);
//                            Console.WriteLine(small.SubT);
                            if (small.SubT == "SMALL_VTA")
                            {
                                /*
                                bool voteClear = false;
                                if (VoteRestart != -1 && (int)small.uval == (int)InSim.vtn.VOTE_RESTART && listOfPlayers.voteReached != (int)InSim.vtn.VOTE_RESTART)
                                    voteClear = true;
                                if (VoteQualify != -1 && (int)small.uval == (int)InSim.vtn.VOTE_QUALIFY && listOfPlayers.voteReached != (int)InSim.vtn.VOTE_QUALIFY)
                                    voteClear = true;
                                if (VoteEnd != -1 && (int)small.uval == (int)InSim.vtn.VOTE_END && listOfPlayers.voteReached != (int)InSim.vtn.VOTE_END)
                                    voteClear = true;
                                if (voteClear)
                                {
                                    byte[] vtc = InSim.Encoder.VTC();
                                    insimConnection.Send(vtc, vtc.Length);
                                }
                                else
                                {
                                    listOfPlayers.voteClear();
                                    listOfPlayers.voteReached = (int)InSim.vtn.VOTE_NONE;
                                    refreshVote();
                                }
*/
                            }
                            #endregion
                            break;
                        case "RST": // Race Start
                            #region RST
                            currRace.inRace = true;
                            currRace.lapsDone = 0;
                            if (newCfg.varsLapper.EnableRotation)
                                currRace.racesDone++;

                            InSim.Decoder.RST rst = new InSim.Decoder.RST(recvPacket);


                            //Raz of idle on start
                            listOfPlayers.raceRestart();
                            if (rst.QualMins == 0)
                            {
                                Tasks.Add(new Task("RaceStartAction", DateTime.Now + new TimeSpan(0, 0, 5)));
                            }
                            #endregion
                            break;
                        case "REN": // Race End
                            #region REN
                            if (debugmode) Console.WriteLine("Race ENd (return to entry screen)");

                            #endregion
                            break;
                        case "NCN": // New Connection
                            #region NCN
                            
                            InSim.Decoder.NCN newConnection = new InSim.Decoder.NCN(recvPacket);

                            listOfPlayers.newPlayer(newConnection.UCID, newConnection.userName, newConnection.nickName, insimConnection.Product);
                            currInfoPlayer = listOfPlayers.getPlayerByUCID(newConnection.UCID);
                            currInfoPlayer.playerVars = newCfg.assignPlayerVar();
                            
                            if (currInfoPlayer == null)
                                break;
                            cfu.retreive(currInfoPlayer);
                            if (currInfoPlayer.CName == "")
                                currInfoPlayer.CName = newCfg.varsLapper.DefaultTopCar;
                            if (currInfoPlayer.CName != "")
                            {
                                LFS.PlayerStats nplys = lfsDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                                currInfoPlayer.updateSaved(nplys);
                                LFS.DriftPlayerStats plysDrift = lfsDriftDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                                currInfoPlayer.updateSavedDrift(plysDrift);

                            }
                            executeFunction( "OnConnect", currInfoPlayer );

                            #endregion
                            break;
                        case "CNL": // ConN Leave (end connection is moved down into this slot)
                            #region CNL
                            InSim.Decoder.CNL lostConnection = new InSim.Decoder.CNL(recvPacket);


                            currInfoPlayer = listOfPlayers.getPlayerByUCID(lostConnection.UCID);

                            if (currInfoPlayer == null)
                                break;

                            executeFunction("OnDisConnect", currInfoPlayer);
                            listOfPlayers.removePlayer(lostConnection.UCID);


                            if (debugmode)
                                Console.WriteLine(string.Format("Username:{0} Nickname:{1} ConnectionNumber:{2}", currInfoPlayer.userName, currInfoPlayer.nickName, lostConnection.UCID));
                            #endregion
                            break;
                        case "NPL": // New PLayer joining race (if number already exists, then leaving pits)
                            #region NPL
                            InSim.Decoder.NPL newPlayer = new InSim.Decoder.NPL(recvPacket);


                            currInfoPlayer = listOfPlayers.getPlayerByUCID(newPlayer.UCID);
                            if (currInfoPlayer == null)
                                break;
                            currInfoPlayer.OnTrack = true;
                            currInfoPlayer.LastCrossedFinishLine = DateTime.Now;
                            currInfoPlayer.MaxLapTime1Reached = false;
                            currInfoPlayer.MaxLapTime2Reached = false;
                            currInfoPlayer.MaxLapTime = trackInfo.getMaxLapTime(currentTrackName, newPlayer.CName);
                            //                            Console.WriteLine(currInfoPlayer.userName + " On track :" + currInfoPlayer.OnTrack);
                            listOfPlayers.majIndexPLID(newPlayer.UCID, newPlayer.PLID);
                            // If player change car, Clear session
                            if (currInfoPlayer.CName != newPlayer.CName)
                            {
                                currInfoPlayer.clearSessionInfo();
                            }
                            currInfoPlayer.CName = newPlayer.CName;
                            LFS.PlayerStats plys = lfsDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                            currInfoPlayer.updateSaved(plys);
                            LFS.DriftPlayerStats nplplysDrift = lfsDriftDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                            currInfoPlayer.updateSavedDrift(nplplysDrift);


                            #region Handicap User
                            // If indication of Handicap of current player
                            currInfoPlayer.H_Mass = newPlayer.H_Mass;
                            currInfoPlayer.H_TRes = newPlayer.H_TRes;
                            int cumH_Mass = 0;
                            int cumH_Tres = 0;
// Handicap priority
// Player, CarTrack, Car
                            // Car handicap
                            if (carHandicap.ContainsKey(currInfoPlayer.CName.ToLower()))
                            {
                                cumH_Mass = (carHandicap[currInfoPlayer.CName.ToLower()] as infoHandicap).H_Mass;
                                cumH_Tres = (carHandicap[currInfoPlayer.CName.ToLower()] as infoHandicap).H_TRes;
                            }
                            // Car/Tarck handicap
                            string carTrack = currInfoPlayer.CName.ToLower() + "/" + currentTrackName.ToLower();
//                            Console.WriteLine(carTrack);
                            if (carTrackHandicap.ContainsKey(carTrack))
                            {
                                cumH_Mass = (carTrackHandicap[carTrack] as infoHandicap).H_Mass;
                                cumH_Tres = (carTrackHandicap[carTrack] as infoHandicap).H_TRes;
                            }
                            // Player handicap
                            if (playerHandicap.ContainsKey(currInfoPlayer.userName.ToLower()))
                            {
                                cumH_Mass = (playerHandicap[currInfoPlayer.userName.ToLower()] as infoHandicap).H_Mass;
                                cumH_Tres = (playerHandicap[currInfoPlayer.userName.ToLower()] as infoHandicap).H_TRes;
                            }
                            if (newPlayer.H_Mass < cumH_Mass || newPlayer.H_TRes < cumH_Tres)
                                executeFunction("OnToLowHandicap", currInfoPlayer);
                            #endregion

                            #region Authorization for this player to join race
                            // Player Authorisation


                            if (!AllowAllPlayer && AuthOn && listOfPlayers.countPlayer() > newCfg.varsLapper.AuthMinPlayer)
                            {
                                bool PlayerAllowed = false;
                                string[] PlyAuth = GetAuth(currInfoPlayer).Split('|');
                                for (int i = 0; i < PlyAuth.Length; i++)
                                {
                                    try
                                    {
                                        int idx = int.Parse(PlyAuth[i]);
                                        if (AuthAllowPlayer[idx] == true)
                                        {
                                            PlayerAllowed = true;
                                            break;
                                        }
                                    }
                                    catch { }
                                }
                                if (!PlayerAllowed) // Test if Player is Always Allowed
                                {
                                    if( playerAlwaysAuth.ContainsKey(currInfoPlayer.userName.ToLower()))
                                        PlayerAllowed = true;
                                }
                                if (PlayerAllowed)
                                    executeFunction("OnAuthAllowed", currInfoPlayer);
                                else
                                    executeFunction("OnAuthNotAllowed", currInfoPlayer);
                            }
                            #endregion

                            #region flags for this player
                            actionPlayerFlags(newPlayer.Flags, currInfoPlayer,true );
                            #endregion

                            #endregion
                            break;
                        case "PLP": //PLayer Pits (go to settings - stays in player list)
                            #region PLP
                            InSim.Decoder.PLP plp = new InSim.Decoder.PLP(recvPacket);


                            currInfoPlayer = listOfPlayers.getPlayerByPLID(plp.PLID);
                            if (currInfoPlayer == null)
                                break;

                            currInfoPlayer.OnPit = false;
                            currInfoPlayer.OnTrack = false;
                            currInfoPlayer.currVote = (int)InSim.vtn.VOTE_END;
                            //                            Console.WriteLine(currInfoPlayer.userName + " On track :" + currInfoPlayer.OnTrack);
                            executeFunction("EnterPitAction", currInfoPlayer);
                            #endregion
                            break;
                        case "PLL": // PLayer Leave race (spectate - leaves player list, all are shunted down)
                            #region PLL
                            InSim.Decoder.PLL pll = new InSim.Decoder.PLL(recvPacket);

                            currInfoPlayer = listOfPlayers.getPlayerByPLID(pll.PLID);
                            if (currInfoPlayer == null)
                                break;
                            currInfoPlayer.OnTrack = false;
                            currInfoPlayer.OnPit = false;
                            currInfoPlayer.currVote = (int)InSim.vtn.VOTE_END;

                            //                            Console.WriteLine(currInfoPlayer.userName + " On track :" + currInfoPlayer.OnTrack);

                            currInfoPlayer.showButton = 0;
                            //ClearButton(currInfoPlayer);
                            executeFunction("LeaveRaceAction", currInfoPlayer);
                            listOfPlayers.removeIndexPLID(pll.PLID);
                            #endregion
                            break;
                        case "CPR": // Current Player rename
                            #region CPR
                            InSim.Decoder.CPR cpr = new InSim.Decoder.CPR(recvPacket);


                            currInfoPlayer = listOfPlayers.getPlayerByUCID(cpr.UCID);
                            if (currInfoPlayer == null)
                                break;
                            // For make bug programm to test object debug
                            /*
                                                        currInfoPlayer = listOfPlayers.getPlayerByUCID(300);
                                                        currInfoPlayer.CName = "";
                            */

                            string oldNickName = currInfoPlayer.nickName;
                            currInfoPlayer.Rename(cpr.newNickName);
                            if (currInfoPlayer.demoPlayer)
                            {
                                if (currInfoPlayer.CName == "")
                                    currInfoPlayer.CName = newCfg.varsLapper.DefaultTopCar;
                                if (currInfoPlayer.CName != "")
                                {
                                    LFS.PlayerStats nplys = lfsDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                                    currInfoPlayer.updateSaved(nplys);
                                    LFS.DriftPlayerStats plysDrift = lfsDriftDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                                    currInfoPlayer.updateSavedDrift(plysDrift);
                                }
                            }
                            // Sometime LFS send a CPR with same oldNickname and newNickname, maybe a new uniqueID
                            // if you do .Remove of Var the programm crash because the ref of var are same and the program crash;
                            if (debugmode) Console.WriteLine(string.Format("Conn Player {0} Rename from {1} to {2}, id:{3}",
                                                        currInfoPlayer.userName,
                                                        oldNickName,
                                                        cpr.newNickName,
                                                        cpr.UCID)
                             );
                            #endregion
                            break;
                        case "CLR": // "CLear Race - all players removed from race in one go"
                            #region CLR
                            currRace.inRace = false;
                            if (newCfg.varsLapper.AutoRestartRaceMn > 0)
                                currRace.nextRestart = DateTime.Now.AddMinutes((double)newCfg.varsLapper.AutoRestartRaceMn);

                            #endregion
                            break;
                        case "LAP": // LAP time
                            #region LAP
                            InSim.Decoder.LAP lapDec = new InSim.Decoder.LAP(recvPacket);


                            if (currRace.inRace == true && lapDec.LapsDone > currRace.lapsDone)
                                currRace.lapsDone = lapDec.LapsDone;

//                            Console.WriteLine("Lap N " + currRace.lapsDone.ToString());
                            
                            currInfoPlayer = listOfPlayers.getPlayerByPLID(lapDec.PLID);
                            if (currInfoPlayer == null)
                                break;

                            #region test flags for this player
                            actionPlayerFlags(lapDec.Flags, currInfoPlayer,false);
                            #endregion

                            delayedSaveDb = true;   // enable delayed save DB on new Lap
                            if (lapDec.LTime == unitConv.HMSToLong(60, 0, 0))
                                goto endOfLap;
                            if (debugmode) Console.WriteLine(string.Format(
                                    "UserName:{0} NickName:{1} CarName:{2} PlayerID:{3} Time:{4}",
                                    currInfoPlayer.userName,
                                    currInfoPlayer.nickName,
                                    currInfoPlayer.CName,
                                    lapDec.PLID.ToString(),
                                    unitConv.LongToHMS(lapDec.LTime)
                            ));
                            #region Message relative to time do by player ( good time, incerdible time, etc... )
                            string lapTimeAction = trackInfo.getLapAction(currentTrackName, currInfoPlayer.CName, lapDec.LTime);
                            if (lapTimeAction != "")
                            {
                                newCfg.setLocalVar("LapTime", quote( unitConv.LongToHMS(lapDec.LTime) ));
                                executeFunction(lapTimeAction, currInfoPlayer);
                            }
                            #endregion

                            #region Drift scores
                            if (currInfoPlayer.totaldriftscore >= newCfg.varsLapper.MinimumDriftScore)
                            {
                                currInfoPlayer.updateLapDriftScore(currentTrackName, newCfg.varsLapper.DateFormat, newCfg.varsLapper.TimeFormat);
                                if (currInfoPlayer.newBestdriftScore)
                                {
                                    lfsDriftDb.updateRow(currInfoPlayer, currentTrackName, modeSync, newCfg.varsLapper.SyncID, newCfg.varsLapper.SyncDir, SyncIDsToSync);
                                    imediateSaveDriftDb = true;
                                    try
                                    {
                                        executeFunction("DriftPBAction", currInfoPlayer);
                                    }
                                    catch (Exception ex)
                                    {
                                        Console.WriteLine(ex.ToString());
                                    }
                                }
                                else
                                {
                                    try
                                    {
                                        executeFunction("DriftLapAction", currInfoPlayer);
                                    }
                                    catch (Exception ex)
                                    {
                                        Console.WriteLine(ex.ToString());
                                    }
                                }
                            }
                            else
                            {
                                try
                                {
                                    executeFunction("DriftTooLowAction", currInfoPlayer);
                                }
                                catch (Exception ex)
                                {
                                    Console.WriteLine(ex.ToString());
                                }
                            }
                            #endregion

                            // For non drifting Update row of DB Every Laps
                            currInfoPlayer.updateLap(lapDec.LTime, trackInfo.getMaxLapTime(currentTrackName, currInfoPlayer.CName), currentTrackName, newCfg.varsLapper.DateFormat, newCfg.varsLapper.TimeFormat);
                            lfsDb.updateRow(currInfoPlayer, currentTrackName, modeSync, newCfg.varsLapper.SyncID, newCfg.varsLapper.SyncDir, SyncIDsToSync);
                            // On new Split
                            #region Show splitting
                            if (newCfg.varsLapper.ShowSplitPB && currInfoPlayer.showSplitPB )
                                executeFunction("OnSpbLast", currInfoPlayer);
                            executeFunction("OnLap", currInfoPlayer);
                            #endregion

                            #region Show if new PB
                            if (currInfoPlayer.isNewPBLtime)
                            {
                                imediateSaveDb = true;
                                try
                                {
                                    string CurAction;
                                    if (playerFilter.ContainsKey(currInfoPlayer.userName.ToLower()))
                                        CurAction = "PBQualAction";
                                    else
                                        CurAction = "PBAction";
                                    executeFunction(CurAction, currInfoPlayer);
                                }
                                catch (Exception ex)
                                {
                                    Console.WriteLine(ex.ToString());
                                }
                            }
                            #endregion

                            #region Max session laps
                            if (currInfoPlayer.sessLaps >= newCfg.varsLapper.MaxSessionLaps)
                                executeFunction("OnMaxSessionLaps",currInfoPlayer);
                            #endregion

                        endOfLap:
                            currInfoPlayer.totaldriftscore = 0;//reset score to 0
                            currInfoPlayer.maxLapSpeed = 0;//reset maxlapspeed to 0
                            currInfoPlayer.bestSpeed = (double)0;
                            #endregion
                            break;
                        case "SP1":
                        case "SP2":
                        case "SP3":
                        case "SPX": // Splitting info
                            #region SPX
                            InSim.Decoder.SPX splitdec = new InSim.Decoder.SPX(recvPacket);


                            currInfoPlayer = listOfPlayers.getPlayerByPLID(splitdec.PLID);
                            if (currInfoPlayer == null)
                                break;
                            if (splitdec.STime == unitConv.HMSToLong(60, 0, 0))
                                break;
                            currInfoPlayer.updateSplit(splitdec.Split, splitdec.STime, currentTrackName);
                            // If new splitting on PB file, save value and query save delayed DB
                            if (currInfoPlayer.newPBBestSplit)
                            {
                                lfsDb.updateRow(currInfoPlayer, currentTrackName, modeSync, newCfg.varsLapper.SyncID, newCfg.varsLapper.SyncDir, SyncIDsToSync);
                                delayedSaveDb = true;
                            }

                            SplitNotify(currInfoPlayer, splitdec);
                            #endregion
                            break;
                        case "RES": // RESult (qualify or finish) temporary
                            #region RES
                            InSim.Decoder.RES res = new InSim.Decoder.RES(recvPacket);


                            currRace.inRace = false;
                            if (newCfg.varsLapper.AutoRestartRaceMn > 0)
                                currRace.nextRestart = DateTime.Now.AddMinutes((double)newCfg.varsLapper.AutoRestartRaceMn);
                            #endregion
                            break;
                        case "FIN": // Final Result
                            #region FIN
                            InSim.Decoder.FIN fin = new InSim.Decoder.FIN(recvPacket);

                            #endregion
                            break;
                        case "REO": // REOrder (when race restarts after qualifying)
                            #region REO
                            InSim.Decoder.REO reo = new InSim.Decoder.REO(recvPacket);

                            #endregion
                            break;
                        case "STA": // State
                            #region STA
                            InSim.Decoder.STA state = new InSim.Decoder.STA(recvPacket);


                            if (currentTrackName != state.ShortTrackName)
                            {
                                listOfPlayers.changeTrack(state.ShortTrackName, lfsDb, lfsDriftDb);
                            }
                            currentTrackName = state.ShortTrackName;

                            if (debugmode) Console.WriteLine("Current track:" + currentTrackName
                                                     + " Conn:" + state.NumConns
                                        + " Player:" + state.NumP
                                        + " Flags:" + (state.Flags & 512)
                            );
                            if (flagFirst == true && (state.Flags & 512) == 512)
                            {
                                flagFirst = false;

                                byte[] sism = InSim.Encoder.ISM();
                                insimConnection.Send(sism, sism.Length);
/*
                                // Get All Connections
                                byte[] ncn = InSim.Encoder.NCN();
                                insimConnection.Send(ncn, ncn.Length);
                                // Get All Players
                                byte[] npl = InSim.Encoder.NPL();
                                insimConnection.Send(npl, npl.Length);
*/
                            }
                            #endregion
                            break;
                        case "MSO": // Message Output
                            #region MSO
                            InSim.Decoder.MSO msg = new InSim.Decoder.MSO(recvPacket);


                            currInfoPlayer = listOfPlayers.getPlayerByUCID(msg.UCID);
                            if (currInfoPlayer == null)
                                break;
                            string nicknamewithoutcolors = currInfoPlayer.nickName;
                            if (msg.UserType == 1)
                            {
                                if (swearWordObj.findSwearWords(msg.message)) // On swear word
                                {
                                    currInfoPlayer.swearWordsCount++;
                                    string tmpStr;
                                    if (currInfoPlayer.swearWordsCount >= newCfg.varsLapper.SwearWordsMax)
                                    {
                                        tmpStr = "SwearWordsAction2";
                                        currInfoPlayer.swearWordsCount = 0;
                                    }
                                    else
                                    {
                                        tmpStr = "SwearWordsAction1";
                                    }
                                    executeFunction(tmpStr, currInfoPlayer);
                                }
                                CheckForFlooding(currInfoPlayer);
                                string[] messWords = msg.message.Split(' ');
                                string cmdline = messWords[0];
                                string argline = "";
                                for (int i = 1; i < messWords.Length;i++ )
                                    argline += messWords[i] + " ";
                                argline = argline.Trim();
                                if (newCfg.msgActionsLapper.ContainsKey(messWords[0]) ) 
                                {
                                    lexCfg.MSGACTION msgAction = (lexCfg.MSGACTION)newCfg.msgActionsLapper[messWords[0]];
                                    newCfg.setLocalVar("argv", quote( argline.Trim()));
                                    executeFunction(msgAction.buffer, currInfoPlayer);
                                }
                            }
                            #endregion
                            break;
                        case "MCI":
                            #region MCI
                            InSim.Decoder.MCI mci = new InSim.Decoder.MCI(recvPacket);

                            #region Update stat of each player
                            for (int i = 0; i < System.Math.Min(8, mci.numOfPlayers); i++)
                            {
                                double xm = mci.compCar[i].x / 65536d;
                                double ym = mci.compCar[i].y / 65536d;
                                double zm = mci.compCar[i].z / 65536d;

                                double spm = mci.compCar[i].speed / 327.68 * 3.6; // kmh
                                double dirm = mci.compCar[i].direction * 180 / 32768d;
                                double headm = mci.compCar[i].heading * 180 / 32768d;
                                double angm = mci.compCar[i].angvel * 180 / 8192d;
                                currInfoPlayer = listOfPlayers.getPlayerByPLID(mci.compCar[i].PLID);
                                if (currInfoPlayer != null)
                                {
                                    double accStart;
                                    double accStop;
                                    if (currInfoPlayer.unitSpeedKmh)
                                    {
                                        accStart = newCfg.varsLapper.AccelerationStartSpeed;
                                        accStop = newCfg.varsLapper.AccelerationEndSpeed;
                                    }
                                    else
                                    {
                                        accStart = newCfg.varsLapper.AccelerationStartSpeedMph * 1.609344;
                                        accStop = newCfg.varsLapper.AccelerationEndSpeedMph * 1.609344;
                                    }
                                    currInfoPlayer.UpdateState(xm, ym, zm, spm, dirm, headm, angm, newCfg.varsLapper.MinimumDriftSpeed, newCfg.varsLapper.MinimumDriftAngle, newCfg.varsLapper.MaximumDriftAngle, newCfg.varsLapper.MinAngleVelocity, accStart, accStop);
                                }
                            }
                            #endregion

                            foreach (System.Collections.DictionaryEntry de in listOfPlayers.playersUCID)
                            {
                                currInfoPlayer = (infoPlayer)de.Value;

                                #region check for instunt time player
                                if (currInfoPlayer.stuntticks == newCfg.varsLapper.MaxNbInStunt)
                                    executeFunction("MaxNbInStuntAction", currInfoPlayer);
                                else if (currInfoPlayer.stuntticks == 1)
                                {
                                    executeFunction("AngleVelocityAction", currInfoPlayer);
                                }
                                #endregion

                                #region check for idle time
                                {
                                    string testExclude = "," + newCfg.varsLapper.IdleExclude.ToLower() + ",";
//                                    Console.WriteLine(currInfoPlayer.userName + ":" + currInfoPlayer.idleticks);
                                    if (testExclude.IndexOf("," + currInfoPlayer.userName.ToLower() + ",") != -1)
                                    {
//                                        Console.WriteLine("Pas idle");
                                        currInfoPlayer.idleticks = 0;
                                    }
                                    if (currRace.inRace == false || currInfoPlayer.OnPit == true || currInfoPlayer.OnTrack == false)
                                    { // if not in race, Force IdleTick for each player to 0
                                        currInfoPlayer.idleticks = 0;
                                    }
                                }
                                if (currInfoPlayer.idleticks > (newCfg.varsLapper.OnIdleTimeout2 * 10))
                                {
                                    executeFunction("OnIdleAction2", currInfoPlayer);
                                    currInfoPlayer.idleticks = 0; //reset to zero afterwards, don't want flooding
                                    currInfoPlayer.OnIdleAction1Sended = false;
                                }
                                if ((currInfoPlayer.idleticks > (newCfg.varsLapper.OnIdleTimeout1 * 10)) && (currInfoPlayer.OnIdleAction1Sended == false))
                                {
                                    executeFunction("OnIdleAction1", currInfoPlayer);
                                    currInfoPlayer.OnIdleAction1Sended = true;
                                    //                                    p.idleticks = 0; //reset to zero afterwards, don't want flooding
                                }
                                #endregion

                                #region write current drift score
                                if (currInfoPlayer.driftticks == 0 && currInfoPlayer.lastdriftscore > 0 && currInfoPlayer.totaldriftscore > 0)
                                {
                                    executeFunction("OnDriftScore", currInfoPlayer);

                                    if (currInfoPlayer.lastdriftscore >= newCfg.varsLapper.GoodDriftScore)
                                        executeFunction("GoodDriftAction", currInfoPlayer);

                                    currInfoPlayer.lastdriftscore = 0;
                                }
                                #endregion

                                #region acceleration 0-100
                                if (currInfoPlayer.accelerationTimeValid && currInfoPlayer.accelerationTime.TotalSeconds <= newCfg.varsLapper.AccelerationPrivateMaxTime)
                                {
                                    if (!currInfoPlayer.unitSpeedKmh)
                                    {
                                        newCfg.setLocalVar( "AccelerationStartSpeed", newCfg.varsLapper.AccelerationStartSpeedMph.ToString() );
                                        newCfg.setLocalVar("AccelerationEndSpeed", newCfg.varsLapper.AccelerationEndSpeedMph.ToString());
                                    }
                                    currInfoPlayer.accelerationTimeValid = false;
                                    executeFunction("OnAcceleration", currInfoPlayer);
                                }
                                #endregion

                                #region Action if player is to slow to complete a lap
                                if (currRace.inRace && currInfoPlayer.OnTrack)
                                {
                                    if (newCfg.varsLapper.MaxAllowedLapTime1 != -1)
                                    {
                                        long second = (long)(((double)newCfg.varsLapper.MaxAllowedLapTime1 / 100) * ((double)currInfoPlayer.MaxLapTime / 1000));
                                        if (!currInfoPlayer.MaxLapTime1Reached && currInfoPlayer.LastCrossedFinishLine.AddSeconds((double)second) < DateTime.Now)
                                        {
                                            executeFunction("OnMaxAllowedLapTime1", currInfoPlayer);
                                            currInfoPlayer.MaxLapTime1Reached = true;
                                        }
                                    }
                                    if (newCfg.varsLapper.MaxAllowedLapTime2 != -1)
                                    {
                                        long second = (long)(((double)newCfg.varsLapper.MaxAllowedLapTime2 / 100) * ((double)currInfoPlayer.MaxLapTime / 1000));
                                        if (!currInfoPlayer.MaxLapTime2Reached && currInfoPlayer.LastCrossedFinishLine.AddSeconds((double)second) < DateTime.Now)
                                        {
                                            executeFunction("OnMaxAllowedLapTime2", currInfoPlayer);
                                            currInfoPlayer.MaxLapTime2Reached = true;
                                        }
                                    }
                                }
                                #endregion
                            }
                            #endregion
                            break;
                        case "ISM": //ISM multiplayer notification packet
                            #region ISM
                            InSim.Decoder.ISM ism = new InSim.Decoder.ISM(recvPacket);

                            currentHName = ism.HName;
                            if (newCfg.varsLapper.EnableRegisterWeb)
                            {
                                objregisterWeb.HName = ism.HName;
                                objregisterWeb.Ver =  LFSLapper.getShortVersion(3);
                            }
                            // Get All Connections
                            System.Threading.Thread.Sleep(100);
                            byte[] ismncn = InSim.Encoder.NCN();
                            insimConnection.Send(ismncn, ismncn.Length);
                            // Get All Players
                            System.Threading.Thread.Sleep(100);
                            byte[] ismnpl = InSim.Encoder.NPL();
                            insimConnection.Send(ismnpl, ismnpl.Length);
                            #endregion
                            break;
                        case "PEN": // NEW PEN : (penalty)
                            #region PEN
                            InSim.Decoder.PEN pen = new InSim.Decoder.PEN(recvPacket);


                            currInfoPlayer = listOfPlayers.getPlayerByPLID(pen.PLID);

                            if (currInfoPlayer == null)
                                break;

                            if (debugmode) Console.WriteLine(currInfoPlayer.nickName
                                                + " OldPen:" + Enum.GetName(typeof(InSim.pen), pen.OldPen)
                                                + " NewPen:" + Enum.GetName(typeof(InSim.pen), pen.NewPen)
                                                + " Reason:" + Enum.GetName(typeof(InSim.penr), pen.Reason));
                            OnPenalties(currInfoPlayer, pen);
                            #endregion
                            break;
                        case "BFN": // NEW BFN : (Button request)
                            #region BFN
                            InSim.Decoder.BFN bfn = new InSim.Decoder.BFN(recvPacket);

                            currInfoPlayer = listOfPlayers.getPlayerByUCID(bfn.UCID);
                            if (currInfoPlayer == null)
                                break;
                            if (currInfoPlayer.PLID == -1)
                                break;
                            currInfoPlayer.showButton++;
                            if (currInfoPlayer.showButton > 1)
                                currInfoPlayer.showButton = 0;
                            UpButton(currInfoPlayer);
                            #endregion
                            break;
                        case "BTC": // NEW BTC : (Button click)
                            #region BTC
                            InSim.Decoder.BTC btc = new InSim.Decoder.BTC(recvPacket);

//                            Console.WriteLine("UCID-> " + btc.UCID + "/" + btc.ClickID);
                            currInfoPlayer = listOfPlayers.getPlayerByUCID(btc.UCID);
                            if (currInfoPlayer == null)
                                break;
                            if (btc.ClickID == (int)btnID.BUT_SESS) // Session Spb
                            {
                                currInfoPlayer.viewSPBSplit = 'S';
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_PB) // PB server Spb
                            {
                                currInfoPlayer.viewSPBSplit = 'P';
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_WR) // WR Spb
                            {
                                currInfoPlayer.viewSPBSplit = 'W';
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_SHOW) // Show Split PB
                            {
                                currInfoPlayer.showSplitPB = true; // show
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_HIDE) // Hide Split PB
                            {
                                currInfoPlayer.showSplitPB = false; // Hide
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_KMH) // Speed in KM
                            {
                                currInfoPlayer.unitSpeedKmh = true; // Km/h
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_MPH) // Speed in MPH
                            {
                                currInfoPlayer.unitSpeedKmh = false; // Mp/h
                                cfu.update(currInfoPlayer);
                            }
                            UpButton(currInfoPlayer);
                            executeFunction( currInfoPlayer.playerBox.doAction( btc.ClickID, btc.UCID ), currInfoPlayer );
                            #endregion
                            break;
                        case "TOC": // NEW TOC : (take over car)
                            #region TOC
                            InSim.Decoder.TOC toc = new InSim.Decoder.TOC(recvPacket);


                            infoPlayer oldCurrInfoPlayer = listOfPlayers.getPlayerByPLID(toc.PLID);
                            if (oldCurrInfoPlayer == null)
                                break;

                            listOfPlayers.removeIndexPLID(toc.PLID); // Remove PLID OF oldPlayer
                            listOfPlayers.majIndexPLID(toc.NewUCID, toc.PLID); // Attach PLID to new player

                            currInfoPlayer = listOfPlayers.getPlayerByPLID(toc.PLID);
                            currInfoPlayer.H_Mass = oldCurrInfoPlayer.H_Mass;
                            currInfoPlayer.H_TRes = oldCurrInfoPlayer.H_TRes;
                            currInfoPlayer.CName = oldCurrInfoPlayer.CName;
                            // Retreive Info of this Player in DBS
                            LFS.PlayerStats tocplys = lfsDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                            currInfoPlayer.updateSaved(tocplys);
                            LFS.DriftPlayerStats tocplysDrift = lfsDriftDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                            currInfoPlayer.updateSavedDrift(tocplysDrift);
                            currInfoPlayer.OnTrack = true;
                            currInfoPlayer.LastCrossedFinishLine = DateTime.Now;
                            currInfoPlayer.MaxLapTime1Reached = false;
                            currInfoPlayer.MaxLapTime2Reached = false;

                            //                            Console.WriteLine(currInfoPlayer.userName + " On track :" + currInfoPlayer.OnTrack);

                            #endregion
                            break;
                        case "PIT": // NEW PIT : (pit stop)
                            #region PIT
                            InSim.Decoder.PIT pit = new InSim.Decoder.PIT(recvPacket);


                            currInfoPlayer = listOfPlayers.getPlayerByPLID(pit.PLID);
                            if (currInfoPlayer == null)
                                break;
                            currInfoPlayer.OnPit = true;
                            newCfg.setLocalVar("Work", quote( pit.sWork ));
                            executeFunction("OnBeginPit", currInfoPlayer);
                            #endregion
                            break;
                        case "PSF": // NEW PSF : (pit stop finished)
                            #region PSF
                            InSim.Decoder.PSF psf = new InSim.Decoder.PSF(recvPacket);


                            currInfoPlayer = listOfPlayers.getPlayerByPLID(psf.PLID);
                            if (currInfoPlayer == null)
                                break;
                            currInfoPlayer.OnPit = false;
                            currInfoPlayer.totalPitTime += psf.STime;
                            newCfg.setLocalVar("PitTime", quote( unitConv.LongToHMS( psf.STime )));
                            executeFunction("OnEndPit", currInfoPlayer);
                            #endregion
                            break;
                        case "NLP":
                            #region NLP
                            #endregion
                            break;
                        case "VTC":
                            #region VTC
                            #endregion
                            break;
                        case "VTN": // Insim Vote
                            #region VTN

                            InSim.Decoder.VTN vtn = new InSim.Decoder.VTN(recvPacket);
                            currInfoPlayer = listOfPlayers.getPlayerByUCID(vtn.UCID);
//                            Console.WriteLine("VTN info " + currInfoPlayer.userName + ":" + vtn.UCID);
                            if (currInfoPlayer == null)
                                break;
//                            Console.WriteLine( "Vote : " + vtn.Action);
                            if (((currRace.lapsDone + 1) < InRaceLapsVoteMin
                                || (currRace.lapsDone + 1) > InRaceLapsVoteMax)
                                && currRace.inRace == true 
                                && vtn.Action > 1
                                && vtn.UCID != 0
                                )
                            {
                                byte[] vtc = InSim.Encoder.VTC();
                                insimConnection.Send(vtc, vtc.Length);
                                Console.WriteLine("Cancel because lap not done");
                                break;
                            }
                            currInfoPlayer.currVote = vtn.Action;
                            currInfoPlayer.expireVote = DateTime.Now.AddSeconds(newCfg.varsLapper.VoteLifeSec);

                            if (newCfg.varsLapper.VoteRestart != -1 && currInfoPlayer.currVote == (int)InSim.vtn.VOTE_RESTART && vtn.UCID != 0)
                            {
                                trVote(currInfoPlayer, vtn, newCfg.varsLapper.VoteRestart, listOfPlayers.voteRestart, "onVoteRestartChange", "onVoteRestartReach");
                            }
                            if (newCfg.varsLapper.VoteQualify != -1 && currInfoPlayer.currVote == (int)InSim.vtn.VOTE_QUALIFY && vtn.UCID != 0)
                            {
                                trVote(currInfoPlayer, vtn, newCfg.varsLapper.VoteQualify, listOfPlayers.voteQualify, "onVoteQualifyChange", "onVoteQualifyReach");
                            }
                            if (newCfg.varsLapper.VoteEnd != -1 && currInfoPlayer.currVote == (int)InSim.vtn.VOTE_END && vtn.UCID != 0)
                            {
                                trVote(currInfoPlayer, vtn, newCfg.varsLapper.VoteEnd, listOfPlayers.voteEnd, "onVoteEndChange", "onVoteEndReach");
                            }
                            #endregion
                            break;
                        case "III": // NEW III : InSimInfo
                            #region III
                            #endregion
                            break;
                        case "PLA": // NEW PLA : (Pit LAne)
                            #region PLA
                            #endregion
                            break;
                        case "FLG": // NEW FLG : (yellow or blue flags)
                            #region FLG
                            #endregion
                            break;
                        case "PFL": // NEW PFL : (player help flags)
                            #region PFL
                            InSim.Decoder.PFL pfl = new InSim.Decoder.PFL(recvPacket);
                            currInfoPlayer = listOfPlayers.getPlayerByPLID(pfl.PLID);
                            if (currInfoPlayer == null)
                                break;
                            if( currInfoPlayer.OnTrack )
                                actionPlayerFlags(pfl.Flags, currInfoPlayer, true);
                            #endregion
                            break;
                        case "CCH": // NEW CCH : (camera changed)
                            #region CCH
                            #endregion
                            break;
                        case "AXI": // send an IS_AXI
                            #region AXI
                            #endregion
                            break;  // autocross cleared
                        case "AXC":
                            #region AXC
                            #endregion
                            break;
                        default:
                            Console.WriteLine(packetHead);
                            break;
                    }

                }
            }

        }
    }
}