 /*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.IO;
using System.Reflection;
using System.Collections;
using Microsoft.CSharp;
using System.CodeDom.Compiler;

namespace lexCfg
{
    enum paramLapper
    {
        maxSplit = 3,
        delayedSave = 120,  // Delay beetxeen 2 save delayed in second
        UploadSync = 20,     // Delay Between 2 Upload Sync
        delayedRegisterWeb = 15,  // Delay beetween 2 registration on web in minute
        webTimeOut = 10000,  // Timeout in ms on Web Request
        nbLineTop = 18,        // Multiple of 2
        debugmode = 0,      // Allow logerr.txt to be generated for error reporting
    }


    public enum typFunction
    {
        Event,
        Sub,
    }
    public enum typVar
    {
        str,
        num,
        ip,
    }
    enum eventAllowed{
        OnLapperStart,
        OnAuthAllowed,
        OnAuthNotAllowed,
        OnAuthReached,
        SwearWordsAction1,
        SwearWordsAction2,
        OnToLowHandicap,
        OnNotMatchFlags,
        onVoteRestartChange,
        onVoteRestartReach,
        onVoteRestartZero,
        onVoteQualifyChange,
        onVoteQualifyReach,
        onVoteQualifyZero,
        onVoteEndChange,
        onVoteEndReach,
        onVoteEndZero,
        OnConnect,
        OnDisConnect,
        OnSplit1,
        OnSplit2,
        OnSplit3,
        OnLap,
        OnSpbSplit1,
        OnSpbSplit2,
        OnSpbSplit3,
        OnSpbLast,
        FloodAction,
        RaceStartAction,
        OnMaxSessionLaps,
        AngleVelocityAction,
        MaxNbInStuntAction,
        OnMaxAllowedLapTime1,
        OnMaxAllowedLapTime2,
        OnIdleAction1,
        OnIdleAction2,
        DriftPBAction,
        DriftLapAction,
        OnDriftScore,
        PBAction,
        PBQualAction,
        OnAcceleration,
        EnterPitAction,
        OnBeginPit,
        OnEndPit,
        OnFastDriveOnPitL1,
        OnFastDriveOnPitL2,
        OnMaxFastDriveOnPit,
        OnFalseStartL1,
        OnFalseStartL2,
        LeaveRaceAction,
        DriftTooLowAction,
        GoodDriftAction,
        OnRotateCar,
        OnRotateTrack,
    }
    public class VAR
    {
        public typVar typ ;
        public string value;
        public VAR(typVar t, string v)
        {
            this.typ = t;
            this.value = v;
        }
    }
    public class MSGACTION
    {
        public string pattern;
        public string buffer;
        public MSGACTION(string pat, string buff)
        {
            this.pattern = pat;
            this.buffer = buff;
        }
    }
    public class FUNCTION
    {
        public typFunction type;
        public string buffer;
        public int lineInCfg;
        public FUNCTION(typFunction typ, string buff, int line )
        {
            this.type = typ;
            this.buffer = buff;
            this.lineInCfg = line;
        }
    }
    public class VLAPPER
    {
        public string Host;
        public int Port;
        public string Password;
        public string TrackInfoFile;
        public bool TCPmode = true;
        public bool EnableRegisterWeb = true;
        public string DateFormat = "dd/MM/yyyy";
        public string TimeFormat = "HH:mm";
        public int MessageTime = 5000;
        public bool ShowPlayerControl = true;
        public string FtpServer = "";
        public string FtpLogin = "";
        public string FtpPasswd = "";
        public string FtpRemotePath = "";
        public string SyncID = "";
        public string SyncDir = "";
        public string SyncIDsToSync = "";
        public string DefaultTopCar;
        public string PubStatIdk = "";
        public bool UseUsernameForAuthentication = true;
        // AUthorization
        public string Auth1 = "";
        public string Auth2 = "";
        public string Auth3 = "";
        public string Auth4 = "";
        public string Auth5 = "";
        public string Auth6 = "";
        public string Auth7 = "";
        public string Auth8 = "";
        public string Auth9 = "";
        public string Auth10 = "";
        public string AuthAllowPlayer = "All";
        public int AuthMinPlayer = 0;
        //SwearWordsList
        public string SwearWordsList = "";
        public int SwearWordsMax = 2;
        // HandicapCars
        public string HandicapCars = "";
        public string HandicapCarsTracks = "";
        public bool RefreshHandicapUsers = false;
        public string HandicapUsers = "";
        // Control Allowed 
        public string SwapSide = "*";
        public string AutoGears = "*";
        public string Shifter = "*";
        public string HelpBrake = "*";
        public string AxisClutch = "*";
        public string AutoClutch = "*";
        public string Mouse = "*";
        public string KbNoHelp = "*";
        public string KbStabilised = "*";
        public string CustomView = "*";
        // Votation
        public string InRaceLapsVoteMinMax = "0-9999999";
        public int VoteLifeSec = 30;

        public int VoteRestart = -1;
        public int VoteQualify = -1;
        public int VoteEnd = -1;
        // Rotation
        public int AutoRestartRaceMn = 0;
        public int RotateEveryNbRaces = 4;
        public bool EnableRotation = false;
        public string RotateTracks = "";
        public string RotateCars = "";
        // Connection
        // Splitting
        public bool ShowSplitPB = true;
        // List of user qualifying 
        public bool RefreshQualUsers = true;
        public string QualUsers = "";
        // Flood Actions
        public int MaxFloodLines = 4;
        public int MaxFloodLinesTime = 5000;
        // Session action
        public int MaxSessionLaps = 99999;
        //Spinning detection options
        public int MinAngleVelocity = 250;
        public int MaxNbInStunt = 32768;
        // to Slow user
        public int MaxAllowedLapTime1 = -1;

        public int MaxAllowedLapTime2 = -1;
        // Idling options
        public int OnIdleTimeout1 = 60;
        public string IdleExclude = "";

        public int OnIdleTimeout2 = 120;
        // Drifting
        public string DriftDatabase = "./DriftPB.txt";
        public int GoodDriftScore = 4000;
        public int MinimumDriftScore = 10;
        public int MinimumDriftSpeed = 50;
        public int MinimumDriftAngle = 15;
        public int MaximumDriftAngle = 100;
        // Hotlapping options
        public string Database = "./PB.txt";
        // Acceleration options
        public double AccelerationStartSpeed = 1;
        public double AccelerationEndSpeed = 100;
        public double AccelerationStartSpeedMph = 1;
        public double AccelerationEndSpeedMph = 60;
        public double AccelerationPrivateMaxTime = 10;
        // Penalties
        public int MaxFastDriveOnPit = 99999;

    }

    class lexConfigurator
    {
        public VLAPPER varsLapper;
        public System.Collections.Hashtable varsGlobal = new System.Collections.Hashtable();
        public System.Collections.Hashtable varsUserGlobal = new System.Collections.Hashtable();
        public System.Collections.Hashtable varsPlayer = new System.Collections.Hashtable();
        public System.Collections.Hashtable varsLocal = new System.Collections.Hashtable();
        public System.Collections.Hashtable functionsLapper = new System.Collections.Hashtable();
        public System.Collections.Hashtable msgActionsLapper = new System.Collections.Hashtable();
        public System.Collections.ArrayList Tasks = new System.Collections.ArrayList();

        
        public lexConfigurator()
        {
            varsLapper = new VLAPPER();
        }
        public void dumpVar()
        {

            FieldInfo[] fields = varsLapper.GetType().GetFields();
            for (int i = 0; i < fields.Length; i++)
            {
                if (fields[i].GetValue(varsLapper) == null)
                {
                    Console.WriteLine(fields[i].Name + " = Null");
                }
                else
                {
                    Console.WriteLine(fields[i].Name + " = " + fields[i].GetValue(varsLapper));
                }

            }

        }
        public void dumpVarsGlobal()
        {
            foreach (DictionaryEntry de in varsGlobal)
            {
                Console.WriteLine( de.Key + " = " + de.Value.ToString());
            }
        }
        public void dumpFunctions()
        {
            foreach (DictionaryEntry de in functionsLapper)
            {
                FUNCTION fu = (FUNCTION)de.Value;
                Console.WriteLine(fu.type + " " + de.Key + " = " + fu.buffer);
            }

        }
        public void dumpMsgActionsLapper()
        {
            foreach (DictionaryEntry de in msgActionsLapper)
            {
                MSGACTION fu = (MSGACTION)de.Value;
                Console.WriteLine(fu.pattern + " " + de.Key + " = " + fu.buffer);
            }

        }
        public void dumpTask()
        {
            for (int i = 0; i < Tasks.Count; i++)
            {
                Console.WriteLine((Tasks[i] as LFSLapper.Task).Cron + " : " + (Tasks[i] as LFSLapper.Task).Command);
            }
        }
        public bool load(string filepath)
        {
            Type TvarsLapper = varsLapper.GetType();
            FieldInfo FIvarsLapper;
            int LineError = 0;
            FileStream file;
            Scanner scnr;
            try
            {
                file = new FileStream(filepath, FileMode.Open);
                scnr = new Scanner(file);
            }
            catch (System.Exception ev)
            {
                Console.WriteLine(ev.Message);
                return false;
            }
            try
            {
                Console.Write("Parse config file...");
                int tok;
                do
                {
                    tok = scnr.yylex();

//                    Console.WriteLine("#" + tok + ": " + scnr.yytext);
                    switch(tok){
                        case lexCfg.Scanner.E_BEGIN_FUNCTION:
                            {
                                string identName = scnr.yytext.ToLower();
                                int lineCurr = scnr.GyyLine;
                                if ((tok = scnr.yylex()) != lexCfg.Scanner.E_IDENT)
                                    throw (new System.Exception("Syntax error in cfg file Event need Event identification"));

                                string ev = scnr.yytext;

                                if (identName == "event" && !Enum.IsDefined(typeof(eventAllowed), ev))
                                    throw (new System.Exception("Event " + ev + " do not exist in LFSLapper"));

                                if ((tok = scnr.yylex()) != lexCfg.Scanner.E_PAR_OPEN)
                                    throw (new System.Exception("Syntax error in cfg file Event need '(' in event :" + ev));

                                if ((tok = scnr.yylex()) != lexCfg.Scanner.E_PAR_CLOSE)
                                    throw (new System.Exception("Syntax error in cfg file Event need ')' in event :" + ev));
                                string strBloc = "";
                                scnr.BEGIN(4);
                                while (true)
                                {
                                    tok = scnr.yylex();
                                    string str = scnr.yytext;
                                    if (tok == lexCfg.Scanner.E_BEGIN_FUNCTION)
                                    {
                                        throw (new System.Exception("Unexpected function in event :" + ev));
                                    }
                                    if (tok == lexCfg.Scanner.E_END_FUNCTION)
                                    {
                                        if (identName == "event" && str.ToLower() == "endevent")
                                            break;
                                        if (identName == "sub" && str.ToLower() == "endsub")
                                            break;
                                        throw (new System.Exception("Unexpected end function in event :" + ev));
                                    }
                                    strBloc += str;
                                }
                                scnr.BEGIN(0);

                                //Console.WriteLine("#" + tok + ": >----\n" + strBloc + "\n<------- ");
                                if (identName == "event")
                                    functionsLapper[ev] = new FUNCTION(typFunction.Event, strBloc, lineCurr);
                                if (identName == "sub")
                                    functionsLapper[ev] = new FUNCTION(typFunction.Sub, strBloc, lineCurr);
                            }
                            break;
                        case lexCfg.Scanner.E_IDENT:
                            {
                                string identName = scnr.yytext.ToLower();
                                if (identName == "register")
                                {
                                    if ((tok = scnr.yylex()) != lexCfg.Scanner.E_IDENT)
                                        throw (new System.Exception("Syntax error in cfg file Register need Register identification"));

                                    string typRegister = scnr.yytext.ToLower();

                                    if ((tok = scnr.yylex()) != lexCfg.Scanner.E_PAR_OPEN)
                                        throw (new System.Exception("Syntax error in cfg file Event need '('"));

                                    if ((tok = scnr.yylex()) != lexCfg.Scanner.E_STRING)
                                        throw (new System.Exception("Syntax error in cfg file Event need string in cron timer"));
                                    string firstArg = scnr.yytext;
                                    int l = firstArg.Length;
                                    firstArg = firstArg.Substring(1, l - 2);

                                    if ((tok = scnr.yylex()) != lexCfg.Scanner.E_COLON)
                                        throw (new System.Exception("Syntax error in cfg file ScheduleAction need ','"));

                                    if ((tok = scnr.yylex()) != lexCfg.Scanner.E_IDENT)
                                        throw (new System.Exception("Syntax error in cfg file ScheduleAction need function identification"));

                                    string secondArg = scnr.yytext;

                                    if ((tok = scnr.yylex()) != lexCfg.Scanner.E_PAR_CLOSE)
                                        throw (new System.Exception("Syntax error in cfg file Event need '('"));

                                    if (scnr.yylex() != lexCfg.Scanner.E_SEMICOLON)
                                        throw (new System.Exception("Syntax error in cfg file need '; at end of line'"));

                                    if (typRegister == "scheduleaction")
                                    {
                                        string[] cronTimer = firstArg.Split(':');
                                        for (int i = 0; i < cronTimer.Length; i++)
                                            Tasks.Add(new LFSLapper.Task(secondArg, cronTimer[i], scnr.GyyLine));
                                    }
                                    else if (typRegister == "msgaction")
                                    {
                                        msgActionsLapper[firstArg] = new MSGACTION(firstArg, secondArg);
                                    }
                                    else
                                        throw (new System.Exception("Syntax error in cfg file register action not allowed"));
                                }
                                else
                                    throw (new System.Exception("Syntax error in cfg file :" + scnr.yytext));
                            }
                            break;
                        case lexCfg.Scanner.E_VAR:
                            string idVar = scnr.yytext.Substring(1);
                            if (scnr.yylex() != lexCfg.Scanner.E_EQUAL)
                                throw (new System.Exception("Syntax error in cfg file var $" + idVar + " need '='" ));

                            tok = scnr.yylex();
                            int typParam = tok;
//                            Console.WriteLine("#" + typParam + ": " + scnr.yytext);
                            string strVal = scnr.yytext;
//                            Console.WriteLine("Var = " + idVar);
//                            Console.WriteLine("Value = " + strVal);

                            if (scnr.yylex() != lexCfg.Scanner.E_SEMICOLON)
                                throw (new System.Exception("Syntax error in cfg file var $" + idVar + " need '; at end of line'" ));

                            FIvarsLapper = TvarsLapper.GetField(idVar);

                            if (FIvarsLapper == null)
                                throw (new System.Exception("Param var $" + idVar + " do not exist" ));

                            string typVarsLapper = FIvarsLapper.FieldType.Name;
                            if (typVarsLapper == "String" && typParam == lexCfg.Scanner.E_IP)
                            {
//                                Console.WriteLine("Je set " + idVar + " Avec : " + strVal);
                                FIvarsLapper.SetValue(varsLapper, strVal);
                            }
                            else if (typVarsLapper == "String" && typParam == lexCfg.Scanner.E_STRING)
                            {
                                FIvarsLapper.SetValue(varsLapper, strVal.Substring(1, strVal.Length - 2));
                            }
                            else if (typVarsLapper == "Int32" && typParam == lexCfg.Scanner.E_INTEGER)
                            {
                                try
                                {
                                    FIvarsLapper.SetValue(varsLapper, int.Parse(strVal));
                                }
                                catch
                                {
                                    throw (new System.Exception("Var $" + idVar + " is wrong type. Need Integer value" ));
                                }
                            }
                            else if (typVarsLapper == "Double" && (typParam == lexCfg.Scanner.E_INTEGER || typParam == lexCfg.Scanner.E_FLOAT))
                            {
                                try
                                {
                                    FIvarsLapper.SetValue(varsLapper, double.Parse(strVal.Replace(".", System.Globalization.NumberFormatInfo.CurrentInfo.CurrencyDecimalSeparator)));
                                }
                                catch
                                {
                                    throw (new System.Exception("Var $" + idVar + " is wrong type. Need float value" ));
                                }
                            }
                            else if (typVarsLapper == "Boolean" && (strVal.ToLower() == "true" || strVal.ToLower() == "false"))
                            {
                                try
                                {
                                    FIvarsLapper.SetValue(varsLapper, bool.Parse(strVal));
                                }
                                catch
                                {
                                    throw (new System.Exception("Var $" + idVar + " is wrong type. Need true or false value" ));
                                }

                            }
                            else
                                throw (new System.Exception("Var $" + idVar + " is wrong type. Need " + typVarsLapper + " value" ));

                            varsGlobal[idVar] = strVal;
//                            Console.WriteLine(idVar + " = " + FIvarsLapper.GetValue(varsLapper));
                            break;
                        case lexCfg.Scanner.E_END:
                            return true;
                        default:
                            throw (new System.Exception("Syntax error in cfg file line " + scnr.yytext + " Char " + scnr.yytext ));
                            break;



                    }
                } while (tok > (int)Tokens.EOF);
            }
            catch (System.Exception ev)
            {
                Console.WriteLine("Ko");
                Console.WriteLine(ev.Message + " at line #" + scnr.GyyLine);
                return false;
            }
//            Console.ReadKey();
            return true;

        }

        public bool isPlayerVar(string idVar)
        {
            return varsPlayer.ContainsKey( idVar );
        }
        public void setPlayerVar(string idVar, string strVal)
        {
            varsPlayer[idVar] = strVal;
        }
        public System.Collections.Hashtable assignPlayerVar()
        {
            System.Collections.Hashtable newVars = new System.Collections.Hashtable();
            foreach (DictionaryEntry de in varsPlayer )
            {
                newVars[de.Key] = de.Value.ToString();
            }
            return newVars;

        }
        public bool isUserGlobalVar(string idVar)
        {
            return varsUserGlobal.ContainsKey(idVar);
        }
        public void setUserGlobalVar(string idVar, string strVal)
        {
            varsUserGlobal[idVar] = strVal;
        }
        public void setLocalVar(string idVar, string strVal)
        {
            varsLocal[idVar] = strVal;
        }
        public void clearLocalVar()
        {
            varsLocal.Clear();
        }
    }
}