/*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Text;
using System.Collections;



namespace LFSLapper
{

    public class infoPlayer
    {
        public int UCID;
        public int PLID;
        public string userName;
        public string nickName;
        public bool demoPlayer = false;

        public bool OnTrack = false;
        public bool OnPit = false;

        public long MaxLapTime;

        public int laps;
        public int sessLaps;

        public long[] split = new long[(int)lexCfg.paramLapper.maxSplit];
        public long lapTime;
        public long diffLapTimeToPb;
        public long[] sectorSplit = new long[(int)lexCfg.paramLapper.maxSplit];
        public long sectorSplitLast;
        public long[] bestSectorSplit = new long[(int)lexCfg.paramLapper.maxSplit];
        public long bestSectorSplitLast;
        public long[] diffSectorSplit = new long[(int)lexCfg.paramLapper.maxSplit];
        public long diffSectorSplitLast;
        public bool[] isBestSectorSplit  = new bool[(int)lexCfg.paramLapper.maxSplit];
        public bool isBestSectorSplitLast;

        public long splitLast;

        public long currSplit;
        public long diffSplit;
        public long bestSplit;
        public bool newSessBestSplit;
        public bool newPBBestSplit;
        public bool newWRBestSplit;

        public long lastSplitTime;


        public long[] sessBestSplitDiff = new long[(int)lexCfg.paramLapper.maxSplit];
        public long sessBestSplitDiffLast;

        public long[] PBBestSplitDiff = new long[(int)lexCfg.paramLapper.maxSplit];
        public long PBBestSplitDiffLast;

        public double bestSpeed;
        public string CName;

        public long PBLTime;
        public long[] PBSplit = new long[(int)lexCfg.paramLapper.maxSplit];
        public string PBDate;
        public string PBTime;
        public bool isNewPBLtime;


        public double absangle;
        public double totaldriftscore,lastdriftscore,driftticks;

        public double bestdriftscore;
        public string DriftPBDate;
        public string DriftPBTime;
        public bool newBestdriftScore;

        public double speed, direction, heading;

        public int idleticks;
        public bool OnIdleAction1Sended = false;
        
        public int stuntticks;
        public double AngVel;

        public double maxLapSpeed;

        public bool accelerationInProgress;
        public System.DateTime timeSinceZeroSpeed;
        public System.TimeSpan accelerationTime;
        public bool accelerationTimeValid;

        public double x, y;

        public int floodcount;
        public DateTime LastLine = DateTime.Now;

        public DateTime LastCrossedFinishLine = DateTime.Now;
        public bool MaxLapTime1Reached = false;
        public bool MaxLapTime2Reached = false;

        public int swearWordsCount = 0;

        public int drivethroughcount;
        public int NbFastDriveOnPit;

        public long totalPitTime;

        public int showButton = 0;
// Config for the curr player
        public char viewSPBSplit = 'P';
        public bool showSplitPB = true;
        public bool unitSpeedKmh = true;
//Handicap info
        public int H_Mass = 0; // Handicap Mass
        public int H_TRes = 0; // Handicap ntake restriction

// Vote
        public int currVote = (int)InSim.vtn.VOTE_NONE;
        public DateTime expireVote = DateTime.Now;

// Player Box
        public ISMB.msgBox playerBox = new ISMB.msgBox();

// Player Var
        public System.Collections.Hashtable playerVars;


        public infoPlayer(int SUCID, string Susername, string Snickname, string SProduct )
        {
            this.UCID = SUCID;
            this.PLID = -1;
            this.userName = Susername;
            this.nickName = Snickname;

            for (int i = 0; i < (int)lexCfg.paramLapper.maxSplit; i++)
            {
                this.split[i] = 0;
                this.sectorSplit[i] = 0;
                this.sessBestSplitDiff[i] = 0;
                this.PBBestSplitDiff[i] = 0;
                this.bestSectorSplit[i] = 0;
                this.diffSectorSplit[i] = 0;
                this.isBestSectorSplit[i] = false;
            }
            this.sectorSplitLast = 0;
            this.bestSectorSplitLast = 0;
            this.diffSectorSplitLast = 0;
            this.lapTime = 0;
            this.splitLast = 0;
            this.sessBestSplitDiffLast = 0;
            this.PBBestSplitDiffLast = 0;
            this.isBestSectorSplitLast = false;
            this.bestSpeed = (double)0;
            this.CName = "";
            this.bestdriftscore = 0;

            this.PBLTime = 0;

            this.laps = 0;
            this.sessLaps = 0;

            this.showSplitPB = true;

            this.totalPitTime = 0;

        }
        public void privateButtonClose(string argString)
        {

            string[] butToClose = argString.Split('&');
            for (int i = 0; i < butToClose.Length; i++)
            {
                this.playerBox.delete(butToClose[i], this.UCID);
//                Console.WriteLine("Close : " + butToClose[i]);
            }

        }
        public void clearSessionInfo()
        {
            for (int i = 0; i < (int)lexCfg.paramLapper.maxSplit; i++)
            {
                this.sessBestSplitDiff[i] = 0;
            }
            this.sessBestSplitDiffLast = 0;
            this.sessLaps = 0;

        }
        public void UpdateState(double x, double y, double z, double speed, double direction, double heading, double anglevelocity, int minspeed, int minangle, int maxangle, int MinVel, double accelStartSpeed, double accelEndSpeed)
        {

            this.absangle = AbsoluteAngleDifference(this.direction, this.heading);
            double driftscoreinthistick = this.absangle * speed * speed / 10000d;

            if (speed < minspeed)
            {
                this.driftticks = 0;
                this.totaldriftscore = 0;
                this.lastdriftscore = 0;
            }
            else
            {
                if (this.absangle > minangle && this.absangle < maxangle)
                {
                    this.driftticks++;
                    this.lastdriftscore += driftscoreinthistick;
                    this.totaldriftscore += driftscoreinthistick;
                        //System.Console.WriteLine(string.Format("DRIFT: {0} {1} {2} {3} score: {4}", this.UserName, this.NickName, this.UniqueID, this.ConnectionNumber, this.driftscore));
                }
                else
                {
                    this.driftticks = 0;
                }
            }

            this.direction = direction;
            this.heading = heading;
            this.speed = speed;
            this.AngVel = anglevelocity;
            this.x = x;
            this.y = y;

                // anglevelocity
            if (anglevelocity > MinVel)
                this.stuntticks++;
            else
                this.stuntticks = 0;

            // voting
            if ((this.currVote != (int)InSim.vtn.VOTE_NONE) && (this.expireVote < DateTime.Now))
                this.currVote = (int)InSim.vtn.VOTE_NONE;
            // idling

            this.idleticks = speed > 1 ? 0 : this.idleticks + 1;
            if (speed > 1)
                this.OnIdleAction1Sended = false;

            // speed

            if (speed > this.maxLapSpeed)
                this.maxLapSpeed = speed;

            if (speed > this.bestSpeed)
                this.bestSpeed = speed;

            // acceleration

            if ( speed < accelStartSpeed/*0.1*/)
            {
                this.timeSinceZeroSpeed = System.DateTime.Now;
                this.accelerationInProgress = true;
               //System.Console.WriteLine("measurement started");
            }
            else if (speed > accelEndSpeed/*100*/ && this.accelerationInProgress)
            {
                this.accelerationTime = System.DateTime.Now - this.timeSinceZeroSpeed;
                this.accelerationInProgress = false;
                this.accelerationTimeValid = true;
            }
        }
        public void Rename( string newnick )
        {
            this.nickName = newnick;
/*
            if( this.demoPlayer )
                 this.userName = newnick;
*/
        }

        static double AbsoluteAngleDifference(double d, double h)
        {
            double absdiff = Math.Abs(d - h);

            if (absdiff <= 180)
                return absdiff;

            if (d < 180)
            {
                h -= 360;
                return d - h;
            }
            else
            {
                d -= 360;
                return h - d;
            }

        }
        public void updateLapDriftScore( string currentTrackName, string DateFormat, string TimeFormat  )
        {
            if (this.totaldriftscore > this.bestdriftscore)
            {
                this.bestdriftscore = this.totaldriftscore;
//                this.DriftPBDate = System.DateTime.Now.ToShortDateString();
//                this.DriftPBTime = System.DateTime.Now.ToShortTimeString();
                this.DriftPBDate = System.DateTime.Now.ToString(DateFormat);
                this.DriftPBTime = System.DateTime.Now.ToString(TimeFormat);

                this.newBestdriftScore = true;
            }
            else
            {
                this.newBestdriftScore = false;
            }
        }
        public void updateLap(long LTime, long maxLtime, string currentTrackName, string DateFormat, string TimeFormat )
        {
            long sessDiffSplit;
            long sessBestSplit;
            long PBDiffSplit;
            long PBBestSplit;

            this.laps++;
            this.sessLaps++;
            this.currSplit = LTime - this.splitLast;
            this.sectorSplitLast = this.currSplit;
            this.lastSplitTime = LTime;
            this.lapTime = LTime;

            sessDiffSplit = currSplit - this.sessBestSplitDiffLast;
            sessBestSplit = this.sessBestSplitDiffLast;
            if (currSplit < this.sessBestSplitDiffLast || this.sessBestSplitDiffLast == 0)
            {
                this.sessBestSplitDiffLast = currSplit;
                this.newSessBestSplit = true;
            }
            else
            {
                this.newSessBestSplit = false;
            }
            
            PBDiffSplit = currSplit - this.PBBestSplitDiffLast;
            PBBestSplit = this.PBBestSplitDiffLast;
            if (currSplit < this.PBBestSplitDiffLast || this.PBBestSplitDiffLast == 0)
            {
                this.PBBestSplitDiffLast = currSplit;
                this.newPBBestSplit = true;
            }
            else
            {
                this.newPBBestSplit = false;
            }
            this.isBestSectorSplitLast = false;
            switch (this.viewSPBSplit)
            {
                case 'P':
                    this.diffSplit = PBDiffSplit;
                    this.bestSplit = PBBestSplit;
                    if (this.newPBBestSplit)
                        this.isBestSectorSplitLast = true;
                    break;
                case 'S':
                    this.diffSplit = sessDiffSplit;
                    this.bestSplit = sessBestSplit;
                    if (this.newSessBestSplit)
                        this.isBestSectorSplitLast = true;
                    break;
                case 'W':
                    try
                    {
                        wr.wrInfo wi = wr.getWR(currentTrackName, this.CName);
                        this.diffSplit = this.currSplit - wi.sectorSplitLast;
                        this.bestSplit = wi.sectorSplitLast;
                        if (this.newWRBestSplit)
                            this.isBestSectorSplitLast = true;
                    }
                    catch
                    {
                        this.diffSplit = 0;
                        this.bestSplit = 0;
                        Console.WriteLine("WR not found for combo :" + currentTrackName + "/" + this.CName);
                    }
                    break;
            }
            this.bestSectorSplitLast = this.bestSplit;
            this.diffSectorSplitLast = this.diffSplit;
            this.splitLast = 0;

            this.diffLapTimeToPb = LTime - this.PBLTime;
            if (LTime < maxLtime)
            {
                if (LTime < this.PBLTime || this.PBLTime == 0)
                {
                    this.PBLTime = LTime;
                    for (int i = 0; i < (int)lexCfg.paramLapper.maxSplit; i++)
                    {
                        this.PBSplit[i] = this.split[i];
                    }
                    this.PBDate = System.DateTime.Now.ToString(DateFormat);
                    this.PBTime = System.DateTime.Now.ToString(TimeFormat);
//                    this.PBDate = System.DateTime.Now.ToShortDateString();
//                    this.PBTime = System.DateTime.Now.ToShortTimeString();
                    this.isNewPBLtime = true;
                }
                else
                    this.isNewPBLtime = false;
            }
            else
                this.isNewPBLtime = false;

            LastCrossedFinishLine = DateTime.Now;

        }
        public void updateSplit(int Split, long STime, string track )
        {
            long sessDiffSplit;
            long sessBestSplit;
            long PBDiffSplit;
            long PBBestSplit;

            int idxSplit = Split - 1;
// Clear Last Split on first Split
            if (idxSplit == 0)
            {
                this.splitLast = 0;
                for (int i = 0; i < (int)lexCfg.paramLapper.maxSplit; i++)
                {
                    this.split[i] = 0;
                    this.sectorSplit[i] = 0;
                    this.sectorSplitLast = 0;
                }
            }

            this.lastSplitTime = STime;
            this.split[idxSplit] = STime;
            this.currSplit = STime - this.splitLast;
            this.sectorSplit[idxSplit] = this.currSplit;

            sessDiffSplit = this.currSplit - this.sessBestSplitDiff[idxSplit];
            sessBestSplit = this.sessBestSplitDiff[idxSplit];
            if (sessDiffSplit < 0 || this.sessBestSplitDiff[idxSplit] == 0)
            {
                this.sessBestSplitDiff[idxSplit] = this.currSplit;
                this.newSessBestSplit = true;
            }
            else
            {
                this.newSessBestSplit = false;
            }

            PBDiffSplit = this.currSplit - this.PBBestSplitDiff[idxSplit];
            PBBestSplit = this.PBBestSplitDiff[idxSplit];
            if (PBDiffSplit < 0 || this.PBBestSplitDiff[idxSplit] == 0)
            {
                this.PBBestSplitDiff[idxSplit] = this.currSplit;
                this.newPBBestSplit = true;
            }
            else
            {
                this.newPBBestSplit = false;
            }
            this.isBestSectorSplit[idxSplit] = false;
            switch (this.viewSPBSplit)
            {
                case 'P':
                    this.diffSplit = PBDiffSplit;
                    this.bestSplit = PBBestSplit;
                    if (this.newPBBestSplit)
                        this.isBestSectorSplit[idxSplit] = true;
                    break;
                case 'S':
                    this.diffSplit = sessDiffSplit;
                    this.bestSplit = sessBestSplit;
                    if (this.newSessBestSplit)
                        this.isBestSectorSplit[idxSplit] = true;
                    break;
                case 'W':
                    try
                    {
                        wr.wrInfo wi = wr.getWR(track, this.CName);
                        this.diffSplit = this.currSplit - wi.sectorSplit[idxSplit];
                        this.bestSplit = wi.sectorSplit[idxSplit];
                        if (this.newWRBestSplit)
                            this.isBestSectorSplit[idxSplit] = true;
                    }
                    catch
                    {
                        this.diffSplit = 0;
                        this.bestSplit = 0;
                        Console.WriteLine("WR not found for combo :" + track  + "/" + this.CName );
                    }
                    break;
            }
            this.bestSectorSplit[idxSplit] = this.bestSplit;
            this.diffSectorSplit[idxSplit] = this.diffSplit;
            this.splitLast = STime;
        }
        public void updateSaved(LFS.PlayerStats plys)
        {
            if (plys != null)
            {
                this.PBLTime = plys.personalBestLapTime;
                this.PBDate = plys.datePb;
                this.PBTime = plys.timePb;
                this.PBSplit[0] = plys.splitTime[0];
                this.PBSplit[1] = plys.splitTime[1];
                this.PBSplit[2] = plys.splitTime[2];
                this.laps = plys.laps;
                this.PBBestSplitDiff[0] = plys.PBBestSplitDiff[0];
                this.PBBestSplitDiff[1] = plys.PBBestSplitDiff[1];
                this.PBBestSplitDiff[2] = plys.PBBestSplitDiff[2];
                this.PBBestSplitDiffLast = plys.PBBestSplitDiffLast;
            }
            else
            {
                this.PBLTime = 0;
                this.PBDate = "";
                this.PBTime = "";
                this.PBSplit[0] = 0;
                this.PBSplit[1] = 0;
                this.PBSplit[2] = 0;
                this.laps = 0;
                this.sessLaps = 0;
                this.PBBestSplitDiff[0] = 0;
                this.PBBestSplitDiff[1] = 0;
                this.PBBestSplitDiff[2] = 0;
                this.PBBestSplitDiffLast = 0;
            }
        }
        public void updateSavedDrift(LFS.DriftPlayerStats plysDrift)
        {
            if (plysDrift != null)
                this.bestdriftscore = plysDrift.personalBestLap;
        }

        public long TPb
        {
            get {
                long Tpb = 0;
                switch( this.viewSPBSplit ){
                    case 'W':
                    case 'P':
                        for (int i = 0; i < (int)lexCfg.paramLapper.maxSplit; i++)
                            Tpb += this.PBBestSplitDiff[i];
                        Tpb += this.PBBestSplitDiffLast;
                        break;
                    case 'S':
                        for (int i = 0; i < (int)lexCfg.paramLapper.maxSplit; i++)
                            Tpb += this.sessBestSplitDiff[i];
                        Tpb += this.sessBestSplitDiffLast;
                        break;
                }
                return Tpb;
            }
        }
    }

    public class listPlayers
    {
        public Hashtable playersUCID = new Hashtable();
        public Hashtable playersPLID = new Hashtable();

        public void newPlayer(int UCID, string username, string nickname, string Product )
        {
            playersUCID[UCID] = new infoPlayer(UCID,username,nickname, Product );
        }
        public infoPlayer getPlayerByUCID(int UCID)
        {
            if (playersUCID.ContainsKey(UCID))
                return (infoPlayer)playersUCID[UCID];
            else
                return null;
        }
        public infoPlayer getPlayerByPLID(int PLID)
        {
            if (playersPLID.ContainsKey(PLID))
                return (infoPlayer)playersPLID[PLID];
            else
                return null;
        }
        public int countPlayer()
        {
            return playersUCID.Count;
        }
        public void getPlayerByPLID2(infoPlayer currInfoPlayer, int PLID)
        {
            if (playersPLID.ContainsKey(PLID))
            {
                currInfoPlayer = (infoPlayer)playersPLID[PLID];
            }
        }
        public void removePlayer(int UCID)
        {
            if ((playersUCID[UCID] as infoPlayer).PLID != -1)
                playersPLID.Remove((playersUCID[UCID] as infoPlayer).PLID);
            playersUCID.Remove(UCID);
        }
        public void removeIndexPLID(int PLID)
        {
            (playersPLID[PLID] as infoPlayer).PLID = -1;
            playersPLID.Remove(PLID);
        }

        public void majIndexPLID(int UCID, int PLID )
        {
            playersPLID[PLID] = playersUCID[UCID];
            (playersUCID[UCID] as infoPlayer).PLID = PLID;
        }
        public void changeTrack(string newTrack, LFS.Db lfsDb, LFS.DriftDb lfsDriftDb)
        {
// Retrouver les infos de tous les joueurs
            foreach (DictionaryEntry de in playersUCID)
            {
                infoPlayer currInfoPlayer = (infoPlayer)de.Value;
//                Console.WriteLine("Retreive : " + currInfoPlayer.userName + " Car : " + currInfoPlayer.CName + " Track : " + newTrack);
                currInfoPlayer.clearSessionInfo();
                LFS.PlayerStats plys = lfsDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, newTrack);
                currInfoPlayer.updateSaved(plys);
                LFS.DriftPlayerStats nplplysDrift = lfsDriftDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, newTrack);
                currInfoPlayer.updateSavedDrift(nplplysDrift);
            }
        }

        public void loopButton()
        {
            // Retrouver les infos de tous les joueurs
            foreach (DictionaryEntry de in playersUCID)
            {
                infoPlayer currInfoPlayer = (infoPlayer)de.Value;
                currInfoPlayer.playerBox.loopButton(currInfoPlayer.UCID);
            }
        }
        public void globalButtonMessage(string id, int UCID, int P_L, int P_T, int P_W, int P_H, int interligne, int secVisible, int P_TypeIn, int P_BSTyle, string P_caption, string P_buttonText, string P_onClick)
        {
            foreach (DictionaryEntry de in playersUCID)
            {
                infoPlayer currInfoPlayer = (infoPlayer)de.Value;
                currInfoPlayer.playerBox.create( id,
                                                UCID,
                                                P_L,
                                                P_T,
                                                P_W,
                                                P_H,
                                                interligne,
                                                secVisible,
                                                P_TypeIn,
                                                P_BSTyle,
                                                P_caption,
                                                P_buttonText,
                                                P_onClick);
                currInfoPlayer.playerBox.show( id,currInfoPlayer.UCID );
            }
        }

        public void globalButtonClose(string argString)
        {
            // Retrouver les infos de tous les joueurs
            foreach (DictionaryEntry de in playersUCID)
            {
                infoPlayer currInfoPlayer = (infoPlayer)de.Value;
                currInfoPlayer.privateButtonClose(argString);
            }
        }
        public void raceRestart() // Race or Qualify restart
        {
            foreach (DictionaryEntry de in playersUCID)
            {
                infoPlayer currInfoPlayer =  (infoPlayer)de.Value;
                (currInfoPlayer as infoPlayer).idleticks = 0;
                (currInfoPlayer as infoPlayer).totalPitTime = 0;
                (currInfoPlayer as infoPlayer).splitLast = 0;
                (currInfoPlayer as infoPlayer).LastCrossedFinishLine = DateTime.Now;
                (currInfoPlayer as infoPlayer).MaxLapTime1Reached = false;
                (currInfoPlayer as infoPlayer).MaxLapTime2Reached = false;
                (currInfoPlayer as infoPlayer).OnPit = false;
                (currInfoPlayer as infoPlayer).NbFastDriveOnPit = 0;
                (currInfoPlayer as infoPlayer).currVote = (int)InSim.vtn.VOTE_NONE;
            }
        }
        public int nbPlayerOnTrack  // Return votation for players
        {
            get
            {
                int IT = 0;
                foreach (DictionaryEntry de in playersUCID)
                {
                    infoPlayer currInfoPlayer = (infoPlayer)de.Value;
                    if ( currInfoPlayer.OnTrack )
                        IT++;
                }
                return IT;
            }
        }
        public void voteClear()
        {
            foreach (DictionaryEntry de in playersUCID)
            {
                infoPlayer currInfoPlayer = (infoPlayer)de.Value;
                currInfoPlayer.currVote = (int)InSim.vtn.VOTE_NONE;
            }
        }
        public int voteRestart  // Return votation for players
        {
            get
            {
                int VR = 0;
                foreach (DictionaryEntry de in playersUCID)
                {
                    infoPlayer currInfoPlayer = (infoPlayer)de.Value;
                    if (currInfoPlayer.currVote == (int)InSim.vtn.VOTE_RESTART)
                        VR++;
                }
                return VR;
            }
        }
        public int voteQualify  // Return votation for players
        {
            get
            {
                int VQ = 0;
                foreach (DictionaryEntry de in playersUCID)
                {
                    infoPlayer currInfoPlayer = (infoPlayer)de.Value;
                    if (currInfoPlayer.currVote == (int)InSim.vtn.VOTE_QUALIFY )
                        VQ++;
                }
                return VQ;
            }
        }
        public int voteEnd  // Return votation for players
        {
            get
            {
                int VE = 0;
                foreach (DictionaryEntry de in playersUCID)
                {
                    infoPlayer currInfoPlayer = (infoPlayer)de.Value;
                    if (currInfoPlayer.currVote == (int)InSim.vtn.VOTE_END )
                        VE++;
                }
                return VE;
            }
        }
        public static double Distance(double x1, double y1, double x2, double y2)
        {
            return Math.Sqrt(Math.Pow((x1-x2),2) + Math.Pow((y1-y2),2));
        }

    }
}
