/*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.IO;
using System.Diagnostics;
using System.Threading;
using System.Reflection;
using System.Text.RegularExpressions;



namespace LFSLapper
{
    class LFSLapper
    {
        #region Main

        /// <summary>
        /// References GNU GPL License
        /// </summary>
        public static string getShortVersion(int level)
        {
            string[] FullNameSplit = System.Reflection.Assembly.GetExecutingAssembly().FullName.Split(',');
            string[] version = FullNameSplit[1].Trim().Split('=');
            string[] id = version[1].Split('.');
            string retVal = id[0];
            for (int i = 1; i < level; i++)
                retVal += "." + id[i];
            return retVal;
        }

        static void PrintLicense()
        {
            Console.WriteLine("LFSLapper Version=" + getShortVersion(4) + " on GNU license");
            Console.WriteLine("2005-2008 Janez Cufer and Robert BRACCAGNI ( Gai-Luron )");
            Console.WriteLine("LFSLapper comes with ABSOLUTELY NO WARRANTY");
            Console.WriteLine("This is free software, and you are welcome to redistribute it");
            Console.WriteLine("under certain conditions. Read LICENSE for details.");
            Console.WriteLine("Type LFSLapper -help to view usage");
            Console.WriteLine("Started : " + DateTime.Now.ToString());
            Console.WriteLine();
//            Console.WriteLine(DateTime.Now.ToString("hh:mm"));
//            Console.WriteLine(DateTime.Now.ToString("dd/MM/yyyy"));
        }

        /// <summary>
        /// Prints command line usage with license.
        /// </summary>
        static void PrintUsage()
        {
            Console.WriteLine("Usage: LFSLapper.exe scriptfilename [-debug] [-dumpvar]\n");
            Console.WriteLine("-dumpvar Lapper show all variable availlable in cfg file\n");
            Console.WriteLine("-debug Put LFSLapper in debug mode\n");
            Console.WriteLine("-help Show this message\n");
            Console.WriteLine("Report bugs and suggestions http://www.lfsforum.net/showthread.php?t=25756\n");
        }

        static void Main(string[] Args)
        {
            try
            {

/*
                //                lexCfg.Parseur toto = new lexCfg.Parseur("\"\\\"toto\" . 6+2*6 + \"2\" . \" finale\"");
                //                lexCfg.Parseur toto = new lexCfg.Parseur("12 == (2*4)+4");
                //                lexCfg.Parseur toto = new lexCfg.Parseur("12+12+12 >= 12*(2+1)");
                //                lexCfg.Parseur toto = new lexCfg.Parseur("\"a\" >= \"a\"");
                //                lexCfg.Parseur toto = new lexCfg.Parseur("1==2");
                //                lexCfg.Parseur toto = new lexCfg.Parseur("\"0.10.10\" + \"0.01.20\"");
                //                lexCfg.Parseur toto = new lexCfg.Parseur("\"toto\" == \"toto\" && 1 > 3");
                //                lexCfg.Parseur toto = new lexCfg.Parseur("1++2-");
                //                lexCfg.Parseur toto = new lexCfg.Parseur("\"-1.10.10\" <= \"0.01.20\"");
                                lexCfg.Parseur toto = new lexCfg.Parseur("\"-1.10.10\" - 100 ");
                Console.WriteLine(toto.ToRPN());
                Console.WriteLine((toto.getval() as lexCfg.unionVal).typVal);
                Console.WriteLine((toto.getval() as lexCfg.unionVal).fval);
                Console.WriteLine((toto.getval() as lexCfg.unionVal).sval);
                Console.ReadKey();
                Environment.Exit(0);
*/
                
                
                PrintLicense();

                if (Args.Length > 2)
                {
                    PrintUsage();
                    return;
                }
                bool debugmode = false;
                bool dumpVar = false;
                bool usage = false;
                string fileCfg = "";
                for (int i = 0; i < Args.Length; i++ )
                {
                    switch (Args[i].ToUpper())
                    {
                        case "-DEBUG":
                            debugmode = true;
                            break;
                        case "-DUMPVAR":
                            dumpVar = true;
                            break;
                        case "-HELP":
                            usage = true;
                            break;
                        default:
                            fileCfg = Args[i];
                            break;

                    }
                }
                if( fileCfg == "" )
                    fileCfg = "LFSLapper.lpr";
                if (dumpVar)
                {
                    lexCfg.lexConfigurator cfg = new lexCfg.lexConfigurator();
                    cfg.load(fileCfg);
                    cfg.dumpFunctions();
                    cfg.dumpMsgActionsLapper();
                    cfg.dumpTask();
                    cfg.dumpVar();
                    cfg.dumpVarsGlobal();
                    System.Threading.Thread.Sleep(10000);
                }
                else if (usage)
                {
                    PrintUsage();
                    System.Threading.Thread.Sleep(10000);
                }
                else
                {
                    LFSClient lfsclient = new LFSClient(fileCfg, debugmode);
                }
            }
            catch (Exception ex)
            {
//                System.Console.WriteLine(ex.Message);
                Console.WriteLine("The following error occurred:");
                Console.WriteLine(ex.Message);   // Print the error message.
                Console.WriteLine(ex.Source);    // Name of application or object that caused the error.
                Console.WriteLine(ex.StackTrace); //String that contains the stack trace for this exception.
                Console.WriteLine(ex.TargetSite ); //String that contains the stack trace for this exception.
                Console.WriteLine("");
                System.Threading.Thread.Sleep(50000);
            }
            Console.WriteLine("ICI");
            return;
        }

        #endregion
    }


}
