/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
namespace LFSLapper
{
    partial class LFSClient
    {
        void ScheduleTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            try
            {
                for (int i = 0; i < Tasks.Count; i++)
                {
                    Task task = (Task)Tasks[i];
                    if (task.IsToExecuteNow())
                    {
//                        Console.WriteLine("Execution de : " + task.Command);
                        executeFunction(task.Command,null);
                        if (task.IsOnceToExecuteOnly)
                            Tasks.RemoveAt(i--);
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
            }
        }

        void RestartTimer()
        {
            timer.Stop();
            timer.Interval = newCfg.varsLapper.MessageTime;
            timer.Start();
        }

        void timer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            SendMsg(-1, "/rcc_all");
        }
    }
}
