/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.IO;
using System.Threading;
using LapperThreads;
namespace LFSLapper
{
    partial class LFSClient
    {



        enum btnID
        {
            NOT_USED,
            LIBEL_SPB,
            BUT_SESS,
            BUT_PB,
            BUT_WR,
            LIBEL_SHOW_SPB,
            BUT_SHOW,
            BUT_HIDE,
            LIBEL_SPEED_UNIT,
            BUT_KMH,
            BUT_MPH,
        };

        public class posQualUser
        {
            public string userName;
            public string nickName;
            public int posUser;
            public int totalUser;
            public int groupUser;

            public posQualUser(string userName, string nickName,int pos, int total, int group)
            {
                this.userName = userName;
                this.nickName = nickName;
                this.posUser = pos;
                this.totalUser = total;
                this.groupUser = group;
            }
        }
        public class infoHandicap
        {
            public int H_Mass = 0;
            public int H_TRes = 0;
            public infoHandicap(int H_Mass, int H_TRes)
            {
                this.H_Mass = H_Mass;
                this.H_TRes = H_TRes;
            }
        }
        public class raceInfo
        {
            public bool inRace = false;
            public int lapsDone = 0;
            public DateTime nextRestart;
            public int racesDone = 0;
            public int currRotateTrack = 0;
            public int currRotateCar = 0;
        }
        raceInfo currRace = new raceInfo();
        InSim.Connect insimConnection;
        Mutex myMutex = new Mutex(false);
        LFS.Db lfsDb;
        LFS.DriftDb lfsDriftDb;
        cfguser cfu = new cfguser();
        clSyncUploadDownload threadSyncDownload;
        WebCmds objWebCmd;
        registerWeb objregisterWeb;
        trackCarData trackInfo;
        System.Collections.Hashtable playerFilter = new System.Collections.Hashtable();
        System.Collections.Hashtable playerAlwaysAuth = new System.Collections.Hashtable();

        string barGraphChar = InSim.CodePage.chr('L', 145);
    

        bool wrLoaded = false;
        bool TermProg = false;


        lexCfg.lexConfigurator newCfg;

        #region swearwords
        swearwords swearWordObj;
        #endregion


        #region handicap options
        System.Collections.Hashtable carTrackHandicap = new System.Collections.Hashtable();
        System.Collections.Hashtable carHandicap = new System.Collections.Hashtable();
        System.Collections.Hashtable playerHandicap = new System.Collections.Hashtable();
        #endregion


        #region Sync Options
        bool modeSync = false;
        string[] SyncIDsToSync;
        #endregion


        int InRaceLapsVoteMin = 0;
        int InRaceLapsVoteMax = 9999;

 



        #region Qualification Option
        int MaxGroupQual = 0;
        int MaxUserGroupQual = 0;
        int MinUserGroupQual = 0;
        #endregion

        #region Authorisation Options
        String[] Auth = new string[10];
        bool[] AuthAllowPlayer = new bool[10];
        bool AllowAllPlayer = true;
        bool AuthOn = true;
        #endregion

        #region flags players allowed
        string[] FlagsPlayerAllow = new string[14];
        #endregion


        System.Collections.ArrayList shortCarNames = new System.Collections.ArrayList();
        System.Collections.ArrayList longCarNames = new System.Collections.ArrayList();
        bool debugmode = false;
        string currentTrackName = "";
        string currentHName = "";

        System.Timers.Timer timer;
        System.Timers.Timer ScheduleTimer;

        System.Collections.ArrayList Tasks;

        listPlayers listOfPlayers = new listPlayers();





        public void inputHandler(ConsoleCtrl.ConsoleEvent consoleEvent)
        {
            if (consoleEvent == ConsoleCtrl.ConsoleEvent.CtrlC
                || consoleEvent == ConsoleCtrl.ConsoleEvent.CtrlClose
                || consoleEvent == ConsoleCtrl.ConsoleEvent.CtrlBreak
                || consoleEvent == ConsoleCtrl.ConsoleEvent.CtrlLogoff
                || consoleEvent == ConsoleCtrl.ConsoleEvent.CtrlShutdown)
            {
                byte[] cl = InSim.Encoder.IS_TINY((byte)InSim.TypePack.ISP_TINY, 0, (byte)InSim.TypeTiny.TINY_CLOSE);
                insimConnection.Send(cl, cl.Length);
                System.Environment.Exit(-1);
            }
        }
        public LFSClient(string scriptfilename,  bool debugmode)
        {
            this.debugmode = debugmode;
            this.lfsDb = new LFS.Db(myMutex);
            this.lfsDriftDb = new LFS.DriftDb(myMutex);

            // Here to intercept keys Ctrl
            try
            {
                ConsoleCtrl cc = new ConsoleCtrl();
                cc.ControlEvent += new ConsoleCtrl.ControlEventHandler(inputHandler);
            }
            catch { Console.WriteLine("Intercept don't work"); }

            #region Car Names Tables
            shortCarNames.Add("TBO"); longCarNames.Add("TURBO");
            shortCarNames.Add("LRF"); longCarNames.Add("LRF");
            shortCarNames.Add("GTR"); longCarNames.Add("GTR");
            shortCarNames.Add("UF1"); longCarNames.Add("UF 1000");
            shortCarNames.Add("XFG"); longCarNames.Add("XF GTI");
            shortCarNames.Add("XRG"); longCarNames.Add("XR GT");
            shortCarNames.Add("XRT"); longCarNames.Add("XR GT TURBO");
            shortCarNames.Add("RB4"); longCarNames.Add("RB4 GT");
            shortCarNames.Add("FXO"); longCarNames.Add("FXO TURBO");
            shortCarNames.Add("LX4"); longCarNames.Add("LX4");
            shortCarNames.Add("LX6"); longCarNames.Add("LX6");
            shortCarNames.Add("RAC"); longCarNames.Add("RA");
            shortCarNames.Add("FZ5"); longCarNames.Add("FZ50");
            shortCarNames.Add("MRT"); longCarNames.Add("MRT5");
            shortCarNames.Add("XFR"); longCarNames.Add("XF GTR");
            shortCarNames.Add("UFR"); longCarNames.Add("UF GTR");
            shortCarNames.Add("FOX"); longCarNames.Add("FORMULA XR");
            shortCarNames.Add("FO8"); longCarNames.Add("FORMULA V8");
            shortCarNames.Add("FXR"); longCarNames.Add("FXO GTR");
            shortCarNames.Add("XRR"); longCarNames.Add("XR GTR");
            shortCarNames.Add("FZR"); longCarNames.Add("FZ50 GTR");
            shortCarNames.Add("BF1"); longCarNames.Add("BMW SAUBER");
            shortCarNames.Add("FBM"); longCarNames.Add("BMW FB02");
            #endregion

            #region Configuring LFSLapper

            newCfg = new lexCfg.lexConfigurator();

            cfu.load();
            if (!newCfg.load(scriptfilename))
            {
                Console.WriteLine("Programm ended!");
                System.Threading.Thread.Sleep(10000);
                Environment.Exit(0);
            }
            Console.WriteLine( "Ok" );
            //lexCfg.dumpVarsGlobal();
            //lexCfg.dumpVar();
            /*
                        lexCfg.dumpFunctions();
                        lexCfg.dumpMsgActionsLapper();
                        lexCfg.dumpTask();
            */


            #region PubStat et wr get cfg
            Console.Write("Loading WR...");
            if (wr.load("", "", newCfg.varsLapper.PubStatIdk))
            {
                wrLoaded = true;
                Console.WriteLine("Ok");
            }
            else
            {
                wrLoaded = false;
                Console.WriteLine("Not Loaded");
            }
            #endregion

            #region track info cfg
            trackInfo = new trackCarData(newCfg.varsLapper.TrackInfoFile);
            #endregion



            #region swearwords action get cfg
            swearWordObj = new swearwords();
            Console.Write("Loading swearwords...");
            if (swearWordObj.load(newCfg.varsLapper.SwearWordsList) == false)
                Console.WriteLine("Not Loaded");
            else
                Console.WriteLine("Ok");
            #endregion

            #region Set Sync Config
            SyncIDsToSync = newCfg.varsLapper.SyncIDsToSync.Split('|');
            if (SyncIDsToSync[0] != "" && newCfg.varsLapper.SyncID == "" && newCfg.varsLapper.SyncDir == "")
            {
                throw new System.Exception("Sync Config Error\n");
            }
            if (newCfg.varsLapper.SyncDir != "" && newCfg.varsLapper.SyncID != "" && SyncIDsToSync[0] != "")
                modeSync = true;
            Console.WriteLine("Mode Sync = " + modeSync.ToString());

            // Create my Directory
            if (modeSync)
            {
                string path;
                path = newCfg.varsLapper.SyncDir + "/" + newCfg.varsLapper.SyncID;
                if (!Directory.Exists(path))
                {
                    Directory.CreateDirectory(path);
                }
                // Create all other Sync Directory
                for (int i = 0; i < SyncIDsToSync.Length; i++)
                {
                    if (SyncIDsToSync[i] == newCfg.varsLapper.SyncID)
                        throw new System.Exception("Sync Config Error, You can't synchronize yourself\n");
                    if (SyncIDsToSync[i] != "")
                    {
                        path = newCfg.varsLapper.SyncDir + "/" + SyncIDsToSync[i];
                        if (!Directory.Exists(path))
                        {
                            Directory.CreateDirectory(path);
                        }

                    }
                }
            }
            #endregion

            #region Authorisation option
            if (newCfg.varsLapper.AuthAllowPlayer == "" || newCfg.varsLapper.AuthAllowPlayer.ToLower() == "all")
            {
                AllowAllPlayer = true;
                for( int i = 0; i < 10; i++ )
                    Auth[i] = "";
            }
            else
            {
                AllowAllPlayer = false;
                Auth[0] = newCfg.varsLapper.Auth1;
                Auth[1] = newCfg.varsLapper.Auth2;
                Auth[2] = newCfg.varsLapper.Auth3;
                Auth[3] = newCfg.varsLapper.Auth4;
                Auth[4] = newCfg.varsLapper.Auth5;
                Auth[5] = newCfg.varsLapper.Auth6;
                Auth[6] = newCfg.varsLapper.Auth7;
                Auth[7] = newCfg.varsLapper.Auth8;
                Auth[8] = newCfg.varsLapper.Auth9;
                Auth[9] = newCfg.varsLapper.Auth10;
                for (int i = 0; i < 9; i++)
                    AuthAllowPlayer[i] = false;
                string[] tmpAuthAllowPlayer = newCfg.varsLapper.AuthAllowPlayer.Split('|');
                for (int i = 0; i < tmpAuthAllowPlayer.Length; i++)
                {
                    if (tmpAuthAllowPlayer[i].IndexOf("@") == 0) // Players Always Allowed
                    {
                        string tmp = tmpAuthAllowPlayer[i].Substring(1);
                        string[] allPlayer = tmp.Split(',');
                        for (int j = 0; j < allPlayer.Length; j++)
                            playerAlwaysAuth[allPlayer[j].ToLower()] = true;
                    }
                    else
                    {
                        int idx = int.Parse(tmpAuthAllowPlayer[i].Substring(4));
                        AuthAllowPlayer[idx - 1] = true;
                    }
                }
            }

            #endregion


            #region Rotations et autorestart options

            if (newCfg.varsLapper.AutoRestartRaceMn > 0)
                currRace.nextRestart = DateTime.Now.AddMinutes(newCfg.varsLapper.AutoRestartRaceMn);
            if (newCfg.varsLapper.AutoRestartRaceMn == 0)
                newCfg.varsLapper.EnableRotation = false;
/*
            if (newCfg.varsLapper.RotateCars != "" && newCfg.varsLapper.RotateCars.Split(',').Length != newCfg.varsLapper.RotateTracks.Split(',').Length)
            {
                newCfg.varsLapper.EnableRotation = false;
                Console.WriteLine("Nb of Tracks not matches Nb of Car in rotation parameter, rotation disabled!");
            }
*/

            if (newCfg.varsLapper.InRaceLapsVoteMinMax == "")
                newCfg.varsLapper.InRaceLapsVoteMinMax = "-";
            {
                string[] tmpSplit = newCfg.varsLapper.InRaceLapsVoteMinMax.Split('-');
                try
                {
                    if (tmpSplit[0] == "")
                        tmpSplit[0] = "0";
                    InRaceLapsVoteMin = int.Parse(tmpSplit[0]);
                    if (tmpSplit[1] == "")
                        tmpSplit[1] = "99999999";
                    InRaceLapsVoteMax = int.Parse(tmpSplit[1]);

                }
                catch
                {
                    Console.WriteLine("Error on cfg : InRaceLapsVoteMinMax = " + newCfg.varsLapper.InRaceLapsVoteMinMax);
                    InRaceLapsVoteMin = 0;
                    InRaceLapsVoteMax = 9999999;
                }
            }
            #endregion



            #region help flags
            {
                string tmpStr;
                int i = 0;
                tmpStr = newCfg.varsLapper.SwapSide;
                if (tmpStr == "") 
                    tmpStr = "*";
                FlagsPlayerAllow[i++] = tmpStr;    
                
                FlagsPlayerAllow[i++] = "*";    // RESERVED_2
                
                FlagsPlayerAllow[i++] = "*";    // RESERVED_4

                tmpStr = newCfg.varsLapper.AutoGears;
                if (tmpStr == "") 
                    tmpStr = "*";
                FlagsPlayerAllow[i++] = tmpStr;

                tmpStr = newCfg.varsLapper.Shifter;
                if (tmpStr == "") 
                    tmpStr = "*";
                FlagsPlayerAllow[i++] = tmpStr;    
                
                FlagsPlayerAllow[i++] = "*";    // RESERVED_32

                tmpStr = newCfg.varsLapper.HelpBrake;
                if (tmpStr == "")
                    tmpStr = "*";
                FlagsPlayerAllow[i++] = tmpStr;

                tmpStr = newCfg.varsLapper.AxisClutch;
                if (tmpStr == "")
                    tmpStr = "*";
                FlagsPlayerAllow[i++] = tmpStr;

                FlagsPlayerAllow[i++] = "*";    // INPITS

                tmpStr = newCfg.varsLapper.AutoClutch;
                if (tmpStr == "")
                    tmpStr = "*";
                FlagsPlayerAllow[i++] = tmpStr;

                tmpStr = newCfg.varsLapper.Mouse;
                if (tmpStr == "")
                    tmpStr = "*";
                FlagsPlayerAllow[i++] = tmpStr;

                tmpStr = newCfg.varsLapper.KbNoHelp;
                if (tmpStr == "")
                    tmpStr = "*";
                FlagsPlayerAllow[i++] = tmpStr;

                tmpStr = newCfg.varsLapper.KbStabilised;
                if (tmpStr == "")
                    tmpStr = "*";
                FlagsPlayerAllow[i++] = tmpStr;

                tmpStr = newCfg.varsLapper.CustomView;
                if (tmpStr == "")
                    tmpStr = "*";
                FlagsPlayerAllow[i++] = tmpStr;
            }

            #endregion




            #region Qualification
            UpdateQualUsers(newCfg.varsLapper.QualUsers);
            #endregion

            #region Handicap
            UpdateHandicapUsers(newCfg.varsLapper.HandicapUsers);
            UpdateHandicapCars(newCfg.varsLapper.HandicapCars);
            UpdateHandicapCarsTracks(newCfg.varsLapper.HandicapCarsTracks);
            #endregion




            timer = new System.Timers.Timer(10000);
            timer.AutoReset = false;
            timer.Elapsed += new System.Timers.ElapsedEventHandler(timer_Elapsed);


            #region load scheduled tasks

            Tasks = newCfg.Tasks;
            {
                ScheduleTimer = new System.Timers.Timer(1000);
                ScheduleTimer.AutoReset = true;
                ScheduleTimer.Elapsed += new System.Timers.ElapsedEventHandler(ScheduleTimer_Elapsed);
            }

            #endregion


            #endregion

            insimConnection = new InSim.Connect();
            ISMB.msgBox.initMsgBox(insimConnection);

            insimConnection.insimConnect(newCfg.varsLapper.Host, newCfg.varsLapper.Port, newCfg.varsLapper.Password, "U", "LFSLapper", false, newCfg.varsLapper.TCPmode);
            string info = "Product:" + insimConnection.Product + " Version:" + insimConnection.Version + " InSim Version:" + insimConnection.InSimVersion;
            Console.WriteLine(info);
            if (!lfsDb.Load(newCfg.varsLapper.Database, newCfg.varsLapper.FtpServer, newCfg.varsLapper.FtpLogin, newCfg.varsLapper.FtpPasswd, newCfg.varsLapper.FtpRemotePath, modeSync, newCfg.varsLapper.SyncID, newCfg.varsLapper.SyncDir, SyncIDsToSync))
                System.Console.WriteLine("Warning:Error loading {0} or file does not exist yet!", newCfg.varsLapper.Database);

            if (!lfsDriftDb.Load(newCfg.varsLapper.DriftDatabase, newCfg.varsLapper.FtpServer, newCfg.varsLapper.FtpLogin, newCfg.varsLapper.FtpPasswd, newCfg.varsLapper.FtpRemotePath))
                System.Console.WriteLine("Warning:Error loading {0} or file does not exist yet!", newCfg.varsLapper.DriftDatabase);

            ScheduleTimer.Enabled = true;

            byte[] intervalReq = InSim.Encoder.NLI(100);    //receive status every 100 ms
            insimConnection.Send(intervalReq, intervalReq.Length);

            // Start Thread for Sync Download
            if (modeSync)
            {
                threadSyncDownload = new clSyncUploadDownload(newCfg.varsLapper.SyncID, newCfg.varsLapper.SyncDir, SyncIDsToSync);
                Thread syncDownload = new Thread(new ThreadStart(threadSyncDownload.GetInfoToSync));
                syncDownload.Start();
            }

            // Start Thread for cmd via Web
            objWebCmd = new WebCmds();
            Thread TwebCmd = new Thread( new ThreadStart( objWebCmd.TWebCmds ));
            TwebCmd.Start();

            // Start Thread for Register Web
            if (newCfg.varsLapper.EnableRegisterWeb)
            {
                objregisterWeb = new registerWeb();
                Thread TRegisterWeb = new Thread(new ThreadStart(objregisterWeb.RegisterLoop));
                TRegisterWeb.Start();
            }
            System.Threading.Thread.Sleep(1000);
            Console.WriteLine("LFSLapper is running...");
            byte[] sstreq = InSim.Encoder.SST();
            insimConnection.Send(sstreq, sstreq.Length);

            // Main loop
            Loop(insimConnection);


            // terminate
            byte[] terreq = InSim.Encoder.ISC();
            insimConnection.Send(terreq, terreq.Length);
            insimConnection.Close();
            Console.WriteLine("Programm ended by user");
            System.Threading.Thread.Sleep(2000);
            Environment.Exit(0);
        }
    }
}




