<?xml version="1.0" encoding="iso-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<!-- Simple stage rally result stylesheet v.1.0 by: Aquilifer -->

<xsl:output method =  "html"/>

	<xsl:template match="/">
		<!-- <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"/> -->
		<html>
			<head>
				<title>
					Stage Rally results at
					<xsl:value-of select="stagerally/server/name"/>
				</title>
			</head>

			<body bgcolor="#000000" text="#ffffff" background="../pics/bg_race.jpg">
				<font face="Verdana, Geneva, Arial, Helvetica, sans-serif" size="3" color="#fffff">
					<br/>
					<br/>
					<!--  <h1 align='center'>Stage Rally results</h1> -->

					<table align="center">
						<tr>
						<td>
						<img src="../pics/title_race.gif" alt="Race results" halign="center"/>
						</td>
						</tr>
					</table>

					<br/>
					<xsl:apply-templates select="stagerally">
						<!-- <xsl:sort select="entry/endtime" order = "ascending" /> -->
					</xsl:apply-templates>

					<font size="2"><p align="center">Generated by VCom</p></font>

				</font>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="server">
		<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0" bgcolor="#555555">
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Server: </b></td>
				<!-- <td><xsl:value-of select="name"/></td> -->
				<td>
					<xsl:apply-templates select="name"/>
				</td>
				<td></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Time: </b></td>
				<td><xsl:value-of select="../time"/></td>
				<td></td>
			</tr>

			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>

		</table>
		<p></p>
	</xsl:template>

	
	<xsl:template match="stagerally">
	
		<xsl:apply-templates select="comment"/>
		<br/>
	
		<xsl:apply-templates select="server"/>
		<br/>

		<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td halign="left" colspan="4">Total times</td>
				<td height="12"></td>
			</tr>
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td></td> <!-- pos -->
				<td></td> <!-- driver -->
				<td></td> <!-- car -->
				<td></td> <!-- car pic --> 
				<td></td> <!-- end time -->
				<xsl:for-each select="stages/stage">
					<td></td>
				</xsl:for-each>
				<td width="12" height="12"></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Pos.</b></td>
				<td><b>Driver</b></td>
				<td><b>Car</b></td>
				<td></td> <!-- car picture -->
				<td><b>End time</b></td>
				<xsl:apply-templates select="stages/stage"/>
				<td></td>
			</tr>
			<xsl:apply-templates select="end_results/racer"/>
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td></td> <!-- pos -->
				<td></td> <!-- driver -->
				<td></td> <!-- car -->
				<td></td> <!-- car pic --> 
				<td></td> <!-- end time -->
				<xsl:for-each select="stages/stage">
					<td></td>
				</xsl:for-each>				
				<td width="12" height="12"></td>
			</tr>
		</table>

		<br/><br/>
		
		<xsl:for-each select="stage_results">
			<table width="75%" border="0" align="center" cellspacing="0" cellpadding="0">
				<tr bgcolor="#555555">
					<td width="12" height="12"></td>
					<td halign="left" colspan="4">Special Stage <xsl:value-of select="@stage"/></td>
					<td height="12"></td>
				</tr>
				<tr bgcolor="#555555">
					<td width="12" height="12"></td>
					<td></td> <!-- pos -->
					<td></td> <!-- driver -->
					<td></td> <!-- car -->
					<td></td> <!-- car pic --> 
					<td></td> <!-- stage time -->
					<td></td> <!-- diff time -->
					<td width="12" height="12"></td>
				</tr>
				<tr bgcolor="#555555">
					<td></td>
					<td><b>Pos.</b></td>
					<td><b>Driver</b></td>
					<td><b>Car</b></td>
					<td></td> <!-- car picture -->
					<td><b>Stage time</b></td>
					<td><b>Difference</b></td>
					<td></td>
				</tr>
				<xsl:apply-templates select="entry"/>
				<tr bgcolor="#555555">
					<td width="12" height="12"></td>
					<td></td> <!-- pos -->
					<td></td> <!-- driver -->
					<td></td> <!-- car -->
					<td></td> <!-- car pic --> 
					<td></td> <!-- stage time -->
					<td></td> <!-- diff time -->
					<td width="12" height="12"></td>
				</tr>
			</table>
			<br/>
		</xsl:for-each>
		
		<br/>
		<br/>
		<br/>
	</xsl:template>
	
	<xsl:template match="comment">
		<xsl:if test="string-length(.) > 0">
			<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
				<tr bgcolor="#555555">
					<td width="12" height="12"></td>
					<td></td>
					<td width="12" height="12"></td>
				</tr>
				<tr bgcolor="#555555">
					<td></td>
					<td><xsl:value-of select="."/></td>
					<td></td>
				</tr>
				<tr bgcolor="#555555">
					<td width="12" height="12"></td>
					<td></td>
					<td width="12" height="12"></td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="racer">
		<tr bgcolor="#555555">
			<td></td>
			<td>
				<xsl:if test="not(@dqf)">
					<p valign="center"><xsl:value-of select="position()"/></p>
				</xsl:if>
				<xsl:if test="@dqf">
					<p valign="center">DQF<br/>
					<font size="1">(<xsl:value-of select="@dqf"/>)</font></p>
				</xsl:if>
			</td>
			<td>
				<xsl:apply-templates select="pname"/>
				<xsl:if test="uname">
					<br/>
					<font size="2">(<xsl:value-of select="uname"/>)</font>
				</xsl:if>
			</td>
			<td>
				<p valign="center"><xsl:value-of select="car"/></p>
			</td>
			<td>
				<img border="0" width="128" height="64" align="center">
					<!-- <xsl:attribute name="src">../pics/s_<xsl:value-of select="car"/>.jpg</xsl:attribute> -->
					<xsl:attribute name="src">../pics/nocar.png</xsl:attribute>
					<xsl:if test="string-length(car) > 0">
						<xsl:attribute name="src">../pics/<xsl:value-of select="car"/>.jpg</xsl:attribute>
					</xsl:if>
					<xsl:attribute name="alt"><xsl:value-of select="car"/></xsl:attribute>
				</img>
			</td>
			<td>
					<p avalign="center">
						<xsl:value-of select="totaltime"/>
						<xsl:if test="time_diff">
							<font size="1">
								<br/>
								(+<xsl:value-of select="time_diff"/>)
							</font>
						</xsl:if>
						<xsl:if test="@timepenalty">
							<font size="1">
								<br/>
								(+<xsl:value-of select="@timepenalty"/> sec penalty)
							</font>					
						</xsl:if>
						<xsl:if test="average_speed">
							<font size="1">
								<br/>
								(<xsl:value-of select="average_speed"/> km/h)
								<br/>
								(<xsl:value-of select="round(average_speed *1000 div 1.609344) div 1000"/> mi/h)
							</font>
						</xsl:if>
					</p>
			</td>
			<xsl:for-each select="stagetime">

				<xsl:if test="@best">
					<td><font color="#ffff00"><xsl:value-of select="."/></font></td>
				</xsl:if>
				<xsl:if test="not(@best)">
					<xsl:if test="string(@status) != 'OK'">
						<td><font color="#ff0000"><xsl:value-of select="."/></font></td>
					</xsl:if>
					<xsl:if test="string(@status) = 'OK'">
						<td><xsl:value-of select="."/></td>
					</xsl:if>
				</xsl:if>

			</xsl:for-each>
			<td></td>
		</tr>
	</xsl:template>
	
	<xsl:template match="entry">
		<tr bgcolor="#555555">
			<td></td>
			<td>
				<xsl:if test="not(@dqf)">
					<p valign="center"><xsl:value-of select="position()"/></p>
				</xsl:if>
				<xsl:if test="@dqf">
					<p valign="center">DQF<br/>
					<font size="1">(<xsl:value-of select="@dqf"/>)</font></p>
				</xsl:if>
			</td>
			<td>
				<xsl:apply-templates select="pname"/>
				<xsl:if test="uname">
					<br/>
					<font size="2">(<xsl:value-of select="uname"/>)</font>
				</xsl:if>
			</td>
			<td>
				<p valign="center"><xsl:value-of select="car"/></p>
			</td>
			<td>
				<img border="0" width="128" height="64" align="center">
					<!-- <xsl:attribute name="src">../pics/s_<xsl:value-of select="car"/>.jpg</xsl:attribute> -->
					<xsl:attribute name="src">../pics/nocar.png</xsl:attribute>
					<xsl:if test="string-length(car) > 0">
						<xsl:attribute name="src">../pics/<xsl:value-of select="car"/>.jpg</xsl:attribute>
					</xsl:if>
				</img>
			</td>
			<td>
				<xsl:value-of select="stagetime"/>
				<xsl:if test="status">
					<br/>
					<font color="#ff0000">
						<font size="1">
							(<xsl:value-of select="status"/>)
						</font>
					</font>
				</xsl:if>
				<xsl:if test="stage_penalty">
					<font size="1">
						<br/>
						<font color="#ff0000">
						(<xsl:value-of select="stage_penalty"/>)
						</font>
					</font>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="time_diff">
					<font size="2">
						+<xsl:value-of select="time_diff"/>
					</font>
				</xsl:if>
			</td>
			<td></td>
		</tr>
	</xsl:template>

	<xsl:template match="name">
		<xsl:if test="font">
			<xsl:apply-templates select="font"/>
		</xsl:if>
		<xsl:if test="not(font)">
			<xsl:value-of select="."/>
		</xsl:if>
	</xsl:template>
		
	<xsl:template match="pname">
		<xsl:if test="font">
			<xsl:apply-templates select="font"/>
		</xsl:if>
		<xsl:if test="not(font)">
			<xsl:value-of select="."/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="font">
		<!-- <xsl:attribute name="color"> -->
		<font>
			<xsl:attribute name="color"> <xsl:value-of select="@color"/> </xsl:attribute>
			<xsl:value-of select="."/>
		</font>
	</xsl:template>
	
	<xsl:template match="stage">
		<!-- <xsl:attribute name="color"> -->
		<td><b>SS<xsl:value-of select="number"/> - <xsl:value-of select="track"/></b></td>
	</xsl:template>

	<xsl:template match="stagetime">
		<!-- <xsl:attribute name="color"> -->
		<xsl:if test="@best">
			<td><font color="#ff0000"><xsl:value-of select="."/></font></td>
		</xsl:if>
		<xsl:if test="not(best)">
			<td><xsl:value-of select="."/></td>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>

