##############################################################################
##                                                                          ##
##  Live for Speed - LFS World Script v1.0.10                               ##
##  from Thomas 'CyBex' Hagen <lfsw-script@cybex.has.nolife.org>            ##
##                                                                          ##
##  http://l4s.nolife.org/lfs/                                              ##
##                                                                          ##
##############################################################################
##                                                                          ##
##  Catch information vom LFSWorld.net and Output to IRC for the game LFS.  ##
##                                                                          ##
##  Commands:                                                               ##
##  !lfs <on/off> to switch the power of this script for the actual channel ##
##  !pb <racer> <track> <car> to get lap and split times                    ##
##  !wr <track> <car> to see WR lap- and split times                        ##
##  !status <racer> to see if <racer> is online and where he is             ##
##                                                                          ##
##############################################################################
##                                                                          ##
##  Minimum Configure is, get a PubstatKey from LFSWorld.net                ##
##                                                                          ##
##############################################################################

# Config
namespace eval ::LFSWorld {

	# Pubstat Key -> http://lfsworld.net -> My LFSW Settings -> Pubstat
	variable PubstatKey ""

	# Minimum time betweed to request
	# Don't setup lower then 7 secs, if you don't have premium access
	variable FloodHelpTime 59
	variable FloodCacheTime 2
	variable FloodNoCacheTime 7

	# What trigger char do you want? !pb !wr !status
	variable Trigger "!"
}

# Expert Settings
namespace eval ::LFSWorld {
	variable UseCache 1; # better use cache, switch off only if you have premium access
	variable DeleteCache 1; # set to 0 if you want to look in files later
	variable CachePSTTime 15; # 15secs - Online Status
	variable CachePBTime 300; # 5mins - PBs
	variable CacheWRTime 900; # 15mins - WRs
}


##########################################################
### Don't edit below this, if you not know what you do ###
##########################################################

package require http

namespace eval ::LFSWorld {

	# Checks
	if {$PubstatKey eq ""} {
		putlog "You need to configure the PubstatKey"
		return "You need to configure the PubstatKey"
	}

	# Variables
	variable Cars
	array set Cars {
		uf1 1 xfg 1 xrg 1 lx4 1 lx6 1
		rb4 1 fxo 1 xrt 1 rac 1 fz5 1
		ufr 1 xfr 1 fxr 1 xrr 1 fzr 1
		mrt 1 fbm 1 fox 1 fo8 1 bf1 1
	}
	variable Tracks
	array set Tracks {
		bl1 000 bl1r 001 bl2 010 bl2r 011 bl3 020
		so1 100 so1r 101 so2 110 so2r 111 so3 120 so3r 121 so4 130 so4r 131 so5 140 so5r 141 so6 150 so6r 151
		fe1 200 fe1r 201 fe2 210 fe2r 211 fe3 220 fe3r 221 fe4 230 fe4r 231 fe5 240 fe5r 241 fe6 250 fe6r 251
		au1 300 au2 310  au3 320 au4 330
		ky1 400 ky1r 401 ky2 410 ky2r 411 ky3 420 ky3r 421
		we1 500 we1r 501
		as1 600 as1r 601 as2 610 as2r 611 as3 620 as3r 621 as4 630 as4r 631 as5 640 as5r 641 as6 650 as6r 651 as7 660 as7r 661
	}
	variable Developer 0
	variable Version 1
	variable Subver 0
	variable Build
	if {[info exi Build]} {if {$Developer} {incr Build}} {set Build 10}
	variable FirstEdit 1217482312
	variable LastUpdate 1217836666
	variable b \002

	# Binds
	bind pub - ${Trigger}pb [namespace current]::Pub:PB
	bind pub - ${Trigger}wr [namespace current]::Pub:WR
	bind pub - ${Trigger}status [namespace current]::Pub:Status
	bind pub - ${Trigger}racer [namespace current]::Pub:Status
	bind pub - ${Trigger}help [namespace current]::Pub:Help
	bind pub - ${Trigger}lfs [namespace current]::Pub:Help
	if {$DeleteCache} {
		bind time - * [namespace current]::Time
	}

	# Procs
	proc StripText {text} {
		regsub -all -- "\002|\037|\026|\003(\\d{1,2})?(,\\d{1,2})?" $text "" text
		return $text
	}
	proc Time {args} {
		variable DeleteCache
		if {$DeleteCache} {
			CheckDirsNFiles
		}
	}
	proc PutText {type dest text} {
		if {[validchan $dest] && [string match *c* [getchanmode $dest]]} {
			puthelp "$type $dest :[StripText $text]"
		} {
			puthelp "$type $dest :$text"
		}
	}
	proc CheckFlood {args} {
		if {[llength $args] eq 2} {
			foreach {type racer} $args {break}
		} elseif {[llength $args] eq1} {
			foreach {type} $args {break}; set racer ""
		} {
			set type ""; set racer ""
		}

		variable UseCache
		if {$UseCache} {
			variable CacheDir
			if {$type eq "wr"} {
				variable CacheWRTime; set time $CacheWRTime; set file $CacheDir/WR.txt
			} elseif {$type eq "pb"} {
				variable CachePBTime; set time $CachePBTime; set file $CacheDir/PB.$racer.txt
			} elseif {$type eq "pst"} {
				variable CachePSTTime; set time $CachePSTTime; set file $CacheDir/PST.$racer.txt
			} {
				set time -1; set file -1
			}
			#putcmdlog "check file $file with time $time"
			if {[file exi $file] && [clock sec]-[file mtime $file]>=$time} {
			#putcmdlog "file $file to old, renew"
				set file -1
			} elseif {![file exi $file]} {
			#putcmdlog "file $file not exists"
				set file -1
			}
			if {$file ne "-1"} {
				set time [file mtime $file]
				#putcmdlog "Use cache [expr {[clock sec]-$time}]"
				variable FloodCacheTime
				variable LastCacheTime
				if {![info exi LastCacheTime]} {set LastCacheTime 0}
				set time [expr {[clock seconds]-$LastCacheTime}]
				set return [expr {$time>=$FloodCacheTime?1:0}]
				#putcmdlog "Cache diff $time>$FloodCacheTime == $return"
				if {$return} {set LastCacheTime [clock seconds]; return 1} {return 0}
			} {
				if {$type eq "help"} {
					variable FloodHelpTime
					variable LastHelpTime
					if {![info exi LastHelpTime]} {set LastHelpTime 0}
					set time [expr {[clock seconds]-$LastHelpTime}]
					set return [expr {$time>=$FloodHelpTime?1:0}]
					#putcmdlog "Help diff $time>$FloodHelpTime == $return"
					if {$return} {set LastHelpTime [clock seconds]; return 1} {return 0}
				} {
					variable FloodNoCacheTime
					variable LastNoCacheTime
					if {![info exi LastNoCacheTime]} {set LastNoCacheTime 0}
					set time [expr {[clock seconds]-$LastNoCacheTime}]
					set return [expr {$time>=$FloodNoCacheTime?1:0}]
					#putcmdlog "NoCache diff $time>$FloodNoCacheTime == $return"
					if {$return} {set LastNoCacheTime [clock seconds]; return 1} {return 0}
				}
			}
		} {
		#putcmdlog "Dont use cache"
			if {$type eq "help"} {
				variable FloodHelpTime
				variable LastHelpTime
				if {![info exi LastHelpTime]} {set LastHelpTime 0}
				set time [expr {[clock seconds]-$LastHelpTime}]
				set return [expr {$time>=$FloodHelpTime?1:0}]
				#putcmdlog "Dont Help diff $time>$FloodHelpTime == $return"
				if {$return} {set LastHelpTime [clock seconds]; return 1} {return 0}
			} {
				variable FloodNoCacheTime
				variable LastNoCacheTime
				if {![info exi LastNoCacheTime]} {set LastNoCacheTime 0}
				set time [expr {[clock seconds]-$LastNoCacheTime}]
				set return [expr {$time>=$FloodNoCacheTime?1:0}]
				#putcmdlog "Dont NoCache diff $time>$FloodNoCacheTime == $return"
				if {$return} {set LastNoCacheTime [clock seconds]; return 1} {return 0}
			}
		}

		#putcmdlog "check flood t:$type; r:$racer;"
		return 1
	}
	proc CheckUDEF {nick chan} {
		if {[channel get $chan nolfsw]} {
		#PutText NOTICE $nick "LFS-World-Script is here disabled, ask the admin."
			return 0
		}
		return 1
	}
	proc CheckDirsNFiles {args} {
		variable UseCache
		if {$UseCache} {
			if {[info exi ::temp-path]} {set dir ${::temp-path}/LFSWorldCache} {set dir "[pwd]/.LFSWorldCache"}
			set dir [string map [list "//" "/"] $dir]
			if {![file exi $dir]} {
				if {[catch {file mkdir $dir} cmsg]} {
					putlog "Can't create cache dir, check for rights to write in [join [lrange [split $dir /] 0 end-1] /] errormsg:$cmsg"
					return "Can't create cache dir, check for rights to write in [join [lrange [split $dir /] 0 end-1] /] errormsg:$cmsg"
				}
				putlog "Create directory $dir"
			}
			variable CacheDir $dir
			#putcmdlog "set dir to $dir [file exi $dir]"

			variable DeleteCache
			if {$DeleteCache} {
				if {[catch {glob "$CacheDir/*.txt"} cmsg]} {
					return -1
					#putcmdlog "catch:$cmsg;"
				} {
					foreach file $cmsg {
						set type [lindex [split [lindex [split $file .] 0] /] end]
						set now [clock seconds]
						switch -exact $type {
							WR {variable CacheWRTime; set time $CacheWRTime}
							PB {variable CachePBTime; set time $CachePBTime}
							PST {variable CachePSTTime; set time $CachePSTTime}
							default {set time $now}
						}
						if {$now-[file mtime $file]>$time} {
							file delete -force -- $file
							#putcmdlog "del $file;"
						} {
						#putcmdlog "not del $file; [clock form [file mtime $file]]"
						}
					}
					#putcmdlog "files:$cmsg;"
				}; # if glob
			} ; # if Dele
		} ; # If Use
	}
	proc CheckValidCars {list} {
		variable Cars
		set return [list]
		foreach l $list {
			set l [string trim [string tolower $l]]
			if {[info exists Cars($l)]} {lappend return $l}
		}
		return $return
	}
	proc CheckValidTracks {list} {
		variable Tracks
		set return [list]
		foreach l $list {
			set l [string trim [string tolower $l]]
			if {[info exists Tracks($l)]} {lappend return [list $l $Tracks($l)]}
		}
		return $return
	}
	proc LFSTime2String {time} {
		if {$time<0} {
			set time [expr {$time*-1}]
			set diff "-"
		} {
			set diff ""
		}
		if {$time=="" || $time=="0"} {
			return ""
		} {
			if {[string len $time]<4} {set time "0$time"}
			if {[string len $time]<4} {set time "0$time"}
			if {[string len $time]<4} {set time "0$time"}
			if {[string len $time]<4} {set time "0$time"}
			set tss [string range $time end-2 end]
			set tmm [string range $time 0 end-3]; if {$tmm==""} {set tmm 0}
			#putcmdlog "time:$time; tss:$tss; tmm:$tmm;"
			set s [expr {$tmm % 60}]
			set m [expr {$tmm / 60}]
			if {$m!=0} {set m "$m:"} {set m ""}
			if {$m!="" && [string len $s]<2} {set s "0$s"}
			if {$tss!=0 && [string trimright $tss 0]!=""} {set tss ".[string trimright $tss 0]"} {set tss ""}
			return $diff$m$s$tss
		}
	}
	proc ColorLFS2IRC {text} {
		set text [string map -nocase [list "^9" "\003\002\002" "^8" "\003\002\002" "^0" "\0031\002\002" "^1" "\0035\002\002" "^2" "\0033\002\002" "^3" "\0038\002\002" "^4" "\0032\002\002" "^5" "\00313\002\002" "^6" "\00311\002\002" "^7" "\0030\002\002"] $text]
		return "$text\003\002\002"
	}
	proc Help {nick chan} {
		if {[CheckUDEF $nick $chan]} {
			if {![CheckFlood help]} {set type NOTICE; set dest $nick} {set type PRIVMSG; set dest $chan}
			PutText $type $dest "Help: !Status Name - !PB Name Track Car - !PB Track Car"
		}
	}
	proc GetHTTPData {type {racer ""}} {
		set data -1
		variable PubstatKey
		if {$type eq "wr"} {
			set url "http://lfsworld.net/pubstat/get_stat2.php?[http::formatQuery version 1.4 idk ${PubstatKey} action $type]"
		} elseif {$type eq "pb"} {
			set url "http://lfsworld.net/pubstat/get_stat2.php?[http::formatQuery version 1.4 idk ${PubstatKey} action $type racer $racer]"
		} elseif {$type eq "pst"} {
			set url "http://lfsworld.net/pubstat/get_stat2.php?[http::formatQuery version 1.4 idk ${PubstatKey} action $type racer $racer]"
		} {
			return -1
		}
		if {[catch { set token [http::geturl $url -timeout 3000]} error]}  {
		} elseif {[http::status $token] == "ok"} {
			set data [http::data $token]
		}
		catch {http::cleanup $token}
		return $data
	}
	proc GetData {type {racer ""}} {
		set file -1; set wfile -1; set data -1
		set racer [string tolower [string trim $racer]]
		variable UseCache
		if {$UseCache} {
			variable CacheDir
			if {$type eq "wr"} {
				variable CacheWRTime
				set time $CacheWRTime
				set file $CacheDir/WR.txt
			} elseif {$type eq "pb"} {
				variable CachePBTime
				set time $CachePBTime
				set file $CacheDir/PB.$racer.txt
			} elseif {$type eq "pst"} {
				variable CachePSTTime
				set time $CachePSTTime
				set file $CacheDir/PST.$racer.txt
			} {
				set time -1; set file -1
			}
			set wfile $file
			#putcmdlog "check file $file with time $time"
			if {[file exi $file] && [clock sec]-[file mtime $file]>=$time} {
			#putcmdlog "file $file to old, renew"
				set file -1
			} elseif {![file exi $file]} {
			#putcmdlog "file $file not exists"
				set file -1
			}
			if {$file ne "-1"} {
				set fh [open $file];
				set data [read -nonewline $fh]
				close $fh
				set wfile -1
				#putcmdlog "read data from $file ([expr {[clock sec]-[file mtime $file]}]=[expr {[clock sec]-[file mtime $file]>=$time}])"
			}
		}
		if {$file eq "-1"} {
		#putcmdlog "Get from HTTP (write:$wfile)"
			set data [GetHTTPData $type $racer]
		}
		if {[string match "*can't reload this page that quickly after another*" $data]} {
			set wfile -1
		}
		if {$wfile ne "-1"} {
		#putcmdlog "Write to $wfile"
			set fh [open $wfile w]
			puts $fh $data
			close $fh
		}
		return [split $data \n]
	}
	proc Pub:PB {n u h c t} {
	#putcmdlog "udef"
		if {[CheckUDEF $n $c]} {
			variable b
			set type PRIVMSG
			set dest $c
			#putcmdlog "split"
			set l [split $t]
			if {$t eq "" || [llength $l]<3} {
				if {![CheckFlood help]} {set type NOTICE; set dest $n} {set type PRIVMSG; set dest $c}
				PutText $type $dest "Help: $::lastbind Racer Track Car"
			} else {
			#putcmdlog "all checked"
				#foreach {racer track car} $l {break}
				set racer [join [lrange $l 0 end-2]]
				set track [lindex $l end-1]
				set car [lindex $l end]
				set flood [CheckFlood pb $racer]
				if {!$flood} {set type NOTICE; set dest $n}
				set lcar [CheckValidCars $car]
				set ltrack [CheckValidTracks $track]
				if {$lcar==[list] && $ltrack==[list]} {
				#putcmdlog "swap $car <> $track"
					set tcar $car; set car $track; set track $tcar
				}
				set lcar [CheckValidCars $car]
				set ltrack [CheckValidTracks $track]
				if {$lcar!=[list] && $ltrack!=[list]} {

					## roger roger
					#PutText $type $dest "Check $racer on $track with $car"
					variable UseCache
					if {$UseCache || $flood} {
						set data [GetData pb $racer]
					} { set data -1 }
					if {[string match "*no valid username*" $data]} {
						PutText $type $dest "No valid username: $b$racer$b"
						return -1
					}
					if {[string match "*can't reload this page that quickly after another*" $data]} {
						PutText $type $dest "Reload to fast, try again later: $::lastbind $racer $track $car"
						return -1
					}
					set pos [lsearch -glob $data "[lindex $ltrack 0 1] [string toupper $car] *"]
					#putcmdlog "search pb $pos [llength $data] [lindex $data $pos]"
					if {$pos!=-1} {
						foreach {ptrack pcar psp1 psp2 psp3 plaptime plapcount ptime} [lindex $data $pos] {break}
						if {$plaptime!=0} {
							set dur [duration [set diff [expr {[clock seconds]-$ptime}]]]
							if {[llength $dur]>4} {set dur [lrange $dur 0 3]}
							if {$diff>7776000} {
								set atime "since [clock form $ptime -form "%d.%m.%Y %H:%M"]"
								#putcmdlog "atime $atime"
							} {
								set atime "since $dur"
								#putcmdlog "atime $atime"
							}
							if {$ptime==0} {set atime ""}
							if {$psp3!=0} {
								PutText $type $dest "PB on ${b}[string toupper $track]${b} with ${b}[string toupper $car]${b}: ${b}$racer${b} in ${b}[LFSTime2String $plaptime]${b} (Split1: [LFSTime2String $psp1]; Split2: [LFSTime2String $psp2]; Split3: [LFSTime2String $psp3]) $atime"
							} elseif {$psp2!=0} {
								PutText $type $dest "PB on ${b}[string toupper $track]${b} with ${b}[string toupper $car]${b}: ${b}$racer${b} in ${b}[LFSTime2String $plaptime]${b} (Split1: [LFSTime2String $psp1]; Split2: [LFSTime2String $psp2]) $atime"
							} elseif {$psp1!=0} {
								PutText $type $dest "PB on ${b}[string toupper $track]${b} with ${b}[string toupper $car]${b}: ${b}$racer${b} in ${b}[LFSTime2String $plaptime]${b} (Split1: [LFSTime2String $psp1]) $atime"
							} {
								PutText $type $dest "PB on ${b}[string toupper $track]${b} with ${b}[string toupper $car]${b}: ${b}$racer${b} in ${b}[LFSTime2String $plaptime]${b} $atime"
							}
						} {
							PutText $type $dest "${b}$racer${b} hasn't any personal besttime on ${b}[string toupper $track]${b} with ${b}[string toupper $car]${b}"
						}
						#putcmdlog "pb:$plaptime; $plapcount; $dur;"
					} {
					#putcmdlog "no pb found"
						set type NOTICE; set dest $n
						PutText $type $dest "PB not found or too fast!"
					}
					#putcmdlog "d:$data;"
					##

				} elseif {$lcar==[list] && $ltrack==[list]} {
					if {[info exi tcar]} {
					#putcmdlog "swap $car <> $track"
						set tcar $car; set car $track; set track $tcar
					}
					PutText $type $dest "$b$track$b is not a valid track and $car isn't a valid car!"
				} elseif {$lcar==[list]} {
					PutText $type $dest "$b$car$b isn't a valid car!"
				} elseif {$ltrack==[list]} {
					PutText $type $dest "$b$track$b isn't a valid track!"
				}
				#putcmdlog "Check PB $racer for $car on $track"
			}
			#putcmdlog "done"

		}
	}
	proc Pub:WR {n u h c t} {
	#putcmdlog "udef"
		if {[CheckUDEF $n $c]} {
			variable b
			set type PRIVMSG
			set dest $c
			#putcmdlog "split"
			set l [split $t]
			if {$t eq "" || [llength $l]<2 || [llength $l]>2} {
				if {![CheckFlood help]} {set type NOTICE; set dest $n} {set type PRIVMSG; set dest $c}
				PutText $type $dest "Help: $::lastbind Track Car"
			} else {
			#putcmdlog "all checked"
				set flood [CheckFlood wr]
				if {!$flood} {set type NOTICE; set dest $n}
				foreach {track car} $l {break}
				set lcar [CheckValidCars $car]
				set ltrack [CheckValidTracks $track]
				if {$lcar==[list] && $ltrack==[list]} {
				#putcmdlog "swap $car <> $track"
					set tcar $car; set car $track; set track $tcar
				}
				set lcar [CheckValidCars $car]
				set ltrack [CheckValidTracks $track]
				if {$lcar!=[list] && $ltrack!=[list]} {
				## roger roger
					variable UseCache
					#putcmdlog "Check WR on $track ($ltrack) with $car ($UseCache || $flood)"
					if {$UseCache || $flood} {
						set data [GetData wr]
					} { set data -1 }
					if {[string match "*can't reload this page that quickly after another*" $data]} {
						PutText $type $dest "Reload to fast, try again later: $::lastbind $track $car"
						return -1
					}
					set pos [lsearch -glob $data "* [lindex $ltrack 0 1] [string toupper $car] *"]
					#putcmdlog "search wr $pos [llength $data]"
					if {$pos!=-1} {
						foreach {wid wtrack wcar wsp1 wsp2 wsp3 wlaptime wflags} [lindex $data $pos] {break}
						set alink "\037http://www.lfsworld.net/get_spr.php?file=$wid&w=1\037"
						set wname [join [lrange [lindex $data $pos] 8 end]]
						if {$wsp3!=0} {
							PutText $type $dest "WR on ${b}[string toupper $track]${b} with ${b}[string toupper $car]${b}: ${b}$wname${b} in ${b}[LFSTime2String $wlaptime]${b} (Split1: [LFSTime2String $wsp1]; Split2: [LFSTime2String $wsp2]; Split3: [LFSTime2String $wsp3]) $alink"
						} elseif {$wsp2!=0} {
							PutText $type $dest "WR on ${b}[string toupper $track]${b} with ${b}[string toupper $car]${b}: ${b}$wname${b} in ${b}[LFSTime2String $wlaptime]${b} (Split1: [LFSTime2String $wsp1]; Split2: [LFSTime2String $wsp2]) $alink"
						} elseif {$wsp1!=0} {
							PutText $type $dest "WR on ${b}[string toupper $track]${b} with ${b}[string toupper $car]${b}: ${b}$wname${b} in ${b}[LFSTime2String $wlaptime]${b} (Split1: [LFSTime2String $wsp1]) $alink"
						} {
							PutText $type $dest "WR on ${b}[string toupper $track]${b} with ${b}[string toupper $car]${b}: ${b}$wname${b} in ${b}[LFSTime2String $wlaptime]${b} $alink"
						}
						#putcmdlog "WR $wid from $wname; $wlaptime; $wsp1 $wsp2 $wsp3; $wflags"
					} {
						set type NOTICE; set dest $n
						PutText $type $dest "WR not found or too fast!"
					}
					#putcmdlog "data:'* [lindex $ltrack 0 1] [string toupper $car] *':[lsearch -glob $data "* [lindex $ltrack 0 1] [string toupper $car] *"]:$data;"
					##

				} elseif {$lcar==[list] && $ltrack==[list]} {
					if {[info exi tcar]} {
					#putcmdlog "swap $car <> $track"
						set tcar $car; set car $track; set track $tcar
					}
					PutText $type $dest "${b}$track${b} is not a valid track and $car isn't a valid car!"
				} elseif {$lcar==[list]} {
					PutText $type $dest "${b}$car${b} isn't a valid car!"
				} elseif {$ltrack==[list]} {
					PutText $type $dest "${b}$track${b} isn't a valid track!"
				}
				#putcmdlog "Check WR for $car on $track"
			}
			#putcmdlog "done"

		}
	}
	proc Pub:Status {n u h c t} {
	#putcmdlog "udef"
		if {[CheckUDEF $n $c]} {
			variable b
			set type PRIVMSG
			set dest $c
			#putcmdlog "split"
			set l [split $t]
			if {$t eq "" || [llength $l]<1} {
				if {![CheckFlood help]} {set type NOTICE; set dest $n} {set type PRIVMSG; set dest $c}
				PutText $type $dest "Help: $::lastbind Racer"
			} else {
			#putcmdlog "all checked"
				set racer $t
				#putcmdlog "checked pst $racer"
				set flood [CheckFlood pst $racer]
				variable UseCache
				if {!$flood} {set type NOTICE; set dest $n}
				if {$UseCache || $flood} {
					set data [GetData pst $racer]
				} { set data -1 }
				if {[string match "*no valid username*" $data]} {
					PutText $type $dest "No valid username: $b$racer$b"
					return -1
				}
				if {[string match "*can't reload this page that quickly after another*" $data]} {
					PutText $type $dest "Reload to fast, try again later: $::lastbind $racer"
					return -1
				}
				if {[llength $data]>=13} {
					foreach {dist fuel laps hosts wins sec thrd fin qual pole drag dwins country status hostname ltime track car} $data {break}
					set alink "\037lfs://|[StripText [ColorLFS2IRC $hostname]]|0|S2|/\037"
					set dur [duration [set diff [expr {[clock seconds]-$ltime}]]]
					if {[llength $dur]>4} {set dur [lrange $dur 0 3]}
					if {$diff>7776000} {
						set atime "since [clock form $ltime -form "%d.%m.%Y %H:%M"]"
						#putcmdlog "atime $atime"
					} {
						set atime "since $dur"
						#putcmdlog "atime $atime"
					}
					if {$ltime==0} {set atime ""}
					switch -exact -- $status {
						0 {
						# offline
							PutText $type $dest "${b}$racer${b} is ${b}offline${b} $atime"
						}
						default {
						# online
							PutText $type $dest "${b}$racer${b} is ${b}online${b} at [ColorLFS2IRC $hostname] $atime $alink"
						}
					}
					#putcmdlog "w:$wins q:$qual dr:$drag online $status"
				}
				#putcmdlog "data:'* [lindex $ltrack 0 1] [string toupper $car] *':[lsearch -glob $data "* [lindex $ltrack 0 1] [string toupper $car] *"]:$data;"
				##

			}
			#putcmdlog "done"

		}
	}
	proc Pub:Help {n u h c t} {
		switch -exact $t {
			on {if {[matchattr $h m|m $c]} {channel set $c -nolfsw}}
			off {if {[matchattr $h m|om $c]} {channel set $c +nolfsw}}
			default {
				Help $n $c
			}
		}

		CheckDirsNFiles

	}

	putlog "[info script] (v$Version.$Subver.$Build) from CyBex loaded.."
}

# change
setudef flag nolfsw