#ifndef _EVENT_H_
#define _EVENT_H_

#include <wx/string.h>
#include <wx/event.h>

class cGraphH;
class cGraphView;
class cLap;

//-----------------------------------------------------------------------------
// custom events, and functions to generate them

void SendCommandEvent(WXTYPE type, int clientInt, void* eventObject, const wxString& string = wxEmptyString);

// request closing a view (graph or pane)
DECLARE_EVENT_TYPE(EVT_LRA_CLOSEVIEW, -1)
void CloseView_Send(wxWindow* view);
void CloseView_Decode(wxCommandEvent& event, wxWindow*& view);

// move a graph in the list of graphs
DECLARE_EVENT_TYPE(EVT_LRA_MOVEGRAPH, -1)
void MoveGraph_Send(cGraphView* view, int change);
void MoveGraph_Decode(wxCommandEvent& event, cGraphView*& view, int& change);

// request deletion of a lap
DECLARE_EVENT_TYPE(EVT_LRA_DELETELAP, -1)
void DeleteLap_Send(cLap* lap);
void DeleteLap_Decode(wxCommandEvent& event, cLap*& lap);

// show or hide a lap in the graphs
DECLARE_EVENT_TYPE(EVT_LRA_SHOWLAP, -1)
void ShowLap_Send(cLap* lap, bool shown);
void ShowLap_Decode(wxCommandEvent& event, cLap*& lap, bool& shown);

// set new position of track cursor(s)
DECLARE_EVENT_TYPE(EVT_LRA_SETTRACKCURSORPOS, -1)
void SetTrackCursorPos_Send(float pos, int type);
void SetTrackCursorPos_Decode(wxCommandEvent& event, float& pos, int& type);

// set the visible ('selected') part of the lap
DECLARE_EVENT_TYPE(EVT_LRA_SETTRACKSELECTION, -1)
void SetTrackSelection_Send(float start, float end);
void SetTrackSelection_Decode(wxCommandEvent& event, float& start, float& end);

// make all graphs equal height
DECLARE_EVENT_TYPE(EVT_LRA_EQUALHEIGHTGRAPHS, -1)
void EqualHeightGraphs_Send();
// NB no need for a decoding function

// request to open a file
DECLARE_EVENT_TYPE(EVT_LRA_OPENFILE, -1)
void OpenFile_Send(const wxString& filename);
void OpenFile_Decode(wxCommandEvent& event, wxString& filename);

// request to an action on the presets
DECLARE_EVENT_TYPE(EVT_LRA_PRESET, -1)
void Preset_Send(int action, const wxString& name);
void Preset_Decode(wxCommandEvent& event, int& action, wxString& name);

// synchronise the graphviews
DECLARE_EVENT_TYPE(EVT_LRA_SYNCGRAPHS, -1)
void SyncGraphs_Send(cGraphView* view);
void SyncGraphs_Decode(wxCommandEvent& event, cGraphView*& view);

// update the layout of the main frame
DECLARE_EVENT_TYPE(EVT_LRA_LAYOUTFRAME, -1)
void LayoutMainFrame_Send();
// NB no need for a decoding function

//-----------------------------------------------------------------------------

#endif
