#ifndef _CGRAPHTOOLS_Y_H_
#define _CGRAPHTOOLS_Y_H_

#include "global.h"
#include "cgraphtools.h"
#include "cgraph_y.h"
#include <wx/checkbox.h>
#include <wx/choice.h>
#include <wx/sizer.h>
#include <wx/stattext.h>

class cGraphView;

//-----------------------------------------------------------------------------
// A toolbar on a graph

class cGraphToolsY : public cGraphTools
{
private:
  wxChoice* m_LogtypeChoice;    // dropdown box for the log type
  wxChoice* m_WheeltypeChoice;  // dropdown box to select the wheel type
  wxStaticText* m_WheelText;    // text for m_WheelChoice
  wxCheckBox* m_DeltaCheck;     // delta checkbox
  wxChoice* m_LapChoice;        // dropdown box for the delta-lap

  void OnChangeLogtype(wxCommandEvent& event);
  void OnToggleDeltaMode(wxCommandEvent& event);
  void OnChangeLap(wxCommandEvent& event);

  void SetDeltaLap();
  virtual void DoEnableControls();

  DECLARE_EVENT_TABLE()

public:
  cGraphToolsY(cGraphView* parent, cGraphY* graph);
  virtual ~cGraphToolsY();

  virtual void UpdateAll();
  virtual void TranslateTexts();
};

#endif
