#include "ccar.h"

#define CARCODE_NOT_FOUND _T("???")

//-----------------------------------------------------------------------------
// Static members

wxString cCar::s_CarCodes[] = {
 _T("XF GTI:XFG"),
 _T("XR GT:XRG"),
 _T("XR GT Turbo:XRT"),
 _T("RB4 GT:RB4"),
 _T("FXO Turbo:FXO"),
 _T("LX4:LX4"),
 _T("LX6:LX6"),
 _T("MRT5:MRT"),
 _T("UF 1000:UF1"),
 _T("RA:RAC"),
 _T("FZ50:FZ5"),
 _T("XF GTR:XFR"),
 _T("UF GTR:UFR"),
 _T("Formula XR:FOX"),
 _T("Formula V8:FO8"),
 _T("BMW Sauber F1.06:BF1"),
 _T("FXO GTR:FXR"),
 _T("XR GTR:XRR"),
 _T("FZ50 GTR:FZR"),
 _T("Formula BMW FB02:FBM")
};

wxString cCar::s_TyreTypeNames[] = {
  _T("R1"),
  _T("R2"),
  _T("R3"),
  _T("R4"),
  _T("ROAD SUPER"),
  _T("ROAD NORMAL"),
  _T("HYBRID"),
  _T("KNOBBLY")
};

//-----------------------------------------------------------------------------

cCar::cCar()
{
}

//-----------------------------------------------------------------------------

cCar::~cCar()
{
}

//-----------------------------------------------------------------------------
// Convert the full car name to the 3-letter code
// - name = car name

wxString cCar::Name2Code(const wxString& name)
{
  // search the list
  int count = sizeof(s_CarCodes) / sizeof(wxString);
  for (int i = 0; i < count; i++) {

    if (s_CarCodes[i].BeforeFirst(':').CmpNoCase(name) != 0) continue; // different name

    // found it
    wxString code = s_CarCodes[i].AfterFirst(':');  // car code
    return code;
  }

  // not found
  return wxString(CARCODE_NOT_FOUND);
}

//-----------------------------------------------------------------------------
// Get the list of codes
// - codes = list that will be filled with the codes

void cCar::GetCodes(wxArrayString& codes)
{
  codes.Empty();
  int count = sizeof(s_CarCodes) / sizeof(wxString);
  for (int i = 0; i < count; i++) {
    codes.Add(s_CarCodes[i].AfterFirst(':'));
  }
  codes.Sort();
}
