#region Copyright  2006 Daniel Monzert [jackd.m@gmx.net]
/*
 * cSharpToHtml is provided 'as-is' without any warranties. I am not responsible
 * for any damages or data loss happening from using this program.
 * You can use, alter and redistribute this software freely by the following
 * restrictions:
 * 
 * 1. Do not misrepresent the origin of this software and the origin of the
 *    software by Jean-Claude Manoli. You do not claim to be the original
 *    author of either software.
 * 
 * 2. If you alter the source code and redistribute it, plainly mark it
 *    as such.
 * 
 * 3. This notice will not be removed or altered from any sourcecode
 *    distribution.
 */
#endregion
#region Copyright  2001-2003 Jean-Claude Manoli [jc@manoli.net]
/*
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the author(s) be held liable for any damages arising from
 * the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 * 
 *   1. The origin of this software must not be misrepresented; you must not
 *      claim that you wrote the original software. If you use this software
 *      in a product, an acknowledgment in the product documentation would be
 *      appreciated but is not required.
 * 
 *   2. Altered source versions must be plainly marked as such, and must not
 *      be misrepresented as being the original software.
 * 
 *   3. This notice may not be removed or altered from any source distribution.
 */ 
#endregion
using System;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Threading;
using System.Windows.Forms;

[assembly: AssemblyTitle("cSharpToHtml")]
[assembly: AssemblyDescription("GUI for CSharpFormat to generate syntax-highlighted source-code.")]
[assembly: AssemblyCompany("-BatchWare")]
[assembly: AssemblyProduct("cSharpToHtml")]
[assembly: AssemblyCopyright("Copyright 2006, -BatchWare")]
[assembly: AssemblyVersion("1.0.*")]

namespace cSharpToHtml
{
	/// <summary>
	///		Application's core class.
	/// </summary>
	public class Core
	{
		private static Assembly		m_CoreAssembly			= Assembly.GetExecutingAssembly();
		private static Process		m_CoreProcess			= Process.GetCurrentProcess();
		private static string		m_ExePath				= m_CoreProcess.MainModule.FileName;
		private static string		m_BaseDirectory			= Path.GetDirectoryName(m_ExePath);
		private static Thread		m_CoreThread			= Thread.CurrentThread;
		private static Version		m_Version				= m_CoreAssembly.GetName().Version;
		
		public static Assembly	CoreAssembly
		{
			get { return m_CoreAssembly; }
		}

		public static Process	CoreProcess
		{
			get { return m_CoreProcess; }
		}

		public static string	ExePath
		{
			get { return m_ExePath; }
		}

		public static string	BaseDirectory
		{
			get { return m_BaseDirectory; }
		}

		public static Thread	CoreThread
		{
			get { return m_CoreThread; }
		}

		public static string	VersionString
		{
			get
			{
				return String.Format("v{0}.{1}.{2} build {3}",
					m_Version.Major, m_Version.Minor, m_Version.Build, m_Version.Revision);
			}
		}

		public static Version	Version
		{
			get { return m_Version; }
		}

		[STAThreadAttribute()]
		public static void Main(string[] args)
		{
			Application.Run(new frmMain());
		}
	}
}
