/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSAdminRights.Screens;

import it.starblue.LFS.LFSAdminRights.Admin;
import it.starblue.LFS.LFSAdminRights.Host;
import it.starblue.LFS.LFSAdminRights.LFSAdminRights;
import it.starblue.LFS.LFSAdminRights.Screens.AdminMainScreen;
import it.starblue.LFS.LFSAdminRights.Screens.Authorization;
import it.starblue.LFS.LFSAdminRights.Screens.Screen;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class AdminRightsPanel
implements Screen {
    private static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSAdminRights.Screens.AdminRightsPanel");
    private Host host;
    private byte connectionId;
    private int page = 1;
    private HashMap<Byte, Authorization> authorizationMap = new HashMap();
    private HashMap<Byte, String> delMap = new HashMap();
    private byte PREVBUTTON = (byte)4;
    private byte NEXTBUTTON = (byte)5;
    private byte BACKTOMAIN = (byte)6;
    private byte CLOSEBUTTON = (byte)7;
    private byte NEWADMINBUTTON = (byte)11;
    private byte ADDADMINBUTTON = (byte)12;
    private String newAdmin = "";

    public AdminRightsPanel(byte by, Host host) {
        this.host = host;
        this.connectionId = by;
    }

    public void display() {
        int n = 40;
        this.host.createButton("Admin Rights", 10, 40, 5, 30, n++, 33, this.connectionId);
        this.authorizationMap.clear();
        HashMap<String, String> hashMap = LFSAdminRights.getCommandsMap();
        TreeSet<String> treeSet = new TreeSet<String>(hashMap.keySet());
        int n2 = 4;
        int n3 = Math.max((int)Math.ceil((double)hashMap.size() / (double)n2), 1) * 10;
        int n4 = (int)Math.floor(120.0 / (double)n3);
        HashMap<String, Admin> hashMap2 = LFSAdminRights.getAdminMap();
        TreeSet<String> treeSet2 = new TreeSet<String>(hashMap2.keySet());
        int n5 = 1;
        for (String string : treeSet2) {
            if (n5 > (this.page - 1) * n4 && n5 <= this.page * n4) {
                int n6 = n5 - (this.page - 1) * n4 - 1;
                this.host.createButton("^1Del", 10, 10, 5, 40 + n6 * n3, n++, 40, this.connectionId);
                this.delMap.put((byte)(n - 1), string);
                this.host.createButton("^7" + string, 10, 30, 15, 40 + n6 * n3, n++, 32, this.connectionId);
                int n7 = 0;
                for (String string2 : treeSet) {
                    Admin admin = hashMap2.get(string);
                    if (admin.isAuthorizedFor(string2)) {
                        this.host.createButton("^2" + string2, 10, 15, 45 + n7 % 4 * 15, 40 + n6 * n3 + n7 / 4 * 10, n++, 24, this.connectionId);
                        this.authorizationMap.put((byte)(n - 1), new Authorization(string, string2));
                    } else {
                        this.host.createButton(string2, 10, 15, 45 + n7 % 4 * 15, 40 + n6 * n3 + n7 / 4 * 10, n++, 40, this.connectionId);
                        this.authorizationMap.put((byte)(n - 1), new Authorization(string, string2));
                    }
                    ++n7;
                }
            }
            ++n5;
        }
        this.host.createButton("^2Add", 10, 15, 45, 30, this.ADDADMINBUTTON, 40, this.connectionId);
        if (this.newAdmin.length() > 0) {
            this.host.createTextButton(30, this.newAdmin, 10, 45, 60, 30, this.NEWADMINBUTTON, 40, this.connectionId);
        } else {
            this.host.createTextButton(30, "<New Admin Username>", 10, 45, 60, 30, this.NEWADMINBUTTON, 40, this.connectionId);
        }
        int n8 = 1;
        int n9 = (int)Math.ceil((double)hashMap2.size() / (double)n4);
        if (this.page > n8) {
            this.host.createButton("^7Prev", 10, 25, 30, 160, this.PREVBUTTON, 41, this.connectionId);
        } else {
            this.host.createButton("Prev", 10, 25, 30, 160, this.PREVBUTTON, 32, this.connectionId);
        }
        if (this.page < n9) {
            this.host.createButton("^7Next", 10, 25, 55, 160, this.NEXTBUTTON, 41, this.connectionId);
        } else {
            this.host.createButton("Next", 10, 25, 55, 160, this.NEXTBUTTON, 32, this.connectionId);
        }
        this.host.createButton("^7Back to Main", 10, 25, 5, 160, this.BACKTOMAIN, 41, this.connectionId);
        this.host.createButton("^2Close", 10, 25, 80, 160, this.CLOSEBUTTON, 41, this.connectionId);
    }

    public Screen processClicks(byte by, boolean bl) {
        if (by == this.ADDADMINBUTTON) {
            if (this.newAdmin.length() > 0) {
                try {
                    LFSAdminRights.addAdmin(this.newAdmin);
                    this.newAdmin = "";
                }
                catch (IOException iOException) {
                    log.error((Object)"Failed to add new Admin!", (Throwable)iOException);
                }
            }
            this.display();
        } else {
            if (by == this.BACKTOMAIN) {
                return new AdminMainScreen(this.connectionId, this.host);
            }
            if (by == this.CLOSEBUTTON) {
                this.host.clearAllButtons(this.connectionId);
                return null;
            }
            if (by == this.NEXTBUTTON) {
                ++this.page;
                this.display();
            } else if (by == this.PREVBUTTON) {
                --this.page;
                this.display();
            } else {
                if (this.delMap.containsKey(by)) {
                    String string = this.delMap.get(by);
                    try {
                        LFSAdminRights.removeAdmin(string);
                    }
                    catch (IOException iOException) {
                        log.error((Object)"Failed to remove Admin!", (Throwable)iOException);
                    }
                    return this;
                }
                if (this.authorizationMap.containsKey(by)) {
                    Authorization authorization = this.authorizationMap.get(by);
                    try {
                        LFSAdminRights.toggleAuthorization(authorization.getUsername(), authorization.getCommand());
                    }
                    catch (IOException iOException) {
                        log.error((Object)"Failed to grant/revoke Authorization!", (Throwable)iOException);
                    }
                    return this;
                }
            }
        }
        return this;
    }

    public void updateTexts(byte by, String string) {
        if (by == this.NEWADMINBUTTON && string.trim().length() > 0) {
            this.newAdmin = string.trim();
            this.display();
        }
    }
}

