/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSAdminRights;

import it.starblue.LFS.LFSAdminRights.Admin;
import it.starblue.LFS.LFSAdminRights.Host;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFSAdminRights {
    private static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSAdminRights.LFSAdminRights");
    private static Properties properties = new Properties();
    private static HashMap<String, Admin> adminList = new HashMap();
    private static HashMap<String, String> commandList = new HashMap();
    private static char prefix = (char)36;

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        LFSAdminRights.loadConfig();
        commandList = LFSAdminRights.loadCommands();
        adminList = LFSAdminRights.loadAdmins();
        ArrayList<Host> arrayList = LFSAdminRights.loadHosts();
        block0: while (true) {
            Thread.sleep(60000L);
            Iterator<Host> iterator = arrayList.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Host host = iterator.next();
                host.testConnection();
            }
            break;
        }
    }

    private static void loadConfig() throws FileNotFoundException, IOException {
        properties.load(new FileInputStream("adminRights.cfg"));
        String string = properties.getProperty("prefix");
        if (string != null && string.length() > 0) {
            prefix = string.toCharArray()[0];
        }
    }

    private static ArrayList<Host> loadHosts() throws IOException {
        FileReader fileReader = new FileReader("hosts.txt");
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string = bufferedReader.readLine();
        ArrayList<Host> arrayList = new ArrayList<Host>();
        while (string != null && !string.trim().equals("")) {
            String[] stringArray = string.split(";");
            if (stringArray.length == 3) {
                try {
                    String string2 = stringArray[0];
                    int n = Integer.parseInt(stringArray[1]);
                    String string3 = stringArray[2];
                    arrayList.add(new Host(string2, n, string3, prefix));
                }
                catch (NumberFormatException numberFormatException) {
                    log.fatal((Object)("Failed to parse port number from the following host line:\n" + string));
                    bufferedReader.close();
                    System.exit(-1);
                }
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        return arrayList;
    }

    private static HashMap<String, Admin> loadAdmins() throws IOException {
        FileReader fileReader = new FileReader("admins.txt");
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string = bufferedReader.readLine();
        HashMap<String, Admin> hashMap = new HashMap<String, Admin>();
        while (string != null && !string.trim().equals("")) {
            String[] stringArray = string.split(";");
            if (stringArray.length > 0) {
                String string2 = stringArray[0];
                Admin admin = new Admin(string2.toLowerCase());
                for (int i = 1; i < stringArray.length; ++i) {
                    if (commandList.get(stringArray[i]) == null) continue;
                    admin.addAuthorizationFor(stringArray[i]);
                }
                hashMap.put(admin.getUsername().toLowerCase(), admin);
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        return hashMap;
    }

    private static HashMap<String, String> loadCommands() throws IOException {
        FileReader fileReader = new FileReader("commands.txt");
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string = bufferedReader.readLine();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (string != null && !string.trim().equals("")) {
            String[] stringArray = string.split(";");
            if (stringArray.length == 2) {
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                hashMap.put(string2, string3);
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        return hashMap;
    }

    public static synchronized boolean checkRights(String string, String string2) {
        Admin admin = adminList.get(string.toLowerCase());
        if (admin != null) {
            return admin.isAuthorizedFor(string2);
        }
        return false;
    }

    public static synchronized String getTranslation(String string) {
        return commandList.get(string);
    }

    public static synchronized HashMap<String, String> getCommandsMap() {
        return (HashMap)commandList.clone();
    }

    public static synchronized void addCommand(String string, String string2) throws IOException {
        commandList.put(string, string2);
        LFSAdminRights.saveCommandList();
    }

    public static synchronized void removeCommand(String string) throws IOException {
        for (Admin admin : adminList.values()) {
            admin.removeAuthorizationFor(string);
        }
        LFSAdminRights.saveAdminList();
        commandList.remove(string);
        LFSAdminRights.saveCommandList();
    }

    private static synchronized void saveAdminList() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("admins.txt"));
        for (Admin admin : adminList.values()) {
            bufferedWriter.write(admin.getUsername());
            for (String string : admin.getAuthorizations()) {
                bufferedWriter.write(";" + string);
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.close();
    }

    private static synchronized void saveCommandList() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("commands.txt"));
        for (String string : commandList.keySet()) {
            bufferedWriter.write(string + ";" + commandList.get(string) + "\n");
        }
        bufferedWriter.close();
    }

    public static synchronized void updateCommand(String string, String string2) throws IOException {
        LFSAdminRights.addCommand(string, string2);
    }

    public static synchronized void addAdmin(String string) throws IOException {
        Admin admin = new Admin(string.toLowerCase());
        adminList.put(admin.getUsername().toLowerCase(), admin);
        LFSAdminRights.saveAdminList();
    }

    public static synchronized void removeAdmin(String string) throws IOException {
        adminList.remove(string);
        LFSAdminRights.saveAdminList();
    }

    public static synchronized HashMap<String, Admin> getAdminMap() {
        return (HashMap)adminList.clone();
    }

    public static synchronized void toggleAuthorization(String string, String string2) throws IOException {
        Admin admin = adminList.get(string);
        if (admin.isAuthorizedFor(string2)) {
            admin.removeAuthorizationFor(string2);
        } else {
            admin.addAuthorizationFor(string2);
        }
        LFSAdminRights.saveAdminList();
    }
}

