/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSAdminRights;

import it.starblue.LFS.LFSAdminRights.Host;
import it.starblue.LFS.LFSAdminRights.Screens.Screen;

public class Connection {
    private byte connId;
    private String username = "";
    private String playerName = "";
    private boolean isAdmin;
    private Host host;
    private Screen currentScreen;
    private Thread cleaner;
    private long lastAction = 0L;
    private int displayTimeout = 60000;

    public Host getHost() {
        return this.host;
    }

    private void initCleaner() {
        this.cleaner = new Thread(){

            public void run() {
                try {
                    long l = System.currentTimeMillis();
                    while (l < Connection.this.lastAction + (long)Connection.this.displayTimeout) {
                        Thread.sleep(Connection.this.lastAction + (long)Connection.this.displayTimeout - l);
                        l = System.currentTimeMillis();
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                Connection.this.host.clearAllButtons(Connection.this.connId);
                Connection.this.currentScreen = null;
            }
        };
        this.cleaner.start();
    }

    public byte getConnId() {
        return this.connId;
    }

    public void setConnId(byte by) {
        this.connId = by;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean bl) {
        this.isAdmin = bl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public Screen getCurrentScreen() {
        return this.currentScreen;
    }

    public void setCurrentScreen(Screen screen) {
        this.setActive();
        this.currentScreen = screen;
        this.host.clearAllButtons(this.connId);
        if (this.currentScreen != null) {
            this.currentScreen.display();
            if (this.cleaner == null || !this.cleaner.isAlive()) {
                this.initCleaner();
            }
        }
    }

    public void setActive() {
        this.lastAction = System.currentTimeMillis();
    }

    public void setDisplayTimeout(int n) {
        this.displayTimeout = n;
    }

    public String toString() {
        return "{" + this.connId + " " + this.username + "}";
    }

    public Connection(Host host, byte by, boolean bl, String string, String string2) {
        this.host = host;
        this.connId = by;
        this.isAdmin = bl;
        this.username = string;
        this.playerName = string2;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String string) {
        this.playerName = string;
    }
}

