/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.types;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class RaceLaps {
    boolean isPractice;
    boolean isTimedRace;
    int laps;

    public RaceLaps(ByteBuffer buffer) throws BufferUnderflowException {
        byte readLap = buffer.get();
        if (readLap == 0) {
            this.isPractice = true;
            this.isTimedRace = false;
            this.laps = 0;
        } else if (readLap > 190) {
            this.isPractice = false;
            this.isTimedRace = true;
            this.laps = readLap - 190;
        } else if (readLap > 100) {
            this.isPractice = false;
            this.isTimedRace = false;
            this.laps = (readLap - 100) * 10 + 100;
        } else {
            this.isPractice = false;
            this.isTimedRace = false;
            this.laps = readLap;
        }
    }

    public String toString() {
        String retval = "";
        retval = this.isPractice() ? retval + "Practice Session" : (this.isTimedRace() ? retval + this.getLaps() + " hours." : retval + this.getLaps() + " laps.");
        return retval;
    }

    public boolean isPractice() {
        return this.isPractice;
    }

    public void setPractice(boolean isPractice) {
        this.isPractice = isPractice;
    }

    public boolean isTimedRace() {
        return this.isTimedRace;
    }

    public void setTimedRace(boolean isTimedRace) {
        this.isTimedRace = isTimedRace;
    }

    public int getLaps() {
        return this.laps;
    }

    public void setLaps(int laps) {
        this.laps = laps;
    }
}

