/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.PlayerResponse;
import net.sf.jinsim.types.Tyres;

public class PitStopResponse
extends PlayerResponse {
    public static final int NOTHING = 1;
    public static final int STOP = 2;
    public static final int FRONT_DAMAGE = 4;
    public static final int FRONT_WHEEL = 8;
    public static final int LEFT_FRONT_DAMAGE = 16;
    public static final int LEFT_FRONT_WHEEL = 32;
    public static final int RIGHT_FRONT_DAMAGE = 64;
    public static final int RIGHT_FRONT_WHEEL = 128;
    public static final int REAR_DAMAGE = 256;
    public static final int REAR_WHEEL = 512;
    public static final int LEFT_REAR_DAMAGE = 1024;
    public static final int LEFT_REAR_WHEEL = 2048;
    public static final int RIGHT_REAR_DAMAGE = 4096;
    public static final int RIGHT_REAR_WHEEL = 8192;
    public static final int BODY_MINOR = 16386;
    public static final int BODY_MAJOR = 32768;
    public static final int SETUP = 65536;
    public static final int REFUEL = 131072;
    private int laps;
    private int playerFlags;
    private byte penalty;
    private byte numberOfPitstops;
    private Tyres tyres;
    private int work;

    public PitStopResponse() {
        super(PacketType.PIT);
    }

    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.setLaps(buffer.getShort());
        this.setPlayerFlags(buffer.getShort());
        buffer.position(buffer.position() + 1);
        this.setPenalty(buffer.get());
        this.setNumberOfPitstops(buffer.get());
        buffer.position(buffer.position() + 1);
        this.setTyres(new Tyres(buffer));
        this.setWork(buffer.getInt());
        buffer.position(buffer.position() + 4);
    }

    public Tyres getTyres() {
        return this.tyres;
    }

    public void setTyres(Tyres tyres) {
        this.tyres = tyres;
    }

    public int getWork() {
        return this.work;
    }

    public void setWork(int work) {
        this.work = work;
    }

    public int getLaps() {
        return this.laps;
    }

    public void setLaps(int laps) {
        this.laps = laps;
    }

    public int getPlayerFlags() {
        return this.playerFlags;
    }

    public void setPlayerFlags(int playerFlags) {
        this.playerFlags = playerFlags;
    }

    public byte getPenalty() {
        return this.penalty;
    }

    public void setPenalty(byte penalty) {
        this.penalty = penalty;
    }

    public byte getNumberOfPitstops() {
        return this.numberOfPitstops;
    }

    public void setNumberOfPitstops(byte numberOfPitstops) {
        this.numberOfPitstops = numberOfPitstops;
    }

    public boolean didNothing() {
        return (this.work & 1) > 0;
    }

    public boolean didStop() {
        return (this.work & 2) > 0;
    }

    public boolean didFrontDamage() {
        return (this.work & 4) > 0;
    }

    public boolean didFrontWheel() {
        return (this.work & 8) > 0;
    }

    public boolean didLeftFrontDamage() {
        return (this.work & 0x10) > 0;
    }

    public boolean didLeftFrontWheel() {
        return (this.work & 0x20) > 0;
    }

    public boolean didRightFrontDamage() {
        return (this.work & 0x40) > 0;
    }

    public boolean didRightFrontWheel() {
        return (this.work & 0x80) > 0;
    }

    public boolean didRearDamage() {
        return (this.work & 0x100) > 0;
    }

    public boolean didRearWheel() {
        return (this.work & 0x200) > 0;
    }

    public boolean didLeftRearDamage() {
        return (this.work & 0x400) > 0;
    }

    public boolean didLeftRearWheel() {
        return (this.work & 0x800) > 0;
    }

    public boolean didRightRearDamage() {
        return (this.work & 0x1000) > 0;
    }

    public boolean didRightRearWheel() {
        return (this.work & 0x2000) > 0;
    }

    public boolean didBodyMinor() {
        return (this.work & 0x4002) > 0;
    }

    public boolean didBodyMajor() {
        return (this.work & 0x8000) > 0;
    }

    public boolean didSetup() {
        return (this.work & 0x10000) > 0;
    }

    public boolean didRefuel() {
        return (this.work & 0x20000) > 0;
    }

    public String toString() {
        return super.toString() + ", laps: " + this.laps + ", playerFlags: " + this.playerFlags + ", penalty: " + this.penalty + ", numberOfPitstops: " + this.numberOfPitstops + ", tyres: " + this.tyres + ", work: " + this.work;
    }
}

