/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.Car;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.PlayerResponse;
import net.sf.jinsim.types.Tyres;

public class NewPlayerResponse
extends PlayerResponse {
    private byte connectionId;
    private byte playerType;
    private int playerFlags;
    private String playerName;
    private String numberPlate;
    private Car car;
    private String skinName;
    private Tyres tyres;
    private byte addedMass;
    private byte intakeRestriction;
    private byte passengers;
    private byte numberInRace;
    private byte model;

    public NewPlayerResponse() {
        super(PacketType.NEW_PLAYER);
    }

    public byte getAddedMass() {
        return this.addedMass;
    }

    public Car getCar() {
        return this.car;
    }

    public byte getIntakeRestriction() {
        return this.intakeRestriction;
    }

    public byte getNumberInRace() {
        return this.numberInRace;
    }

    public String getNumberPlate() {
        return this.numberPlate;
    }

    public byte getPassengers() {
        return this.passengers;
    }

    public int getPlayerFlags() {
        return this.playerFlags;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public byte getPlayerType() {
        return this.playerType;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public Tyres getTyres() {
        return this.tyres;
    }

    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.connectionId = buffer.get();
        this.playerType = buffer.get();
        this.playerFlags = buffer.getShort();
        this.playerName = this.getString(buffer, 24);
        this.numberPlate = this.getString(buffer, 8);
        String carName = this.getString(buffer, 4);
        this.car = Car.getCarByName(carName);
        this.skinName = this.getString(buffer, 16);
        this.tyres = new Tyres(buffer);
        this.addedMass = buffer.get();
        this.intakeRestriction = buffer.get();
        this.model = buffer.get();
        this.passengers = buffer.get();
        buffer.position(buffer.position() + 5);
        this.numberInRace = buffer.get();
        buffer.position(buffer.position() + 2);
    }

    public String toString() {
        return super.toString() + ", uniqueId: " + this.connectionId + ", playerType: " + this.playerType + ", playerFlags: " + this.playerFlags + ", playerName: " + this.playerName + ", numberPlate: " + this.numberPlate + ", car: " + (Object)((Object)this.car) + ", skinName: " + this.skinName + ", tyres: " + this.tyres + ", addedMass: " + this.addedMass + ", intakeRestriction: " + this.intakeRestriction + ", model: " + this.model + ", passengers: " + this.passengers + ", numberInRace: " + this.numberInRace;
    }

    public byte getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(byte uniqueId) {
        this.connectionId = uniqueId;
    }

    public byte getModel() {
        return this.model;
    }
}

