/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.RaceTrackingResponse;

public class NewConnectionResponse
extends RaceTrackingResponse {
    private String username;
    private String playername;
    private boolean isAdmin;
    private byte numberOfConnections;

    public NewConnectionResponse() {
        super(PacketType.NEW_CONNECTION);
    }

    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.username = this.getString(buffer, 24);
        this.playername = this.getString(buffer, 24);
        this.isAdmin = buffer.get() > 0;
        this.numberOfConnections = buffer.get();
        buffer.position(buffer.position() + 2);
    }

    public String toString() {
        return super.toString() + ", username: " + this.username + ", playername: " + this.playername + ", isAdmin: " + this.isAdmin + ", numberOfConnection: " + this.numberOfConnections;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public byte getNumberOfConnections() {
        return this.numberOfConnections;
    }

    public String getPlayerName() {
        return this.playername;
    }

    public String getUsername() {
        return this.username;
    }
}

