/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.Encoding;
import net.sf.jinsim.PacketType;

public abstract class InSimResponse {
    protected static final int MAX_PLAYERS = 32;
    protected PacketType packetType;
    protected byte requestInfo;

    public byte getRequestInfo() {
        return this.requestInfo;
    }

    public InSimResponse(PacketType packetType) {
        this.packetType = packetType;
    }

    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        this.requestInfo = buffer.get();
    }

    public String toString() {
        return "[" + this.getClass().getName() + "]";
    }

    public PacketType getPacketType() {
        return this.packetType;
    }

    protected byte[] getBytes(ByteBuffer buffer, int size) {
        byte[] data = new byte[size];
        buffer.get(data);
        return data;
    }

    protected String getString(ByteBuffer buffer, int size) {
        byte[] data = new byte[size];
        buffer.get(data);
        return Encoding.decodeString(data);
    }
}

