/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;

public class ButtonClickedResponse
extends InSimResponse {
    private int LEFT_CLICK = 1;
    private int RIGHT_CLICK = 2;
    private int CTRL = 4;
    private int SHIFT = 8;
    private byte connectionId;
    private byte clickId;
    private byte clickFlags;

    public ButtonClickedResponse() {
        super(PacketType.BUTTON_CLICKED);
    }

    protected ButtonClickedResponse(PacketType type) {
        super(type);
    }

    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.connectionId = buffer.get();
        this.clickId = buffer.get();
        buffer.position(buffer.position() + 1);
        this.clickFlags = buffer.get();
    }

    public byte getClickId() {
        return this.clickId;
    }

    public byte getConnectionId() {
        return this.connectionId;
    }

    public boolean isLeftClick() {
        return (this.clickFlags & this.LEFT_CLICK) > 0;
    }

    public boolean isRightClick() {
        return (this.clickFlags & this.RIGHT_CLICK) > 0;
    }

    public boolean isCtrl() {
        return (this.clickFlags & this.CTRL) > 0;
    }

    public boolean isShift() {
        return (this.clickFlags & this.SHIFT) > 0;
    }
}

