/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.request;

import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.request.InSimRequest;

public class InitRequest
extends InSimRequest {
    public static short LOCAL = (short)4;
    public static short KEEP_MESSAGE_COLOR = (short)8;
    public static short RECEIVE_NODE_LAP = (short)16;
    public static short RECEIVE_MULTI_CAR_INFO = (short)32;
    private int udpPort;
    private short flags;
    private short interval;
    private String password;
    private char prefix;
    private String name;
    private boolean requestVersion;

    public InitRequest() {
        super(PacketType.INSIM_INITIALIZE, 44);
    }

    public void assemble(ByteBuffer data) {
        if (this.requestVersion) {
            this.setRequestInfo((byte)1);
        } else {
            this.setRequestInfo((byte)0);
        }
        super.assemble(data);
        data.put((byte)0);
        data.putShort((short)this.udpPort);
        data.putShort(this.flags);
        data.put((byte)0);
        data.put((byte)this.prefix);
        data.putShort(this.interval);
        this.assembleString(data, this.password, 16);
        this.assembleString(data, this.name, 16);
    }

    public String toString() {
        String retval = super.toString();
        retval = retval + "Port: " + this.getPort() + "\n";
        retval = retval + "Flags: " + this.getFlags() + "\n";
        retval = retval + "Node lap interval: " + this.getInterval() + "\n";
        retval = retval + "Password: " + this.getPassword() + "\n";
        return retval;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public void addFlag(int flag) {
        this.setFlags((byte)(this.getFlags() | flag));
    }

    public void removeFlag(int flag) {
        this.setFlags((byte)(this.getFlags() & ~flag));
    }

    public short getInterval() {
        return this.interval;
    }

    public void setInterval(short interval) {
        this.interval = interval;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.udpPort;
    }

    public void setUdpPort(int port) {
        this.udpPort = port;
    }

    public char getPrefix() {
        return this.prefix;
    }

    public void setPrefix(char prefix) {
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRequestVersion(boolean sendVersion) {
        this.requestVersion = sendVersion;
    }
}

