/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.request;

import java.nio.ByteBuffer;
import net.sf.jinsim.Encoding;
import net.sf.jinsim.PacketType;

public abstract class InSimRequest {
    private PacketType type;
    protected int size;
    protected byte requestInfo;

    public InSimRequest(PacketType type, int size) {
        this.type = type;
        this.size = size;
        this.requestInfo = 0;
    }

    public PacketType getType() {
        return this.type;
    }

    public void assemble(ByteBuffer byteBuffer) {
        byteBuffer.clear();
        byteBuffer.put((byte)this.size);
        byteBuffer.put((byte)this.type.getId());
        byteBuffer.put(this.requestInfo);
    }

    public String toString() {
        return "InSimRequest of type " + (Object)((Object)this.type) + ", requestInfo: " + this.requestInfo;
    }

    public void assembleString(ByteBuffer data, String string, int length) {
        byte[] destination = new byte[length];
        if (string != null) {
            byte[] stringData = Encoding.encodeString(string);
            int copySize = stringData.length;
            if (copySize > length) {
                copySize = length;
            }
            System.arraycopy(stringData, 0, destination, 0, copySize);
        }
        data.put(destination);
    }

    public void setRequestInfo(byte requestInfo) {
        this.requestInfo = requestInfo;
    }

    public int getSize() {
        return this.size;
    }
}

