/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import net.sf.jinsim.AbstractChannel;

public class TCPChannel
extends AbstractChannel {
    private Selector selector;
    private SocketChannel socketChannel;

    public TCPChannel(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port));
    }

    public TCPChannel(InetSocketAddress address) throws IOException {
        this.socketChannel = SocketChannel.open(address);
        this.socketChannel.configureBlocking(false);
        this.selector = Selector.open();
        this.socketChannel.register(this.selector, 5);
    }

    protected synchronized int receive(ByteBuffer buffer) throws IOException {
        return this.socketChannel.read(buffer);
    }

    public int getPort() {
        return this.socketChannel.socket().getPort();
    }

    protected synchronized void send(ByteBuffer sendBuffer) throws IOException {
        this.socketChannel.write(sendBuffer);
    }
}

