/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSAdminRights.Screens;

import it.starblue.LFS.LFSAdminRights.Host;
import it.starblue.LFS.LFSAdminRights.LoggedCommand;
import it.starblue.LFS.LFSAdminRights.Screens.AdminMainScreen;
import it.starblue.LFS.LFSAdminRights.Screens.Screen;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LastCommandsPanel
implements Screen {
    private static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSAdminRights.Screens.LastCommandsPanel");
    private Host host;
    private byte connectionId;
    private int page = 1;
    private byte PREVBUTTON = (byte)4;
    private byte NEXTBUTTON = (byte)5;
    private byte BACKTOMAIN = (byte)6;
    private byte CLOSEBUTTON = (byte)7;
    private String newAdmin = "";

    public LastCommandsPanel(byte by, Host host) {
        this.host = host;
        this.connectionId = by;
    }

    public void display() {
        int n = 40;
        this.host.createButton("Last Used Commands", 10, 110, 5, 30, n++, 33, this.connectionId);
        Vector<LoggedCommand> vector = this.host.getLoggedCommands();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm.ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                LoggedCommand loggedCommand = (LoggedCommand)object;
                LoggedCommand loggedCommand2 = (LoggedCommand)object2;
                return -loggedCommand.getDate().compareTo(loggedCommand2.getDate());
            }
        });
        int n2 = 1;
        for (LoggedCommand loggedCommand : vector) {
            if (n2 > (this.page - 1) * 6 && n2 <= this.page * 6) {
                int n3 = n2 - (this.page - 1) * 6 - 1;
                this.host.createButton("^7" + simpleDateFormat.format(loggedCommand.getDate()), 10, 40, 5, 40 + n3 * 20, n++, 40, this.connectionId);
                this.host.createButton(loggedCommand.getUsername(), 10, 35, 45, 40 + n3 * 20, n++, 40, this.connectionId);
                this.host.createButton("^3" + this.host.getPrefix() + "^7" + loggedCommand.getCommand(), 10, 35, 80, 40 + n3 * 20, n++, 40, this.connectionId);
                this.host.createButton("^3" + loggedCommand.getEffect() + loggedCommand.getParameters(), 10, 110, 5, 40 + n3 * 20 + 10, n++, 40, this.connectionId);
            }
            ++n2;
        }
        int n4 = 1;
        int n5 = (int)Math.ceil((double)vector.size() / 6.0);
        if (this.page > n4) {
            this.host.createButton("^7Prev", 10, 25, 30, 160, this.PREVBUTTON, 41, this.connectionId);
        } else {
            this.host.createButton("Prev", 10, 25, 30, 160, this.PREVBUTTON, 32, this.connectionId);
        }
        if (this.page < n5) {
            this.host.createButton("^7Next", 10, 25, 55, 160, this.NEXTBUTTON, 41, this.connectionId);
        } else {
            this.host.createButton("Next", 10, 25, 55, 160, this.NEXTBUTTON, 32, this.connectionId);
        }
        this.host.createButton("^7Back to Main", 10, 25, 5, 160, this.BACKTOMAIN, 41, this.connectionId);
        this.host.createButton("^2Close", 10, 25, 80, 160, this.CLOSEBUTTON, 41, this.connectionId);
    }

    public Screen processClicks(byte by, boolean bl) {
        if (by == this.BACKTOMAIN) {
            return new AdminMainScreen(this.connectionId, this.host);
        }
        if (by == this.CLOSEBUTTON) {
            this.host.clearAllButtons(this.connectionId);
            return null;
        }
        if (by == this.NEXTBUTTON) {
            ++this.page;
            this.display();
        } else if (by == this.PREVBUTTON) {
            --this.page;
            this.display();
        }
        return this;
    }

    public void updateTexts(byte by, String string) {
    }
}

