/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSAdminRights.Screens;

import it.starblue.LFS.LFSAdminRights.Host;
import it.starblue.LFS.LFSAdminRights.LFSAdminRights;
import it.starblue.LFS.LFSAdminRights.Screens.AdminMainScreen;
import it.starblue.LFS.LFSAdminRights.Screens.Screen;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CommandListPanel
implements Screen {
    private static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSAdminRights.Screens.CommandListPanel");
    private Host host;
    private byte connectionId;
    private int page = 1;
    private HashMap<Byte, String> delMap = new HashMap();
    private HashMap<Byte, String> editMap = new HashMap();
    private byte PREVBUTTON = (byte)4;
    private byte NEXTBUTTON = (byte)5;
    private byte BACKTOMAIN = (byte)6;
    private byte CLOSEBUTTON = (byte)7;
    private byte NEWCOMMANDBUTTON = (byte)8;
    private byte NEWEFFECTBUTTON = (byte)9;
    private byte ADDBUTTON = (byte)10;
    private String newCommand = "";
    private String newEffect = "";

    public CommandListPanel(byte by, Host host) {
        this.host = host;
        this.connectionId = by;
    }

    public void display() {
        int n = 40;
        this.host.createButton("Command List", 10, 80, 15, 30, n++, 33, this.connectionId);
        this.delMap.clear();
        this.editMap.clear();
        HashMap<String, String> hashMap = LFSAdminRights.getCommandsMap();
        TreeSet<String> treeSet = new TreeSet<String>(hashMap.keySet());
        int n2 = 1;
        for (String string : treeSet) {
            if (n2 > (this.page - 1) * 10 && n2 <= this.page * 10) {
                int n3 = n2 - (this.page - 1) * 10;
                this.host.createButton("^1Del", 10, 15, 15, 30 + n3 * 10, n++, 40, this.connectionId);
                this.delMap.put((byte)(n - 1), string);
                this.host.createButton("^3" + this.host.getPrefix() + "^7" + string, 10, 30, 30, 30 + n3 * 10, n++, 32, this.connectionId);
                this.host.createTextButton(30, hashMap.get(string), 10, 35, 60, 30 + n3 * 10, n++, 40, this.connectionId);
                this.editMap.put((byte)(n - 1), string);
            }
            ++n2;
        }
        this.host.createButton("^2Add", 10, 15, 15, 140, this.ADDBUTTON, 40, this.connectionId);
        if (this.newCommand.length() > 0) {
            this.host.createTextButton(30, "^3" + this.host.getPrefix() + "^7" + this.newCommand, 10, 35, 30, 140, this.NEWCOMMANDBUTTON, 40, this.connectionId);
        } else {
            this.host.createTextButton(30, "^3" + this.host.getPrefix() + "^7" + "<New Command>", 10, 35, 30, 140, this.NEWCOMMANDBUTTON, 40, this.connectionId);
        }
        if (this.newEffect.length() > 0) {
            this.host.createTextButton(30, this.newEffect, 10, 30, 65, 140, this.NEWEFFECTBUTTON, 40, this.connectionId);
        } else {
            this.host.createTextButton(30, "<Effect>", 10, 30, 65, 140, this.NEWEFFECTBUTTON, 40, this.connectionId);
        }
        int n4 = 1;
        int n5 = (int)Math.ceil((double)hashMap.size() / 10.0);
        if (this.page > n4) {
            this.host.createButton("^7Prev", 10, 40, 15, 150, this.PREVBUTTON, 41, this.connectionId);
        } else {
            this.host.createButton("Prev", 10, 40, 15, 150, this.PREVBUTTON, 32, this.connectionId);
        }
        if (this.page < n5) {
            this.host.createButton("^7Next", 10, 40, 55, 150, this.NEXTBUTTON, 41, this.connectionId);
        } else {
            this.host.createButton("Next", 10, 40, 55, 150, this.NEXTBUTTON, 32, this.connectionId);
        }
        this.host.createButton("^7Back to Main", 10, 40, 15, 160, this.BACKTOMAIN, 41, this.connectionId);
        this.host.createButton("^2Close", 10, 40, 55, 160, this.CLOSEBUTTON, 41, this.connectionId);
    }

    public Screen processClicks(byte by, boolean bl) {
        if (by == this.ADDBUTTON) {
            if (this.newCommand.length() > 0 && this.newEffect.length() > 0) {
                try {
                    LFSAdminRights.addCommand(this.newCommand, this.newEffect);
                    this.newCommand = "";
                    this.newEffect = "";
                }
                catch (IOException iOException) {
                    log.error((Object)"Failed to add new Command!", (Throwable)iOException);
                }
            }
            this.display();
        } else {
            if (by == this.BACKTOMAIN) {
                return new AdminMainScreen(this.connectionId, this.host);
            }
            if (by == this.CLOSEBUTTON) {
                this.host.clearAllButtons(this.connectionId);
                return null;
            }
            if (by == this.NEXTBUTTON) {
                ++this.page;
                this.display();
            } else if (by == this.PREVBUTTON) {
                --this.page;
                this.display();
            } else if (this.delMap.containsKey(by)) {
                String string = this.delMap.get(by);
                try {
                    LFSAdminRights.removeCommand(string);
                }
                catch (IOException iOException) {
                    log.error((Object)"Failed to remove Command!", (Throwable)iOException);
                }
                return this;
            }
        }
        return this;
    }

    public void updateTexts(byte by, String string) {
        if (by == this.NEWCOMMANDBUTTON) {
            if (string.trim().length() > 0) {
                this.newCommand = string.trim();
                this.display();
            }
        } else if (by == this.NEWEFFECTBUTTON) {
            if (string.trim().length() > 0) {
                this.newEffect = string.trim();
                this.display();
            }
        } else if (this.editMap.containsKey(by) && string.trim().length() > 0) {
            String string2 = this.editMap.get(by);
            try {
                LFSAdminRights.updateCommand(string2, string.trim());
            }
            catch (IOException iOException) {
                log.error((Object)"Failed to update Command!", (Throwable)iOException);
            }
            this.display();
        }
    }
}

