/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSAdminRights;

import it.starblue.LFS.LFSAdminRights.Connection;
import it.starblue.LFS.LFSAdminRights.Host;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.ButtonClickedResponse;
import net.sf.jinsim.response.ButtonTypeResponse;
import net.sf.jinsim.response.ConnectionLeaveResponse;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.MessageResponse;
import net.sf.jinsim.response.NewConnectionResponse;
import org.apache.log4j.Logger;

public class HostListener
implements InSimListener {
    private static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSAdminRights.HostListener");
    private Host host;

    public HostListener(Host host) {
        this.host = host;
    }

    public void packetReceived(InSimResponse inSimResponse) {
        log.debug((Object)("Received packet:" + inSimResponse.getPacketType()));
        try {
            MessageResponse messageResponse;
            if (inSimResponse.getPacketType().equals((Object)PacketType.MESSAGE_OUT)) {
                messageResponse = (MessageResponse)inSimResponse;
                String string = messageResponse.getMessage();
                if (string.equalsIgnoreCase(this.host.getPrefix() + "adminGUI")) {
                    log.debug((Object)(this.host + " Admin GUI invoked by ConnId: " + messageResponse.getConnectionId()));
                    this.host.displayAdminPanel(messageResponse.getConnectionId());
                } else if (string.startsWith(this.host.getPrefix() + "")) {
                    log.debug((Object)(this.host + " received special message by ConnId: " + messageResponse.getConnectionId()));
                    this.host.execute(messageResponse);
                }
                log.debug((Object)(this.host + " received this msg (" + string + ") by ConnId: " + messageResponse.getConnectionId()));
            }
            if (inSimResponse.getPacketType().equals((Object)PacketType.BUTTON_CLICKED)) {
                messageResponse = (ButtonClickedResponse)inSimResponse;
                this.host.clickButton(this.host.getConnection(messageResponse.getConnectionId()), messageResponse.getClickId(), messageResponse.isRightClick());
            }
            if (inSimResponse.getPacketType().equals((Object)PacketType.BUTTON_TYPED)) {
                messageResponse = (ButtonTypeResponse)inSimResponse;
                this.host.updateTexts(this.host.getConnection(messageResponse.getConnectionId()), messageResponse.getClickId(), messageResponse.getText());
            }
            if (inSimResponse.getPacketType().equals((Object)PacketType.NEW_CONNECTION)) {
                messageResponse = (NewConnectionResponse)inSimResponse;
                this.host.addConnection(new Connection(this.host, messageResponse.getId(), messageResponse.isAdmin(), messageResponse.getUsername(), messageResponse.getPlayerName()));
                log.debug((Object)"New Connection");
            }
            if (inSimResponse.getPacketType().equals((Object)PacketType.CONNECTION_LEFT)) {
                messageResponse = (ConnectionLeaveResponse)inSimResponse;
                this.host.removeConnection(messageResponse.getId());
                log.debug((Object)"Connection left");
            }
        }
        catch (Exception exception) {
            log.error((Object)"Something went wrong while processing a packet inside Online Tracker.", (Throwable)exception);
        }
    }
}

